#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <io.h>


/* UPLOAD DIRECTORY INFORMATION */
typedef struct {
    char            name[41],       /* directory name */
	                filename[9],	/* direct database filename */
                    path[81];       /* filename path */
    unsigned char   dsl,            /* DSL for directory */
                    age;            /* minimum age for directory */
    unsigned short  dar,            /* DAR for directory */
                    maxfiles,       /* max files for directory */
                    mask,           /* file type mask */
                    type;           /* 4 digit directory type */
}               directoryrec;

/*** structure of a record in a wwiv '.dir' file ***/
typedef struct {
    char            filename[13],      /* filename */
                    description[59],   /* file description */
                    date[9],           /* date u/l'ed */
                    upby[46];          /* name of upload user */
	unsigned char
                    filetype;          /* file type for apples */
	unsigned short
                    numdloads,         /* number times d/l'ed */
                    ownersys, ownerusr,/* who uploaded it */
                    mask;              /* file type mask */
	unsigned long
                    daten,             /* date uploaded */
                    numbytes;          /* number bytes long file is */
}               uploadsrec;

/********** structures defined in net.h ******************/
typedef struct {
    unsigned char   type;       /* type of network */
	char            name[16];	/* network name */
    char            dir[69];    /* directory for net data */
    unsigned short  sysnum;     /* system number */
    void far       *con;        /* ptr to callout data */
    void far       *ncn;        /* ptr to contact info */
    int             num_con;    /* number in array */
    int             num_ncn;    /* number in array */
}               net_networks_rec;

typedef struct {
    unsigned short  tosys,      /* destination system */
                    touser,     /* destination user */
                    fromsys,    /* originating system */
	                fromuser;	/* originating user */
	unsigned short  main_type,	/* main message type */
	                minor_type;	/* minor message type */
	unsigned short  list_len;	/* # of entries in system list */
    unsigned long   daten;      /* date/time sent */
    unsigned long   length;     /* # of bytes of msg after header */
    unsigned short  method;     /* method of compression */
}               net_header_rec;


/********    Tolkien's structure ***********/
struct pk {
    char            sig[10];    /* packscan signature - "pksjrr G G" */
    char            fn[13];     /* filename 8.3 and terminator */
    long            size;       /* size of file being sent */
    char            fa;         /* file attributes */
	char            unk1;
    unsigned        ft;         /* file time, dos dir format */
    unsigned        fd;         /* file date, dos dir format */
    char            des[59];    /* description of transaction */
    long            chksum;     /* CRC 32  */
    int             msgtyp;     /* 16 sendfile, 17 reqfile , 19 reqlist */
    int             dirnum;     /* destination directory */
    long            pktnum;     /* packet number - 1 to n */
    long            oneof;      /* THIS IS THE "N" FROM ABOVE... */
    long            unk2;       /* always 0 ? */
	char            from[60];	/* originating bbs name */
    char            netname[16];/* originating net name */
    unsigned        tonode;     /* originating node */
    unsigned        touser;     /* destination node */
    char            netname2[16]; /* destination network ? */
	unsigned        fromnode;
	unsigned        fromuser;
    int             stealth;     /* 1 = stealth mode */
    char            unk5[16];    /* reserved ? all zeroes */
    int             numbytes;    /* number of bytes of file data that
                                  * follow... */
};


typedef struct {
    unsigned int    sysnum;     /* system number of the system */
	char            phone[13],	/* phone number of system */
	                name[41];	/* name of system */
    unsigned int    speed,      /* max baud rate of system */
                    other,      /* other info about sys (bit-mapped) */
                    forsys;     /* how to get there */
    int             numhops;    /* how long to get there */
    float           cost;       /* how much it costs to get there */
}               net_system_list_rec;


/* directoryrec.mask */
#define mask_PD              0x0001
#define mask_no_uploads 	 0x0004
#define mask_archive         0x0008
#define mask_pending_batch   0x0010
#define mask_no_ratio 		 0x0020
#define mask_cdrom           0x0040
#define mask_extended        0x8000

#define CHUNK 512
#define DEBUG_UTILS
#define JUSTIFY_LEFT   0
#define JUSTIFY_RIGHT  1
#define JUSTIFY_CENTER 2

#define pad_string(s, l) justify_string((s), (l), ' ', JUSTIFY_LEFT);

/* FUNCTIONS DEFINED IN 'TRON.C' */
void checklocal(void);
unsigned char  *daten_to_date(long dt);
int build_system_index(void);
int get_board_info(net_system_list_rec * node, unsigned short sys);
void ssm(unsigned sys, char *msg);
int get_net_info(int num, net_networks_rec * rec);
int get_send_type(void);
void tron_menu(void);


/* FUNCTIONS DEFINED IN 'LINK.C' */
void linkout(char *name, char *des);
void process_lnk(FILE * src, net_header_rec * header);
void linkreq(char *name, net_header_rec * rh);


/* FUNCTIONS DEFINED IN 'PKSCN.C' */
void process_pak(FILE * src, net_header_rec * header);
void packreq(char *name, net_header_rec * rh);
void packout(char *name, char *des, net_header_rec * rh);
void packin(FILE * from, net_header_rec * n, struct pk * p);
void upload(struct pk * p);


/* FUNCTIONS DEFINED IN UTILS.C */
char *filelist(void);
char *findfile(uploadsrec * u, char *name);
int uploadit(char *name, char *des, unsigned long size, int by);
char *padname(char *name);
unsigned long crc32file(char *name);
int open_mail(void);
long file_daten(char *filename);
int  compare(char *s1, char *s2);
char *unalign(char *filename);
int  search_list(char **list, char *search, int amount_in_list);
long filesize(FILE * stream);
char *strip_string(char *string);
void makepath(char *dest, char *src);
char *justify_string(char *string, int length, int bg, int type);

/****   FUNCTIONS DEFINED IN 'NETUP.C' ****/

int netup(void);

