#include "tron.h"
#include<process.h>
#include <stdio.h>
#include <dos.h>
#include <dir.h>
#include <time.h>
#include <alloc.h>

#define BLKSIZE (unsigned long)32518


extern net_networks_rec thisnet;
extern net_system_list_rec thisboard;
extern net_system_list_rec thatboard;
extern time_t   now;
extern char     buf[];
extern FILE    *incomming;
extern FILE    *log;
extern FILE    *mail;
extern char     netpath[];
extern char     sys_area[101];
extern int      local;

char            ulpath[80];
int             pver;
uploadsrec      up;
char            mess[101];

void 
process_pak(FILE * src, net_header_rec * header)
{
	char           *fpath;
	struct pk       jrr;
    open_mail();
	switch (header->minor_type) {
	case 1000:
		pver = 1;	/* Packscan 2.30 */
	case 69:
		pver = 2;	/* Packscan 2.31 */
		fread(&jrr, sizeof(struct pk), 1, src);
		switch (jrr.msgtyp) {
        case 0:
        case 1:
        case 2:
        case 3:
		case 16:	/* normal packscan file */
			packin(src, header, &jrr);
			break;
		case 17:	/* file request */
			fprintf(log, "%s requested %s\n", thatboard.name, jrr.fn);
			printf("%s requested %s\n", thatboard.name, jrr.fn);
			fpath = findfile(&up, jrr.fn);	/* find the file */
			if (fpath) {
				packout(fpath, up.description, header);
				fprintf(log, "Sent %s via %d\n", jrr.fn, thatboard.forsys);
				printf("Sent %s via %d\n", jrr.fn, thatboard.forsys);
			}
			break;
		case 19:	/* file list request */
			fprintf(log, "%s requested file list\n", thatboard.name);
			printf("%s requested file list\n", thatboard.name);
			sprintf(mess, "Files available on %s", thisboard.name);
            packout(filelist(), mess, header);
			break;
        default:
			fprintf(log, "Unk PS msgtype %d from %s\n",
				jrr.msgtyp, thatboard.name);
			printf("Unk PS msgtype %d from %s\n",
			       jrr.msgtyp, thatboard.name);
			fseek(src, (unsigned) header->length - sizeof(struct pk), SEEK_CUR);
			sprintf(mess, "%s didn't recognize msg typ %d:%d", thisboard.name,
				header->main_type, header->minor_type);
			ssm(header->fromsys, mess);	/* Let 'em know ! <g> */
			break;
		}
		break;		/* endcase 69 */
	case 56:
		fprintf(log, "Incomming BRE packet from %s\n", thatboard.name);
		/* No break; */
	default:
		fseek(src, header->length, SEEK_CUR);	/* dunno - just skip it */
		break;
	}
	fclose(mail);
	return;
}


void 
packout(char *name, char *des, net_header_rec * rh)
{
	FILE           *foo;
	unsigned        test;
	net_header_rec  h;
	unsigned        numchar;
	unsigned long   flength;
	struct ffblk    tmp;
	struct pk       pkt;
	char            nt[95];


	strcpy(nt, name);
	strupr(nt);

	if (findfirst(nt, &tmp, 0)) {
		printf("******* File %s not found !\n", nt);

		if (!local) {
			fprintf(log, "******* File %s not found !\n", nt);
			sprintf(mess, "Tron says %s not available on %s", nt, thisboard.name);
			ssm(thatboard.sysnum, mess);
		}
		return;
	}
	flength = tmp.ff_fsize;


	memset(&pkt, 0, sizeof(struct pk));	/* first initialize packet */
	memset(&h, 0, sizeof(net_header_rec));
	/****** setup the network packet header **********/
	h.touser = 1;
	h.tosys = thatboard.sysnum;
	h.fromsys = thisboard.sysnum;
	h.fromuser = 1;

	if (rh->main_type == 0x0a) {
		h.main_type = 0x0a;	/* Packscan 2.3 */
		h.minor_type = 1000;

		strcpy(pkt.sig, "pksjrr");	/* Packscan 2.3 signature */
    }
    if(rh->main_type == 0x1b) {
		h.main_type = 0x1b;	/* packscan 2.31 */
		h.minor_type = 69;

		strcpy(pkt.sig, "pksjrr G G");	/* Packscan 2.31 signature */
	}
	h.daten = now;
	h.method = 0;
	h.list_len = 0;

	/******** set up the packscan header ************/
	strcpy(pkt.fn, tmp.ff_name);	/* filename */
	strcpy(pkt.des, des);

	pkt.msgtyp = 16;	/* Packscan 'send file' */
	pkt.size = tmp.ff_fsize;
	pkt.ft = tmp.ff_ftime;
	pkt.fd = tmp.ff_fdate;
	pkt.fa = tmp.ff_attrib;
	pkt.fromnode = thisboard.sysnum;
	pkt.fromuser = 1;
	pkt.tonode = thatboard.sysnum;
	pkt.touser = 1;

	pkt.chksum = crc32file(nt);

	test = (flength / BLKSIZE) + 1;
	pkt.oneof = (long) test;
	foo = fopen(nt, "rb");
	if (!foo) {
		printf("Unable to open %s\n", nt);

		if (!local) {
			fprintf(log, "Unable to open %s\n", nt);
			sprintf(mess, "Tron says %s is not available on %s", nt, thisboard.name);
			ssm(thatboard.sysnum, mess);
		}
		return;
	}
	printf("Sending file %s (%ld bytes)...\n", nt, flength);


	while (flength) {
		numchar = (flength > BLKSIZE) ? BLKSIZE : flength;
		flength -= numchar;
		h.length = sizeof(struct pk) + numchar;
		fwrite(&h, sizeof(net_header_rec), 1, mail);	/* write net packet
								 * header */
		pkt.pktnum++;
		strcpy(pkt.from, thisboard.name);
		strcpy(pkt.netname, thisnet.name);
		strcpy(pkt.netname2, thisnet.name);
		fwrite(&pkt, sizeof(struct pk), 1, mail);	/* write packscan header */

		while (numchar > CHUNK) {
			fread(buf, CHUNK, 1, foo);
			fwrite(buf, CHUNK, 1, mail);	/* write CHUNK bytes to
							 * output file */
			numchar -= CHUNK;
		}
		fread(buf, numchar, 1, foo);
		fwrite(buf, numchar, 1, mail);	/* write the rest */
	}
	fclose(foo);
	sprintf(mess, "Sent %s to %s (%u)", nt, thatboard.name, thatboard.forsys);
	printf("%s\n", mess);
	fprintf(log, "%s\n", mess);
	if (!local)
		ssm(0, mess);
	return;
}


void 
packin(FILE * from, net_header_rec * n, struct pk * p)
{
	unsigned        howlong;
	char            t[L_tmpnam];

	if (p->pktnum == 1) {	/* if it's the first packet, open a temp file */
		fprintf(log, "Incomming PS file %s from %s\n", p->fn, thatboard.name);
		fprintf(log, "Description = %s\n", p->des);

		printf("Incomming PS file %s from %s\n", p->fn, thatboard.name);
		printf("Description = %s\n", p->des);

		strcpy(ulpath, netpath);
		strcat(ulpath, tmpnam(t));
		incomming = fopen(ulpath, "wb");


	}
	/** actual length of file data is msg size minus the packscan header **/
	howlong = (unsigned) n->length - sizeof(struct pk);

	if (incomming) {
		while (howlong > CHUNK) {
			fread(buf, CHUNK, 1, from);
			/* write CHUNK bytes to output file */
			fwrite(buf, CHUNK, 1, incomming);
			howlong -= CHUNK;
		}
		fread(buf, howlong, 1, from);
		fwrite(buf, howlong, 1, incomming);	/* write the rest */

		if (p->pktnum == p->oneof) {	/* last packet for this file */
			fclose(incomming);
			upload(p);

		}
	}
}

void 
upload(struct pk * p)
{
    int i;
	long            check;
	long            len;
	char            trash[L_tmpnam];
	char            newpath[80];
    char            tmppath[80];
    struct ffblk    ffb;
	directoryrec    dirrec;
	FILE           *in, *out, *dirs;
    char *pgppath;
    len = p->size;
	check = crc32file(ulpath);	/* could speed up by calculating
					 * before... */
	if (check != p->chksum) {
		fprintf(log, "%s Failed CRC !\n", p->fn);
		strcpy(newpath, netpath);
		strcat(newpath, tmpnam(trash));
		fprintf(log, "Renamed to %s\n", trash);
		sprintf(mess, "Tron says %s sent to %s failed CRC !", p->fn, thisboard.name);
		ssm(thatboard.sysnum, mess);
		sprintf(mess, "Tron renamed %s to %s - it failed CRC check !", p->fn, trash);
		ssm(0, mess);
    } else
        {
        if(p->msgtyp==16)
            {
            dirs = fopen("data/dirs.dat", "rb");    /* find upload path */
            if (!dirs)
               {
               fprintf(log, "\nUnable to open directory data file !\n");
               strcpy(newpath, netpath);   /* just dump it in the
							 * net dir... */
               }
            else
               {
               fread(&dirrec, sizeof(directoryrec), 1, dirs);  /* upload to sysop */
               strcpy(newpath, dirrec.path);
               }
            strcat(newpath, p->fn); /* append the filename */
	/* need to add spaces to fill extension to 3 spaces... */
            if (!findfirst(newpath, &ffb, 0))
               { /* make sure it's not already there */
               tmpnam(trash);
               sprintf(mess, "File Collision - Tron renmed incomming %s to %s",
               p->fn, trash);
               ssm(thisboard.sysnum, mess);
               fprintf(log, "FILE COLLISION - Incomming %s renamed to %s\n",
               p->fn, trash);
            /* strcpy(p->fn,trash);          // why not ? */
               strcpy(newpath, dirrec.path);
               strcat(newpath, trash);
               }
            }
        else
           {
           strcpy(newpath,netpath); /* network update */
           strcat(newpath, p->fn); /* append the filename */
            }
        }
        if (uploadit(p->fn, p->des, p->size, pver)) {
		sprintf(mess, "%s sent to %s arrived.  Thanks !",
			p->fn, thisboard.name);
		ssm(thatboard.sysnum, mess);
		sprintf(mess, "%s arrived from %s", p->fn, thatboard.name);
		ssm(0, mess);
	} else {
		sprintf(mess, "Tron says %s fumbled reception of %s !",
			thisboard.name, p->fn);
		ssm(thatboard.sysnum, mess);
		sprintf(mess, "Tron says Fumbled %s from %s", p->fn, thatboard.name);
		ssm(0, mess);
	}
	in = fopen(ulpath, "rb");	/* open the temp file */
	if (!in) {
		fprintf(log, " Unable to open %s !\n", ulpath);
		printf(" Unable to open %s !\n", ulpath);
		return;
	}
	out = fopen(newpath, "wb");
	if (!out) {
		fprintf(log, " Unable to open %s !\n", newpath);
		printf(" Unable to open %s !\n", newpath);
		fclose(in);
		return;
	}
	/************  there must be a better way.....*************/

	while (len > CHUNK) {
		fread(buf, CHUNK, 1, in);
		fwrite(buf, CHUNK, 1, out);
		len -= CHUNK;
	}
	fread(buf, len, 1, in);
	fwrite(buf, len, 1, out);
	fclose(in);
	unlink(ulpath);		/* delete the temporary file */
	fclose(out);
    if(p->msgtyp == 16)
       return;

pgppath = searchpath("pgp.exe");
if(!pgppath)
	{
    fprintf(log,"couldn't find pgp !  (rtmfd)\n");
    return;  // need error handling here !
	}

out=fopen("pgp.ini","wt");
strcpy(tmppath,"pubring=");
strcat(tmppath,netpath);
strcat(tmppath,p->netname);
strcat(tmppath,".pgp");
fprintf(out,tmppath);
fprintf(out,"\n");
fclose(out);

strcpy(tmppath,newpath);

i=strlen(tmppath);
i-=3;
if(p->msgtyp ==3)
   strcpy(&tmppath[i],"lst"); /* subs.lst */
else
   strcpy(&tmppath[i],"net"); /* bbslist.net or connect.net */

i=spawnl(P_WAIT,pgppath,pgppath,"+batchmode","+verbose=0","+force",
newpath,"-o",tmppath,NULL);
if(i)
      {
      fprintf(log,"PGP returned Error %d!\n");
      return;
      }
unlink(newpath);
}






void 
packreq(char *name, net_header_rec * rh)
{
	net_header_rec  h;
	struct pk       pkt;
	char            nt[95];
	int             file_list = 0;

	strcpy(nt, name);
	strupr(nt);

	if (strcmp(nt, "FILELIST.ALL") == 0)	/* requesting a full file
						 * list */
		file_list = 1;
	else if (strcmp(nt, "FILELIST.NEW") == 0)	/* requesting a new scan */
		file_list = 2;

	memset(&pkt, 0, sizeof(struct pk));	/* first initialize packet */
	memset(&h, 0, sizeof(net_header_rec));
	/****** setup the network packet header **********/
	h.touser = 1;
	h.tosys = thatboard.sysnum;
	h.fromsys = thisboard.sysnum;
	h.fromuser = 1;

	if (rh->main_type == 0x0a) {
		if (!file_list) {
			h.main_type = 0x0a;	/* Packscan 2.3 */
			h.minor_type = 1000;
		} else {	/* force a packescan 2.31 */
			h.main_type = 0x1b;
			h.minor_type = 69;
		}
		strcpy(pkt.sig, "pksjrr");	/* Packscan 2.3 signature */
	} else {
		h.main_type = 0x1b;	/* packscan 2.31 */
		h.minor_type = 69;

		strcpy(pkt.sig, "pksjrr G G");	/* Packscan 2.31 signature */
	}
	h.daten = now;
	h.method = 0;
	h.list_len = 0;

	/******** set up the packscan header ************/
	strcpy(pkt.fn, nt);	/* filename */

	if (!file_list)
		pkt.msgtyp = 17;/* Packscan 2.31 'request file' */
	else
		pkt.msgtyp = file_list = 1 ? 19 : 200;
	/* 19 = complete filelist, 200 = new scan */

	pkt.fromnode = thisboard.sysnum;
	pkt.fromuser = 1;
	pkt.tonode = thatboard.sysnum;
	pkt.touser = 1;

	strcpy(pkt.from, thisboard.name);
	strcpy(pkt.netname, thisnet.name);
	strcpy(pkt.netname2, thisnet.name);

	h.length = sizeof(struct pk);
	h.fromsys = thisboard.sysnum;
	h.fromuser = 1;
	h.tosys = thatboard.sysnum;
	h.touser = 1;

	fwrite(&h, sizeof(net_header_rec), 1, mail);	/* write net packet
							 * header */
	pkt.pktnum++;
	fwrite(&pkt, sizeof(struct pk), 1, mail);	/* write packscan header */


	fprintf(log, "Sent out request for %s on %s\n", nt, thatboard.name);
	printf("Sent out request for %s on %s\n", nt, thatboard.name);

	return;
}
