#include "tron.h"
#include <dir.h>
#include <process.h>
#include <time.h>

#define BLKSIZE (unsigned long)32518

int netout(int what);

extern char netpath[];
extern char netname[];
extern net_networks_rec thisnet;
extern net_system_list_rec thisboard;
extern net_system_list_rec thatboard;
extern time_t   now;
extern char     buf[];
extern FILE    *incomming;
extern FILE    *log;
extern FILE    *mail;
extern char     netpath[];
extern char     sys_area[101];
extern int      local;

char tmppath[128];
char *pgppath;
char pass[80];

int nodelist[250];
int numnodes;

int netup(void)
{
int i;
char ch;
FILE *in;
pgppath = searchpath("pgp.exe");
if(!pgppath)
	{
    printf("couldn't find pgp !  (rtmfd)\n");
    getch();
    return 0;  // need error handling here !
	}
strcpy(tmppath,netpath);
strcat(tmppath,"bbsdata.ind");
in=fopen(tmppath,"rb");
numnodes=fread(nodelist,sizeof(int),250,in);
fclose(in);
printf("Updating %d nodes\n",numnodes);


printf("\n Enter PGP passphrase: ");
while((ch != 0x0d) && (i < 79))
  {
  ch=getch();
  putch('X');
  pass[i]=ch;
  i++;
  }
pass[i]=0;
printf("\n\npassphrase is:  %s\n",pass);
netout(1);
netout(2);
netout(3);
return 0;
}

int encode(char *netfile, char *pp)
{
int i;
FILE *ini;


ini=fopen("pgp.ini","wt");
strcpy(tmppath,"pubring=");
strcat(tmppath,netpath);
strcat(tmppath,netname);
strcat(tmppath,".pgp");
fprintf(ini,tmppath);
fprintf(ini,"\n");
strcpy(tmppath,"secring=");
strcat(tmppath,netpath);
strcat(tmppath,"nc.pgp");
fprintf(ini,tmppath);
fprintf(ini,"\n");
fclose(ini);

i=spawnl(P_WAIT,pgppath,pgppath,"+batchmode","+verbose=0","+force",
"-s",netfile,"-u",netname,"-z",pp,NULL);
if(i)
      {
      printf("\nError %d!\n");
      getch();
      return 1;       // if pgp returned error
      }
return 0;
}


int netout(int what)
{
    int i;
    FILE           *foo,*bar;
	unsigned        test;
	net_header_rec  h;
	unsigned        numchar;
	unsigned long   flength;
	struct ffblk    tmp;
	struct pk       pkt;
	char            nt[95];
    char            bp[95];
    char mess[80];
    strcpy(nt, netpath);
    switch(what){
        case 1:strcat(nt,"bbslist.net");break;
        case 2:strcat(nt,"connect.net");break;
        case 3:strcat(nt,"subs.lst");break;
        default:return 0;break;
    }

	if (findfirst(nt, &tmp, 0)) {
		printf("******* File %s not found !\n", nt);
        return -1;
	}
    encode(nt,pass);
    i=strlen(nt);
    i-=3;
    strcpy(&nt[i],"pgp");
    printf("Encoded %s\n",nt);
    if (findfirst(nt, &tmp, 0)) {
		printf("******* File %s not found !\n", nt);
        return -1;
    }
   flength = tmp.ff_fsize;

    memset(&pkt, 0, sizeof(struct pk)); /* first initialize packet */
	memset(&h, 0, sizeof(net_header_rec));
	/****** setup the network packet header **********/
    h.touser = 0;
    h.tosys = 0;
	h.fromsys = thisboard.sysnum;
	h.fromuser = 1;
    h.main_type = 0x1b; /* packscan 2.31 */
    h.minor_type = 69;
    strcpy(pkt.sig, "pksjrr G G");  /* Packscan 2.31 signature */
	h.daten = now;
	h.method = 0;
    h.list_len = numnodes;

	/******** set up the packscan header ************/
	strcpy(pkt.fn, tmp.ff_name);	/* filename */
    strcpy(pkt.des,"Network Update");

    pkt.msgtyp = what;    /* Packscan 'send file' */
	pkt.size = tmp.ff_fsize;
	pkt.ft = tmp.ff_ftime;
	pkt.fd = tmp.ff_fdate;
	pkt.fa = tmp.ff_attrib;
	pkt.fromnode = thisboard.sysnum;
	pkt.fromuser = 1;
	pkt.tonode = thatboard.sysnum;
	pkt.touser = 1;

	pkt.chksum = crc32file(nt);

	test = (flength / BLKSIZE) + 1;
	pkt.oneof = (long) test;
	foo = fopen(nt, "rb");
	if (!foo) {
		printf("Unable to open %s\n", nt);

		if (!local) {
			fprintf(log, "Unable to open %s\n", nt);
			sprintf(mess, "Tron says %s is not available on %s", nt, thisboard.name);
			ssm(thatboard.sysnum, mess);
		}
        return -1;
	}
	printf("Sending file %s (%ld bytes)...\n", nt, flength);
    strcpy(bp,netpath);
    strcat(bp,"p9.net");
    bar=fopen(bp,"ab");

	while (flength) {
		numchar = (flength > BLKSIZE) ? BLKSIZE : flength;
		flength -= numchar;
		h.length = sizeof(struct pk) + numchar;
        fwrite(&h, sizeof(net_header_rec), 1, bar);    /* write net packet
								 * header */
        fwrite(nodelist,sizeof(int),numnodes,bar); /* dist list */
        pkt.pktnum++;
		strcpy(pkt.from, thisboard.name);
		strcpy(pkt.netname, thisnet.name);
		strcpy(pkt.netname2, thisnet.name);
        fwrite(&pkt, sizeof(struct pk), 1, bar);   /* write packscan header */

		while (numchar > CHUNK) {
			fread(buf, CHUNK, 1, foo);
            fwrite(buf, CHUNK, 1, bar);    /* write CHUNK bytes to
							 * output file */
			numchar -= CHUNK;
		}
		fread(buf, numchar, 1, foo);
        fwrite(buf, numchar, 1, bar);  /* write the rest */
	}
	fclose(foo);
    fclose(bar);
    sprintf(mess, "Sent %s to Network", nt);
    printf("%s\n", mess);
    fprintf(log, "%s\n", mess);
    unlink(nt);
    return 0;
}

