#include <stdio.h>
#include <process.h>
#include<stdlib.h>
#include <dos.h>
#include <dir.h>
#include <time.h>
#include "tron.h"

#define TITLE "Tron v2.0"
#define LOGFILE "tron.log"
#define DEBUG 1
#ifdef DEBUG
  char *types[]={
	"undefined_type",
    "net_info      ",
    "email         ",
    "post          ",
    "file          ",
    "pre_post      ",
    "external      ",
    "email_name    ",
    "net_edit      ",  /* 0x08 network editor packet */
    "sub_list      ",  /* 0x09 subs.lst update */
    "Old_Extern    ",  /* 0x0a Linker or PS 2.30 packet, others */
    "group_bbslist ",  /* 0x0b network update from GC */
	 "group_connect ",  /* network update from GC */
    "unsed_1       ",  /* unused */
    "group_info    ",  /* misc update from GC */
    "ssm           ",  /* 0x0f so-and-so read your mail */
    "sub_add_req   ",  /* 0x10 add me to your subboard */
    "sub_drop_req  ",  /* remove me from your subboard */
    "sub_add_resp  ",  /* status of add, 0=ok */
    "sub_drop_resp ",  /* status of drop, 0=ok */
    "sub_list_info ",  /* 0x14 info for subs.lst file */
    "unknown       ",  /* unknown type 0x0015 */
	 "unknown       ",
    "unknown       ",
    "unknown       ",  /* unknown type 0x0018 */
    "unknown       ",
    "post_by_name  ",  /* 0x001a */
    "new_extern    "   /* 0x1b packscan 2.31 & others*/
};
#endif
void checklocal(void);
void process_pak(FILE *src,net_header_rec *header);
void process_lnk(FILE *src,net_header_rec *header);

/* global variables */
net_networks_rec thisnet;       // net struct for current network
net_system_list_rec thisboard;  // sys info struc for this board
net_system_list_rec thatboard;  // sys info struc for that board
char netpath[85];               // path to network files
//char fn[95];                    // a file name string
char buf[CHUNK+1];              // generic scratch buffer
FILE *log;                      // the tron.log file handle
FILE *mail;                     // file for outgoing mail
FILE *incomming;                // incomming file handle
time_t now;

void main(int argc, char *argv[])
{
int i,netnum;

time(&now);                     // time at start of processing

log=fopen(LOGFILE,"at");        // open the log file
if(! log)                       // serious problem...
    return;

if(argc < 2)                    // network should pass the net num...
	{
    fprintf(log,"Didn't get network number !\n\n");
    fclose(log);
    return;
    }

//  get info for current network from networks.dat, store in "thisnet"
netnum = atoi(&argv[1][1]);               // skip the decimal point
if(!get_net_info(netnum, &thisnet))
  {
   fprintf(log,"\nUnable to open network data file !\n");
   fclose(log);
   return;
  }

// make a valid path string from path in networks.dat - store to "netpath"
// this is the path where all incomming & outgoing files for this net are

strcpy(netpath,thisnet.dir);
for(i=0;i<strlen(netpath);i++)            // change "\" to "/"
	  if(netpath[i] == 0x5c)
		  netpath[i] = 0x2f;
netpath[i]='/';
netpath[++i]='\0';

get_board_info(&thisboard,thisnet.sysnum);// get info for this board

checklocal();                             // process the incomming "local.net"

fclose(log);
}

// process incomming "local.net" file
void checklocal(void)
{
char tmppath[80];                         // scratch path buffer
FILE *in;                                 // handle for incomming local.net
FILE *save;
net_header_rec temp;                      // current net packet header
char trash[13];
int i;
char c;
struct ffblk fb;
strcpy(tmppath,netpath);
strcat(tmppath,"local.net");
in=fopen(tmppath,"rb+wb");
if(! in)
	  return;                             // no local.net - nothing to do !

fprintf(log,"\n** Processing %s at %s",tmppath,ctime(&now));

#ifdef DEBUG
	fprintf(log,"   TO\t  FROM\t\t  DATE\t\t\tTYPE\t\tSIZE\n");
#endif

// read a net header rec, store in temp
while(fread(&temp,sizeof(net_header_rec),1,in)!=NULL)
	  {
		fseek(in,temp.list_len*2,SEEK_CUR);// seek past list

#ifdef DEBUG
		fprintf(log,"%3d@%-4d",temp.touser,temp.tosys);
	  fprintf(log," %3d@%-4d",temp.fromuser,temp.fromsys);
	  fprintf(log,"\t%s",daten_to_date(temp.daten));
	  if(temp.main_type < 0x01c)
			 fprintf(log,"\t%x/%u %s",temp.main_type,temp.minor_type,
				  types[temp.main_type]);
	  else
			 fprintf(log,"\t%x/%d UNKNOWN !",temp.main_type,
						temp.minor_type);
        fprintf(log,"\t%ld (%d)\n",temp.length,temp.method);
#endif
      switch(temp.main_type)
		 {
          case 0x0a:
             get_board_info(&thatboard,temp.fromsys);//get info on originating sys
             if(temp.minor_type == 1000)
                 process_pak(in,&temp);    /* packscan 2.30*/
              else
                 {
                 printf("processing linker...\n");
                 process_lnk(in,&temp);   /* probably Linker */
                 }
              break;
          case 0x1b:
             get_board_info(&thatboard,temp.fromsys);
             process_pak(in,&temp);         /* Packscan 2.31 */
             break;
          default:fseek(in,temp.length,SEEK_CUR); /* dunno - skip it */
             break;
         }
    }
fclose(in);
fprintf(log,"** End of %s \n",tmppath);
return;
}


/*** following function ripped off from uedit.c ***/
unsigned char *daten_to_date(long dt)
{
  struct date d;
  struct time t;
  static unsigned char s[9];

  unixtodos(dt,&d,&t);
  sprintf(s,"%02d/%02d/%02d",d.da_mon,d.da_day,(d.da_year-1900));
  return(s);
}

// find where a packet should be routed...

int get_board_info(net_system_list_rec *node,unsigned short sys)
  {
  FILE *net;
  char fn[80];
  strcpy(fn,netpath);
  strcat(fn,"bbsdata.net");
  net=fopen(fn,"rb");
  while(fread(node,sizeof(net_system_list_rec),1,net))
    if(node->sysnum == sys)
      {
      fclose(net);
      return 1;
      }
  fclose(net);
  return 0;
}

void ssm(unsigned sys, char *msg)
{
net_header_rec h;
long mark;
FILE *locmail;
char locpath[90];

h.touser = 1;
if(sys)            // if sys == 0, it's a local ssm
   h.tosys = sys;
else
   h.tosys = thisboard.sysnum;
h.fromsys = thisboard.sysnum;
h.fromuser = 1;
h.length=(unsigned long)strlen(msg)+1;
h.main_type = 15;
h.daten = now;
h.method = 0;
h.list_len =0;
if(sys)
   {
   fwrite(&h,sizeof(net_header_rec),1,mail);
   fwrite(msg,strlen(msg)+1,1,mail);
   }
else
   {
   strcpy(locpath,netpath);
   strcat(locpath,"local.net");
   locmail=fopen(locpath,"ab");
   fwrite(&h,sizeof(net_header_rec),1,locmail);
   fwrite(msg,strlen(msg)+1,1,locmail);
   fclose(locmail);
  }
return;
}

int get_net_info(int num,net_networks_rec *rec)
{
FILE *in;
in=fopen("data/networks.dat","rb");
if(!in)
   return 0;
fseek(in,(long)(num * sizeof(net_networks_rec)),SEEK_SET);
fread(rec,sizeof(net_networks_rec),1,in);
fclose(in);
return 1;
}
