#include "tron.h"
#include <stdio.h>
#include <time.h>
#include <dir.h>

struct link{
    char netname[16];
    char fn[13];
    char des[59];
    int pktnum;
    int oneof;
    unsigned ft;
    unsigned fd;
    char fa;   // ?
};

extern net_networks_rec thisnet;
extern net_system_list_rec thisboard;
extern net_system_list_rec thatboard;

extern char netpath[];
extern FILE *incomming;
extern FILE *mail;
extern FILE *log;
extern time_t now;
extern char buf[];
char *fpath;
static unsigned long sz;

void linkin(FILE *from, net_header_rec *n);
void linkout(char *name, net_header_rec *bar);



void process_lnk(FILE *src,net_header_rec *header)
{
struct link ln;
int i;
char mess[80];
uploadsrec up;
open_mail(thatboard.forsys);

printf("Minor type %d\n",header->minor_type);
switch(header->minor_type)
  {
   case 515 : linkin(src,header);
              break;
   case 513 : fread(&ln,sizeof(struct link),1,src);
              fprintf(log,"Linker requested %s\n",
              ln.fn[0] ? ln.fn : "File List");
              if(ln.fn[0])
                 {
                 fpath = findfile(&up,ln.fn);
                 if(fpath)
                   linkout(fpath,header);
                 }
              else
                {
                linkout(filelist(),header);
                }
              break;
   default  : fprintf(log,"unknown linker subtype %d\n",header->minor_type);
              fseek(src,header->length-sizeof(struct link),SEEK_CUR);
              sprintf(mess,"Tron didn't recognize msg typ %d:%d",
                  header->main_type,header->minor_type);
              ssm(header->fromsys,mess);    // Let 'em know ! <g>
              break;

   }
fclose(mail);
return;
}


void linkin(FILE *from, net_header_rec *n)
{

unsigned foo,howlong;
directoryrec dirrec;
FILE *dirs;
char ulpath[94];
struct link l;
char t[14];
struct ffblk ffb;

fread(&l,sizeof(struct link),1,from);
howlong=(unsigned)n->length-sizeof(struct link) ;
printf("rec. file %s, %s\n",l.fn,l.des);
printf("howling = %d, pktnum=%d, oneof=%d\n",howlong,l.pktnum,l.oneof);
if(l.pktnum==1)
    {
    sz=0;
    dirs=fopen("data/dirs.dat","rb");
    if(!dirs)
        fprintf(log,"\nUnable to open directory data file !\n");
    else
        {
         fread(&dirrec,sizeof(directoryrec),1,dirs);
         strcpy(ulpath,dirrec.path);
         strcat(ulpath,l.fn);
         fprintf(log," **** Processing Linker incomming file %s\n",
                      ulpath);
         if(l.des[0])
              fprintf(log,"Description = %s\n",l.des);
         if(!findfirst(ulpath,&ffb,0))
            {
            tmpnam(t);
            fprintf(log,"FILE COLLISION - Incomming %s renamed to %s\n",
                         l.fn,t);
            strcpy(ulpath,dirrec.path);
            strcat(ulpath,t);
            }
         incomming = fopen(ulpath,"wb");
         }
    }
sz+=howlong;
if(incomming)
   {
   while(howlong > CHUNK)
      {
      fread(buf,CHUNK,1,from);
      fwrite(buf,CHUNK,1,incomming);
      howlong-=CHUNK;
      }
   fread(buf,howlong,1,from);
   fwrite(buf,howlong,1,incomming);
   if(l.pktnum==l.oneof)               /* last packet */
      {
      fclose(incomming);
      uploadit(l.fn,l.des,sz,3);
      }
   }
}



void linkout(char *name, net_header_rec *rh)
{
FILE *foo;
unsigned test;
net_header_rec h;
unsigned numchar,i,blksize;
unsigned long flength;
struct ffblk  tmp;
struct link lnk;
char nt[95];

strcpy(nt,name);
if(findfirst(nt,&tmp,0))
  {
  fprintf(log,"******* File %s not found !\n",nt);
  return;
  }
flength=tmp.ff_fsize;

memset(&lnk,0,sizeof(struct link));  // first initialize packet
memset(&h,0,sizeof(net_header_rec));
/****** setup the network packet header **********/
h.touser = 1;
h.tosys = rh->fromsys;
h.fromsys = thisnet.sysnum;
h.fromuser = 1;

h.main_type=0x0a;
h.minor_type=515;
h.daten = now;      // rh->daten;
h.method = 0;
h.list_len =0;

/******** set up the linker header ************/
strcpy(lnk.fn,tmp.ff_name);        // filename
lnk.ft=tmp.ff_ftime;
lnk.fd=tmp.ff_fdate;
lnk.fa=tmp.ff_attrib;
//strcpy(lnk.netname,thisnet.name);

blksize = (unsigned)32767 - (sizeof(net_header_rec) + sizeof(struct link));
test=(flength/blksize)+1;  // how many packets ?
lnk.oneof=(long)test ;
foo = fopen(nt,"rb");
if(!foo)
   {
   fprintf(log,"Unable to open %s\n",nt);
   return;
   }
while(flength > 0)
  {
  numchar = (flength > blksize) ? blksize : flength;
  flength -= numchar;

  h.length=sizeof(struct link)+numchar;
  fwrite(&h,sizeof(net_header_rec),1,mail);
  lnk.pktnum++;
  fwrite(&lnk,sizeof(struct link),1,mail);
  while(numchar > 512)
      {
      fread(buf,512,1,foo);
      fwrite(buf,512,1,mail); //write 512 bytes to output file
      numchar -= 512;
      }
  fread(buf,numchar,1,foo);
  fwrite(buf,numchar,1,mail); // write the rest
  }
fclose(foo);
fprintf(log,"Sent %s to %s via %d\n",name,thatboard.name,thatboard.forsys);
return;
}


