/* UPLOAD DIRECTORY INFORMATION */

typedef struct {
	char		name[41],		/* directory name */
                filename[9],    /* direct database filename */
                path[81];       /* filename path */
    unsigned char   dsl,        /* DSL for directory */
                age;            /* minimum age for directory */
    unsigned short  dar,        /* DAR for directory */
                maxfiles,       /* max files for directory */
                mask,           /* file type mask */
                type;           /* 4 digit directory type */
} directoryrec;

/*** structure of a record in a wwiv '.dir' file ***/
typedef struct {
    char    filename[13],       /* filename */
			description[59],	/* file description */
            date[9],            /* date u/l'ed */
            upby[46];           /* name of upload user */
    unsigned char
            filetype;           /* file type for apples */
    unsigned short
            numdloads,          /* number times d/l'ed */
			ownersys,ownerusr,	/* who uploaded it */
            mask;               /* file type mask */
    unsigned long
            daten,              /* date uploaded */
            numbytes;           /* number bytes long file is */
} uploadsrec;

/********** structures defined in net.h ******************/
typedef struct {
        unsigned char   type;           /* type of network */
        char            name[16];       /* network name */
        char            dir[69];        /* directory for net data */
        unsigned short  sysnum;         /* system number */
        void far        *con;           /* ptr to callout data */
        void far        *ncn;           /* ptr to contact info */
        int             num_con;        /* number in array */
        int             num_ncn;        /* number in array */
} net_networks_rec;

typedef struct {
		  unsigned short  tosys,          /* destination system */
                          touser,         /* destination user */
                          fromsys,        /* originating system */
                          fromuser;       /* originating user */
		  unsigned short  main_type,      /* main message type */
                          minor_type;     /* minor message type */
		  unsigned short  list_len;       /* # of entries in system list */
		  unsigned long   daten;          /* date/time sent */
		  unsigned long   length;         /* # of bytes of msg after header */
		  unsigned short  method;         /* method of compression */
} net_header_rec;

struct pk {
	 char sig[10];     /* packscan signature - "pksjrr G G" */
	 char fn[13];      /* filename 8.3 and terminator */
	 long size;        /* size of file being sent */
	  char fa;          /* file attributes */
	  char unk1;
	  unsigned ft;           /* file time, dos dir format */
	  unsigned fd;           /* file date, dos dir format */
     char des[59];     /* description of transaction */
     long  chksum;     /* CRC 32 ? */
	  int  msgtyp;      /* 16 sendfile, 17 reqfile , 19 reqlist */
	  int  dirnum;      /* destination directory */
	  long pktnum;      /* packet number - 1 to n */
	  long oneof;       /* THIS IS THE "N" FROM ABOVE... */
	  long unk2;        /* always 0 ? */
	  char from[60];    /* originating bbs name */
	 char netname[16]; /* originating net name */
     unsigned  tonode;    /* originating node */
     unsigned  touser;      /* destination node */
      char netname2[16];  /* destination network ? */
     unsigned fromnode;
     unsigned fromuser;
	 int stealth;      /* 1 = stealth mode */
	  char unk5[16];    /* reserved ? all zeroes */
	 int numbytes;     /* number of bytes of file data that follow...*/
};


typedef struct {
        unsigned int    sysnum;         /* system number of the system */
        char            phone[13],      /* phone number of system */
                        name[41];       /* name of system */
        unsigned int    speed,          /* max baud rate of system */
                        other,          /* other info about sys (bit-mapped)*/
                        forsys;         /* how to get there */
        int             numhops;        /* how long to get there */
        float           cost;           /* how much it costs to get there */
} net_system_list_rec;


char *findfile(uploadsrec *u, char *name);
unsigned char *daten_to_date(long dt);
unsigned long crc32file(char *name);
char *filelist(void);
unsigned long crc32file(char *name);
int findto(net_system_list_rec *node,unsigned short sys);
void ssm(unsigned sys, char *msg);
int open_mail(unsigned sys);

#define CHUNK 512
