/*****************************************************************************

		 TICPROC Fidonet to WWIV BBS File Converter
		   Copyright (C) 1994,1995 by Joe Barbara

  Distribution of the source code for TICPROC, in modified, without PRIOR
  WRITTEN APPROVAL by the author, is expressly prohibited.  Furthermore,
  you may not use this software if you have not registered you copy of
  WWIV BBS.

  Distribution of compiled versions of TICPROC are limited to copies
  compiled BY THE AUTHOR.  Distribution of any copies of TICPROC not
  compiled by the author is expressly prohibited.

*****************************************************************************/

#include "vardec.h"   /* Must get from YOUR BBS sorc code also */
#pragma hdrstop

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <stdlib.h>
#include <alloc.h>
#include <process.h>
#include <stdarg.h>

// ########## DEFINES ######################################################//

#define SETREC(f,i) lseek(f,((long) (i))*((long)sizeof(uploadsrec)),SEEK_SET);
#define MAX_LINES   10
#define VER         "1.03a"

// ########## GLOBAL VARIABLES #############################################//

typedef struct {
     char area[12],
	  file[MAXPATH];
     int  ok_to_replace,
	  file_or_dir,
	  send_ssm;
} convertrec;

char  		Area[9],
		Origin[15],
		From[15],
		Replace[15],
		File[15],
		Desc[81],
		Import_Dir[MAXPATH];
convertrec      dir_arry[100];

int             Tot_Dirs,
		ok_to_replace;

directoryrec    d;
configrec       syscfg;            /* holds config.dat data              */
configoverrec   syscfgovr;         /* holds instance config.ovr data     */

// ########## FUNCTIONS ####################################################//

unsigned long bytes_to_k(unsigned long b);
char *date(void);
void outstr(char *s);
void plcr(char *fmt, ...);

int  Get_Config(void);

void add_extended_description(char *fn, char *desc);
void delete_extended_description(char *fn);
char *read_extended_description(char *fn);

int  exist(char *s);
void cd_to(char *s);
void get_dir(char *s, int be);
void copy_file(char *input, char *output);
void align(char *s);
char *stripfn(char *fn);

int  run(char *cl);
void stuff_in(char *s, char *s1, char *f1, char *f2, char *f3, char *f4, char *f5);

void main(void);
void import_tics(void);
int  finddir(char *Area);
void upload_file(char *fn, char *rfn, char *desc);
void get_file_idz(uploadsrec *u);

// ########## UTILITY ######################################################//

unsigned long bytes_to_k(unsigned long b)
{
  return((unsigned long)((b+1023)/1024));
}
/*============================================================*/
char *date(void)
{
  static char ds[9];
  struct date today;

  getdate(&today);
  sprintf(ds,"%02d/%02d/%02d",today.da_mon,today.da_day,today.da_year-1900);
  return(ds);
}
/*============================================================*/
void outstr(char *s)
{
  char   temp[3],        /* Temp conversion var */
	 s1[50];
  int    i = 0,          /* String Counter      */
	 ansi_c,         /* ANSI Color          */
	 ansi_x,         /* ANSI X-coordinate   */
	 ansi_y;         /* ANSI Y-coordinate   */

  while (i<=strlen(s)) {

    switch (s[i]) {
      case  3:                      /* 3 = Color Change       */
	ansi_c=s[i+1]-65;
	if (ansi_c>8)
	  ansi_c=ansi_c-24;
	if (((ansi_c>=0) && (ansi_c<=15))) {
	  if (ansi_c>=8) {
	    sprintf(s1,"\x1b[0;0;%dm",ansi_c+22);
	    printf(s1);
	  } else {
	    sprintf(s1,"\x1b[0;1;%dm",ansi_c+30);
	    printf(s1);
	  }
	}
	i += 2;
	break;

      case  6:                      /* 6 = Clear screen        */
	  printf("[2J");
	i += 1;
	break;

      default:
	  sprintf(s1,"%c",s[i]);
	printf(s1);
	i++;

    }       /* sw end */
  }         /* for end */
}
/*============================================================*/
void plcr(char *fmt, ...)
{
  va_list ap;
  char s[512];

  va_start(ap, fmt);
  vsprintf(s, fmt, ap);
  va_end(ap);
  strcat(s,"\r\n");
  outstr(s);
}

// ########## READ DATA ####################################################//

int Get_Config(void)
{
  int f, i;

  if ((f = open("CONFIG.DAT", O_RDONLY | O_BINARY)) < 0)
    return(-1);

  read(f, (void *)(&syscfg), sizeof(configrec));
  close(f);

  return(0);
}

// ########## EXTENDED DESC ################################################//

void add_extended_description(char *fn, char *desc)
{
  ext_desc_type ed;
  int f;
  char edlfn[MAXPATH];

  strcpy(ed.name,fn);
  ed.len=strlen(desc);
  sprintf(edlfn,"%s%s.EXT",syscfg.datadir,d.filename);
  f=open(edlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  lseek(f,0L,SEEK_END);
  write(f,&ed,sizeof(ext_desc_type));
  write(f,desc,ed.len);
  f=close(f);
}
/*============================================================*/
void delete_extended_description(char *fn)
{
  ext_desc_type ed;
  long r,w,l1,f;
  char *ss=NULL, edlfn[MAXPATH];

  r=w=0;
  if ((ss=(char *)malloc(10241L))==NULL)
    return;
  sprintf(edlfn,"%s%s.EXT",syscfg.datadir,d.filename);
  f=open(edlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  l1=filelength(f);
  while (r<l1) {
    lseek(f,r,SEEK_SET);
    read(f,&ed,sizeof(ext_desc_type));
    if (ed.len<10000) {
      read(f,ss,ed.len);
      if (strcmp(fn,ed.name)) {
	if (r!=w) {
	  lseek(f,w,SEEK_SET);
	  write(f,&ed,sizeof(ext_desc_type));
	  write(f,ss,ed.len);
	}
	w +=(sizeof(ext_desc_type) + ed.len);
      }
    }
    r += (sizeof(ext_desc_type) + ed.len);
  }
  chsize(f,w);
  f=close(f);
  farfree(ss);
}
/*============================================================*/
char *read_extended_description(char *fn)
{
  ext_desc_type ed;
  long l,l1;
  char *ss=NULL,edlfn[MAXPATH];
  int f;

  l=0;
  sprintf(edlfn,"%s%s.EXT",syscfg.datadir,d.filename);
  f=open(edlfn,O_RDONLY | O_BINARY);
  if (f>0) {
    l1=filelength(f);
    while (l<l1) {
      lseek(f,l,SEEK_SET);
      l += (long) read(f,&ed,sizeof(ext_desc_type));
      if (strcmp(fn,ed.name)==0) {
	ss=(char *)malloc((long) ed.len+11);
	if (ss) {
	  read(f,ss,ed.len);
	  ss[ed.len]=0;
	}
	f=close(f);
	return(ss);
      } else
	l += (long) ed.len;
    }
    f=close(f);
  }
  return(NULL);
}

// ########## DISK OPS #####################################################//

int exist(char *s)
{
  int i;
  struct ffblk ff;

  i=findfirst(s,&ff,FA_HIDDEN);
  if (i)
    return(0);
  else
    return(1);
}
/*============================================================*/
void cd_to(char *s)
{
  char s1[81];
  int i,db;

  strcpy(s1,s);
  i=strlen(s1)-1;
  db=(s1[i]=='\\');
  if (i==0)
    db=0;
  if ((i==2) && (s1[1]==':'))
    db=0;
  if (db)
    s1[i]=0;
  chdir(s1);
  if (s[1]==':')
    setdisk(s[0]-'A');
}
/*============================================================*/
void get_dir(char *s, int be)
{
  strcpy(s,"X:\\");
  s[0]='A'+getdisk();
  getcurdir(0,&(s[3]));
  if (be) {
    if (s[strlen(s)-1]!='\\')
      strcat(s,"\\");
  }
}
/*============================================================*/
void copy_file(char *input, char *output)
{
  int f1, f2, i;
  char *b;
  struct ftime ft;

  plcr("\nhStart file copy");
  if ((strcmp(input, output) != 0) && (exist(input)) && (!exist(output))) {
    if ((b = (char *) malloc(20481)) == NULL)
      return;
    f1 = open(input, O_RDONLY | O_BINARY);
    f2 = open(output, O_RDWR | O_BINARY | O_CREAT | O_TRUNC, S_IREAD | S_IWRITE);
    do {
      i = read (f1, (void *) b, 20480);
	  write(f2, (void *) b, i);
    } while (i > 0);
    close(f1);
    close(f2);
    free(b);
  }
  plcr("hEnd File copy\n");
}
/*============================================================*/
void align(char *s)
{
  char f[40],e[40],s1[20],*s2;
  int i,i1,i2;

  i1=0;
  if (s[0]=='.')
    i1=1;
  for (i=0; i<strlen(s); i++)
    if ((s[i]=='\\') || (s[i]=='/') || (s[i]==':') || (s[i]=='<') ||
      (s[i]=='>') || (s[i]=='|'))
      i1=1;
  if (i1) {
    strcpy(s,"!");
    return;
  }
  s2=strchr(s,'.');
  if (s2==NULL) {
    e[0]=0;
  } else {
    strcpy(e,&(s2[1]));
    e[3]=0;
    s2[0]=0;
  }
  strcpy(f,s);

  for (i=strlen(f); i<8; i++)
    f[i]=32;
  f[8]=0;
  i1=0;
  i2=0;
  for (i=0; i<8; i++) {
    if (f[i]=='*')
      i1=1;
    if (f[i]==' ')
      i2=1;
    if (i2)
      f[i]=' ';
    if (i1)
      f[i]='?';
  }

  for (i=strlen(e); i<3; i++)
    e[i]=32;
  e[3]=0;
  i1=0;
  for (i=0; i<3; i++) {
    if (e[i]=='*')
      i1=1;
    if (i1)
      e[i]='?';
  }

  for (i=0; i<12; i++)
    s1[i]=32;
  strcpy(s1,f);
  s1[8]='.';
  strcpy(&(s1[9]),e);
  strcpy(s,s1);
  strupr(s);
}
/*============================================================*/
char *stripfn(char *fn)
{
  static char ofn[15];
  int i,i1;
  char s[81];

  i1=-1;
  for (i=0; i<strlen(fn); i++)
    if ((fn[i]=='\\') || (fn[i]==':') || (fn[i]=='/'))
      i1=i;
  if (i1!=-1)
    strcpy(s,&(fn[i1+1]));
  else
    strcpy(s,fn);
  for (i=0; i<strlen(s); i++)
    if ((s[i]>='A') && (s[i]<='Z'))
      s[i]=s[i]-'A'+'a';
  i=0;
  while (s[i]!=0) {
    if (s[i]==32)
      strcpy(&s[i],&s[i+1]);
    else
      ++i;
  }
  strcpy(ofn,s);
  return(ofn);
}

// ########## EXTERN PROGS #################################################//

int run(char *cl)
{
  int i,i1,l;
  char s[160];
  char *ss[30];

  strcpy(s,cl);
  ss[0]=s;
  i=1;
  l=strlen(s);
  for (i1=1; i1<l; i1++)
    if (s[i1]==32) {
      s[i1]=0;
      ss[i++]=&(s[i1+1]);
    }
  ss[i]=NULL;
  i=spawnvp(P_WAIT,ss[0],ss);
  return(i);
}
/*============================================================*/
void stuff_in(char *s, char *s1, char *f1, char *f2, char *f3, char *f4, char *f5)
{
  int r=0,w=0;

  while (s1[r]!=0) {
    if (s1[r]=='%') {
      ++r;
      s[w]=0;
      switch(s1[r]) {
	case '1': strcat(s,f1); break;
	case '2': strcat(s,f2); break;
	case '3': strcat(s,f3); break;
	case '4': strcat(s,f4); break;
	case '5': strcat(s,f5); break;
      }
      w=strlen(s);
      r++;
    } else
      s[w++]=s1[r++];
  }
  s[w]=0;
}

// ########## MAIN #########################################################//

void main(void)
{
  int          i;
  char         *ss, swt[31], arg[31], reg_num[21], line[81], cwd[MAXPATH],
	       s[81];
  FILE         *file;

  plcr("");

  // Defaults
  strcpy(Import_Dir,"C:\\");
  for (i=0; i<100; i++) {
    strcpy(dir_arry[i].area,NULL);
    strcpy(dir_arry[i].file,NULL);
  }
  Get_Config();

  ok_to_replace = 0;
  i = 0;

  if ((file = fopen("TICPROC.INI","rt")) != NULL) {

    while (fgets(line,80,file) != NULL) {

      if((strncmpi(line,"\n",1)!=0)  &&
	 (strncmpi(line,";",1)!=0)  &&
	 (strncmpi(line,"[",1)!=0))  {
	strupr(line);
	ss=strtok(line,"\n");     /* Strip trailing new line       */
	ss=strtok(line,";" );     /* Strip comments                */
	strcpy(s,line);
	ss=strtok(line,"=" );     /* Divide switch & argument      */               /* from msg                    */
	sprintf(swt,"%s",ss);     /* copy ptr to switch string     */
	ss=strtok(NULL,"=" );     /* get argument ptr              */
	sprintf(arg,"%s",ss);     /* copy ptr to argument string   */

	if        (strncmpi(swt,"IMPORTDIR",9)==0) {
	  ss=strtok(arg," ");
	  sprintf(Import_Dir,"%s",ss);
	  if (Import_Dir[strlen(Import_Dir)-1] != '\\')
	    strcat(Import_Dir,"\\");
	} else if (strncmpi(swt,"REPLACE"  ,7)==0) {
	  ok_to_replace = atoi(arg);
	} else if (swt!=NULL && arg!=NULL && i<100) {
	  ss=strtok(swt," ");
	  sprintf(dir_arry[i].area,"%s",ss);
	  ss=strtok(arg," ");
	  sprintf(dir_arry[i].file,"%s",ss);

/*	  strcpy(line,s);
	  ss=strtok(line,"/" );
	  ss=strtok(NULL,"/" );
	  printf("'%s'",ss);
	  sprintf(s,"%s",ss);
	  dir_arry[i].ok_to_replace = atoi(s);
	  ss=strtok(NULL,"/" );
	  printf("'%s'",ss);
	  sprintf(s,"%s",ss);
	  dir_arry[i].file_or_dir   = atoi(s);
	  ss=strtok(NULL,"/" );
	  printf("'%s'",ss);
	  sprintf(s,"%s",ss);
	  dir_arry[i].send_ssm      = atoi(s);
	  printf("ok_to_replace=%d   file_or_dir=%d   send_ssm=%d\n",
		  dir_arry[i].ok_to_replace,dir_arry[i].file_or_dir,dir_arry[i].send_ssm);
	  sleep(1);  */


	  i++;
	}
      }
    } /* end while */
    fclose(file);

  } else {
    plcr("Couldn't open TICPROC.INI File");
    exit(-1);
  }

  get_dir(cwd,1);
  cd_to(Import_Dir);

  import_tics();
  cd_to(cwd);

}
/*============================================================*/
void import_tics(void)
{
  int     f1, quit;
  char    fn1[MAXPATH], fn2[MAXPATH], line[81], *ss;
  struct  ffblk ff;
  FILE    *file;

  sprintf(fn1,"%s*.TIC",Import_Dir);
  f1=findfirst(fn1,&ff,0);

  do {

    plcr("hͻ");
    plcr("       CTICPROC Fidonet File Import Utility V%6.6s for WWIV BBS Systemsh      ",VER);
    plcr("             CCopyright 1994,1995 by Joe Barbara (1@4230 WWIVnet)h             ");
    plcr("C%*sThis Copy Running on %s%*sh",
	  (78-(strlen(syscfg.systemname)+22))/2," ",syscfg.systemname,
	  (78-(strlen(syscfg.systemname)+22))/2," ");
    plcr("ͼ");

    sprintf(fn1,"%s%s",Import_Dir,ff.ff_name);


    if ((file = fopen(fn1,"rt")) != NULL) {
      quit = 0;
      strcpy(Replace,"0");
      while ( (fgets(line     ,80,file)!=NULL)  &&  (!quit) ) {
	if        (strncmp(line,"Area"    ,4)==0) {
	  ss=strtok(line,"\n");
	  ss=strtok(line," " );
	  ss=strtok(NULL," " );
	  sprintf(Area,"%s",ss);
	} else if (strncmp(line,"Origin"  ,6)==0) {
	  ss=strtok(line,"\n");
	  ss=strtok(line," " );
	  ss=strtok(NULL," " );
	  sprintf(Origin,"%s",ss);
	} else if (strncmp(line,"From"    ,4)==0) {
	  ss=strtok(line,"\n");
	  ss=strtok(line," " );
	  ss=strtok(NULL," " );
	  sprintf(From,"%s",ss);
	} else if (strncmp(line,"Replaces",8)==0) {
	  ss=strtok(line,"\n");
	  ss=strtok(line," " );
	  ss=strtok(NULL," " );
	  sprintf(Replace,"%s",ss);
	} else if (strncmp(line,"File"    ,4)==0) {
	  ss=strtok(line,"\n");
	  ss=strtok(line," " );
	  ss=strtok(NULL," " );
	  sprintf(File,"%s",ss);
	} else if (strncmp(line,"Desc"    ,4)==0) {
	  ss=strtok(line,"\n");
	  strrev(line);
	  line[strlen(line)-5]=0;
	  strrev(line);
	  sprintf(Desc,"%s",ss);
	} else if (strncmp(line,"Seenby"  ,6)==0) {
	  quit = 1;
	}
      } /* end while */

      fclose(file);

      unlink(fn1); /* delete the tic */

      plcr("\ncArea    H: C%-8.8s                     Import Dir H: c'C%sc'",Area,Import_Dir);
      plcr("cOrigin  H: C%-15.15s              Processing H: c'C%-13.13sc'",Origin,ff.ff_name);
      plcr("cFrom    H: C%-15.15s",From);
      plcr("cReplacesH: C%-13.13s",(Replace[0]=='0')?"None.":Replace);
      plcr("cFile    H: C%-13.13s",File);
      plcr("cDesc    H: C%-56.56sh\n",Desc);

      sleep(3);

      sprintf(fn1,"%s%s",Import_Dir,File);
      if (finddir(Area)) {
	if (exist(fn1)) {
	  upload_file(File, Replace, Desc);
	  sprintf(fn2,"%s%s",d.path,File);
	  copy_file(fn1,fn2);
	  unlink(fn1);
	} else {
	  plcr("EFile '%s' Doesn't exist NOT uploaded!\n",File);
	}
	plcr("GFile '%s' Uploaded.\n",File);
      } else {
	unlink(fn1);
	plcr("ENo WWIV directory specified for '%s' Area!",Area);
	plcr("File '%s' NOT uploaded!\n",File);
      }

      f1=findnext(&ff);

    } /* end if open */
  } while (f1==0);

  plcr("\nhNo more TIC's to process.\n");

}
/*============================================================*/
int finddir(char *Area)
{
  int i,j,f,found;
  char fn[81];

  found=0;

  for (j=0; j<100 && !found; j++) {          /* Search CFG array for convert */
    if (strcmp(dir_arry[j].area, Area)==0)    /* fido dir to wwiv file dir    */
      found=1;
  }
  j--;

  if (found) {
    found=0;
    sprintf(fn,"%sDIRS.DAT",syscfg.datadir);
    if ((f=open(fn, O_RDONLY | O_BINARY))>=0) {
      Tot_Dirs= int (filelength(f)/sizeof(directoryrec));
      i=0;
      do {
	lseek(f,long (i*sizeof(directoryrec)),SEEK_SET);
	read(f, (void *)&d, sizeof(directoryrec));
	if (strcmp(dir_arry[j].file,d.filename)==0)
	  found=1;;
	i++;
      } while( i<Tot_Dirs && !found);
      close(f);
    } else {
      plcr("Cannot open '%s%s.DIR'",syscfg.datadir,dir_arry[j].file);
    }
  }

  return(found);
}
/*============================================================*/
void upload_file(char *fn, char *rfn, char *desc)
{
  int  i, f, numf, ok_to_up, try_to_replace, replaced;
  char s[81],ff[81],r_filename[13];
  long l;

  uploadsrec u,u1;

  ok_to_up = 1;
  replaced = 0;

  if (strcmp(rfn,"0")!=0) {
    strcpy(s,rfn);
    align(s);
    strcpy(r_filename,s);
    try_to_replace=1;
  } else {
    try_to_replace=0;
  }

  strcpy(s,fn);
  align(s);
  strcpy(u.filename,s);
  u.ownerusr=0;
  u.ownersys=0;
  u.numdloads=0;
  u.filetype=0;
  u.mask=0;
  sprintf(ff,"%s%s",Import_Dir,s);
  f=open(ff,O_RDONLY | O_BINARY);
  l=filelength(f);
  u.numbytes=l;
  close(f);
  strcpy(u.upby, Origin);
  strcpy(u.date,date());
  strncpy(u.description,desc,58);
  u.description[58]=0;
  time(&l);
  u.daten=l;

  get_file_idz(&u);

  sprintf(ff,"%s%s.DIR",syscfg.datadir,d.filename);
  f=open(ff,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
  SETREC(f,0);
  read(f, &u1, sizeof(uploadsrec));
  numf=u1.numbytes;
  for (i=1; i<=numf && ok_to_up; i++) {
    SETREC(f,i);
    read(f,(void *)&u1,sizeof(uploadsrec));
    if (strcmp(u1.filename,u.filename)==0) {
      if (try_to_replace && ok_to_replace && strcmp(u1.filename,r_filename)!=0 )
	 ok_to_up=0;
    }
    if (try_to_replace && ok_to_replace) {
      if (replaced) {
	SETREC(f,i-1);
	write(f,(void *)&u1,sizeof(uploadsrec));
      }
      if (strcmp(u1.filename,r_filename)==0)
	replaced=1;
    }
  }

  if (replaced) {
    numf--;
  }

  if (ok_to_up) {
    numf++;
    SETREC(f,numf);
    write(f,(void *)&u,sizeof(uploadsrec));
    SETREC(f,0);
    read(f, &u1, sizeof(uploadsrec));
    u1.numbytes=numf;
    u1.daten=l;
    SETREC(f,0);
    write(f,(void *)&u1,sizeof(uploadsrec));
  }
  close(f);

  if (replaced) {
    if (strcmp(u.filename,r_filename)!=0)
      delete_extended_description(r_filename);
  }

}
/*============================================================*/
void get_file_idz(uploadsrec *u)
{
  char *b,*ss,cmd[128],s[81];
  int f,i,ok=0;
  FILE *file;

  ss=strchr(stripfn(u->filename),'.');
  if (ss==NULL)
    return;
  ++ss;
  for (i=0; i<4 && !ok; i++)
    if (!ok)
      ok=(stricmp(ss,syscfg.arcs[i].extension)==0);
  if (!ok)
    return;

  sprintf(s,"%sFILE_ID.DIZ",Import_Dir);
  unlink(s);
  sprintf(s,"%sDESC.SDI",Import_Dir);
  unlink(s);

  sprintf(s,"%s FILE_ID.DIZ DESC.SDI", stripfn(u->filename));
  stuff_in(cmd,syscfg.arcs[i-1].arce,s,NULL,NULL,NULL,NULL);

  run(cmd);

  sprintf(s,"FILE_ID.DIZ");
  if (!exist(s))
    sprintf(s,"%sDESC.SDI");
  if (exist(s)) {
    ss=read_extended_description(u->filename);
    if (ss) {
      farfree(ss);
      delete_extended_description(u->filename);
    }
    if ((b= (char *) malloc(MAX_LINES*256+1))==NULL)
      return;
    f=open(s,O_RDONLY | O_BINARY);
    if (filelength(f)<(MAX_LINES*256)) {
      read(f,b,(int) filelength(f));
      b[filelength(f)]=0;
    } else {
      read(f,b,(int)MAX_LINES*256);
      b[(int)MAX_LINES*256]=0;
    }
    close(f);
    ss=strtok(b,"\n");
    sprintf(u->description,"%.56s",ss);
    ss=strtok(NULL,"");
    for (i=strlen(ss)-1; i>0; i--) {
      if ((ss[i]==26) || (ss[i]==12))
	ss[i]=32;
    }
    add_extended_description(u->filename,ss);
    u->mask |= mask_extended;
    free(b);
    plcr("gRead in D%s gas extended description.");
  }
  sprintf(s,"FILE_ID.DIZ");
  unlink(s);
  sprintf(s,"DESC.SDI");
  unlink(s);
}
/*============================================================*/
