In order to get SinMail to work with your system, these mods must be made to
the WWIV source code.  These have been tested with versions v4.24 and v4.24a
and are planned to be updated as new versions of WWIV are released.

There are three main sections to this file.  The first includes all the
necessary changes which will enable SinMail to work with your system.  The
second part adds an automatic dialer to your WFC so your system will be able
to call your internet connection.  The third section gives your users their
own plan files which users on the internet can finger through SinMail.  For
more information on the finger system, please refer to the main documenation
for SinMail.

Why is this section broken up into three separate sections?  In the interest
of proper modularity and future modifications writen by Singe Technologies
and/or third parties, this makes it easier to distinguish the main sections
that might be built upon.


  KEY to symbols:

    ##  = Look for this existing code (in unmodified original source code)
     +  = Add this line of code
    -   = Remove this line of code


:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::
:::  SinMail Mod
:::

This section is absolutely necessary if you wish to run SinMail.

Adds approximately 1.5kb to your BBS.EXE

[ ] VARDEC.H ================================================================

  (1) Look for this code near the top of the file and make the
      appropriate additions.

##  #ifndef __OS2__
##  #define RIPDRIVE
##  #endif
##
 +  // sinmail block start
 +  #define INTERNET_EMAIL   65532
 +  #define INTERNET_NEWS    65533
 +  #define INTERNET_STORAGE 3
 +  // sinmail block end
##
##  #define OK_LEVEL 0


[ ] FCNS.H ==================================================================

  (1) Change the line for "int open_email".   (Near line 233 if you haven't
      changed your source very much.)

-  int open_email(int wrt);
 + int open_email(unsigned int wrt);


[ ] MSGBASE.C ===============================================================

  (1) SEARCH for "void remove_link".  Down a few lines more (about 20):

##  case 2:
 +  case INTERNET_STORAGE: // sinmail line
##    f=open_file(aux);

  (2) Again, about 25 lines down in "void savefile":

##  case 2:
 +  case INTERNET_STORAGE: // sinmail line
##    f=open_file(aux);

  (3) Again, about 30 lines down in "char *readfile":

##  case 2:
 +  case INTERNET_STORAGE: // sinmail line
##    f=open_file(aux);

  (4)  In the "void inmsg" function, SEARCH for "if (real_name)" and put
       this section of code _above_ it.

##    l1=0;
 +    // sinmail block start
 +    if (strcmpi(aux,"imail")==0)
 +      addline(b,dest,&l1);
 +    // sinmail block end
##    if (real_name)
##      addline(b,thisuser.realname,&l1);
##    else
##      addline(b,nam1(&thisuser,usernum,net_sysnum),&l1);

  (5) A little over 50 lines down in inmsg from where you just were, you'll
      find this section:

##  if (sysinfo.flags & OP_FLAGS_MSG_TAG) {
##    if ((xsubs[curlsub].num_nets) && (strcmp(aux,"EMAIL")!=0)
 +        && (strcmp(aux,"IMAIL")!=0) // sinmail line
##        && (!(subboards[curlsub].anony & anony_no_tag))
##        && (strcmp(strupr(irt),strupr(get_string(333)))!=0)) {

  (6) SEARCH for "int open_email", make these changes and insert these lines:

-   int open_email(int wrt)
 +  int open_email(unsigned int wrt)
##  {
##    char s[100];
##    int f,i;
##
 +    // sinmail block start
 +    if(wrt==INTERNET_EMAIL)
 +      sprintf(s,"%sIMAIL.DAT", syscfg.datadir);
 +    else
 +    // sinmail block end
##    sprintf(s,"%sEMAIL.DAT", syscfg.datadir);
##
##    for (i=0; i<5; i++) {

  (7) SEARCH for "void sendout_email".  About 25 lines down ...

##  if (sy==0) {
 +    // sinmail block start
 +    if ((un==INTERNET_EMAIL)||(un==INTERNET_NEWS))
 +      f=open_email(INTERNET_EMAIL);
 +    else
 +    // sinmail block end
##    f=open_email(1);
##    if (f<0) {
##      return;
##    }

  (8) SEARCH for "get_string(647)", which should be about 80 lines down,

##    bbsfree(b);
##    bbsfree(b1);
##  }
##  s2[0]=0;
##  strcpy(s,get_string(647));
 +
 +  // sinmail block start
 +  if (un==INTERNET_EMAIL)
 +    strcat(s,net_email_name);
 +  else if (un==INTERNET_NEWS)
 +    strcat(s,subboards[curlsub].name);
 +  else
 +  // sinmail block end
 +
##  if (sy==0) {
##    read_user(un,&ur);
##    ++ur.waiting;

  (9) SEARCH for "void email".  Near the top, put in this chunk of code:
      (it's large, but try to bear with it; you're almost done MSGBASE.C)

##  char s2[81],t[81];
##  userrec ur;
##  slrec ss;
##  net_system_list_rec *csne;
##
##
 +  // sinmail block start
 +  if (un==INTERNET_EMAIL) {
>+    if (0x0100 & thisuser.ar) {
 +      // user is qualified
 +      // net_email_name has recipient's email address
 +      nl();
 +      prt(7,"Internet email to: ");
 +      prt(3,net_email_name);
 +      nl();
 +      strcpy(s2,net_email_name);
 +      msg.storage_type=2;
 +      write_inst(INST_LOC_EMAIL, INTERNET_EMAIL, INST_FLAGS_NONE);
 +
 +      // now get the message.
 +      inmsg(&msg,t,0,1,"IMAIL",ALLOW_FULLSCREEN,s2,0);
 +      if (msg.stored_as==0xffffffff)
 +        return;
 +      sendout_email(t, &msg, 0, INTERNET_EMAIL, 0, 0, usernum,
 +        net_sysnum, 0, net_num);
 +
 +      sprintf(s2,"9Sent Internet email to 1%s9.0",net_email_name);
 +      sysoplog(s2);
 +      return;
>+    }
>+    else {
>+      // user is not qualified
>+      nl();
>+      pl("9I'm sorry, your account cannot access Internet email.");
>+      nl();
>+      return;
>+    }
 +  }
 +  // sinmail block end
 +
##  if (freek1(syscfg.msgsdir)<10.0) {
##    nl();
##    pl(get_string(332));

  ==> Special Note:  The lines above that begin with the symbol >+ indicate
      lines that the SysOp may wish to change to suit his or her own system.
      On The Ethereal Plane, an AR of I indicates that a user has the access
      to send or receive Internet mail, but this is changable above.  You
      may also wish to remove the >+ lines entirely, which will still work,
      but will not restrict certain users from using Internet email.  This is
      left to the SysOp's discretion.

  (10) SEARCH for "void read_message1".  About 25 lines down :

##    case 2:
 +    case INTERNET_STORAGE: // sinmail line
##      ss=readfile(&m,fn,&len);
-       if (m.storage_type!=2) {
 +      // sinmail line changed
 +      if ((m.storage_type!=2) && (m.storage_type!=INTERNET_STORAGE)) {
##        strcpy(s,syscfg.msgsdir);
##        ltoa(m.stored_as,s1,16);
##        if (m.storage_type==1) {

  (11) Down about 150 lines in read_message1 ...
       (SEARCH for "case 2:")

##      case 2:
 +      case INTERNET_STORAGE: // sinmail line
##        ch=ss[l1];
##        if (l1>=len)

  (12) SEARCH for "void lineadd".  About 25 lines down from that:

##    case 2:
 +    case INTERNET_STORAGE: // sinmail line
##      f=open_file(aux);


[ ] READMAIL.C ==============================================================

  (1) SEARCH for "fromsys==0".  This should be in the void readmail function,
      about 108 lines down from readmail, and 373 from the top of the file.
      (The search should nab it fine though, don't bother counting. <grin>)

##      } else {
##        if (m.fromsys==0) {
 +          // sinmail block start
 +          if (m.fromuser==INTERNET_EMAIL) {
 +            grab_user_name(&(m.msg),"EMAIL");
 +            sprintf(s1,"%30.30s",net_email_name);
 +            strcat(s,s1);
 +          }
 +          else
 +          // sinmail block end
##          if (m.fromuser==65535) {
##            if (nn!=255)
##              strcat(s,net_networks[nn].name);

  (2) Down about 100 lines...  (SEARCH for "rd_coff")

##  #ifdef RIPDRIVE
##        rd_coff();
##  #endif
##        pla(s,&abort);
-         if ((m.fromsys) && (!m.fromuser))
 +        // sinmail line changed
 +        if (((m.fromsys) && (!m.fromuser)) ||
 +         (m.fromuser == INTERNET_EMAIL))
##          grab_user_name(&(m.msg),"EMAIL");
##        else
##          net_email_name[0]=0;


[ ] BBSUTL1.C ===============================================================

  (1) SEARCH for "void parse_email_info".  About 10 lines down:

##        if (un>0)
##          *un1=un;
##        else
##          pl(get_string(8));
 +  /*         // sinmail commenting this block out.
##  } else if (atoi(ss+1)==0) {
##        for (i=0; i<net_num_max; i++) {
.
.   should be a few more lines in here ...  we're getting rid of them anyway
.   by commenting them out.
.
##        if (i>=net_num_max)
##          pl(get_string(8));
 +  */         // sinmail block out end
##  } else {
 +    // sinmail block start
 +    // at this point, we know they put something after the @at@ sign
 +    if(isalpha(ss[1])) {
 +      // to get here, there are letters after the @at@ sign
 +      *un1=INTERNET_EMAIL;
 +      strcpy(net_email_name,s);
 +      return;
 +    }
 +    if(isdigit(ss[1])) {
 +      // to get here, there are numbers.
 +      // this might not be for the internet though so we have to check.
 +      ss1=strchr(ss+1,'.');
 +      if(ss1) if(isdigit(ss1[1])) {
 +        // now we have at least '@255.1'... so we can safely guess its
 +        // an internet IP address.
 +        *un1=INTERNET_EMAIL;
 +        strcpy(net_email_name,s);
 +        return;
 +        }                         
 +      }
 +    // sinmail block end
##
##        ss[0]=0;
##        ss=&(ss[1]);
##        i=strlen(s);
##        while ((i>0) && (s[i-1]==' '))


[ ] BBSOVL1.C ===============================================================

  (1) This step isn't that important, but it does add the 'feel' of having
      Internet mail by making the mail input prompt lowercase.  SEARCH for
      "void send_email".  A few lines down:

##  pl(get_string(15));
##  helpl=14;
##  outstr(":");
-   input(s1,75);
 +  inputl(s1,75); // sinmail line
##  helpl=0;


[ ] FIX.C ===================================================================

  (1) SEARCH for "case 2".  It should be in the "void remove_link" function.

##      unlink(s);
##      break;
##    case 2:
 +    case INTERNET_STORAGE:  // sinmail line
##      f=open_file(aux);
##      if (f>=0) {
##        set_gat_section(f,(int) (m.stored_as/2048));

  (2) SEARCH for "void check_type_2".  About 40 lines down:

##  anything_done=0;
##
##  for (i=0; i<num; i++)
-     if (list[i].storage_type==2) {
 +    // sinmail line changed
 +    if ((list[i].storage_type==2) ||
 +      (list[i].storage_type==INTERNET_STORAGE)) {
##      if (f<0) {
##        if (!any) {

  (3) Down about 50 lines from there:

##    printf("%sErrors in '%s%s.DAT':\n",NOK,syscfg.msgsdir,extra);
##    for (i=0; i<num; i++)
-       if (list[i].storage_type==2) {
 +      // sinmail line changed
 +      if ((list[i].storage_type==2) ||
 +        (list[i].storage_type==INTERNET_STORAGE)) {
##        sec=(list[i].stored_as/2048)*2048;
##        csec=list[i].stored_as % 2048;


[ ] QWK.C ===================================================================

  (1) SEARCH for "char *qwk_readfile".  About 35 lines down:

##      b[*l]=0;  // Null terminate out text
##      break;
##    case 2:
 +    case INTERNET_STORAGE: // sinmail line
##
##      // You will notice that this case opens, but does not close its file
##      // This is becuase of the optimized open file routine, the file gets


[ ] MSGBASE1.C ==============================================================

  (1) SEARCH for "write_inst".  The first one should be about 70 lines down
      in the "void post" function.

##  time1=time(NULL);
##
##  write_inst(INST_LOC_POST,curlsub,INST_FLAGS_NONE);
##
 +  // sinmail block start
 +  if (subboards[curlsub].storage_type == INTERNET_STORAGE) {
 +    nl();
 +    prt(7,"posting on usenet newsgroup: ");
 +    prt(3,subboards[curlsub].name);
 +    nl();
 +    inmsg(&m,p.title,0,1,"IMAIL",ALLOW_FULLSCREEN,subboards[curlsub].name,0);
 +    if(m.stored_as==0xFFFFFFFF)
 +      return;
 +    sendout_email(p.title,&m,0,INTERNET_NEWS,0,0,usernum,0,0,0);
 +    sprintf(s,"9posted on usenet newsgroup: 1%s9.0",
 +      subboards[curlsub].name);
 +    sysoplog(s);
 +    nl();
 +    prt(7,"Be patient, your post will not show up immediately ...");
 +    nl();
 +    return;
 +  }
 +  else
 +  // sinmail block end
 +
##  inmsg(&m,p.title,&a,1,(subboards[curlsub].filename),ALLOW_FULLSCREEN,
##    subboards[curlsub].name, (subboards[curlsub].anony&anony_no_tag)?1:0)
##  if (m.stored_as!=0xffffffff) {

  (2) SEARCH for "case 'A'".  It should be about 200 lines down inside the
      "void scan" function.

##  case 'A':
##    if (rip_on()) {
##      sprintf(s,"\n!|w000%c271610|e|#\r ", formery);
##      comstr(s);
##    }
##    strcpy(irt_sub, subboards[usub[cursub].subnum].name);
-     if ((get_post(msgnum)->ownersys) && (!get_post(msgnum)->owneruser))
 +    // sinmail line changed
 +    if (((get_post(msgnum)->ownersys) && (!get_post(msgnum)->owneruser))
 +      || (get_post(msgnum)->owneruser == INTERNET_EMAIL))
##      grab_user_name(&(get_post(msgnum)->msg),subboards[curlsub].filename);
##    grab_quotes(&(get_post(msgnum)->msg),subboards[curlsub].filename);


[ ] SUBEDIT.C ===============================================================

  (1) SEARCH for "exist".  You should be able to find it in the
      "void modify_sub" function.  A little over 100 lines down:

##    sprintf(s,"%s%s.SUB",syscfg.datadir,r.filename);
##    sprintf(s1,"%s%s.DAT",syscfg.msgsdir,r.filename);
-     if ((r.storage_type==2) && (!exist(s)) && (!exist(s1)) &&
 +    // sinmail line changed
 +    if (((r.storage_type==2) || (r.storage_type==INTERNET_STORAGE)) &&
 +      (!exist(s)) && (!exist(s1)) &&
##      (strcmp(r.filename,"NONAME")!=0)) {
##      prt(2,get_string(973));

  (2) SEARCH for "case 'K'".  It should be about 150 lines down from
      where you were, in the same function.  If you have changed the value
      of INTERNET_STORAGE, you may need to make some changes here.

##  case 'K':
##    nl();
##    prt(2,get_string(205));
##    input(s,4);
##    i=atoi(s);
-     if ((s[0]) && (i>=0) && (i<=2))
 +    // sinmail line changed
 +    if ((s[0]) && (i>=0) && (i<=INTERNET_STORAGE))
##      r.storage_type=i;
##    break;


[ ] BBS.STR =================================================================

  (1) You've probably noticed that we are adding an option to the above
      part in which the SysOp can choose a message base's storage type.
      You will need to change the BBS.STR line 205 to reflect this change
      if you want it to show up in the prompt line.  BBS.STR is found in the
      GFILES directory and can be editing with MINIESM, included with the
      WWIV source, or with any other External String Manager.  Here is an
      example of the usage for MINIESM

    C:\WWIV>MINIESM GFILES\BBS.STR -M205
    GFILES\BBS.STR: 1639 strings

    String #205: "New Storage Type (0,1,2) ? "

    New? New Storage Type (0,1,2,3) ?


    Change string #205 to:
    "New Storage Type (0,1,2,3) ? "

    Sure? y

    Updated string #205

      Please note, that the addition of '3' relies on the fact that you have
      chosen 3 as the INTERNET_STORAGE value.  If you have changed the value,
      it would make sense to make the obvious change here as well.  Also note
      the additional space at the end of the string.  It's not a big deal,
      but since you've taken the time to read this, why not make it look
      nice too?


:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::
:::  Dialout Mod
:::

This mod is pretty much required if you would like your system to
automatically dialout to your connection from the WFC.

Adds approximately 176 bytes to your BBS.EXE  


[ ] BBS.C ===================================================================

  (1) SEARCH for "void getcaller".  Down a few lines more:

##  double d;
##  userrec tu;
 +  unsigned long l;            // sinmail line
 +  l=(long)time(NULL) + 3600;  // sinmail line
##  c_sub=c_dir=0;

  (2) a little further down in "void getcaller":

##    attempt_callout();
##    any=1;
##  }
##
 +  // sinmail block start
 +  // auto dialout after specified duration of time
 +  if ((long)time(NULL)>=l) {
 +    l=(long)time(NULL) + 3600;
 +    if (instance==1) {
 +      // callout time
 +      pl("polling...");
 +      extern_prog("poll.bat",EFLAG_SHRINK);
 +    }
 +  }
 +  // sinmail block end
 +
##  if (kbhitb()) {


  (3) down a little bit more ...

## if (ch) {
##   wfc=2;
##   any=1;
##   switch(ch) {
 +
 +     // sinmail block start
 +     // poll internet connection by pressing '\' backslash key from WFC.
 +     case '\\':
 +       l=(long)time(NULL) + 3600;
 +       // callout time
 +       pl("polling...");
 +       extern_prog("poll.bat",EFLAG_SHRINK);
 +       break;
 +     // sinmail block end
 +
##     case '=':
##       if (ok_local()) {


