/* Net.h								*/
/*									*/
/*	Global defines for WWIV packets					*/
/*									*/
/* REVISION HISTORY:							*/
/*	Matt Logan - 09/14/89 Initial version				*/
/*									*/
/*									*/

typedef struct {
	unsigned short	tosys,		/* destination system */
                        touser,		/* destination user */
                        fromsys,	/* originating system */
                        fromuser;	/* originating user */
        unsigned short	main_type,	/* main message type */
        		minor_type;	/* minor message type */
        unsigned short  list_len;	/* # entrees in system list */
        unsigned long	daten;		/* date/time sent */
        unsigned long	length;		/* # of bytes of msg after header */
        unsigned short	method;
} net_header_rec;

#define main_type_net_info 0x0001
#define main_type_email 0x0002
#define main_type_post 0x0003
#define main_type_file 0x0004
#define main_type_pre_post 0x0005
#define main_type_external 0x0006
#define main_type_email_name 0x0007

typedef struct {
	unsigned int	sysnum;
	char					phone[13];
								name[41];
	unsigned int	speed,
								other,
								forsys;
	int						numhops;
	float					cost;
} net_system_list_rec;

