/*******************************************************************/
/* This software was written by Matt Logan over nearly a year for  */
/* the WWIVnet/Fidonet community.  This software may be freely     */
/* modified and re-compiled.  Modified source must accompanied by  */
/* the original source if it is made availiable on any public BBS. */
/* Modified versions on the binaries may not be posted on any      */
/* public BBS.  All documenation, source, and executables must be  */
/* included in any distribution of this software.  All Copyright   */
/* notices must be left intact in the source and included          */
/* documentation files.                                            */
/*                                                                 */
/* The intent here is to provide the WWIV/FIDONET community with   */
/* reliable access to the lastest versions of this software.  I    */
/* would ask that any modifications that prove to be very useful   */
/* be made availiable to me so that I may include them in future   */
/* releases of this software.  This software may not be sold for   */
/* profit for any reason.  I intend to keep NetSEX a Public Domain */
/* utility FOREVER.                                                */
/*                                                                 */
/*                                                                 */
/* Addresses:                                                      */
/*              USENET:  matt@eecs.cs.pdx.edu                      */
/*             WWIVNET:  1@5317                                    */
/*                                                                 */
/*             US MAIL:  Matt Logan                                */
/*                       11790 S.W. Denney Rd.                     */
/*                       Beaverton Oregon 97005                    */
/*                                                                 */
/*                                                                 */
/* Contributions are welcome and will most likely be applied to my */
/* tuition payments for my last year in college as a Physics/Music */
/* major at Portland State University.                             */
/*                                                       06/14/90  */
/*******************************************************************/



/* NETS.c                                                           */
/*                                                                  */
/*	Converts FIDO packets into WWIV packets and vice versa.         */
/*                                                                  */
/*                                                                  */
/* REVISION HISTORY:                                                */
/*                                                                  */
/*    Matt Logan - 09/25/89 Initial version.                        */
/*                                                                  */
/*    Matt Logan - 11/10/89 Added Aliases, Local and Sub Commands.  */
/*                                                                  */
/*    Matt Logan - 11/17/89 Processed fido messages get bit 10 in   */
/*                          the Attribute field set instead of      */
/*                          being deleted.                          */
/*                                                                  */
/*    Matt Logan - 01/05/90 A whole Lotta stuff fixed, optimized    */
/*                          added. Points, OUT_ALIAS.               */
/*                                                                  */
/*    Matt Logan - 02/11/90 Version 0.89 a ^AWWIVGATE: line is now  */
/*                          used to mark messages as processed.  A  */
/*                          few more bugs have been fixed.          */
/*                          P<N>.NET Files are now created instead  */
/*                          of being appended (Dangerous) and the   */
/*                          limit on the number of BBS's has been   */
/*                          removed.                                */

/* Version - used in log files and in the startup message */
/* NetSEX prints.  It must be FOUR characters long */
#define Version "1.05"

#include "NET.H"
#include "FIDO.H"
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <sys/stat.h>
#include <dos.h>
#include <dir.h>
#include <time.h>

/* De-Comment this line if you want NetSEX to print */
/* Ooodles of debug information,  I mean oodles!    */
/*   |      */
/*	 |      */
/*  \|/     */
/*#define DEBUG*/

/* Structure used to dynamically store the aliases */
struct Alias {
	char in[37], out[37];
};


/* Structure used to store the log information */
typedef struct {
	char name[40];
	unsigned short sub_type;
	unsigned short host;
	unsigned long in_messages, out_messages;
	unsigned long in_bytes, out_bytes;
} log_entry;

/* Structure used to store BBS info for the "From System" Line */
/* On outbound fidonet mail from wwivnet */
struct Stats {
		unsigned int	sysnum;
		char					phone[13],
									name[41];
	};

struct date datep;
struct time timep;
short sub_list[50];
unsigned int sub_type, host_system;
long list_len, Log_Count, Ltime;
log_entry *Ldata;
char Log_Update;
FILE *Net, *Sub, *Log;
char *Path;
char *MailDir;
char *Search;
int NextEnt(), ReadLine(), ProcMess(), Parse(), ParseName();
char Number[10];
unsigned short MyNode, LocalNode;
int FidoNet, FidoNode, FidoZone;
char *Buffer;
char *Banner;
char *wwivpath;
char *MBuf;
long MLength;
net_header_rec header;
struct Alias *Alias;
struct Stats *Stats;
int NumAlias;
int LineCount;
void Import(), Export();
char area[40], bd_flag, export_flag;
int Fidoize();
int destNet, destNode;
char *tname;
void Alloc(), Free();
void Load_Log(), Save_Log(), Faddress();
int Point, ToPoint, Zone, FNet, FNode;
unsigned short CNode, WWIVgate;
char NetString[11];

/* Some flags used in netsex */

/* This flag determines where (if at all) the NETID */
/* string will be printed on fidonet messages       */
/* This string takes the form:                      */
/* <BBSNAME> - [<PHONE>] - Node <NODE NUMBER>				*/
/* This line has caused problems in the past with   */
/* A utility called Areafix.  This flag was created */
/* In an effort to solve this problem.							*/
int NETID_FLAG = 2;

void main( argc, argv)
int argc;
char **argv;
{
	long clock1, clock2;
	time(&clock1);
	printf("NetSEX! Version %s Copyright Matt Logan 1989, 1990\n", Version);
	printf("%s\n", ctime(&clock1));

	NetString[0] = 0;
	CNode = 0;

	Alloc();
	if ( argc == 2 || ( argc == 3 && strcmp(argv[2], "/WF") == 0 )) {
		printf("Running Import then Export\n");
		Load_Log(argv[1]);
		Import(argv);
		Export(argv);
	} else if ( argc == 3 && strcmp(argv[2], "/FW") == 0 ) {
		printf("Running Export then Import\n");
		Load_Log(argv[1]);
		Export(argv);
		Import(argv);
	} else if ( argc == 3 && strcmp(argv[2], "/W") == 0) {
		printf("Running Import only\n");
		Load_Log(argv[1]);
		Import(argv);
	} else if ( argc == 3 && strcmp(argv[2], "/F") == 0) {
		printf("Running Export only\n");
		Load_Log(argv[1]);
		Export(argv);
	} else {
		printf("Usage: %s <DATAPATH> [/FW]\n", argv[0]);
		Free();
		exit(0);
	}
	Save_Log(argv[1]);
	Free();
	time(&clock2);
	printf("Total time: %ld Seconds\n", clock2 - clock1);
}


/* Function: Alloc()
**
** Purpose: Allocate all the dynamic variables
**
** Inputs: NONE.
**
** Variables effected:
**
**   MBuf:    The message buffer
**   Buffer:  A buffer for general use.
**   Path:    The string used to point to various directories
**   Maildir:
**   Search:
**   wwivpath:
**   tname:
**
** Return Value: None.
*/

void Alloc()
{

	/* Huge stuff first in case of low memory */
	MBuf =			(char *)malloc(33000);
	Buffer =		(char *)malloc(240);
	Banner =		(char *)malloc(161);
	Path =			(char *)malloc(81);
	MailDir =		(char *)malloc(81);
	Search =		(char *)malloc(81);
	wwivpath =	(char *)malloc(80);
	tname =			(char *)malloc(80);

	if (Buffer == NULL || Banner == NULL || wwivpath == NULL ||
			MBuf == NULL || Path == NULL || MailDir == NULL || Search == NULL ||
			tname == NULL) {
			printf("Can't allocate Memory");
			Free();
			exit(-1);
	}
}

/* routine to free the memory allocated */
void Free()
{
	free(Buffer);
	free(Banner);
	free(wwivpath);
	free(MBuf);
	free(Path);
	free(MailDir);
	free(Search);
	free(Alias);
	free(tname);
}


/* This procedure imports messages from FIDO to WWIV */
void Import(argv)
char **argv;
{

	long msg_cnt, byte_cnt;
	FILE *fd1, *fd2;
	int x, y, z, no_end;
	long Position;
	unsigned char c;
	unsigned short syst;
	char Subject[80];
	char ToUser[37];
	char Name[80];
	char AName[80];
	char Date[80];
	struct ffblk ffblk;
	int done;
	int MailFlag;
	unsigned char print_flag;
	char *B2;

	printf("\n\nImporting...\n");
	strcpy(wwivpath, argv[1]);

	export_flag = 0;
	MailDir[0] = 0;
	LocalNode = 0;
	NumAlias = 0;
	LineCount = 0;
	/* Set Banner to null for now */
	Banner[0] = 0;

	sprintf(Buffer, "%s/FIDO.NET", wwivpath);
	Net = fopen(Buffer, "rt");
	if ( Net == NULL) {
		printf("Can't Find %s\n", Buffer);
		exit(-1);
	}

	x = 0;
	do {
		x++;
		sprintf( Buffer, "%s/P%d.NET", wwivpath, x);
		fd2 = fopen(Buffer, "rb");
		if (fd2 == NULL) {
			fclose(fd2);
			fd2 = fopen(Buffer, "w+b");
			break;
		} else {
			fclose(fd2);
		}
	} while (x < 10);

	if (x >= 10) {
		printf("Error,  couldn't open a P*.NET FILE\n");
	}


while ( NextEnt() == 0) {

/* This Section of code finds the FIDO messages and converts them       */
/*	into WWIV messages						*/
	sprintf(Search, "%s/*.MSG", Path);
	msg_cnt = 0; byte_cnt = 0; print_flag = 0;
	done = findfirst(Search, &ffblk, 0);

	while (!done) {
		sprintf( Search,"%s/%s", Path, ffblk.ff_name);
		fd1 = fopen( Search, "r+b");
		if ( fd1 == NULL) {
			printf("Error opening file %s\n", Search);
			exit(-1);
		}

		/* Find out if this message has already been processed */
		fseek( fd1, 0, 0);
		fread(AName, 36, 1, fd1);
		fread(tname, 36, 1, fd1);
		fseek(fd1, 166,0);
		fread( &destNode, 2, 1, fd1);
		fseek(fd1, 174, 0);
		fread( &destNet, 2, 1, fd1);

		/* If it hasn't been processed,  process it! */
		if ( strncmp ( AName, "QMail", 5) != 0 && (ffblk.ff_fsize < 28000)) {

/*			strupr(AName);*/
			msg_cnt++;
			gettime(&timep);
			getdate(&datep);
			header.tosys = host_system;
			header.touser = 0;
			header.fromsys = MyNode;
			header.fromuser = 0;
			header.main_type = main_type_pre_post;
			header.minor_type = sub_type;
			header.list_len = list_len;
			header.daten = dostounix(&datep, &timep);
			header.method = 0;
			header.length = 0;

			/* This loop reads the header and gets some info from it */

			/* This is only used if running mail */
			fseek( fd1, 36, 0);
			fread(ToUser, 36, 1, fd1);

			fread(Subject, 72, 1, fd1);
			fread(Date, 20, 1, fd1);

			/* Put the proper Fido Net/Node number in the name */
			fseek(fd1, 168, 0);
			fread(&FNode, 2, 1, fd1);
			fseek(fd1, 172, 0);
			fread(&FNet, 2, 1, fd1);
			fseek( fd1, 190, 0);

			Zone = FidoZone;
			Point = 0;
			ToPoint = 0;
			WWIVgate = 0;
			header.length = MLength = ProcMess(fd1);

/*			printf("fidonet %d\n", (int)FidoNet);
			printf("Fidonode %d\n", (int)FidoNode);
			printf("destnet %d\n", (int)destNet);
			printf("destnode %d\n", (int)destNode);
			printf("FNode %d\n", (int)FNode);
			printf("FNet %d\n", (int)FNet);
			printf(" What? %d\n", (int)~(22 == 2 && 1 == 1));
*/
			if ( ((destNet == FidoNet && destNode == FidoNode
				&& ToPoint == 0) || sub_type !=0)
				&& WWIVgate != LocalNode) {


				fseek(fd1, 0, 2L);
				x = ftell(fd1) - sizeof(struct MessageHdr);
				B2 = malloc( x);
				if (B2 == 0) {
					printf("Error, not enough memory\n");
					exit(-1);
				}

				fseek(fd1, sizeof(struct MessageHdr), 0L);
				fread(B2, x, 1, fd1);
				fseek(fd1, sizeof(struct MessageHdr), 0L);
				fprintf( fd1, "%cWWIVGATE: %d%c%c",
					1, LocalNode, 13, 10);
				fwrite(B2, x, 1, fd1);
				free(B2);

				if ( sub_type == 0 ) {
					if (Point == 0 && Zone == FidoZone) {
						sprintf( Name, "%s OF %d/%d", AName, FNet, FNode);
					} else if ( Point != 0 && Zone == FidoZone) {
						sprintf( Name, "%s OF %d/%d.%d", AName, FNet, FNode, Point);
					} else if (Point == 0 && Zone != FidoZone) {
						sprintf( Name, "%s OF %d:%d/%d", AName, Zone, FNet, FNode);
					} else {
						sprintf( Name, "%s OF %d:%d/%d.%d", AName, Zone, FNet, FNode, Point);
					}
				} else {
						sprintf( Name, "%s", AName);
				}

				byte_cnt += header.length;

				if (print_flag == 0) {
					if (sub_type == 0) {
						printf("Mail:\n");
					} else {
						printf("Sub %ld:\n", (long)sub_type);
					}
					printf("Date       Time     %-5s %-13.13s %s\n", "Size", "To", "From");
					printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
					print_flag = 1;
				}

				printf("%s %5ld %-13.13s %s\n", Date,
				 (long)header.length, ToUser, Name);


				header.length += (strlen(Subject) + 1) + ( strlen(Name) + 2) + (strlen(Date) + 2);

				if (sub_type == 0) {
					MailFlag = ParseName(ToUser);
				}

				if ( Banner[0] != 0) {
					header.length += (strlen(Banner));
				}

				/* Write Header */
				fwrite(&header, sizeof(header), 1, fd2);

				if (sub_type == 0 && MailFlag == 1) {
					fwrite( ToUser, strlen(ToUser), 1, fd2);
					c = 0;
					fwrite( &c, 1, 1, fd2);
				}

				/* Write Title, Name and Date */
				fwrite( Subject, strlen(Subject), 1, fd2);
				c = 0;
				fwrite( &c, 1, 1, fd2 );

				fwrite( Name, strlen(Name), 1, fd2);
				c = 13;
				fwrite( &c, 1, 1, fd2 );
				c = 10;
				fwrite( &c, 1, 1, fd2 );

				fwrite( Date, strlen(Date), 1, fd2);
				c = 13;
				fwrite( &c, 1, 1, fd2 );
				c = 10;
				fwrite( &c, 1, 1, fd2 );

				/* Write Body of text */
				fwrite( MBuf, MLength, 1, fd2);


				/* Write Banner if there is one */
				if ( Banner[0] != 0) {
					fwrite( Banner, strlen(Banner), 1, fd2);
				}
			}
		}
		fclose(fd1);
		done = findnext(&ffblk);
	}
	if (print_flag != 0) {
		printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
		printf("%ld Messages, %ld Bytes\n\n", msg_cnt, byte_cnt);
		for (x = 0; x != Log_Count; x++) {
			if (strcmp( area, Ldata[x].name) == 0) break;
		}
		if ( x == Log_Count ) {
			Log_Count++;
			if (Ldata == NULL) {
				Ldata = (log_entry *)malloc(sizeof(log_entry));
			} else {
				Ldata = (log_entry *)realloc( Ldata, Log_Count * sizeof(log_entry));
			}
			for (y = 0; y != 40; y++) {
				Ldata[x].name[y] = 0;
			}
			strcpy(Ldata[x].name, area);
			Ldata[x].sub_type = sub_type;
			Ldata[x].host = host_system;
			Ldata[x].in_messages = 0;
			Ldata[x].out_messages = 0;
			Ldata[x].in_bytes = 0;
			Ldata[x].out_bytes = 0;
		}
		Ldata[x].in_messages += msg_cnt;
		Ldata[x].in_bytes += byte_cnt;
	}
}
fclose(fd2);
fclose(Net);

}

/* This procedure exports messages from WWIV to FIDO */
void Export(argv)
char **argv;
{
	long msg_cnt, byte_cnt;
	FILE *fd1, *fd2;
	int x, y, z, no_end;
	long Position;
	unsigned char c;
	unsigned short syst;
	char Subject[80];
	char ToUser[37];
	char Name[80];
	char Date[80];
	struct ffblk ffblk;
	int done;
	int MailFlag;
	unsigned short Attribute;
	int max_msg;
	long fpos1, fpos2;
	unsigned short didit = 65535;
	struct MessageHdr Fmessage;
	net_system_list_rec bbsData;
	unsigned char print_flag;
	int bbsEntry;

	export_flag = 1;
	sprintf(&Fmessage.fill[0], "NETSEX");
	printf("Exporting...\n");
	strcpy(wwivpath, argv[1]);

	printf("Loading bbsdata - ");
	sprintf( Buffer, "%s/BBSDATA.NET", wwivpath);
	fd1 = fopen( Buffer, "rb");
	if (fd1 == NULL) {
		printf("Can't find %s\n", Buffer);
		exit(-1);
	}

	/* Find Length of BBSDATA.NET */
	fseek(fd1, 0, 2);
	Position = ftell(fd1);
	fseek(fd1, 0, 0);
	x = Position / 68;

	Stats =	(struct Stats *)malloc( (x + 1) * sizeof(struct Stats));

	if (Stats == NULL) {
		printf("Error, can't allocate memory for BBSDATA.NET\n");
		exit(0);
	}

	for ( bbsEntry = 0; bbsEntry != x; bbsEntry++) {
		fread(&Stats[bbsEntry], 56, 1, fd1);
		fread(Buffer, 12, 1, fd1);
#ifdef DEBUG
		printf("Read %s\n", Stats[bbsEntry].name);
#endif
	}
	fclose(fd1);
	printf("%d Entrys\n", bbsEntry);

	MailDir[0] = 0;
	LocalNode = 0;
	NumAlias = 0;
	LineCount = 0;
	/* Set Banner to null for now */
	Banner[0] = 0;
#ifdef DEBUG
	printf("Initialized variables\n");
#endif

	sprintf(Buffer, "%s/FIDO.NET", wwivpath);
	Net = fopen(Buffer, "rt");
	if ( Net == NULL) {
		printf("Can't Find %s\n", Buffer);
		exit(-1);
	}

	while ( NextEnt() == 0) {
	/* This Section of code finds the WWIV messages and converts them       */
	/*	into FIDO messages						*/

		print_flag = 0;

		if (bd_flag == 1) {
			sprintf(Search, "%s/*.MSG", Path);
			max_msg = 0;

			done = findfirst(Search, &ffblk, 0);

			while (!done) {
				if (atol(ffblk.ff_name) > max_msg) max_msg = atol(ffblk.ff_name);
				done = findnext(&ffblk);
			}

			if (max_msg == 0) max_msg = 1;

#ifdef DEBUG
			printf("Highest message number = %d\n", max_msg);
#endif

			msg_cnt = 0; byte_cnt = 0;

			sprintf( Buffer, "%s/s%d.NET", wwivpath, MyNode);
			fd1 = fopen( Buffer, "r+b");
			if (fd1 != NULL) {
				/* read Header */
				while (fread( &header, sizeof(header), 1, fd1) == 1){
					fpos1 = ftell(fd1) - 16;
					/* Check to see if the message needs to be processed */
					if (
					/* This part checks for posts to the sub currently being processed */
					(header.main_type == main_type_post && header.minor_type == sub_type)
					/* This part checks for Email */
					|| ( header.main_type == main_type_email_name && sub_type == 0)
						 ) {
						fpos2 = ftell(fd1);
						fseek ( fd1, fpos1, 0);
						/* Mark this message as processed */
						fwrite( &didit, sizeof(didit), 1, fd1);
						fseek( fd1, fpos2, 0);
						if (print_flag == 0) {
							if (sub_type == 0) {
								printf("Mail:\n");
							} else {
								printf("Sub %ld:\n", (long)sub_type);
							}
							printf("Date       Time     %-5s %-13.13s %s\n", "Size", "From", "To");
							printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
							print_flag = 1;
						}

						Zone = FidoZone;

						x = Fidoize(fd1, &Fmessage);
						if (Zone != FidoZone) {
							Fmessage.destNet = FidoZone;
							Fmessage.destNode = Zone;
						}
						max_msg++; msg_cnt++;
						byte_cnt += x;
						sprintf( Buffer, "%s\\%d.MSG", Path, max_msg);
						fd2 = fopen( Buffer, "wb");
						if ( fd2 == NULL) {
							printf("Can't write to %s\n", Buffer);
							exit(-1);
						}

						/* Write out the message */
						fwrite( &Fmessage, sizeof(Fmessage), 1, fd2);


						if (Point != 0) {
							fprintf( fd2, "%cTOPT %d%c%c", 1, Point, 13, 10);
						}


						if (Zone != FidoZone) {
							fprintf( fd2,"%cINTL %d:%d/%d %d:%d/%d%c%c", 1,
							 Zone, FNet, FNode, FidoZone, FidoNet, FidoNode, 13, 10);
						}

						fprintf(fd2,"%cWWIVGATE: %d %s N%d U%d%c%c",1,LocalNode,
							NetString,(int)header.fromsys,(int)header.fromuser,13,10);


						/* If the NETID_FLAG is set to BOTTOM then put the */
						/* Message text first. */
						if (NETID_FLAG == 2 || NETID_FLAG == 0) {
							fwrite(MBuf, x, 1, fd2);
							c = 13;
							fwrite(&c, 1, 1, fd2);
							c = 10;
							fwrite(&c, 1, 1, fd2);
						}

						if (	NETID_FLAG != 0 &&
									strncmp(Fmessage.toUserName, "UUCP", 4) != 0 ) {
							z = 0;
							while ( Stats[z].sysnum != header.fromsys) {
								z++;
								if ( z > bbsEntry ) {
									z = -1;
									break;
								}
							}
							if (z != -1) {
								if (NetString[0] != 0) fprintf( fd2, "%s: ", NetString);
								fprintf( fd2, "%s [%s] - Node %d%c%c%c%c",
									Stats[z].name, Stats[z].phone, (int)header.fromsys, 13, 10, 13, 10);
							}
						}

						/* If the netID flag is set to tp then Put the */
						/* Message text after the NETID */
						if (NETID_FLAG == 1) {
							fwrite(MBuf, x, 1, fd2);
							c = 13;
							fwrite(&c, 1, 1, fd2);
							c = 10;
							fwrite(&c, 1, 1, fd2);
						}

						c = 0;
						fwrite( &c, 1, 1, fd2);
						fclose(fd2);
					} else {
						fseek( fd1, header.length, 1);
					}
				}
				fclose(fd1);
			}
		}
		if (print_flag != 0) {
			printf("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
			printf("%ld Messages, %ld Bytes\n\n", msg_cnt, byte_cnt);
			for (x = 0; x != Log_Count; x++) {
				if (strcmp( area, Ldata[x].name) == 0) break;
			}
			if ( x == Log_Count ) {
				Log_Count++;
				if (Ldata == NULL) {
					Ldata = (log_entry *)malloc(sizeof(log_entry));
				} else {
					Ldata = (log_entry *)realloc( Ldata, Log_Count * sizeof(log_entry));
				}
				for (y = 0; y != 40; y++) {
					Ldata[x].name[y] = 0;
				}
				strcpy(Ldata[x].name, area);
				Ldata[x].sub_type = sub_type;
				Ldata[x].host     = host_system;
				Ldata[x].in_messages = 0;
				Ldata[x].out_messages = 0;
				Ldata[x].in_bytes = 0;
				Ldata[x].out_bytes = 0;
			}
			Ldata[x].out_messages += msg_cnt;
			Ldata[x].out_bytes += byte_cnt;

		}
	}
	sprintf( Buffer, "%s/s%d.NET", wwivpath, (int)MyNode);
	unlink( Buffer);
	free(Stats);
	return;
}

/* This function returns the info to process the next sub by reading the */
/* FIDO.NET file */
int NextEnt()
{
	char Line[160], Line2[160];
	int x, y, z, done = 0;
	int tot;
	int Res;

#ifdef DEBUG
	printf("Entering NextEnt()\n");
#endif

	while (done == 0) {
		LineCount++;
		if (fgets(Line, 160, Net) == NULL) {
			/* Bail out if no more to process */
			return(-1);

		}
		/* Copy in case we need the EXACT line */
		strcpy(Line2, Line);
		strupr(Line);

		if (strncmp("SUB: ", Line, 5) == 0) {
#ifdef DEBUG
			printf("%s", Line);
#endif
			x = 3;

			/* Find sub type */
			x = Parse( x, Line);
			if (x == -1) return(-1);
			sub_type = atol(&Line[x]);
#ifdef DEBUG
			printf("Sub type %d\n", sub_type);
#endif

			/* Find host system name */
			x = Parse( x, Line);
			if (x == -1) return(-1);
			host_system = atol(&Line[x]);
#ifdef DEBUG
			printf("Host system %ld\n", (long)host_system);
#endif
			/* Get path name for *.msg files */
			x = Parse( x, Line);
			if (x == -1) return(-1);
			y = Parse( x, Line);
			if (y == -1) return(-1);
			strncpy(Path, &Line[x], y - x);
			z = y - x - 1;
			while( Path[ z] == ' ') {
				Path[z] = 0;
				z--;
			}
#ifdef DEBUG
			printf("Search path: *%s*\n", Path);
#endif

			/* Get name of area for fidonet */
			x = Parse( y, Line);
			if ( x == -1) return(-1);
			strncpy(area, &Line[y], x - y);
			z = x - y - 1;
			while ( area[z] == ' ') {
				area[z] = 0;
				z--;
			}
#ifdef DEBUG
			printf("Fidonet area: %s\n", area);
#endif

			/* And finally,  find out if this sub is bi-directional */
			if ( Line[x] == 'Y') bd_flag = 1;
			else bd_flag = 0;
#ifdef DEBUG
			if ( bd_flag == 1) printf("Sub is bi-directional\n");
#endif
			if ((export_flag == 0) || (bd_flag == 1) )	done = 1;
			Line[0] = ';';
		} else if (((strncmp("IN_ALIAS: ", Line, 7) == 0) && (export_flag == 0)) ||
				 ((strncmp("OUT_ALIAS: ", Line, 8) == 0) && (export_flag == 1)) ){
/*			if (NumAlias > MAX_ALIASES) {
				printf("Error, too many aliases. Line %d\n", LineCount);
				exit(0);
			}
*/
			x = 9 + export_flag;
			while( Line[x] != '=' && x < strlen(Line)) {
				x++;
			}

			if ( x >= strlen(Line)) {
				printf("Error in ALIAS Command Line%d\n%s\n", LineCount, Line);
				exit(0);
			}

			Line[x] = 0;

			Line2[strlen(Line2) - 1] = 0;

			y = 0;
			while( (strcmp(Alias[y].in, &Line[10 + export_flag]) != 0)
				&& (y <NumAlias)) {
				y++;
			}

			if (y == NumAlias) {
#ifdef DEBUG
				printf("New Alias\n");
#endif
				if ( y == 0) {
					Alias = (struct Alias *)malloc( sizeof(struct Alias));
				} else {
					Alias = (struct Alias *)realloc( Alias,
						(NumAlias + 1)* sizeof(struct Alias));
				}
				strcpy (Alias[NumAlias].in, &Line[10 + export_flag]);
				strcpy (Alias[NumAlias].out, &Line2[x+1]);
#ifdef DEBUG
				printf("Aliasing %s to %s\n", Alias[NumAlias].in, Alias[NumAlias].out);
#endif
				NumAlias++;
			} else if (strlen(&Line2[x+1]) == 0) {
#ifdef DEBUG
				printf("De-Aliasing %s\n", Alias[y].in);
#endif
				for ( z = y; z!= NumAlias -1; z++) {
					strcpy(Alias[z].in, Alias[z+1].in);
					strcpy(Alias[z].out, Alias[z+1].out);
				}
				NumAlias--;
				Alias = (struct Alias *)realloc( Alias, NumAlias * sizeof(struct Alias));
			} else {
#ifdef DEBUG

				printf("Changing Alias of %s to %s\n", Alias[y].in, &Line2[x+1]);
#endif
				strcpy(Alias[y].out, &Line2[x+1]);
			}

			Line[0] = ';';
		} else if (strncmp("IN_ALIAS: ", Line, 7) == 0 || strncmp("OUT_ALIAS", Line, 8) == 0) {
			Line[0] = ';';
		} else if (strncmp("BANNER: ", Line, 8) == 0) {
			/* Limit Length to 80 chars */
			tot = 0;
			for ( x = 8; x < strlen(Line2); x++) {
				/* Check for ^P */
				if (Line2[x] == 3) {
					x++;
				} else {
					tot++;
				}
				if ( tot == 80) {
					Line2[x+1] = 0;
					break;
				}
			}
			strcpy (Banner, &Line2[8]);
			Line[0] = ';';
#ifdef DEBUG
			printf("BANNER: %s\n",  Banner);
#endif
		} else if (strncmp("NODE: ", Line, 6) == 0) {
			MyNode = atol(&Line[6]);
			Line[0] = ';';
		} else if (strncmp("FNODE: ", Line, 7) == 0) {
			FidoNode = (unsigned short)atol(&Line[7]);
			Line[0] = ';';
		} else if (strncmp("FNET: ", Line, 6) == 0) {
			FidoNet = (unsigned short)atol(&Line[6]);
			Line[0] = ';';
		} else if (strncmp("FZONE: ", Line, 7) == 0) {
			FidoZone = (unsigned short)atol(&Line[7]);
			Line[0] = ';';
		} else if (strncmp("LOCAL: ", Line, 7) == 0) {
			LocalNode = atol(&Line[7]);
			Line[0] = ';';
		} else if (strncmp("MAIL: ", Line, 6) == 0) {
			strcpy(MailDir, &Line[6]);
			MailDir[strlen(MailDir) - 1] = 0;
			/* Process the mail*/
			strcpy(area, "Mail");
			strcpy(Path,MailDir);
			MailDir[0] = 0;
			sub_type = 0;
			bd_flag = 1;
#ifdef DEBUG
			printf("Processing Mail\n");
#endif
			done = 1;
			Line[0] = ';';
		} else if ( strncmp("COORDINATOR: ", Line, 13) == 0) {
			CNode = atol(&Line[13]);
			Line[0] = ';';
		} else if ( strncmp("NETWORK: ", Line, 9) == 0 ){
				strcpy( NetString, &Line2[9]);
				NetString[strlen(NetString)- 1] = 0;
				Line[0] = ';';
		} else if ( strncmp("NETID: ", Line, 7) == 0) {
				if (strncmp("TOP", &Line[7], 3) == 0) NETID_FLAG = 1;
				else if (strncmp("BOTTOM", &Line[7], 6) == 0) NETID_FLAG = 2;
				else if (strncmp("OFF", &Line[7], 3) == 0) NETID_FLAG = 0;
				Line[0] = ';';
		} else if ( Line[0] != ';' && Line[0] != 10) {
			printf("Error in FIDO.NET file Line %d\n", LineCount);
			return(-1);
		}
	}
	return(0);
}

int ReadLine( Buffer, fd)
unsigned char *Buffer;
FILE *fd;
{
	int x = 0;

	while( fread(&Buffer[x], 1, 1, fd) == 1) {
		if ( Buffer[x] == 10 || Buffer[x] == 141) {
			;
		} else if (Buffer[x] == 13) {
			Buffer[x + 1] = 0;
			return(0);
		} else {
			x++;
			if ( x > 718) {
				Buffer[x] = 0;
				return(x);
			}
		}

	}
	Buffer[x] = 0;
	return(-1);
}

/* Process the message, stripping control info */
/* for messages coming into WWIVnet from FIDONET */
int ProcMess(fd)
FILE *fd;
{
	int x, y, z;
	char Buffer[720];
	y = 0;

	/* Add the To: line from the fido message to the message text */
	if (sub_type != 0) {
		sprintf( MBuf, "To: %s\r\n\r\n", tname);
		y = strlen(MBuf);
	}
	do {
		x = ReadLine(Buffer, fd);
/*		if ( Buffer[0] == 1 && strncmp("FMPT ", &Buffer[1], 5) == 0) {
			Point = atoi(&Buffer[6]);
		}
*/
		/* Ignore ^A Lines and AREA: and SEEN-BY: and EID: */
		if (Buffer[0] != 1
			&& strncmp("AREA:", Buffer, 5) != 0
			&& strncmp("SEEN-BY:", Buffer, 8) != 0
		  && strncmp("EID:", Buffer, 4) != 0
			&& strncmp("TOPT ", Buffer, 4) != 0
			&& strncmp("FMPT:", Buffer, 4) != 0
			&& !(Buffer[0] == 13 && y == 0) ){

			for ( z = 0; z != strlen(Buffer); z++ ) {
				if ( Buffer[z] == 13) {
					MBuf[y] = 13;
					y++;
					MBuf[y] = 10;
					y++;
				} else {
					MBuf[y] = Buffer[z];
					y++;
				}
			}
		} else if ( Buffer[0] == 1 && strncmp("FMPT ", &Buffer[1], 5) == 0) {
			Point = atoi(&Buffer[6]);
		} else if ( Buffer[0] == 1 && strncmp("TOPT ", &Buffer[1], 5) == 0) {
			ToPoint = atoi(&Buffer[6]);
		} else if ( Buffer[0] == 1 && strncmp("INTL ", &Buffer[1], 5) == 0) {
			z = 6;
			while (Buffer[z] != ' ') {
				z++;
			}
			Buffer[z] = 0;
			Faddress(&Buffer[5]);
			destNode = FNode;
			destNet  = FNet;
			Faddress(&Buffer[z+1]);
		} else if ( Buffer[0] == 1 && strncmp("WWIVGATE: ", &Buffer[1], 10) == 0) {
			WWIVgate = atoi(&Buffer[11]);
			if (WWIVgate == LocalNode) {
				return(0);
			}
		}
	} while ( x >= 0);
	return(y);

}

int ParseName(Name)
char *Name;
{
	int Number, Node, x, y;
	char temp[40];

	strupr(Name);
	for (x = 0; x!= NumAlias; x++) {
		if (strcmp(Name, Alias[x].in) == 0) {
#ifdef DEBUG
	printf("%s Aliased to %s.", Name, Alias[x].out);
#endif
			strcpy(Name, Alias[x].out);
			strupr(Name);
			break;
		}
	}

	if ( Name[0] == 'N') {
		Node = atol(&Name[1]);
	} else {
		Node = 0;
	}

#ifdef DEBUG
	printf(" To: %s\n Node = %d.", Name, Node);
#endif
	y = strlen(Name);
	x = 0;
	while( (x < y) && (Name[x] != ' ') ) {
		x++;
	}

	/* No Node Number ?*/
	/* Must be local mail */
	if ( x >= y || Node <= 0) {
#ifdef DEBUG
		printf(" Mail to %s\n", Name);
#endif
		header.length += strlen(Name) + 1;
		header.main_type = main_type_email_name;
		header.list_len = 0;
		header.tosys = LocalNode;
		return(1);
	}

	if (Name[x+1] == 'U') {
		Number = atol(&Name[x+2]);
	} else {
		Number = 0;
	}

#ifdef DEBUG
	printf("Number = %d\n", Number);
#endif
	/* Mail sent to User Number at Node Number*/
	if (Number != 0) {
#ifdef DEBUG
		printf(" Mail to user # %d @ %d.\n", Number, Node);
#endif
		header.main_type = main_type_email;
		header.list_len = 0;
		header.tosys = Node;
		header.touser = Number;
		return(2);
	}

	/* Name E-Mail Bound for another system */
	if ( (Number == 0) && (Node != 0)) {
		strcpy(temp, &Name[x+1]);
		strcpy(Name, temp);
#ifdef DEBUG
		printf(" Mail to %s@%d.\n", Name, Node);
#endif
		header.length += strlen(Name) + 1;
		header.main_type = main_type_email_name;
		header.list_len = 0;
		header.tosys = 5317;
		return(1);
	}
	return(-1);
}

int Parse(opos, buffer)
int opos;
char *buffer;
{
	int pos;
	pos = opos;

	do {
		pos++;
		if ( pos >= strlen(buffer) ) {
			printf ("Error in FIDO.NET file Line %d\n", LineCount);
			return(-1);
		}
	} while ( buffer[pos] != ' ');

	while (buffer[pos] == ' ') {
		pos++;
		if ( pos >= strlen(buffer) ) {
			printf ("Error in FIDO.NET file Line %d\n", LineCount);
			return(-1);
		}
	}
	return(pos);
}


/* Process messages coming from WWIVnet to Fidonet */

int Fidoize(file, Fheader)
FILE *file;
struct MessageHdr *Fheader;
{
	int length,  x, mlength, y, z, x1;
	char alias_flag = 0;
	struct tm *tm;
	unsigned char c;
	int Line, LineMkr;
	char *Mon[12] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
					"Oct", "Nov", "Dec" };

	length = 0;
	mlength = 0;

	if (sub_type == 0) {
		/* Read in the TO field */
		x = 0;
		do {
			if (fread( &Fheader->toUserName[x], 1, 1, file) != 1) {
				printf("Error in s%ld file\n", MyNode);
				exit(-1);
			}
			x++; length++;
		} while (Fheader->toUserName[x-1] != 0);
		strupr(Fheader->toUserName);
		for (; x != 36; x++) {
			Fheader->toUserName[x] = 0;
		}
	} else {
		strcpy(Fheader->toUserName, "All");
		for ( x = 3; x != 36; x++) {
			Fheader->toUserName[x] = 0;
		}
	}

	/* Read in the subject field */
	x = 0;
	do {
		if (fread( &Fheader->subject[x], 1, 1, file) != 1) {
			printf("Error in s%ld file\n", MyNode);
			exit(-1);
		}
		x++; length++;
	} while ( (Fheader->subject[x-1] != 0) && ( x < 70));
	for ( x = x; x != 72; x++) {
		Fheader->subject[x] = 0;
	}

	/* Read in the FROM field */
	x = 0;
	do {
		if (fread( &tname[x], 1, 1, file) != 1) {
			printf("Error in s%ld file\n", MyNode);
			exit(-1);
		}
		x++; length++;
	} while (tname[x-1] != 13);
	tname[x-1] = 0;
	fread(&c , 1, 1, file);
	length++;
	while(tname[x] != '#') {
		x--;
	}
	tname[x] = 0;
	sprintf(Fheader->fromUserName, "N%d U%d", (int)header.fromsys, (int)header.fromuser);

	for(x = 0; x != NumAlias; x++) {
		if (strcmp(Fheader->fromUserName, Alias[x].in) == 0) {
			strcpy(Fheader->fromUserName, Alias[x].out);
			alias_flag = 1;
			break;
		}
	}

	for( x = strlen(Fheader->fromUserName); x != 36; x++) {
		Fheader->fromUserName[x] = 0;
	}



	/* Read in the DATE field */
	x = 0;
	do {
		if (fread( &Fheader->dateTime[0], 1, 1, file) != 1) {
			printf("Error in s%ld file\n", MyNode);
			exit(-1);
		}
		x++; length++;
	} while (Fheader->dateTime[0] != 13);
	Fheader->dateTime[x-1] = 0;
	fread(&c , 1, 1, file);
	length++;
	tm = localtime(&(long)header.daten);
	sprintf(Fheader->dateTime,"%02d %s %02d  %02d:%02d:%02d", tm->tm_mday, Mon[tm->tm_mon],
			tm->tm_year, tm->tm_hour, tm->tm_min, tm->tm_sec);

	/* Read in the text */
	x = 0;
	/* If Not going to uucp,  put in another from field */
#ifdef DEBUG
	printf("to: %s\n", Fheader->toUserName);
#endif
	if (strncmp("UUCP", Fheader->toUserName, 4) != 0 && (alias_flag == 0)) {
		sprintf( MBuf, "Name: %s\r\n\r\n", tname);
		x += strlen(MBuf);
	}
	LineMkr = x;
	do {
		if (fread( &c, 1, 1, file) != 1) {
			printf("Error in file\n");
			exit(0);
		}
		if ( c == 13 || ( c < 128 && c >31)) {
			MBuf[x] = c;
			length++; x++;
		} else if ( c > 127) {
			MBuf[x] = ' ';
			length++; x++;
			/* WWIV Color Code */
		} else if ( c == 3) {
			fread( &c, 1, 1, file);
			length += 2;
			/* Word Wrap */
		} else if ( c == 1) {
			fread( &c, 1, 1, file);
			fread( &c, 1, 1, file);
			length += 3;
			MBuf[x] = 10;
			x++;
		} else {
			length++;
		}
	} while (length < header.length);
	MBuf[x] = 0;

#ifdef DEBUG
	printf("----- Text Follows -----\n%s\n", MBuf);
#endif
	mlength += x;
	Fheader->timesRead = 0;
	Fheader->destNode = 0;
	Fheader->origNode = FidoNode;
	Fheader->cost     = 0; /* This used to mark the message as processed */
	Fheader->origNet  = FidoNet;
	Fheader->destNet  = 0;
	Fheader->replyTo  = 0;
	Fheader->Attribute = (unsigned short)0;
	if (sub_type == 0) {
		Fheader->Attribute = (unsigned short)129 ; /* Private and Kill/Sent bits */
		x = strlen(Fheader->toUserName);
		while (Fheader->toUserName[x] != 'O') {
			x--;
		}
		x--;
		if (strncmp(" OF ", &Fheader->toUserName[x] , 4) == 0) {
			Fheader->toUserName[x] = 0;
			Faddress(&Fheader->toUserName[x+4]);
			Fheader->destNode = FNode;
			Fheader->destNet = FNet;
#ifdef DEBUG
			printf("Headed for %d/%d\n", Fheader->destNet, Fheader->destNode);
#endif
		}
	}

	/* Check to see if the message has a RE: */
	if ( strncmp("RE:", &MBuf[LineMkr], 3) == 0 ) {
#ifdef DEBUG
		printf("Found a RE:\n");
#endif
		/* Find where the "RE:" line ends and block move... */
		x = LineMkr;
		while( MBuf[x] != 13) {
			x++;
		}
		/* Add the RE: into the subject line */
		if ( (strlen(Fheader->subject) + 3 + x - LineMkr ) < 71) {
			strcat(Fheader->subject, " (");
			strncat(Fheader->subject, &MBuf[LineMkr], x - LineMkr);
			strcat(Fheader->subject, ")");
#ifdef DEBUG
			printf("Added RE: to the subject Line\n");
#endif
		}

		/* This loop will find the double <CR> which signifies that */
		/* the message body is starting.  We do this so that in case */
		/* there is some other header garbage floating around in the */
		/* message (like BY: lines) it is skipped over */
		do {
			while(MBuf[x] != 13) x++;
			x++;
		} while( MBuf[x] != 13);
		x++;

		for (length = x; length != mlength; length++) {
			MBuf[length - ( x - LineMkr)] = MBuf[length];
		}
		mlength -= (x - LineMkr);
	}

	x = LineMkr;
	/* Check to see if the message has a To: */
	if ( sub_type != 0 && strncmp("To:", &MBuf[LineMkr], 3) == 0 ) {
#ifdef DEBUG
		printf("Found a To:\n");
#endif
		/* Find where the "To:" line ends and block move... */
		x = LineMkr;
		while( MBuf[x] != 13) {
			x++;
		}
		/* Add the To: into the to line */
		if ( (3 + x - LineMkr ) < 35) {
			strncpy(Fheader->toUserName, &MBuf[LineMkr + 4], x - LineMkr - 4);
#ifdef DEBUG
			printf("Change ToUser Field\n");
#endif
		}
		/* I am assuming that the standard To: line ends in two <CR> */
		x += 1;
		for (length = x; length != mlength; length++) {
			MBuf[length - ( x - LineMkr)] = MBuf[length];
		}
		mlength -= (x - LineMkr);
	}

	/* Going to FIDONET - alternate adressing mode */
	if (sub_type == 0 && strncmp("FIDONET", Fheader->toUserName, 7) == 0
			&& strncmp("To:", &MBuf[LineMkr], 3) == 0 ) {

#ifdef DEBUG
		printf("Found a FIDONET To:\n");
#endif
		/* Find where the "To:" line ends and block move... */
		x = LineMkr;
		while( MBuf[x] != 13) {
			x++;
		}
		/* Add the To: into the to line */
		if ( (3 + x - LineMkr ) < 35) {
			strncpy(Fheader->toUserName, &MBuf[LineMkr + 4], x - LineMkr - 4);
#ifdef DEBUG
			printf("Added To: to the subject Line\n");
#endif
		}
		/* I am assuming that the standard To: line ends in two <CR> */
		x += 1;
		for (length = x; length != mlength; length++) {
			MBuf[length - ( x - LineMkr)] = MBuf[length];
		}
		mlength -= (x - LineMkr);

		x1 = strlen(Fheader->toUserName) - 1;

		while ( x1 > 0 && Fheader->toUserName[x1] != 'O') {
			x1--;
		}
		x1--;

		if (strncmp(" OF ", &Fheader->toUserName[x1] , 4) == 0) {
			Fheader->toUserName[x1] = 0;
			Faddress(&Fheader->toUserName[x1+4]);
			Fheader->destNode = FNode;
			Fheader->destNet = FNet;
#ifdef DEBUG
			printf("Headed for %d/%d\n", Fheader->destNet, Fheader->destNode);
#endif
		}

	}



	Fheader->nextReply = 0;

	printf("%s %5ld %-13.13s %s", Fheader->dateTime,
			 (long)mlength, Fheader->fromUserName, Fheader->toUserName,
			 (long)Fheader->destNet, (long)Fheader->destNode);

	if (sub_type == 0) {
		printf(" of %ld/%ld\n", (long)Fheader->destNet, (long)Fheader->destNode);
	} else {
		printf("\n");
	}

#ifdef DEBUG
	printf("To: %s ", Fheader->toUserName);
	printf("From: %s ", Fheader->fromUserName);
	printf("Subject: %s ", Fheader->subject);
	printf("Date: %s\n", Fheader->dateTime);
#endif
	return(mlength);
}

void Load_Log(path)
char *path;
{
	char bb[80];
	long Ptime;
	struct stat buff;
	struct tm *tm2;
	int x;

	sprintf( bb, "%s/NETSEX.DAT", path);
	Log_Update = 0;
	time(&Ptime);

	if ( stat (bb, &buff) == 0) {
		Log = fopen( bb, "rb");
		fread( &Ltime, sizeof(Ltime), 1, Log);
		Ldata = (log_entry *)malloc( buff.st_size - sizeof(Ltime));
		fread( Ldata, buff.st_size - sizeof(Ltime), 1, Log);
		fclose(Log);
		Log_Count = (buff.st_size - sizeof(Ltime))/ sizeof(log_entry);

		tm2 = localtime(&Ptime);
		/* Send out Log update if it is Sunday, or it has been more */
		/* Than a week since the last update */
		if ((Ptime - Ltime >= 604800) ||
				( (tm2->tm_wday == 0) && (Ptime - Ltime) > 86400) ) {
					Log_Update = 1;
		}
	} else {
		Log_Count = 0;
		Ltime = Ptime;
		Ldata = NULL;
	}
}


/* Function: Save_Log()
**
** Purpose:  To save the NetSEX log information to disk and, if
**           the proper time interval has passed, to mail a copy
**           of the log to the NetSEX COORDINATOR.
**
** Inputs: path - a string containing the path to the WWIV data
**                directory.
**
** Also Uses:
**
**   Log_Update
**   CNode
**   MyNode
**   Ltime
**   LocalNode
**   FidoNode
**   FidoNet
**   FidoZone
**   Version
**   Log_Count
**   Net
**   Ltime
**   Ldata
**
**
** Return Value:
**
**   NONE.
**
*/


void Save_Log(path)
char *path;

{
	struct stat buff;
	char c, bb[80];
	int x, y, z;

	/* Send Log file off to the Coordinator... */
	if (Log_Update == 1 && CNode != 0) {
		printf("Sending out Log file\n");
		sprintf(bb ,"%s/P1.NET", path);
		Net = fopen( bb, "a+b");
		gettime(&timep);
		getdate(&datep);
		header.tosys = CNode;
		header.touser = 0;
		header.fromsys = MyNode;
		header.fromuser = 0;
		header.main_type = main_type_external;
		header.minor_type = 6969;
		header.list_len = 0;
		header.daten = dostounix(&datep, &timep);
		header.method = 0;
		header.length = sizeof(long) + sizeof(LocalNode) + sizeof(FidoNode) +
										+ sizeof(FidoNet) + sizeof(FidoZone) +4 + sizeof(log_entry) * Log_Count;
		fwrite( &header, sizeof(header), 1, Net);
		fwrite( &Ltime, sizeof(long), 1, Net);
		fwrite( &LocalNode, sizeof(LocalNode), 1, Net);
		fwrite( &FidoNode, sizeof(FidoNode), 1, Net);
		fwrite( &FidoNet, sizeof(FidoNet), 1, Net);
		fwrite( &FidoZone, sizeof(FidoZone), 1, Net);
		fwrite( Version, 4, 1, Net);
		fwrite( Ldata, Log_Count * sizeof(log_entry), 1, Net);
		fclose(Net);
		sprintf(bb, "%s/NETSEX.DAT", path);
		time(&Ltime);
		Net = fopen( bb, "w+b");
		fwrite(&Ltime, sizeof(long), 1, Net);
		fclose(Net);

	} else {
		sprintf( bb, "%s/NETSEX.DAT", path);
		Log = fopen( bb, "w+b");
		fwrite( &Ltime, sizeof(Ltime), 1, Log);
		fwrite( Ldata,Log_Count * sizeof(log_entry), 1, Log);
		fclose(Log);
	}

	free(Ldata);
}



/* Function: Faddress()
**
**
** Purpose:  Parse a string containing fidonet address information
**           in the form:   ZONE:NET/NODE.POINT
**
** Inputs:   Buffer - A the string to parse.
**
**
** External variables effected:
**
**   Zone:  Set to the value of the ZONE field in the address string,
**          Otherwise it is set to the value in the variable FidoZone.
**
**   FNet:  Set to the value of the Fido NET field in the address string,
**          otherwise it is set to the value in the variable FidoNet.
**
**   FNode: Set to the value of the Fido NODE field in the address string,
**          otherwise it is set to the value in the variable FidoNode.
**
**   Point: Set to the value of the Fido POINT field in the address string,
**          otherwise it is set to 0.
**
**
** Return Value:
**
**   NONE.
*/
void Faddress(Buffer)
char *Buffer;
{
	int x;
	int y;
	int g;
	char Pflag = 0;

	x = 0;
	y = x;
	g = strlen(Buffer);

	Zone  = FidoZone;
	FNet  = FidoNet;
	FNode = FidoNode;
	Point = 0;

	do {

		switch (Buffer[x]) {
			case ':':
				Buffer[x] = 0;
				Zone = atoi(&Buffer[y]);
				x++;
				y = x;
				break;

			case '/':
				Buffer[x] = 0;
				FNet = atoi(&Buffer[y]);
				x++;
				y = x;
				break;

			case '.':
				Pflag = 1;
				Buffer[x] = 0;
				FNode = atoi(&Buffer[y]);
				x++;
				y = x;
				break;

			case 0:
				if (Pflag == 0) {
					FNode = atoi(&Buffer[y]);
				} else { Point = atoi(&Buffer[y]);
				}
				x++;
				y = x;
				break;
			default:
				x++;
				break;
		}
	} while ( g > x-1);

}