/* ------------------------------------------------------------------------ */
/*                                                                          */
/*  DSZ.EXE - Replacement Program to run both DSZ and FDSZ With WWIV.       */
/*                                                                          */
/*  Simply Edit this file where appropriate, compile using the command      */
/*  line                                                                    */
/*      BCC -MS DSZ.C                                                       */
/*                                                                          */
/*  and copy DSZ.EXE to your WWIV directory.  You will need a copy of       */
/*  FDSZ.EXE and will need to rename DSZ.EXE (or DSZ.COM) to DSZ1.EXE.      */
/*  Make sure to remove any errant copies of GSZ and DSZ that might be      */
/*  in your WWIV directory.  As an alternative, you *CAN* use GSZ.EXE,      */
/*  just rename it to DSZ1.EXE and you'll be all set!                       */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include <conio.h>
#include <stdio.h>
#include <process.h>
#include <stdlib.h>
#include <string.h>

void main(int argc, char *argv[])
{
    int i,successful;
    int send;
    char s[80],send1[80],*ss,send2[80],temp[10];
    int com_port;

    com_port=3; // Comport number of port that must use Fossil DSZ
                // Due to a strange IRQ.

    ss=getenv("WWIV_INSTANCE");
    i=atoi(ss);
    switch(i)
    {
        case 0:         // Change these cases to the instances that use
        case 1:         // Normal comport IRQs.
            strcpy(s,"DSZ1.EXE");
            strcpy(send1,"");
            for (i=1;i<argc;i++)
            {
                sprintf(send2,"%s ",argv[i]);
                strcat(send1,send2);
            }
            successful=spawnlp(P_WAIT,s," ",send1,NULL);
            break;
        case 2:         // This case should be the WWIV Instance that
                        // uses a strange IRQ, and thus requires using
                        // Fossil Zomdem.
            send=1;
            for (i=0;i<argc;i++)
            {
                if (stricmp(argv[i],"rz")==0)
                    send=0;
            }
            if (send)
                strcpy(send1,"sz ");
            else
                strcpy(send1,"rz ");
            sprintf(temp,"%d ",com_port);
            successful=spawnlp(P_WAIT,"FDSZ.EXE"," ",temp,send1,argv[argc-1],NULL);
            break;
    }
    exit(successful);
}

