#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <dir.h>
#include <dos.h>

#include "vardec.h"
#include "net.h"

char *tfile="cvtfile.tmp";
char buf[256];

typedef struct {
  unsigned short old, new;
} cvtnode_t;

#include "nodedata.c"

cvtnode_t *cvtinfo;
int num_cvtinfo;

configrec syscfg;
net_networks_rec *net_networks;
int net_num_max, orignet, destnet;

char *onn="WWIVnet";
char *dnn="WW4Net";

/****************************************************************************/

void swapfile(char *fn)
{
  FILE *fi, *fo;
  unsigned short old, new;

  fi=fopen(fn,"rt");
  if (!fi) {
    perror(fn);
  } else {
    fo=fopen(tfile,"wt");
    if (!fo) {
      fclose(fi);
      perror(tfile);
    } else {
      while (fgets(buf, sizeof(buf), fi)) {
        if ((sscanf(buf, "%d %d", &new, &old)==2) && new && old) {
          fprintf(fo, "%d %d\n", old, new);
        } else {
          fprintf(fo, "%s", buf);
        }
      }

      fclose(fi);
      fclose(fo);
      unlink(fn);
      rename(tfile,fn);
    }
  }
}

void readcvtinfo(char *fn)
{
  FILE *fi;
  int count=0;
  unsigned short new, old;

  fi=fopen(fn,"rt");
  if (!fi) {
    perror(fn);
  } else {
    while (fgets(buf, sizeof(buf), fi)) {
      if ((sscanf(buf, "%d %d", &old, &new)==2) && old && new) {
        count++;
      }
    }
    rewind(fi);
    if (count) {
      cvtinfo = (cvtnode_t *)realloc(cvtinfo, (count+num_cvtinfo) * sizeof(cvtnode_t));
      if (!cvtinfo) {
        printf("Out of memory (%d+%d)\n", count, num_cvtinfo);
        exit(-1);
      }
      while (fgets(buf, sizeof(buf), fi)) {
        if ((sscanf(buf, "%d %d", &old, &new)==2) && old && new) {
          cvtinfo[num_cvtinfo].old = old;
          cvtinfo[num_cvtinfo].new = new;
          num_cvtinfo++;
        }
      }
      printf("%s: %d total\n", fn, num_cvtinfo);

    }

    fclose(fi);
  }
}


void readmultcvt(char *fn)
{
  FILE *fi;
  char fb[100],*ss;

  fi=fopen(fn,"rt");
  if (!fi) {
    perror(fn);
  } else {
    while (fgets(fb, sizeof(fb), fi)) {
      for (ss=strtok(fb," \t\r\n"); ss; ss=strtok(NULL, " \t\r\n")) {
        readcvtinfo(ss);
      }
    }
    fclose(fi);
  }
}

unsigned short newnode(unsigned short oldnode)
{
  int i;

  for (i=0; i<num_cvtinfo; i++) {
    if (cvtinfo[i].old == oldnode)
      return(cvtinfo[i].new);
  }
  return(0);
}

void dumpnodes(void)
{
  FILE *f;
  int i;

  unlink("nodedata.c");
  f=fopen("nodedata.c","w");
  if (!f)
    perror("nodedata.c");
  else {
    fprintf(f,"cvtnode_t cvtinfo_s[] = {\n");
    for (i=0; i<num_cvtinfo; i++) {
      fprintf(f,"  {%u, %u},\n", cvtinfo[i].old, cvtinfo[i].new);
    }
    fprintf(f,"};\nint num_cvtinfo_s = sizeof(cvtinfo_s)/sizeof(cvtinfo_s[0]);\n\n");
    fclose(f);
  }
}

void cvt_fi_fo(FILE *fi, FILE *fo, int atonly)
{
  char str[81];
  int strptr, gotat;
  unsigned short new;
  int ch;

  gotat=strptr=0;

  while ((ch=fgetc(fi))!=EOF) {
    if ((ch>='0') && (ch<='9') && (!atonly || gotat)) {
      str[strptr++]=ch;
    } else {
      if (ch=='@')
        gotat=1;
      else
        gotat=0;
      if (strptr) {
        str[strptr]=0;
        strptr=0;
        new=newnode(atoi(str));
        if (new)
          fprintf(fo,"%u",new);
      }
      fputc(ch,fo);
    }

  }

  if (strptr) {
    str[strptr]=0;
    new=newnode(atoi(str));
    if (new) {
      fprintf(fo,"%u\n",new);
    }
  }

}

void cvtfile(char *fn, int atonly)
{
  FILE *fi, *fo;

  fi=fopen(fn,"rt");
  if (!fi) {
    perror(fn);
  } else {
    fo=fopen(tfile,"wt");
    if (!fo) {
      fclose(fi);
      perror(tfile);
    } else {

      cvt_fi_fo(fi, fo, atonly);

      fclose(fi);
      fclose(fo);
      unlink(fn);
      rename(tfile,fn);
    }
  }

}

/****************************************************************************/

void convert_nfile(char *fn)
{
  char fni[81], fno[81];
  FILE *fi, *fo;

  sprintf(fni, "%s\\%s", net_networks[orignet].dir, fn);
  sprintf(fno, "%s\\%s", net_networks[destnet].dir, fn);

  fi=fopen(fni,"r");
  if (!fi) {
    perror(fni);
    return;
  }

  fo=fopen(fno, "w");
  if (!fo) {
    perror(fno);
    fclose(fi);
    return;
  }

  cvt_fi_fo(fi, fo, 0);

  fclose(fi);
  fclose(fo);

}

/****************************************************************************/

void cvt_networks(void)
{
  int configfile, f, i, f1;
  char s[81], s1[81], s2[81], ss[128], *ss1;
  struct ffblk ff;
  FILE *fi, *fo;
  long flags;
  short host;
  short category;
  char stype[20];

  configfile=open("config.dat", O_RDONLY|O_BINARY);
  if (configfile<0) {
    perror("config.dat");
    exit(0);
  }
  read(configfile,(void *) (&syscfg), sizeof(configrec));
  close(configfile);

  sprintf(s,"%sNETWORKS.DAT", syscfg.datadir);
  f=open(s, O_RDONLY|O_BINARY);
  if (f>0) {
    net_num_max=filelength(f)/sizeof(net_networks_rec);
    if (net_num_max) {
      net_networks=(net_networks_rec *)malloc(net_num_max*sizeof(net_networks_rec));
      if (!net_networks) {
        printf("Not enough memory\n");
        exit(-1);
      }
      read(f, net_networks, net_num_max*sizeof(net_networks_rec));
    }
    close(f);
  } else {
    perror(s);
    exit(0);
  }

  orignet=-1;
  destnet=-1;

  for (i=0; i<net_num_max; i++) {
    if (stricmp(net_networks[i].name, onn)==0)
      orignet=i;
    if (stricmp(net_networks[i].name, dnn)==0)
      destnet=i;
  }

  if (orignet==-1)
    printf("%s not listed in networks.dat\n", onn);
  if (destnet==-1)
    printf("%s not listed in networks.dat\n", dnn);
  if ((orignet==-1) || (destnet==-1))
    exit(0);


  /* convert the n*.net files */
  sprintf(s,"%sn*.net", net_networks[orignet].dir);
  f1=findfirst(s, &ff, 0);
  while (f1==0) {
    printf("Converting %s...\n", ff.ff_name);
    convert_nfile(ff.ff_name);
    f1=findnext(&ff);
  }

  /* convert the subs.xtr file */
  sprintf(s, "%ssubs.xtr", syscfg.datadir);
  sprintf(s1, "%ssubs.tmp", syscfg.datadir);
  sprintf(s2, "%ssubs.bak", syscfg.datadir);
  fi=fopen(s,"r");
  if (!fi) {
    perror(s);
    return;
  }
  fo=fopen(s1,"w");
  if (!fo) {
    perror(s1);
    fclose(fi);
    return;
  }

  printf("Convering subs.xtr...\n");

  while (fgets(ss, sizeof(ss)-1, fi)) {
    if (ss[0]!='$') {
      fprintf(fo, "%s", ss);
    } else {
      ss1=strchr(ss,' ');
      if (!ss1) {
        fprintf(fo,"%s", ss);
      } else {
        *ss1=0;
        if (stricmp(ss+1, net_networks[orignet].name)) {
          /* different net */
          *ss1=' ';
          fprintf(fo,"%s",ss);
        } else {
          /* convert to new network */
          sscanf(ss1+1, "%s %lu %u %u", stype, &flags, &host, &category);
          fprintf(fo,"$%s %s %lu %u %u\n",
                  net_networks[destnet].name,
                  stype,
                  flags,
                  host?newnode(host):0,
                  category);
        }
      }
    }
  }

  fclose(fi);
  fclose(fo);

  unlink(s2);
  rename(s, s2);
  unlink(s);
  rename(s1, s);


  printf("Completed converting %s to %s.\n",
         net_networks[orignet].name, net_networks[destnet].name);
}

/****************************************************************************/

void load_default(void)
{
  if (!num_cvtinfo) {
#ifdef OLD
    readmultcvt("listfile.cvt");
#else
    cvtinfo=cvtinfo_s;
    num_cvtinfo = num_cvtinfo_s;
    printf("%d nodes listed\n", num_cvtinfo);
#endif
  }
}

void main(int argc, char *argv[])
{
  int i, atonly=0;

  cvtinfo = (cvtnode_t *)malloc(sizeof(cvtnode_t));

  if (!cvtinfo) {
    printf("out of memory.\n");
    exit(-1);
  }

  if (argc == 1) {
    load_default();
    cvt_networks();
  }

  for (i=1; i<argc; i++) {
    if (argv[i][0]=='-') {
      switch(toupper(argv[i][1])) {
        case 'A':
          atonly=atoi(argv[i]+2);
          break;
        case 'N':
          readcvtinfo(argv[i]+2);
          break;
        case 'F':
          readmultcvt(argv[i]+2);
          break;
        case 'S':
          swapfile(argv[i]+2);
          break;
        case 'D':
          load_default();
          dumpnodes();
          break;
        case 'B':
          load_default();
          cvt_networks();
          break;
        default:
          printf("Unknown argument: %s\n", argv[i]);
          break;
      }
    } else {
      load_default();
      cvtfile(argv[i], atonly);
    }
  }
}
