/*******************************************************************
*  Fixes many a problem with CR/LF pairs (or lack thereof) and also
*  removes extra blank lines of whitespace, allowing only one line
*  of nothing but whitespace between characters.
*  Further, it removes excess CR/LF pairs from those people who
*  put a bazillion blank lines in messages.
*  A UrielSoft production
********************************************************************/

#include <stdio.h>
#include <string.h>
#include <process.h>
#include <dir.h>
#include <stdlib.h>
#include <io.h>
#include <conio.h>

void main (int argc, char *argv[])
 {
 char temp[80],temp2[80];
 char linein[255],q[1],q1[1];
 short int crud,n_char;
 long position;
 FILE *f,*out;

 printf(" CRSR v2.0\nA UrielSoft Product\n"); 
 if (argc < 2) 
  {
  printf(" Usage is CRSR [path]\n");
  printf(" CRSR will create CR\LF pairs where only the asc13 character\n");
  printf(" is present, and will strip out excessive (more than two in a\n");
  printf(" row) CR\LF pairs.\n");
  exit(100);
  }
 sprintf(temp,"crsr.net");   /* use this as our scratch file throughout */
 sprintf(temp2,"%s",argv[1]);
 remove(temp);
 rename(temp2,temp);
 out=fopen(temp2,"wb");
 f=fopen(temp,"rb");
 crud = fgetc(f);
 while(!feof(f))
  {
  fputc(crud,out);   
  if (crud == '\r')
   {
   position=ftell(f);   /* keep our current place */
   n_char = fgetc(f);   /* get the next char */
   if (n_char != '\n')  /* not already CR/LF */
    fputc('\n',out); 
   fseek(f,position,SEEK_SET);   /* go back to position */
   }
  crud=fgetc(f);
  }
 fclose(f);
 fclose(out);
 remove(temp);
 rename(temp2,temp);  /* removing extra CR/LF pairs */
 out=fopen(temp2,"wb");
 f=fopen(temp,"rb");
 while (!feof(f))
  { 
  if (fgets(linein,255,f)==NULL)
   continue;
  n_char=sscanf(linein,"%s%s",q,q1);   
  if (n_char > 0)  /* not just whitespace */
   crud=0;
  else
   crud++;  /* how many consecutive lines of just whitespace */
  if (crud <= 1)      /* if more than one line of just WS, then */
   fputs(linein,out);  /* don't output anything.  */
  }
 fclose(f);
 fclose(out);
 remove(temp);
 exit(0);
 }
