' 
' Program Title: Sample Program for TriBBS's USERS.SPF API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this userspf.bas file, you will see a couple different examples on how
' to use the Pointer "uspf" to make calls to the TriBBS API USERSSPF.PBU Unit.
' To use any of the current examples, go to the section and you will see a
' "$IF 0" statment at the head of the example, all you need to do to make
' that section of code run is change the '0' to any non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerfull! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "USERSPF.EXE" ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL                    ' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
                            ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' USERS.SPF API which are located in the USERSSPF.INC file.

'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE for USERS.SPF Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

DIM APAF AS INTEGER                 ' Dimention Local variable for this
                                    ' example to hold a integer value

  USERS_SPF_OpenRead 1, 1           ' Will Open USERS.SPF and Read user
                                    ' record #1, and conference record #1

      PRINT USERS_SPF_TotalRecords  ' Prints total records for this user
      PRINT                         ' Print blank line
      APAF = USERS_SPF_GetAPAF      ' Get current Access Private Area Flag
                                      ' 0 = The user doesn't have access to a
                                      '     private file area
                                      ' 1 = The user does have access to a
                                      '     private file area

      PRINT APAF                    ' Let's print the current value

      SELECT CASE APAF              ' Check variable and see if it is a 1 or
         CASE 0                     ' 0, then change it to the other.
           APAF = 1
         CASE 1
           APAF = 0
      END SELECT

      USERS_SPF_PutAPAF APAF        ' Change value in memory with new value

      PRINT USERS_SPF_GetAPAF       ' Prints New bit value after change

  USERS_SPF_Close                   ' Closes USERS.SPF file

$ENDIF

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
END                          ' Ends the Program
