' 
' Program Title: Sample Program for TriBBS's SYSDAT1.DAT API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample.bas file, you will see servals different examples on how
' to use the Pointer "sys1" to make calls to the TriBBS API SYSDAT1.PBU Unit.
' Also there are some examples showing how to use the SYSDAT1.PBU Unit
' without using pointers.  To use any of the current examples, go to the
' section and you will see a "$IF 0" statment at the head of the example, all
' you need to do to make that section of code run is change the '0' to any
' non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerful! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' All String Pointer calls will grab the data from memory, and strip any
' spaces and null terminator characters from the end of the string which
' will allow you to print with better screen output control.
'
' When writting back to memory with a pointer string, this SYSDAT1 API will
' set the length back to proper size and add the null terminator, CHR$(0)
' to the end of the string. This again, will save time in writting back
' to the original record SYSDAT1.DAT.
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "SYSDAT1.EXE"   ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL                    ' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
                            ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' SYSDAT1.DAT API which are located in the SYSDAT1.INC file.

'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for SYSDAT1.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

DIM SN AS STRING            ' Dimention a Local Varible to hold Sysop's Name
                            ' for this example

  SYSDAT1_DAT_OpenRead      ' Will Open and Read in SYSDAT1.DAT

    SN = SYSDAT1_DAT_GetSN  ' Returns a 32-bit pointer to the Sysop's Name
                            ' string

    PRINT SN                ' Prints the Sysop's Name

    SYSDAT1_DAT_PutSN "SysGod"  ' Let's put a new Sysop Name

    PRINT SYSDAT1_DAT_GetSN ' Returns a 32-bit pointer to the Sysop's Name
                            ' string with the new Sysop Name.

  SYSDAT1_DAT_Close         ' Closes SYSDAT1.DAT file

 ' In the example below, we can open, read, close the SYSDAT1.DAT file, also
 ' get and print the BBS Board's Name all in a single line of code. :)

   PRINT    ' Print a blank line
   SYSDAT1_DAT_OpenReadClose : PRINT SYSDAT1_DAT_GetBN

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for SYSDAT1.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

 SYSDAT1_DAT_OpenReadClose      ' Will Open, Read & Close SYSDAT1.DAT

  ' Grab File Area's data from memory using the a 32-bit pointer

    PRINT SYSDAT1_DAT_GetRC          ' Registration Code
    PRINT SYSDAT1_DAT_GetBN          ' Board Name
    PRINT SYSDAT1_DAT_GetSN          ' Sysop Name
    PRINT SYSDAT1_DAT_GetVCCL        ' Virus Checker Command Line
    PRINT SYSDAT1_DAT_GetZIPCCL      ' ZIP Compress Command Line
    PRINT SYSDAT1_DAT_GetZIPUCCL     ' ZIP UnCompress Command Line
    PRINT SYSDAT1_DAT_GetARJCCL      ' ARJ Compress Command Line
    PRINT SYSDAT1_DAT_GetARJUCCL     ' ARJ UnCompress Command Line
    PRINT SYSDAT1_DAT_GetLZHCCL      ' LZH Compress Command Line
    PRINT SYSDAT1_DAT_GetLZHUCCL     ' LZH UnCompress Command Line
    PRINT SYSDAT1_DAT_GetARCCCL      ' ARC Compress Command Line
    PRINT SYSDAT1_DAT_GetARCUCCL     ' ARC UnCompress Command Line
    PRINT SYSDAT1_DAT_GetPAKCCL      ' PAK Compress Command Line
    PRINT SYSDAT1_DAT_GetPAKUCCL     ' PAK UnCompress Command Line
    PRINT SYSDAT1_DAT_GetSDNCCL      ' SDN Compress Command Line
    PRINT SYSDAT1_DAT_GetSDNUCCL     ' SDN UnCompress Command Line
    PRINT SYSDAT1_DAT_GetRARCCL      ' RAR Compress Command Line
    PRINT SYSDAT1_DAT_GetRARUCCL     ' RAR UnCompress Command Line
    PRINT SYSDAT1_DAT_GetBSD         ' Board Start Date
    PRINT SYSDAT1_DAT_GetTN          ' Total Nodes
    PRINT SYSDAT1_DAT_GetCT          ' Calls Today
    PRINT SYSDAT1_DAT_GetMT          ' Messages Today

       PRINT
       PRINT "Hit Any Key To Continue"
       DO: LOOP WHILE INKEY$ = ""
       CLS

    PRINT SYSDAT1_DAT_GetUT          ' Uploads Today
    PRINT SYSDAT1_DAT_GetDT          ' Downloads Today
    PRINT SYSDAT1_DAT_GetDDTL        ' Default Daily Time Limit
    PRINT SYSDAT1_DAT_GetDDL         ' Default Daily Logons
    PRINT SYSDAT1_DAT_GetDTPL        ' Defautl Time Per Logon
    PRINT SYSDAT1_DAT_GetMSSL        ' Minimum Sysop Security Level
    PRINT SYSDAT1_DAT_GetNUSL        ' New User Security Level
    PRINT SYSDAT1_DAT_GetNUTL        ' New User Time Limit
    PRINT SYSDAT1_DAT_GetUTCR        ' Upload Time Compensation Ratio
    PRINT SYSDAT1_DAT_GetMFASL       ' Minimum File Attachment Security Level
    PRINT SYSDAT1_DAT_GetMAVSL       ' Minimum At Varible Security Level
    PRINT SYSDAT1_DAT_GetFLSL        ' Fast Logon Security Level
    PRINT SYSDAT1_DAT_GetTC          ' Total Calls
    PRINT

 ' ** These are Bit Fields converted to integers below **

    PRINT SYSDAT1_DAT_GetPNSF    ' Phone Number Flag
                                  '  0 = Do not format phone number
								  '  1 = North American-sytle phone numbers
    PRINT SYSDAT1_DAT_GetTUF     ' Test Upload Flag
							      ' 0 = Do not test uploads
							      ' 1 = Test uploads
    PRINT SYSDAT1_DAT_GetAADF    ' Auto ANSI detect flag
                                  ' 0 = Do not auto dectect ANSI
                                  ' 1 = Auto detect ANSI
    PRINT SYSDAT1_DAT_GetCFWMF   ' Check for waiting messages flag
                                  ' 0 = Do not check for waiting messages at
                                  '     logon
                                  ' 1 = Check for waiting messages at logon
    PRINT SYSDAT1_DAT_GetUDRTF   ' Upload/Download Ratio type flag
                                  ' 0 = Use sliding security levels
                                  ' 1 = Ratios only effect download ability
    PRINT SYSDAT1_DAT_GetPOHDMF  ' Phone on hook during maintainance flag
                                  ' 0 = Take phone off hook during maintainance
                                  ' 1 = Do not take the phone off hook during
                                  '     maintainance
    PRINT SYSDAT1_DAT_GetNOWNF   ' No one word names flag
                                  ' 0 = Allow on word names
                                  ' 1 = Do not allow one word names

       PRINT
       PRINT "Hit Any Key To Continue"
       DO: LOOP WHILE INKEY$ = ""
       CLS

    PRINT SYSDAT1_DAT_GetNBMALF  ' No bulletin menu at logon flag
                                  ' 0 = Display bulletin menu at logon
                                  ' 1 = Do not display bulletin menu at logon
    PRINT SYSDAT1_DAT_GetAAF     ' Allow aliases flag
                                  ' 0 = Do not allow aliases
                                  ' 1 = Allow aliases
    PRINT SYSDAT1_DAT_GetCSBMF   ' Clear screen before menus flag
                                  ' 0 = Do not clear the screen before menus
                                  ' 1 = Clear the screen before menus
    PRINT SYSDAT1_DAT_GetEFNMFDF ' Exact file name matching for dupes flag
                                  ' 0 = Ignore the extension during duplicate
                                  '     file checking
                                  ' 1 = Do not Ignore the extension during
                                  '     duplicate file checking
    PRINT SYSDAT1_DAT_GetDNUBPF  ' Disable new user birthday prompt flag
                                  ' 0 = Display the birthday prompt to a new
                                  '     user at logon
                                  ' 1 = Do not display the birthday prompt to
                                  '     a new user at logon
    PRINT SYSDAT1_DAT_GetDDCLF   ' Disable detailed callers log flag
                                  ' 0 = Use a detailed callers log
                                  ' 1 = Do not use a detailed callers log
    PRINT SYSDAT1_DAT_GetEREF    ' Enable RIPscip emulation flag
                                  ' 0 = Do not enable RIPscipt
                                  ' 1 = Enable RIPscipt
    PRINT SYSDAT1_DAT_GetUAORNF  ' Use alias or real names flag
                                  ' 0 = Uses the caller's alias for between
                                  '     node information purposes
                                  ' 1 = Uses the caller's real name for
                                  '     between node information purposes
    PRINT SYSDAT1_DAT_GetCUADF   ' Clear uploads and downloads flag
                                  ' 0 = Do not clear the user's upload/download
                                  '     counters when a user's subscription
                                  '     expires
                                  ' 1 = Clear th user's upload/download
                                  '     counters when a user's subsciption
                                  '     expires
    PRINT SYSDAT1_DAT_GetCPMAF   ' Clear private message area flag
                                  ' 0 = Do not clear the user's private
                                  '     message area flags when the user's
                                  '     subsciption expires
                                  ' 1 = Clear the user's private message
                                  '     area flages when the user's
                                  '     spbsciption expires
    PRINT SYSDAT1_DAT_GetCPFAF   ' Clear private file area flag
                                  ' 0 = Do not clear the user's private file
                                  '     area flags when the user's subsciption
                                  '     expires
                                  ' 1 = Clear the the user's private file
                                  '     area flags when the user's subscription
                                  '     expires
    PRINT SYSDAT1_DAT_GetDUBF    ' Disable uploaded by flag
                                  ' 0 = Put "Uploaded By:" lines in the file
                                  '     list when a file is uploaded
                                  ' 1 = Do not put "Uploaded By:" lines in
                                  '     the file list when a file is uploaded

$ENDIF

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END                          ' Ends the Program
