'Revised: 02/21/98 for PowerBasic v3.5
'
' ** Gobal Dimention for TriBBS Main Node's Directory String **
'
DIM TBNode1sMainDirectory AS SHARED STRING  ' Main Node's directory
'
PUBLIC TBNode1sMainDirectory ' Sets TriBBS Node 1's Main variable to be
                             ' gobal between units and main program.

'===========================================================================
' ** Sub Type Structure for 10 byte BitFields **
' Many of the Main Data Structures share this Sub Type BitFields Structure
'
 TYPE BitFields
    bit1  AS BYTE
    bit2  AS BYTE
    bit3  AS BYTE
    bit4  AS BYTE
    bit5  AS BYTE
    bit6  AS BYTE
    bit7  AS BYTE
    bit8  AS BYTE
    bit9  AS BYTE
    bit10 AS BYTE
 END TYPE
'
'===========================================================================
' USERS.DAT & MCONF.DAT Data Structures both share this Sub Type Structure
'
' NetworkBit.bit1 & NetworkBit.bit2 BIT Assignments:
' TriBBS allows a sysop to add up to 16 different Networks.
' Depending on the bit position 0 or 1, means that a certain Message
' Conference belongs to a certain network.
'
' NetworkBit.bit1 BIT Assignment:
'  0 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  1 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  2 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  3 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  4 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  5 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  6 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  7 = Points to network name defined in Network.dat  0 = No, 1 = Yes
' NetworkBit.bit2 BIT Assignment:
'  0 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  1 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  2 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  3 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  4 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  5 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  6 = Points to network name defined in Network.dat  0 = No, 1 = Yes
'  7 = Points to network name defined in Network.dat  0 = No, 1 = Yes

' Sub Type Structure for Network Flag BitFields
 TYPE NetworkBit
    bit1  AS BYTE
    bit2  AS BYTE
 END TYPE

 DIM NetworkBit AS NetworkBit
'
'===========================================================================
' ** SYSDAT1 File Structures and Declarations for SYSDAT1.DAT File **
'
'Sysdat1.dat BitFields breakdown

' SysDat1Bit.bit1 BIT Assignment
'    0 = PhoneNumberFlag                          0 = Non-US, 1 = US Format
'    1 = TestUploadsFlag                          0 = No, 1 = Yes
'    2 = AutoANSIDetectFlag                       0 = No, 1 = Yes
'    3 = CheckForWaitingMessagesFlag              0 = No, 1 = Yes
'    4 = ULDLRatioTypeFlag                        0 = Sec. Level, 1 = Download
'    5 = PhoneOnHookDuringMaintenanceFlag         0 = Off Hook, 1 = On Hook
'    6 = NoOneWordNamesFlag                       0 = Yes, 1 = No
'    7 = NoBulletinMenuAtLogonFlag                0 = Yes, 1 = No

' SysDat1Bit.bit2 BIT Assignment
'    0 = AllowAliasesFlag                         0 = No, 1 = Yes
'    1 = ClearScreenBeforeMenusFlag               0 = No, 1 = Yes
'    2 = ExactFileNameMatchingForDupesFlag        0 = No, 1 = Yes
'    3 = DisableNewUserBirthdayPromptFlag         0 = No, 1 = Yes
'    4 = DisableDetailedCallersLogFlag            0 = No, 1 = Yes
'    5 = EnableRIPscripEmulationFlag              0 = No, 1 = Yes
'    6 = UseAliasOrRealNamesFlag                  0 = Aliases, 1 = Real Names
'    7 = ClearUploadsAndDownloadsFlag             0 = No, 1 = Yes
    
' SysDat1Bit.bit3 BIT Assignment
'    0 = ClearPrivateMessageAreasFlag             0 = No, 1 = Yes
'    1 = ClearPrivateFileAreasFlag                0 = No, 1 = Yes
'    2 = DisableUploadedByFlag                    0 = No, 1 = Yes
'    3 to 7 = 0 (Reserved)

' SysDat1Bit.bit4 to SysDat1Bit.bit10 - All bits are set to 0 (Reserved)
'
'
'---------------------------------------------------------------------------
'
'File Name: "SYSDAT1.DAT"
 TYPE SYSDAT1
    RegistrationCode                   AS STRING * 81
    BoardName                          AS STRING * 41
    SysopName                          AS STRING * 61
    DefaultArchiveExtension            AS STRING * 4
    SystemPassword                     AS STRING * 16
    VirusCheckerCommandLine            AS STRING * 81
    ZIPCompressCommandLine             AS STRING * 81
    ZIPUnCompressCommandLine           AS STRING * 81
    ARJCompressCommandLine             AS STRING * 81
    ARJUnCompressCommandLine           AS STRING * 81
    LZHCompressCommandLine             AS STRING * 81
    LZHUnCompressCommandLine           AS STRING * 81
    ARCCompressCommandLine             AS STRING * 81
    ARCUnCompressCommandLine           AS STRING * 81
    PAKCompressCommandLine             AS STRING * 81
    PAKUnCompressCommandLine           AS STRING * 81
    SDNCompressCommandLine             AS STRING * 81
    SDNUnCompressCommandLine           AS STRING * 81
    RARCompressCommandLine             AS STRING * 81
    RARUnCompressCommandLine           AS STRING * 81
    BoardStartDate                     AS STRING * 9
    TotalNodes                         AS INTEGER
    CallsToday                         AS INTEGER
    MessagesToday                      AS INTEGER
    UploadsToday                       AS INTEGER
    DownloadsToday                     AS INTEGER
    DefaultDailyTimeLimit              AS INTEGER
    DefaultDailyLogons                 AS INTEGER
    DefaultTimePerLogon                AS INTEGER
    MinimumSysopSecurityLevel          AS INTEGER
    NewUserSecurityLevel               AS INTEGER
    NewUserTimeLimit                   AS INTEGER
    UploadTimeCompensationRatio        AS INTEGER
    MinimumFileAttachmentSecurityLevel AS INTEGER
    MinimumAtVariableSecurityLevel     AS INTEGER
    FastLogonSecurityLevel             AS INTEGER
    TotalCalls                         AS LONG
    SysDat1BitFields                   AS BitFields
    ReservedDataArea                   AS STRING * 2625
 END TYPE

 DIM SysDat1Bit AS BitFields
 DIM SYSDAT1    AS SHARED SYSDAT1
 DIM sys1       AS SHARED SYSDAT1 PTR

 sys1 = VARPTR32(SYSDAT1)
 LSET SYSDAT1 = SYSDAT1
'
'---------------------------------------------------------------------------
'
'Declare's used by the SYSDAT1.PBU API
'
' These DECLAREd FUNCTION's below are from the SYSDAT1.PBU Unit
'
DECLARE FUNCTION SYSDAT1_DAT_Open()
DECLARE FUNCTION SYSDAT1_DAT_Close()
DECLARE FUNCTION SYSDAT1_DAT_Read()
DECLARE FUNCTION SYSDAT1_DAT_Write()
DECLARE FUNCTION SYSDAT1_DAT_OpenRead()
DECLARE FUNCTION SYSDAT1_DAT_WriteClose()
DECLARE FUNCTION SYSDAT1_DAT_OpenReadClose()
DECLARE FUNCTION SYSDAT1_DAT_OpenWriteClose()
DECLARE FUNCTION SYSDAT1_DAT_ClearIt()
DECLARE FUNCTION SYSDAT1_DAT_Initialize()

DECLARE FUNCTION SYSDAT1_DAT_GetRC() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutRC(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetBN() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutBN(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetSN() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutSN(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetDAE() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutDAE(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetSP() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutSP(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetVCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutVCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetZIPCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutZIPCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetZIPUCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutZIPUCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetARJCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutARJCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetARJUCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutARJUCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetLZHCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutLZHCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetLZHUCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutLZHUCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetARCCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutARCCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetARCUCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutARCUCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetPAKCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutPAKCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetPAKUCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutPAKUCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetSDNCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutSDNCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetSDNUCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutSDNUCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetRARCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutRARCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetRARUCCL() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutRARUCCL(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetBSD() AS STRING
DECLARE FUNCTION SYSDAT1_DAT_PutBSD(s AS STRING)
DECLARE FUNCTION SYSDAT1_DAT_GetTN() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutTN(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetCT() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutCT(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetMT() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutMT(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetUT() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutUT(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetDT() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutDT(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetDDTL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutDDTL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetDDL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutDDL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetDTPL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutDTPL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetMSSL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutMSSL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetNUSL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutNUSL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetNUTL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutNUTL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetUTCR() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutUTCR(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetMFASL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutMFASL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetMAVSL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutMAVSL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetFLSL() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutFLSL(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetTC() AS LONG
DECLARE FUNCTION SYSDAT1_DAT_PutTC(n AS LONG)

DECLARE FUNCTION SYSDAT1_DAT_GetPNSF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutPNSF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetTUF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutTUF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetAADF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutAADF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetCFWMF() AS INTEGER 
DECLARE FUNCTION SYSDAT1_DAT_PutCFWMF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetUDRTF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutUDRTF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetPOHDMF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutPOHDMF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetNOWNF() AS INTEGER 
DECLARE FUNCTION SYSDAT1_DAT_PutNOWNF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetNBMALF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutNBMALF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetAAF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutAAF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetCSBMF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutCSBMF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetEFNMFDF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutEFNMFDF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetDNUBPF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutDNUBPF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetDDCLF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutDDCLF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetEREF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutEREF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetUAORNF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutUAORNF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetCUADF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutCUADF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetCPMAF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutCPMAF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetCPFAF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutCPFAF(n AS INTEGER)
DECLARE FUNCTION SYSDAT1_DAT_GetDUBF() AS INTEGER
DECLARE FUNCTION SYSDAT1_DAT_PutDUBF(n AS INTEGER)
'
'===========================================================================
' ** SYSDAT2 File Structures and Declarations for SYSDAT2.DAT File **
'
'File Name: "SYSDAT2.DAT"
'
 TYPE SYSDAT2
    Node1sMainDirectory AS STRING * 81
    ReservedDataArea    AS STRING * 175
 END TYPE

 DIM SYSDAT2    AS SHARED SYSDAT2
 DIM sys2       AS SHARED SYSDAT2 PTR

 sys2 = VARPTR32(SYSDAT2)
 LSET SYSDAT2 = SYSDAT2
'
'---------------------------------------------------------------------------
'
'Declare's used by the SYSDAT2.PBU API
'
' These DECLAREd FUNCTION's below are from the SYSDAT2.PBU Unit
'
DECLARE FUNCTION SYSDAT2_DAT_Open()
DECLARE FUNCTION SYSDAT2_DAT_Close()
DECLARE FUNCTION SYSDAT2_DAT_Read()
DECLARE FUNCTION SYSDAT2_DAT_Write()
DECLARE FUNCTION SYSDAT2_DAT_OpenRead()
DECLARE FUNCTION SYSDAT2_DAT_WriteClose()
DECLARE FUNCTION SYSDAT2_DAT_OpenReadClose()
DECLARE FUNCTION SYSDAT2_DAT_OpenWriteClose()
DECLARE FUNCTION SYSDAT2_DAT_ClearIt()
DECLARE FUNCTION SYSDAT2_DAT_Initialize()

DECLARE FUNCTION SYSDAT2_DAT_GetN1MD() AS STRING
DECLARE FUNCTION SYSDAT2_DAT_PutN1MD(s AS STRING)
'
'===========================================================================
' ** NODEDAT File Structures and Declarations for NODE.DAT File **
'
'Node.dat BitFields Breakdown

' NodeDatBit.bit1 BIT Assignment
'    0 = No300BaudCallersFlag                     0 = Yes, 1 = No
'    1 = No1200BaudCallersFlag                    0 = Yes, 1 = No
'    2 = No2400BaudCallersFlag                    0 = Yes, 1 = No
'    3 = RTSCTSHandshakingFlag                    0 = No,  1 = Yes
'    4 = LockSerialPortFlag                       0 = No,  1 = Yes
'    5 = DirectScreenWriteFlag                    0 = No,  1 = Yes
'    6 = PageBellOnFlag                           0 = Off, 1 = On
'    7 = UseNodeDISPLAYDirectoryFlag              0 = No,  1 = Yes

' NodeDatBit.bit2 BIT Assignment
'    0 = PhoneOffHookDuringEventsFlag             0 = No, 1 = Yes
'    1 = EnableLocalRIPscripEmulationFlag         0 = No, 1 = Yes
'    2 = UseFossilDriverFlag                      0 = No, 1 = Yes
'    3 = EnableCallerIDFlag				          0 = No, 1 = Yes
'    4 = BumpNoInfoCallsFlag                      0 = No, 1 = Yes
'    5 = BumpBlockedCallsFlag	                  0 = No, 1 = Yes
'    6 = BumpOutOfAreaCallsFlag                   0 = No, 1 = Yes
'    7 = 0 (Reserved)

' NodeDatBit.bit3 to NodeDatBit.bit10 - All bits are set to 0  (Reserved)

'---------------------------------------------------------------------------
'
'File Name: "NODE.DAT"
 TYPE NODEDAT
    InitializationString             AS STRING * 81
    ErrorCorrectingConnectionMessage AS STRING * 5
    ATZString                        AS STRING * 16
    ATAString                        AS STRING * 16
    ATH0String                       AS STRING * 16
    ATH1String                       AS STRING * 16
    DateOfLastCall                   AS STRING * 9
    NodeNumber                       AS INTEGER
    SerialPort                       AS INTEGER
    DelayBeforeATA                   AS INTEGER
    NumberOfRings                    AS INTEGER
    NodeSecurityLevel                AS INTEGER
    MaximumKeyboardIdleTime          AS INTEGER
    NonStandardIRQNumber             AS INTEGER
    DelayAfterCONNECT                AS INTEGER
    MaximumBaudRate                  AS LONG
    NodeDatBitFields                 AS BitFields
    ReservedDataArea                 AS STRING * 3907
 END TYPE

 DIM NodeDatBit AS BitFields
 DIM NODEDAT    AS SHARED NODEDAT
 DIM nd         AS SHARED NODEDAT PTR

 nd = VARPTR32(NODEDAT)
 LSET NODEDAT = NODEDAT
'---------------------------------------------------------------------------
'
'FUNCTION's below are from the NODEDAT.PBU Unit and DECLAREd in PBAPI10.INC.

DECLARE FUNCTION NODE_DAT_Open()
DECLARE FUNCTION NODE_DAT_Close()
DECLARE FUNCTION NODE_DAT_Read()
DECLARE FUNCTION NODE_DAT_Write()
DECLARE FUNCTION NODE_DAT_OpenRead()
DECLARE FUNCTION NODE_DAT_WriteClose()
DECLARE FUNCTION NODE_DAT_OpenReadClose()
DECLARE FUNCTION NODE_DAT_OpenWriteClose()
DECLARE FUNCTION NODE_DAT_ClearIt()
DECLARE FUNCTION NODE_DAT_Initialize()

DECLARE FUNCTION NODE_DAT_GetIS() AS STRING
DECLARE FUNCTION NODE_DAT_PutIS(s AS STRING)
DECLARE FUNCTION NODE_DAT_GetECCM() AS STRING
DECLARE FUNCTION NODE_DAT_PutECCM(s AS STRING)
DECLARE FUNCTION NODE_DAT_GetATZS() AS STRING
DECLARE FUNCTION NODE_DAT_PutATZS(s AS STRING)
DECLARE FUNCTION NODE_DAT_GetATAS() AS STRING
DECLARE FUNCTION NODE_DAT_PutATAS(s AS STRING)
DECLARE FUNCTION NODE_DAT_GetATH0S() AS STRING
DECLARE FUNCTION NODE_DAT_PutATH0S(s AS STRING)
DECLARE FUNCTION NODE_DAT_GetATH1S() AS STRING
DECLARE FUNCTION NODE_DAT_PutATH1S(s AS STRING)
DECLARE FUNCTION NODE_DAT_GetDOLC() AS STRING
DECLARE FUNCTION NODE_DAT_PutDOLC(s AS STRING)
DECLARE FUNCTION NODE_DAT_GetNN() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutNN(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetSP() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutSP(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetDBATA() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutDBATA(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetDAC() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutDAC(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetNOR() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutNOR(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetNSL() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutNSL(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetMKIT() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutMKIT(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetNSIRQN() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutNSIRQN(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetMBR() AS LONG
DECLARE FUNCTION NODE_DAT_PutMBR(n AS LONG)

DECLARE FUNCTION NODE_DAT_GetN300BCF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutN300BCF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetN1200BCF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutN1200BCF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetN2400BCF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutN2400BCF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetRTSCTSHF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutRTSCTSHF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetLSPF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutLSPF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetDSWF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutDSWF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetPBOF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutPBOF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetUNDDF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutUNDDF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetPOHDEF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutPOHDEF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetELRIPEF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutELRIPEF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetUFDF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutUFDF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetECIDF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutECIDF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetBNICF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutBNICF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetBBCF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutBBCF(n AS INTEGER)
DECLARE FUNCTION NODE_DAT_GetBOOACF() AS INTEGER
DECLARE FUNCTION NODE_DAT_PutBOOACF(n AS INTEGER)
'
'===========================================================================
' ** USERSDAT File Structures and Declarations for USERS.DAT File **

' Users.dat BitFields Breadown

' UserDatBit.bit1 BIT Assignment
'  0 = LockedOutFlag                            0 = No, 1 = Yes
'  1 = MarkedForDeletionFlag                    0 = No, 1 = Yes
'  2 = IncludeLOGON1InQWKFlag                   0 = No, 1 = Yes
'  3 = IncludeGOODBYEInQWKFlag                  0 = No, 1 = Yes
'  4 = IncludeBulletinsInQWKFlag                0 = No, 1 = Yes
'  5 = IncludeNewFilesInQWKFlag                 0 = No, 1 = Yes
'  6 = IncludeNewsletterInQWKFlag               0 = No, 1 = Yes
'  7 = CheckWaitingMessagesFlag                 0 = Yes, 1 = No

' UserDatBit.bit2 BIT Assignment
'  0 = GoodbyeAfterUploadFlag                   0 = No, 1 = Yes
'  1 = AttachedFilesInQWKFlag                   0 = No, 1 = Yes
'  2 to 7 = 0 (Reserved)

' UserDatBit.bit3 to UserDatBit.bit10 - All bits are set to 0  (Reserved)
'
'---------------------------------------------------------------------------
'
'File Name: "USERS.DAT"
 TYPE USERSDAT
    UserName                     AS STRING * 61
    Alias                        AS STRING * 61
    Password                     AS STRING * 16
    StreetAddress1               AS STRING * 41
    StreetAddress2               AS STRING * 41
    City                         AS STRING * 31
    State                        AS STRING * 31
    Country                      AS STRING * 31
    ZipCode                      AS STRING * 11
    PhoneNumber                  AS STRING * 31
    Birthday                     AS STRING * 9
    DateOfFirstCall              AS STRING * 9
    DateOfLastFileCheck          AS STRING * 9
    SubscriptionExpirationDate   AS STRING * 9
    DateAndTimeOfLastCall        AS STRING * 15
    ExpertMode                   AS INTEGER
    SecurityLevel                AS INTEGER
    NumberOfCalls                AS INTEGER
    TimeLeftForToday             AS INTEGER
    LastMessageConference        AS INTEGER
    LastFileArea                 AS INTEGER
    DefaultProtocol              AS INTEGER
    NumberOfCallsToday           AS INTEGER
    QWKNetworkNode               AS INTEGER
    DefaultEditor                AS INTEGER
    InitialChatStatus            AS INTEGER
    NumberOfFilesDownloadedToday AS INTEGER
    ArchiveUsedInQWK             AS INTEGER
    NumberOfFilesUploaded        AS LONG
    NumberOfFilesDownloaded      AS LONG
    NumberOfKBytesUploaded       AS LONG
    NumberOfKBytesDownloaded     AS LONG
    NumberOfMessagesPosted       AS LONG
    NumberOfBytesDownloadedToday AS LONG
    NetworkBitFields             AS NetworkBit
    UserDatBitFields             AS BitFields
    ReservedDataArea             AS STRING * 556
 END TYPE

 DIM UserDatBit AS BitFields
 DIM USERSDAT   AS SHARED USERSDAT
 DIM ud         AS SHARED USERSDAT PTR

 ud = VARPTR32(USERSDAT)
 LSET USERSDAT = USERSDAT
'
'---------------------------------------------------------------------------
'
'Declare's used by the USERSDAT.PBU API
'
' These function's below are from the USERSDAT.PBU Unit
'
DECLARE FUNCTION USERS_DAT_OPEN()
DECLARE FUNCTION USERS_DAT_CLOSE()
DECLARE FUNCTION USERS_DAT_READ(n AS WORD)
DECLARE FUNCTION USERS_DAT_WRITE(n AS WORD)
DECLARE FUNCTION USERS_DAT_Length() AS LONG
DECLARE FUNCTION USERS_DAT_OpenRead(n AS WORD)
DECLARE FUNCTION USERS_DAT_WriteClose(n AS WORD)
DECLARE FUNCTION USERS_DAT_OpenReadClose(n AS WORD)
DECLARE FUNCTION USERS_DAT_OpenWriteClose(n AS WORD)
DECLARE FUNCTION USERS_DAT_Clearit(n AS WORD)

DECLARE FUNCTION USERS_DAT_GetUN() AS STRING
DECLARE FUNCTION USERS_DAT_PutUN(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetAN() AS STRING
DECLARE FUNCTION USERS_DAT_PutAN(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetUP() AS STRING
DECLARE FUNCTION USERS_DAT_PutUP(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetSA1() AS STRING
DECLARE FUNCTION USERS_DAT_PutSA1(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetSA2() AS STRING
DECLARE FUNCTION USERS_DAT_PutSA2(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetCity() AS STRING
DECLARE FUNCTION USERS_DAT_PutCity(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetUS() AS STRING
DECLARE FUNCTION USERS_DAT_PutUS(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetUC() AS STRING
DECLARE FUNCTION USERS_DAT_PutUC(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetUZ() AS STRING
DECLARE FUNCTION USERS_DAT_PutUZ(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetUPN() AS STRING
DECLARE FUNCTION USERS_DAT_PutUPN(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetUBD() AS STRING
DECLARE FUNCTION USERS_DAT_PutUBD(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetDOFC() AS STRING
DECLARE FUNCTION USERS_DAT_PutDOFC(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetDOLFC() AS STRING
DECLARE FUNCTION USERS_DAT_PutDOLFC(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetSED() AS STRING
DECLARE FUNCTION USERS_DAT_PutSED(s AS STRING)
DECLARE FUNCTION USERS_DAT_GetDATOLC() AS STRING
DECLARE FUNCTION USERS_DAT_PutDATOLC(s AS STRING)

DECLARE FUNCTION USERS_DAT_PutEM(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetEM() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutSL(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetSL() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutNOC(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetNOC() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutTLFT(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetTLFT() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutLMC(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetLMC() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutLFA(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetLFA() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutDP(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetDP() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutNOCT(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetNOCT() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutQWKNN(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetQWKNN() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutDE(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetDE() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutICS(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetICS() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutNOFDT(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetNOFDT() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutAUIQ(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetAUIQ() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutSL(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetSL() AS INTEGER

DECLARE FUNCTION USERS_DAT_GetNOFU() AS LONG
DECLARE FUNCTION USERS_DAT_PutNOFU(n AS LONG)
DECLARE FUNCTION USERS_DAT_GetNOFD() AS LONG
DECLARE FUNCTION USERS_DAT_PutNOFD(n AS LONG)
DECLARE FUNCTION USERS_DAT_GetNOKBU() AS LONG
DECLARE FUNCTION USERS_DAT_PutNOKBU(n AS LONG)
DECLARE FUNCTION USERS_DAT_GetNOKBD() AS LONG
DECLARE FUNCTION USERS_DAT_PutNOKBD(n AS LONG)
DECLARE FUNCTION USERS_DAT_GetNOMP() AS LONG
DECLARE FUNCTION USERS_DAT_PutNOMP(n AS LONG)
DECLARE FUNCTION USERS_DAT_GetNOBDT() AS LONG
DECLARE FUNCTION USERS_DAT_PutNOBDT(n AS LONG)

DECLARE FUNCTION USERS_DAT_GetNWN() AS STRING
DECLARE FUNCTION USERS_DAT_GetNWF(nw AS INTEGER) AS INTEGER
DECLARE FUNCTION USERS_DAT_PutNWF(nw AS INTEGER, n AS INTEGER)

DECLARE FUNCTION USERS_DAT_GetLOF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutLOF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetMFDF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutMFDF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetILIQF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutILIQF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetIGIQF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutIGIQF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetIBIQF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutIBIQF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetINFIQF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutINFIQF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetINLIQF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutINLIQF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetCWMF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutCWMF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetGAUF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutGAUF(n AS INTEGER)
DECLARE FUNCTION USERS_DAT_GetAFIQF() AS INTEGER
DECLARE FUNCTION USERS_DAT_PutAFIQF(n AS INTEGER)
'
'===========================================================================
' ** USERS_SPM File Structures and Declarations for USERS.SPM File **

' Users.spm BitField Breakdown

'  BIT Assignment
'  0 = AccessPrivateConferenceFlag      0 = No, 1 = Yes
'  1 = CoSysopStatusFlag                0 = No, 1 = Yes
'  2 to 7 = 0 (Reserved)

'Sub Type Structure for 1 byte BitFields
  TYPE UserSpmBit
    bit1 AS BYTE
  END TYPE
'
'-----------------------------------------------------------------------------
'
' File Name: "USERS.SPM"
 TYPE USERSSPM
    LastMessageRead        AS LONG
    LastWaitingMessageRead AS LONG
    WaitingMessageCounter  AS INTEGER
    QueuedConference       AS INTEGER
    UserSpmBitFields       AS UserSpmBit
 END TYPE

 DIM UserSpmBit AS UserSpmBit
 DIM USERSSPM   AS SHARED USERSSPM
 DIM uspm       AS SHARED USERSSPM PTR

 uspm = VARPTR32(USERSSPM)
 LSET USERSSPM = USERSSPM
'
'---------------------------------------------------------------------------
'
'Declare's used by the USERSSPM.PBU API
'
' These function's below are from the USERSSPM.PBU Unit
'
DECLARE FUNCTION USERS_SPM_OPEN()
DECLARE FUNCTION USERS_SPM_CLOSE()
DECLARE FUNCTION USERS_SPM_READ(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPM_WRITE(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPM_OpenRead(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPM_WriteClose(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPM_OpenReadClose(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPM_OpenWriteClose(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPM_Clearit(n AS WORD)
DECLARE FUNCTION USERS_SPM_TotalRecords() AS WORD

DECLARE FUNCTION USERS_SPM_GetLMR() AS LONG
DECLARE FUNCTION USERS_SPM_PutLMR(n AS LONG)
DECLARE FUNCTION USERS_SPM_GetLWMR() AS LONG
DECLARE FUNCTION USERS_SPM_PutLWMR(n AS LONG)
DECLARE FUNCTION USERS_SPM_GetWMC() AS INTEGER
DECLARE FUNCTION USERS_SPM_PutWMC(n AS INTEGER)
DECLARE FUNCTION USERS_SPM_GetQC() AS INTEGER
DECLARE FUNCTION USERS_SPM_PutQC(n AS INTEGER)
DECLARE FUNCTION USERS_SPM_GetAPCF() AS INTEGER
DECLARE FUNCTION USERS_SPM_PutAPCF(n AS INTEGER)
DECLARE FUNCTION USERS_SPM_GetCSSF() AS INTEGER
DECLARE FUNCTION USERS_SPM_PutCSSF(n AS INTEGER)
'
'===========================================================================
' ** USERS_SPF File Structures and Declarations for USERS.SPF File **
'
' Users.spf BitField Breakdown

' BIT Assignment
'    0 = AccessPrivateAreaFlag                    0 = No, 1 = Yes
'    1 to 7 = 0 (Reserved)

'File Name: "USERS.SPF"
 TYPE USERSSPF
    AccessPrivateAreaFlag AS BYTE
 END TYPE

 DIM USERSSPF AS USERSSPF
 DIM uspf     AS USERSSPF PTR

 uspf = VARPTR32(USERSSPF)
 LSET USERSSPF = USERSSPF
'
'---------------------------------------------------------------------------
'
'Declare's used by the USERSSPF.PBU API
'
' These function's below are from the USERSSPF.PBU Unit
'
DECLARE FUNCTION USERS_SPF_OPEN()
DECLARE FUNCTION USERS_SPF_CLOSE()
DECLARE FUNCTION USERS_SPF_READ(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPF_WRITE(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPF_OpenRead(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPF_WriteClose(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPF_OpenReadClose(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPF_OpenWriteClose(u AS WORD, n AS INTEGER)
DECLARE FUNCTION USERS_SPF_Clearit(n AS WORD)
DECLARE FUNCTION USERS_SPF_TotalRecords() AS WORD

DECLARE FUNCTION USERS_SPF_GetAPAF() AS INTEGER
DECLARE FUNCTION USERS_SPF_PutAPAF(n AS INTEGER)
'
'===========================================================================
' ** USERS_IDX File Structures and Declarations for USERS.IDX File **
'
'File Name: "USERS.IDX"
 TYPE USERSIDX
    UserName     AS STRING * 61
    RecordNumber AS LONG
 END TYPE

 DIM USERSIDX AS SHARED USERSIDX
 DIM ui       AS SHARED USERSIDX PTR

 ui = VARPTR32(USERSIDX)
 LSET USERSIDX = USERSIDX
'
'---------------------------------------------------------------------------
'
'Declare's used by the USERSIDX.PBU API
'
' These function's below are from the USERSIDX.PBU Unit
'
DECLARE FUNCTION USERS_IDX_OPEN()
DECLARE FUNCTION USERS_IDX_CLOSE()
DECLARE FUNCTION USERS_IDX_READ(n AS WORD)
DECLARE FUNCTION USERS_IDX_WRITE(n AS WORD)
DECLARE FUNCTION USERS_IDX_Length() AS LONG
DECLARE FUNCTION USERS_IDX_OpenRead(n AS WORD)
DECLARE FUNCTION USERS_IDX_WriteClose(n AS WORD)
DECLARE FUNCTION USERS_IDX_OpenReadClose(n AS WORD)
DECLARE FUNCTION USERS_IDX_OpenWriteClose(n AS WORD)
DECLARE FUNCTION USERS_IDX_Clearit(n AS WORD)

DECLARE FUNCTION USERS_IDX_Search(s AS STRING) AS LONG
DECLARE FUNCTION USERS_IDX_Insert(s AS STRING, n AS LONG) AS LONG
DECLARE FUNCTION USERS_IDX_Replace(os AS STRING, ns AS STRING)

DECLARE FUNCTION USERS_IDX_GetUN() AS STRING
DECLARE FUNCTION USERS_IDX_PutUN(s AS STRING)
DECLARE FUNCTION USERS_IDX_GetRN() AS WORD
DECLARE FUNCTION USERS_IDX_PutRN(n AS WORD)
'
'===========================================================================
' ** ALIAS_IDX File Structures and Declarations for ALAIS.IDX File **
'
'File Name: "ALIAS.IDX"
 TYPE ALIASIDX
    UserName     AS STRING * 61
    RecordNumber AS LONG
 END TYPE

 DIM ALIASIDX AS SHARED ALIASIDX 
 DIM ai       AS SHARED ALIASIDX PTR

 ai = VARPTR32(ALIASIDX)
 LSET ALIASIDX = ALIASIDX
'
'---------------------------------------------------------------------------
'
'Declare's used by the ALIASIDX.PBU API
'
' These function's below are from the ALIASIDX.PBU Unit
'
DECLARE FUNCTION ALIAS_IDX_OPEN()
DECLARE FUNCTION ALIAS_IDX_CLOSE()
DECLARE FUNCTION ALIAS_IDX_READ(n AS WORD)
DECLARE FUNCTION ALIAS_IDX_WRITE(n AS WORD)
DECLARE FUNCTION ALIAS_IDX_Length() AS LONG
DECLARE FUNCTION ALIAS_IDX_OpenRead(n AS WORD)
DECLARE FUNCTION ALIAS_IDX_WriteClose(n AS WORD)
DECLARE FUNCTION ALIAS_IDX_OpenReadClose(n AS WORD)
DECLARE FUNCTION ALIAS_IDX_OpenWriteClose(n AS WORD)
DECLARE FUNCTION ALIAS_IDX_Clearit(n AS WORD)

DECLARE FUNCTION ALIAS_IDX_Search(s AS STRING) AS LONG
DECLARE FUNCTION ALIAS_IDX_Insert(s AS STRING, n AS LONG) AS LONG
DECLARE FUNCTION ALIAS_IDX_Replace(os AS STRING, ns AS STRING)

DECLARE FUNCTION ALIAS_IDX_GetUN() AS STRING
DECLARE FUNCTION ALIAS_IDX_PutUN(s AS STRING)
DECLARE FUNCTION ALIAS_IDX_GetRN() AS WORD
DECLARE FUNCTION ALIAS_IDX_PutRN(n AS WORD)
'
'===========================================================================
' ** NETWORK_DAT File Structures and Declarations for NETWORK.DAT File **

'File Name: "NETWORK.DAT"
 TYPE NETWORK
    NetworkName      AS STRING * 41
    ReservedDataArea AS STRING * 215
 END TYPE

 DIM NETWORK AS SHARED NETWORK
 DIM netwk   AS SHARED NETWORK PTR

 netwk = VARPTR32(NETWORK)
 LSET NETWORK = NETWORK    
'
'---------------------------------------------------------------------------
'
' Declare's used by the NETWORK.PBU API

'These FUNCTION's below are from the NETWORK.PBU Unit
DECLARE FUNCTION NETWORK_DAT_OPEN()
DECLARE FUNCTION NETWORK_DAT_CLOSE()
DECLARE FUNCTION NETWORK_DAT_READ(n AS INTEGER)
DECLARE FUNCTION NETWORK_DAT_WRITE(n AS INTEGER)
DECLARE FUNCTION NETWORK_DAT_Length() AS LONG
DECLARE FUNCTION NETWORK_DAT_OpenRead(n AS INTEGER)
DECLARE FUNCTION NETWORK_DAT_WriteClose(n AS INTEGER)
DECLARE FUNCTION NETWORK_DAT_OpenReadClose(n AS INTEGER)
DECLARE FUNCTION NETWORK_DAT_OpenWriteClose(n AS INTEGER)
DECLARE FUNCTION NETWORK_DAT_Clearit(n AS INTEGER)

DECLARE FUNCTION NETWORK_DAT_GetNWN() AS STRING
DECLARE FUNCTION NETWORK_DAT_PutNWN(s AS STRING)
'
'===========================================================================
' ** MCONF_DAT File Structures and Declarations for MCONF.DAT File **
'
' Mconf.dat BitFields Breakdown
'
' MconfBit.bit1 BIT Assignment
'  0 = NetworkedConferenceFlag                  0 = No, 1 = Yes
'  1 = PrivateConferenceFlag                    0 = No, 1 = Yes
'  2 = FidoStyleNetMailFlag                     0 = No, 1 = Yes
'  3 = AliasConferenceFlag                      0 = No, 1 = Yes
'  4 = UserDeleteFlag                           0 = Not Allowed, 1 = Allowed
'  5 = TriPackBackupFlag                        0 = No, 1 = Yes
'  6 = DisablePrivateMessagesFlag               0 = Yes, 1 = No
'  7 = DisablePublicMessagesFlag                0 = Yes, 1 = No
'
' NOTE!
' MconfBit.bit6 & MconfBit.bit7 both can be set to Yes, but only one may be
' set to No, with the other set to Yes.

' MconfBit.bit2 to MconfBit.bit10 - All bits are set to 0  (Reserved)
'
'---------------------------------------------------------------------------
'
'File Name: "MCONF.DAT"
 TYPE MCONF
    ConfName                  AS STRING * 41
    ReadSecurityLevel         AS INTEGER
    PostSecurityLevel         AS INTEGER
    TriPackNumberOfDaysToSave AS INTEGER
    HighestMessageNumber      AS LONG
    NetworkBitFields          AS NetworkBit
    MconfBitFields            AS BitFields
    ReservedDataArea          AS STRING * 961
 END TYPE

 DIM MconfBit AS BitFields
 DIM MCONF    AS SHARED MCONF
 DIM mc       AS SHARED MCONF PTR

 mc = VARPTR32(MCONF)
 LSET MCONF = MCONF  
'
'---------------------------------------------------------------------------
'
'Declare's used by the MCONF.PBU API
'
' These function's below are from the MCONF.PBU Unit
'
DECLARE FUNCTION MCONF_DAT_OPEN()
DECLARE FUNCTION MCONF_DAT_CLOSE()
DECLARE FUNCTION MCONF_DAT_READ(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_WRITE(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_Length() AS LONG
DECLARE FUNCTION MCONF_DAT_OpenRead(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_WriteClose(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_OpenReadClose(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_OpenWriteClose(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_Clearit(n AS INTEGER)

DECLARE FUNCTION MCONF_DAT_GetMCN() AS STRING
DECLARE FUNCTION MCONF_DAT_PutMCN(s AS STRING)
DECLARE FUNCTION MCONF_DAT_GetNWCN() AS STRING
DECLARE FUNCTION MCONF_DAT_GetRSL() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutRSL(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetPSL() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutPSL(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetTPNODTS() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutTPNODTS(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetHMN() AS LONG
DECLARE FUNCTION MCONF_DAT_PutHMN(n AS LONG)
DECLARE FUNCTION MCONF_DAT_GetNWF(nw AS INTEGER) AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutNWF(nw AS INTEGER, n AS INTEGER)

DECLARE FUNCTION MCONF_DAT_GetNWCF() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutNWCF(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetPCF() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutPCF(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetFSNM() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutFSNM(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetACF() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutACF(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetUDF() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutUDF(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetTPBF() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutTPBF(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetDPriM() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutDPriM(n AS INTEGER)
DECLARE FUNCTION MCONF_DAT_GetDPubM() AS INTEGER
DECLARE FUNCTION MCONF_DAT_PutDPubM(n AS INTEGER)
'
'============================================================================
' ** MNNNN File Structures and Declarations for MNNNN.HDR File **
'
' Mnnnn.hdr BitFields Breakdown

' MnnnnBit.bit1 BIT Assignment
'  0 = EchoMessageFlag
'  1 = ThreadedMessageFlag
'  2 = PrivateMessageFlag
'  3 = DeletedMessageFlag
'  4 = ReceivedMessageFlag
'  5 = PermanentMessageFlag
'  6 = TriTossEchoMessageFlag
'  7 = CrashMailFlag

' Mnnnn.bit2 to Mnnnn.bit10 - All bits are set to 0  (Reserved)
'
'---------------------------------------------------------------------------
' File Name: "Mnnnn.HDR"  where "nnnn" is the Conf Number
' Example: M0001.HDR to M9999.HDR
'
 TYPE MNNNN
    FromUser                     AS STRING * 61
    ToUser                       AS STRING * 61
    Subject                      AS STRING * 61
    NameOfAttachedFile           AS STRING * 81
    DateAndTime                  AS STRING * 15
    NetMailFromZone              AS INTEGER
    NetMailFromNet               AS INTEGER
    NetMailFromNode              AS INTEGER
    NetMailFromPoint             AS INTEGER
    NetMailToZone                AS INTEGER
    NetMailToNet                 AS INTEGER
    NetMailToNode                AS INTEGER
    NetMailToPoint               AS INTEGER
    OffsetIntoTextFile           AS LONG
    MessageLength                AS LONG
    Number                       AS LONG
    NumberOfMessageThisRepliesTo AS LONG
    FromHash                     AS LONG
    ToHash                       AS LONG
    MnnnnBitFields               AS BitFields
    ReservedDataArea             AS STRING * 695
 END TYPE

 DIM MnnnnBit AS BitFields
 DIM MNNNN    AS SHARED MNNNN
 DIM mch      AS SHARED MNNNN PTR

 mch = VARPTR32(MNNNN)
 LSET MNNNN = MNNNN  
'
'---------------------------------------------------------------------------
'
'Declare's used by the MNNNNH.PBU API
'
' These function's below are from the MNNNN.PBU Unit
'
DECLARE FUNCTION MNNNN_HDR_OPEN(c AS INTEGER) AS INTEGER
DECLARE FUNCTION MNNNN_HDR_CLOSE()
DECLARE FUNCTION MNNNN_HDR_READ(mn AS LONG)
DECLARE FUNCTION MNNNN_HDR_WRITE(mn AS LONG)
DECLARE FUNCTION MNNNN_HDR_Length() AS LONG
DECLARE FUNCTION MNNNN_HDR_OpenRead(c AS INTEGER, mn AS LONG) AS INTEGER
DECLARE FUNCTION MNNNN_HDR_WriteClose(mn AS LONG)
DECLARE FUNCTION MNNNN_HDR_OpenReadClose(c AS INTEGER, mn AS LONG) AS INTEGER
DECLARE FUNCTION MNNNN_HDR_OpenWriteClose(c AS INTEGER, mn AS LONG) AS INTEGER
DECLARE FUNCTION MNNNN_HDR_Clearit(c AS INTEGER)

DECLARE FUNCTION MNNNN_HDR_Search(mn AS LONG) AS INTEGER
DECLARE FUNCTION MNNNN_HDR_GetNext(mn AS LONG) AS INTEGER
DECLARE FUNCTION MNNNN_HDR_GetYourNext(h AS LONG, mn AS LONG) AS INTEGER

DECLARE FUNCTION MNNNN_HDR_GetFU() AS STRING
DECLARE FUNCTION MNNNN_HDR_PutFU(s AS STRING)
DECLARE FUNCTION MNNNN_HDR_GetTU() AS STRING
DECLARE FUNCTION MNNNN_HDR_PutTU(s AS STRING)
DECLARE FUNCTION MNNNN_HDR_GetMS() AS STRING
DECLARE FUNCTION MNNNN_HDR_PutMS(s AS STRING)
DECLARE FUNCTION MNNNN_HDR_GetNOAF() AS STRING
DECLARE FUNCTION MNNNN_HDR_PutNOAF(s AS STRING)
DECLARE FUNCTION MNNNN_HDR_GetDAT() AS STRING
DECLARE FUNCTION MNNNN_HDR_PutDAT(s AS STRING)

DECLARE FUNCTION MNNNN_HDR_GetNMFZ() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutNMFZ(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetNMFNet() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutNMFNet(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetNMFNode() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutNMFNode(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetNMFP() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutNMFP(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetNMTZ() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutNMTZ(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetNMTNet() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutNMTNet(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetNMTNode() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutNMTNode(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetNMTP() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutNMTP(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetOITF() AS LONG
DECLARE FUNCTION MNNNN_HDR_PutOITF(n AS LONG)
DECLARE FUNCTION MNNNN_HDR_GetML() AS LONG
DECLARE FUNCTION MNNNN_HDR_PutML(n AS LONG)
DECLARE FUNCTION MNNNN_HDR_GetMN() AS LONG
DECLARE FUNCTION MNNNN_HDR_PutMN(mn AS LONG)
DECLARE FUNCTION MNNNN_HDR_GetNOMTRT() AS LONG
DECLARE FUNCTION MNNNN_HDR_PutNOMTRT(n AS LONG)
DECLARE FUNCTION MNNNN_HDR_GetFH() AS LONG
DECLARE FUNCTION MNNNN_HDR_PutFH(n AS LONG)
DECLARE FUNCTION MNNNN_HDR_GetTH() AS LONG
DECLARE FUNCTION MNNNN_HDR_PutTH(n AS LONG)

DECLARE FUNCTION MNNNN_HDR_GetEMF() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutEMF(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetTMF() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutTMF(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetPriMF() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutPriMF(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetDMF() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutDMF(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetRMF() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutRMF(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetPerMF() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutPerMF(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetTTEMF() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutTTEMF(n AS INTEGER)
DECLARE FUNCTION MNNNN_HDR_GetCMF() AS INTEGER
DECLARE FUNCTION MNNNN_HDR_PutCMF(n AS INTEGER)
'
'============================================================================
' ** Declarations for MNNNN.TXT File **
'
'Declare's used by the MNNNNT.PBU API
'
' These sub's below are from the MNNNNT.PBU Unit
'
DECLARE FUNCTION MNNNN_TXT_Open(c AS INTEGER)
DECLARE FUNCTION MNNNN_TXT_CLOSE()
DECLARE FUNCTION MNNNN_TXT_READ() AS STRING
DECLARE FUNCTION MNNNN_TXT_Length() AS LONG

'============================================================================
' ** FAREA_DAT File Structures and Declarations for FAREA.DAT File **
'
' Farea.dat BitFields Breakdown
'
' FareaBit.bit1 BIT Assignment
'  0 = PrivateAreaFlag
'  1 = CDROMFileAreaFlag
'  2 = AliasAreaFlag
'  3 = OfflineFileAreaFlag
'  4 = MasterIndexFlag
'  5 to 7 Reserved, set to all 0's
'
' FareaBit.bit2 to FareaBit.bit10, Reserved and all bit's set to 0
'
'---------------------------------------------------------------------------
'
'Sub Type Structure for 10 Additional File Area Paths BitFields
 TYPE AFAP
    FP1  AS STRING * 81
    FP2  AS STRING * 81
    FP3  AS STRING * 81
    FP4  AS STRING * 81
    FP5  AS STRING * 81
    FP6  AS STRING * 81
    FP7  AS STRING * 81
    FP8  AS STRING * 81
    FP9  AS STRING * 81
    FP10 AS STRING * 81
 END TYPE
'
'---------------------------------------------------------------------------
'
'File Name: Main Type Structure for "FAERA.DAT" file
 TYPE FAREA
    FareaName               AS STRING * 41
    FileAreaPath            AS STRING * 81
    FileAreaUploadPath      AS STRING * 81
    FileAreaFileList        AS STRING * 81
    FileAreaUploadList      AS STRING * 81
    FileAreaIndexFile       AS STRING * 81
    AdditionalFileAreaPaths AS AFAP
    SecurityLevel           AS INTEGER
    ViewSecurityLevel       AS INTEGER
    FileSortType            AS INTEGER
    FileBitFields           AS BitFields
    OfflineDiscNumber       AS INTEGER
    ReservedDataArea        AS STRING * 2822
 END TYPE

 DIM FareaBit AS BitFields
 DIM AFAP     AS AFAP
 DIM FAREA    AS SHARED FAREA
 DIM fa       AS SHARED FAREA PTR

 fa = VARPTR32(FAREA)
 LSET FAREA = FAREA
'
'---------------------------------------------------------------------------
'
'Declare's used by the FAREA.PBU API
'
'These function's below are from the FAREA.PBU Unit
DECLARE FUNCTION FAREA_DAT_OPEN()
DECLARE FUNCTION FAREA_DAT_CLOSE()
DECLARE FUNCTION FAREA_DAT_READ(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_WRITE(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_Length() AS LONG
DECLARE FUNCTION FAREA_DAT_OpenRead(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_WriteClose(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_OpenReadClose(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_OpenWriteClose(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_Clearit(n AS INTEGER)

DECLARE FUNCTION FAREA_DAT_GetFAN() AS STRING
DECLARE FUNCTION FAREA_DAT_PutFAN(s AS STRING)
DECLARE FUNCTION FAREA_DAT_GetFAP() AS STRING
DECLARE FUNCTION FAREA_DAT_PutFAP(s AS STRING)
DECLARE FUNCTION FAREA_DAT_GetFAUP() AS STRING
DECLARE FUNCTION FAREA_DAT_PutFAUP(s AS STRING)
DECLARE FUNCTION FAREA_DAT_GetFAFL() AS STRING
DECLARE FUNCTION FAREA_DAT_PutFAFL(s AS STRING)
DECLARE FUNCTION FAREA_DAT_GetFAUL() AS STRING
DECLARE FUNCTION FAREA_DAT_PutFAUL(s AS STRING)
DECLARE FUNCTION FAREA_DAT_GetFAIF() AS STRING
DECLARE FUNCTION FAREA_DAT_PutFAIF(s AS STRING)
DECLARE FUNCTION FAREA_DAT_GetAFAP(n AS INTEGER) AS STRING
DECLARE FUNCTION FAREA_DAT_PutAFAP(n AS INTEGER, s AS STRING)

DECLARE FUNCTION FAREA_DAT_GetSL() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutSL(s AS INTEGER)
DECLARE FUNCTION FAREA_DAT_GetVSL() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutVSL(s AS INTEGER)
DECLARE FUNCTION FAREA_DAT_GetODN() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutODN(s AS INTEGER)
DECLARE FUNCTION FAREA_DAT_GetFST() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutFST(n AS INTEGER)

DECLARE FUNCTION FAREA_DAT_GetPFAF() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutPFAF(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_GetCDFAF() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutCDFAF(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_GetAFAF() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutAFAF(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_GetOFAF() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutOFAF(n AS INTEGER)
DECLARE FUNCTION FAREA_DAT_GetMIFAF() AS INTEGER
DECLARE FUNCTION FAREA_DAT_PutMIFAF(n AS INTEGER)
'
'============================================================================
' ** DOORS_TMP File Structures and Declarations for DOORS.TMP File **
'
' Doors.tmp BitFields Breakdown
'
' DoorTmpBit.bit1 BIT Assignment
'  0 = ANSIFlag
'  1 = FrontEndFlag
'  2 = FrontEndHangUpFlag
'  3 = UserWindowFlag
'  4 = ChatRequestedFlag
'  5 = EventPendingFlag
'  6 = GoodbyeFromDoorFlag
'  7 = ForceBoardDownAfterCallFlag
'
' DoorTmpBit.bit2 Assignment
'  0 = RIPscripFlag
'  1 = DOORSYSFlag
'  2 = ErrorCorrectingConnectionFlag
'  3 to 7 Reserved, set to all 0's
'
' DoorTmpBit.bit3 to DoorTmpBit.bit10, Reserved and all bit's set to 0
'
'---------------------------------------------------------------------------
'
'File Name: "DOORS.TMP"
 TYPE DOORTMP
    TimeLeftAtLogon           AS INTEGER
    CurrentFileArea           AS INTEGER
    CurrentMessageConference  AS INTEGER
    FrontEndTime              AS INTEGER
    WhereTheDoorWasCalledFrom AS INTEGER
    LanguageNumber            AS INTEGER
    NumberOfFilesFlagged      AS INTEGER
    TimeInDOORSYS             AS INTEGER
    UserRecordNumber          AS LONG
    BaudRate                  AS LONG
    FrontEndBaudRate          AS LONG
    TimeWhenUserLoggedOn      AS LONG
    DoorTmpBitFields          AS BitFields
 END TYPE

 DIM DoorTmpBit AS BitFields
 DIM DOORTMP    AS SHARED DOORTMP
 DIM dt         AS SHARED DOORTMP PTR

 dt = VARPTR32(DOORTMP)
 LSET DOORTMP = DOORTMP
'
'---------------------------------------------------------------------------
'
' Declare's used by the DOORTMP.PBU API
'
' These function's below are from the DOORTMP.PBU Unit
'
DECLARE FUNCTION DOORS_TMP_OPEN() AS INTEGER
DECLARE FUNCTION DOORS_TMP_CLOSE()
DECLARE FUNCTION DOORS_TMP_READ()
DECLARE FUNCTION DOORS_TMP_WRITE()
DECLARE FUNCTION DOORS_TMP_OpenRead() AS INTEGER
DECLARE FUNCTION DOORS_TMP_WriteClose()
DECLARE FUNCTION DOORS_TMP_OpenReadClose() AS INTEGER
DECLARE FUNCTION DOORS_TMP_OpenWriteClose() AS INTEGER
DECLARE FUNCTION DOORS_TMP_Clearit() AS INTEGER

DECLARE FUNCTION DOORS_TMP_GetTLAL() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutTLAL(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetCFA() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutCFA(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetCMC() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutCMC(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetFET() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutFET(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetWTDWCF() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutWTDWCF(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetLN() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutLN(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetNOFF() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutNOFF(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetTIDSys() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutTIDSys(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetURN() AS LONG
DECLARE FUNCTION DOORS_TMP_PutURN(n AS LONG)
DECLARE FUNCTION DOORS_TMP_GetBR() AS LONG
DECLARE FUNCTION DOORS_TMP_PutBR(n AS LONG)
DECLARE FUNCTION DOORS_TMP_GetFEBR() AS LONG
DECLARE FUNCTION DOORS_TMP_PutFEBR(n AS LONG)
DECLARE FUNCTION DOORS_TMP_GetTWULO() AS LONG
DECLARE FUNCTION DOORS_TMP_PutTWULO(n AS LONG)

DECLARE FUNCTION DOORS_TMP_GetAF() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutAF(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetFEF() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutFEF(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetFEHU() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutFEHU(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetUWF() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutUWF(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetCRF() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutCRF(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetEPF() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutEPF(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetGFD() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutGFD(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetFBDAC() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutFBDAC(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetRIP() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutRIP(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetDSF() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutDSF(n AS INTEGER)
DECLARE FUNCTION DOORS_TMP_GetECC() AS INTEGER
DECLARE FUNCTION DOORS_TMP_PutECC(n AS INTEGER)
'
'============================================================================
' ** EVENTS_DAT File Structures and Declarations for EVENTS.DAT File **
'
' Events.dat EventsDatBitFields Breakdown

' EventsDatBitFields.bit1 BIT Assignment
'  0 = EventExecutedTodayFlag
'  1 = SlidingEventFlag 
'  2 to 7 Reserved, set to all 0's

' EventsDatBitFields.bit2 to EventsDatBitFields.bit10, Reserved and all
' bit's set to 0.

'Sub Type Structure for 1 byte BitFields
  TYPE EventsDatBit
    bit1 AS BYTE
  END TYPE

'File Name: "EVENTS.DAT"
  TYPE EVENTSDAT
    Time               AS STRING * 6
    File               AS STRING * 13
    Day                AS INTEGER
    EventsDatBitFields AS EventsDatBit
    ReservedDataArea   AS STRING * 234
  END TYPE

  DIM EventsDatBit AS EventsDatBit
  DIM EVENTSDAT    AS SHARED EVENTSDAT
  DIM ed           AS SHARED EVENTSDAT PTR

  ed = VARPTR32(EVENTSDAT)
  LSET EVENTSDAT = EVENTSDAT
'
'---------------------------------------------------------------------------
'
'FUNCTION's below are from the EVENTSDAT.PBU Unit and DECLAREd in PBAPI10.INC.

DECLARE FUNCTION EVENTS_DAT_Open()
DECLARE FUNCTION EVENTS_DAT_Close()
DECLARE FUNCTION EVENTS_DAT_Read(n AS INTEGER)
DECLARE FUNCTION EVENTS_DAT_Write(n AS INTEGER)
DECLARE FUNCTION EVENTS_DAT_OpenRead(n AS INTEGER)
DECLARE FUNCTION EVENTS_DAT_WriteClose(n AS INTEGER)
DECLARE FUNCTION EVENTS_DAT_OpenReadClose(n AS INTEGER)
DECLARE FUNCTION EVENTS_DAT_OpenWriteClose(n AS INTEGER)
DECLARE FUNCTION EVENTS_DAT_Length() AS LONG
DECLARE FUNCTION EVENTS_DAT_ClearIt(n AS INTEGER)

DECLARE FUNCTION EVENTS_DAT_GetTime() AS STRING
DECLARE FUNCTION EVENTS_DAT_PutTime(s AS STRING)
DECLARE FUNCTION EVENTS_DAT_GetFile() AS STRING
DECLARE FUNCTION EVENTS_DAT_PutFile(s AS STRING)
DECLARE FUNCTION EVENTS_DAT_GetDay() AS INTEGER
DECLARE FUNCTION EVENTS_DAT_PutDay(n AS INTEGER)

DECLARE FUNCTION EVENTS_DAT_GetEETF() AS INTEGER
DECLARE FUNCTION EVENTS_DAT_PutEETF(n AS INTEGER)
DECLARE FUNCTION EVENTS_DAT_GetSEF() AS INTEGER
DECLARE FUNCTION EVENTS_DAT_PutSEF(n AS INTEGER)
'
'============================================================================
' ** WHOSON_DAT File Structures and Declarations for WHOSON.DAT File **
'
'File Name: "WHOSON.DAT"
 TYPE WHOSONDAT
    WhoName          AS STRING * 61
    ChatBuffer       AS STRING * 1024
    ChatStatus       AS INTEGER
    NodeChattingWith AS INTEGER
    Head             AS INTEGER
    Tail             AS INTEGER
    ReservedDataArea AS STRING * 3003
 END TYPE

 DIM WHOSONDAT AS SHARED WHOSONDAT
 DIM wd        AS SHARED WHOSONDAT PTR

 wd = VARPTR32(WHOSONDAT)
 LSET WHOSONDAT = WHOSONDAT
'
'---------------------------------------------------------------------------
'
'FUNCTION's below are from the WHOSON.PBU Unit and DECLAREd in PBAPI10.INC.

DECLARE FUNCTION WHOSON_DAT_Open()
DECLARE FUNCTION WHOSON_DAT_Close()
DECLARE FUNCTION WHOSON_DAT_Read(n AS INTEGER)
DECLARE FUNCTION WHOSON_DAT_Write(n AS INTEGER)
DECLARE FUNCTION WHOSON_DAT_OpenRead(n AS INTEGER)
DECLARE FUNCTION WHOSON_DAT_WriteClose(n AS INTEGER)
DECLARE FUNCTION WHOSON_DAT_OpenReadClose(n AS INTEGER)
DECLARE FUNCTION WHOSON_DAT_OpenWriteClose(n AS INTEGER)
DECLARE FUNCTION WHOSON_DAT_Length() AS LONG
DECLARE FUNCTION WHOSON_DAT_ClearIt(n AS INTEGER)

DECLARE FUNCTION WHOSON_DAT_GetWN() AS STRING
DECLARE FUNCTION WHOSON_DAT_PutWN(s AS STRING)
DECLARE FUNCTION WHOSON_DAT_GetCS() AS INTEGER
DECLARE FUNCTION WHOSON_DAT_PutCS(n AS INTEGER)
DECLARE FUNCTION WHOSON_DAT_GetNCW() AS INTEGER
DECLARE FUNCTION WHOSON_DAT_PutNCW(n AS INTEGER)
'
'============================================================================
' ** Declare's used by the DIRUNIT.PBU API **
'
DECLARE FUNCTION DtaAttrib() AS INTEGER
DECLARE FUNCTION DtaDate() AS STRING
DECLARE FUNCTION DtaTime() AS STRING
DECLARE FUNCTION DtaSize() AS LONG
DECLARE FUNCTION Dos2Date(BYVAL Fd AS INTEGER) AS STRING
DECLARE FUNCTION Dos2Time(BYVAL Ft AS INTEGER) AS STRING
DECLARE SUB GetDTA(DtaSeg AS INTEGER, DtaOfs AS INTEGER)
'
'============================================================================
' ** Declare's used by the DOSUNIT.PBU API **
'
DECLARE FUNCTION AddFileHandles(BYVAL NumHandles AS INTEGER) AS INTEGER
DECLARE FUNCTION ArgC(BYVAL Cmd AS STRING) AS INTEGER
DECLARE FUNCTION ArgV(BYVAL Which AS INTEGER, BYVAL Cmd AS STRING) AS STRING
DECLARE FUNCTION CopyFile(BYVAL Source AS STRING, BYVAL Target AS STRING) AS INTEGER
DECLARE FUNCTION Date2DOS(BYVAL TempDate AS STRING) AS WORD
DECLARE FUNCTION DiskFree(BYVAL Drive AS STRING) AS DWORD
DECLARE FUNCTION ExeName() AS STRING
DECLARE FUNCTION Exist(BYVAL Filename AS STRING) AS INTEGER
DECLARE FUNCTION FileSize(BYVAL Filename AS STRING) AS LONG
DECLARE FUNCTION IsShareLoaded() AS INTEGER
DECLARE FUNCTION MakeBAK(BYVAL Filename AS STRING) AS STRING
DECLARE FUNCTION SetFileDateTime(BYVAL FileName AS STRING, BYVAL FileDate AS STRING, BYVAL FileTime AS STRING) AS INTEGER
DECLARE FUNCTION Time2DOS(BYVAL TempTime AS STRING) AS WORD
DECLARE FUNCTION WildMatchFile(BYVAL FileName AS STRING, BYVAL WildCard AS STRING) AS INTEGER
DECLARE SUB SplitPath(BYVAL Source AS STRING, Fldrive AS STRING, Flpath AS STRING, Flname AS STRING)
DECLARE SUB SplitPath2(FilePath$, Path$, FileName$)
'
'============================================================================
' ** Declare's used by the DATEUNIT.PBU API **
'
DECLARE FUNCTION CDOW(BYVAL string) AS string
DECLARE FUNCTION DOW(BYVAL string) AS integer
DECLARE FUNCTION DOY(BYVAL string) AS integer
DECLARE FUNCTION DateMath(BYVAL string, BYVAL integer) AS string
DECLARE FUNCTION DateToDays(string) AS word
DECLARE FUNCTION Days(BYVAL string, BYVAL string) AS integer
DECLARE FUNCTION DaysInMonth(BYVAL integer) AS integer
DECLARE FUNCTION DaysToDate(BYVAL word) AS string
DECLARE FUNCTION Elapsed(BYVAL string, BYVAL string) AS long
DECLARE FUNCTION Leap(BYVAL integer) AS integer
DECLARE FUNCTION MakeDate(BYVAL integer, BYVAL integer, BYVAL integer) AS string
DECLARE FUNCTION MakeTime(BYVAL integer, BYVAL integer, BYVAL integer) AS string
DECLARE FUNCTION MakeTime12(BYVAL integer, BYVAL integer) AS string
DECLARE FUNCTION MonthName(BYVAL integer) AS string
DECLARE FUNCTION SecondsToTime(BYVAL long) AS string
DECLARE FUNCTION TimeToSeconds(BYVAL string) AS long
DECLARE FUNCTION ValidDate(BYVAL string) AS integer
DECLARE SUB SplitDate(BYVAL string, integer, integer, integer)
DECLARE SUB SplitTime(BYVAL string, integer, integer, integer)
'
'============================================================================
' ** Declare's used by the UTIL.PBU API **
'
DECLARE FUNCTION InitialCaps(s AS STRING) AS STRING
DECLARE FUNCTION TrimString(s AS STRING) AS STRING
DECLARE FUNCTION HashIt(s AS STRING) AS LONG
DECLARE FUNCTION MenuBox(x1 AS INTEGER, y1 AS INTEGER, x2 AS INTEGER, y2 AS _
        INTEGER, FColor AS INTEGER, BColor AS INTEGER, HeaderText AS STRING)
DECLARE FUNCTION LineInput(HideChar AS STRING, CharAllow AS STRING, PromptLine _
        AS STRING, Row AS INTEGER, MaxLen AS INTEGER) AS STRING
DECLARE FUNCTION PhoneNumberInput(PromptLine AS STRING, Row AS INTEGER) _
        AS STRING
DECLARE FUNCTION DateInput(PromptLine AS STRING, Row AS INTEGER) AS STRING
DECLARE FUNCTION YesNo(PromptString AS STRING, Row AS INTEGER, ResponseKey _
        AS INTEGER) AS INTEGER
DECLARE SUB CalcByte(Attr AS INTEGER, LowByte AS INTEGER, HiByte AS INTEGER) 
DECLARE SUB MakeByte(Attr AS INTEGER, LowByte AS INTEGER, HiByte AS INTEGER) 
DECLARE SUB CheckBits(Attr AS INTEGER, BitOne AS INTEGER, BitTwo AS INTEGER, _
            BitThree AS INTEGER, BitFour AS INTEGER, BitFive  AS INTEGER, _
            BitSix AS INTEGER, BitSeven AS INTEGER, BitEight AS INTEGER) 
DECLARE FUNCTION VideoSeg()  AS LONG
DECLARE SUB Browse(FileName AS STRING, Mouse AS INTEGER, TextColor AS INTEGER, _
        TopRow AS INTEGER, LeftColumn AS INTEGER, BottomRow AS INTEGER, _
        RightColumn AS INTEGER, Attr AS INTEGER, Shadow AS INTEGER, _
        Border AS INTEGER) 
DECLARE SUB HiPrint(Text AS STRING, HiAttr AS INTEGER, Attr AS INTEGER) 
DECLARE SUB LinePrint(Text AS STRING, Row AS INTEGER, Col AS INTEGER, Wide AS INTEGER, _
            Fill AS INTEGER, Attr AS INTEGER) 
DECLARE SUB CenterPrint(Text AS STRING, Row AS INTEGER, Wide AS INTEGER, Fill AS INTEGER, _
            Attr AS INTEGER) 
'
'============================================================================
' ** Declare's used by the MOUSE.PBU API **
'
DECLARE FUNCTION CheckForMouse() AS INTEGER
DECLARE FUNCTION CentreButtonReleased() AS INTEGER
DECLARE FUNCTION BothButtonReleased() AS INTEGER
DECLARE FUNCTION RightButtonReleased() AS INTEGER
DECLARE FUNCTION LeftButtonReleased() AS INTEGER
DECLARE SUB Clicked (Rgt AS INTEGER, Lft AS INTEGER, Row AS INTEGER, Col AS INTEGER)
DECLARE SUB HideCursor()
DECLARE SUB ShowCursor()
DECLARE SUB LocateCursor (Row AS INTEGER, Col AS INTEGER)
DECLARE SUB ScreenPlus(Row AS INTEGER, Col AS INTEGER, TextFound AS STRING)
DECLARE SUB FindMenu(Row AS INTEGER, Col AS INTEGER, Found AS INTEGER)
'
'============================================================================
' ** Declare's used by the MENU.PBU API **
'
DECLARE SUB HorizontalMenu(Choices() AS STRING, _
                           BarSave   AS STRING, _
                           HiLight   AS INTEGER, _
                           Mouse     AS INTEGER, _
                           HPointer  AS INTEGER, _
                           HotKey    AS INTEGER, _
                           BarAttr   AS INTEGER, _
                           HiAttr    AS INTEGER, _
                           MenuRow   AS INTEGER, _
                           Gap       AS INTEGER, _
                           Marker    AS INTEGER)
DECLARE SUB VerticalMenu(Choices()     AS STRING, _
                         Infoline()    AS STRING, _
                         Rtrn          AS STRING, _
                         BarSave       AS STRING, _
                         Mouse         AS INTEGER, _
                         HotKey        AS INTEGER, _
                         HelpTextColor AS INTEGER, _
                         HelpAttr      AS INTEGER, _
                         HiAttr        AS INTEGER, _
                         MenuRow       AS INTEGER, _
                         Marker        AS INTEGER, _
                         HPointer      AS INTEGER, _
                         Attr          AS INTEGER, _
                         Shadow        AS INTEGER, _
                         Border        AS INTEGER)
DECLARE SUB MGInset(TRow AS INTEGER, LCol AS INTEGER, BRow AS INTEGER, _
            RCol AS INTEGER, Attr AS INTEGER)
'
'============================================================================
' ** Declare's used by the SCREEN.PBU API **
'
DECLARE SUB RestoreScreen(ScreenID AS STRING) 
DECLARE SUB PutSavedScreen(ScreenID AS STRING, TopRow AS INTEGER, LeftColumn AS INTEGER) 
DECLARE SUB SaveScreen(ScreenID AS STRING, TopRow AS INTEGER, LeftColumn  AS INTEGER, _
            BottomRow AS INTEGER, RightColumn AS INTEGER, Shadow AS INTEGER) 
DECLARE SUB POPWIND (Title AS STRING, Toprow AS INTEGER, Leftcolumn  AS INTEGER, _
            Bottomrow AS INTEGER, Rightcolumn AS INTEGER, Attr AS INTEGER, _
            Shadow AS INTEGER, Border AS INTEGER) 
'
'============================================================================
' ** Declare's for Flags used by the Assembly Routines in the API **
'
%FLAGS = 0
%AX    = 1
%BX    = 2
%CX    = 3
%DX    = 4
%SI    = 5
%DI    = 6
%BP    = 7
%DS    = 8
%ES    = 9

%FALSE = 0
%TRUE  = NOT %FALSE
