' 
' Program Title: Sample Program for TriBBS's NODE.DAT API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample.bas file, you will see servals different examples on how
' to use the Pointer "sys1" to make calls to the TriBBS API NODEDAT.PBU Unit.
' Also there are some examples showing how to use the NODEDAT.PBU Unit
' without using pointers.  To use any of the current examples, go to the
' section and you will see a "$IF 0" statment at the head of the example, all
' you need to do to make that section of code run is change the '0' to any
' non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerful! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' All String Pointer calls will grab the data from memory, and strip any
' spaces and null terminator characters from the end of the string which
' will allow you to print with better screen output control.
'
' When writting back to memory with a pointer string, this NODEDAT API will
' set the length back to proper size and add the null terminator, CHR$(0)
' to the end of the string. This again, will save time in writting back
' to the original record NODE.DAT.
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "NODEDAT.EXE"   ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL                    ' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
                            ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' NODEDAT.DAT API which are located in the NODEDAT.INC file.

'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for NODE.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

DIM IS AS STRING         ' Dimention a Local Varible to hold Initialization
                         ' String for this example

  NODE_DAT_OpenRead      ' Will Open and Read in NODE.DAT

    IS = NODE_DAT_GetIS  ' Returns a 32-bit pointer to the Initialization
                         ' String

    PRINT IS             ' Prints the Initialization String

    NODE_DAT_PutIS "AT&FS0=0^M"  ' Let's change the Initialization String
                                 ' data in memory

    PRINT NODE_DAT_GetIS ' Returns a 32-bit pointer to the Initialization
                         ' String back from memory.

  NODE_DAT_Close         ' Closes NODE.DAT file

 ' In the example below, we can open, read, close the NODE.DAT file, also
 ' get and print the Date Of Last Call all in a single line of code. :)

   PRINT    ' Print a blank line
   NODE_DAT_OpenReadClose : PRINT NODE_DAT_GetDOLC

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for NODE.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

 NODE_DAT_OpenReadClose      ' Will Open, Read & Close NODE.DAT

  ' Grab File Area's data from memory using the a 32-bit pointer

    PRINT NODE_DAT_GetIS          ' Initialization String
    PRINT NODE_DAT_GetECCM        ' Error Correcting Connect Message
    PRINT NODE_DAT_GetATZS        ' ATZ String
    PRINT NODE_DAT_GetATAS        ' ATA String
    PRINT NODE_DAT_GetATH0S       ' ATH0 String
    PRINT NODE_DAT_GetATH1S       ' ATH1 String
    PRINT NODE_DAT_GetDOLC        ' Date Of Last Call
    PRINT NODE_DAT_GetNN          ' Node Number
    PRINT NODE_DAT_GetSP          ' Serial Port
    PRINT NODE_DAT_GetDBATA       ' Delay Before ATA
    PRINT NODE_DAT_GetNOR         ' Number of Rings
    PRINT NODE_DAT_GetNSL         ' Node Security Level
    PRINT NODE_DAT_GetMKIT        ' Maximum Keyboard Idle Time
    PRINT NODE_DAT_GetNSIRQN      ' Non-Standard IRQ Number
    PRINT NODE_DAT_GetDAC         ' Delay After CONNECT
    PRINT NODE_DAT_GetMBR         ' Maximum Baud Rate


 ' ** These are Bit Fields converted to integers below **

    PRINT NODE_DAT_GetN300BCF   ' No 300 Baud Callers Flag
                                  ' 0 = Allow 300 baud callers
                                  ' 1 = Do not allow 300 baud callers
    PRINT NODE_DAT_GetN1200BCF  ' No 1200 Baud Callers Flag
							      ' 0 = Allow 1200 baud callers
							      ' 1 = Do not allow 1200 baud callers
    PRINT NODE_DAT_GetN2400BCF  ' No 2400 Baud Callers Flag
                                  ' 0 = Allow 2400 baud callers
                                  ' 1 = Do not allow 2400 baud callers
    PRINT NODE_DAT_GetRTSCTSHF  ' RTS/CTS Handshaking Flag
                                  ' 0 = Do not use RTS/CTS handshaking
                                  ' 1 = Use RTS/CTS handshaking
    PRINT NODE_DAT_GetLSPF      ' Lock Serial Port Flag
                                  ' 0 = Do not lock the serial port
                                  ' 1 = Lock the serial port
    PRINT NODE_DAT_GetDSWF      ' Direct Screen Write Flag
                                  ' 0 = Disable the video controller when
                                  '     writing to the screen memory
                                  ' 1 = Do not disable the videod controller
                                  '     when writting to the screen memory

       PRINT
       PRINT "Hit Any Key To Continue"
       DO: LOOP WHILE INKEY$ = ""
       CLS

    PRINT NODE_DAT_GetPBOF      ' Page Bell On Flag
                                  ' 0 = Page bell is off
                                  ' 1 = Page bell is on
    PRINT NODE_DAT_GetUNDDF     ' Use Node 1's DISPLAY Directory Flag
                                  ' 0 = Use node 1's DISPLAY directory
                                  ' 1 = Do not use node 1's DISPLAY directory
    PRINT NODE_DAT_GetPOHDEF    ' Phone Off Hook During Events Flag
                                  ' 0 = Do not take the phone off hook during
                                  '     events flag
                                  ' 1 = Take the phone off hook during events
    PRINT NODE_DAT_GetELRIPEF   ' Enable Local RIPscrip Emulation Flag
                                  ' 0 = Disable local RIPscrip emulation
                                  ' 1 = Enable local RIPscrip emulation
    PRINT NODE_DAT_GetUFDF      ' Use Fossil Driver Flag
                                  ' 0 = Do not use a fossil driver
                                  ' 1 = Use a fossil driver
    PRINT NODE_DAT_GetECIDF     ' Enable Caller ID Flag
                                  ' 0 = Do not Enable Caller ID
                                  ' 1 = Enable Caller ID
    PRINT NODE_DAT_GetBNICF     ' Bump No Info Calls Flag
                                  ' 0 = Do not bump no info calls
                                  ' 1 = Bump no info calls
    PRINT NODE_DAT_GetBBCF      ' Bump Blocked Calls Flag
                                  ' 0 = Do not bump blocked calls
                                  ' 1 = Bump blocked calls
    PRINT NODE_DAT_GetBOOACF    ' Bump Out Of Area Calls Flag
                                  ' 0 = Do not bump  out of area calls
                                  ' 1 = Bump out of area calls

$ENDIF

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END                          ' Ends the Program
