' 
' Program Title: Sample Program for TriBBS's MCONF.DAT API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample.bas file, you will see servals different examples on how
' to use the Pointer "mc" to make calls to the TriBBS API MCONF.PBU Unit.
' Also there are some examples showing how to use the MCONF.PBU Unit
' without using pointers.  To use any of the current examples, go to the
' section and you will see a "$IF 0" statment at the head of the example, all
' you need to do to make that section of code run is change the '0' to any
' non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerful! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' All String Pointer calls will grab the data from memory, and strip any
' spaces and null terminator characters from the end of the string which
' will allow you to print with better screen output control.
'
' When writting back to memory with a pointer string, this MCONF API will
' set the length back to proper size and add the null terminator, CHR$(0)
' to the end of the string. This again, will save time in writting back
' to the original record MCONF.DAT.
'
' For non-pointer calls, you will have to adjust the string yourself for
' proper printing to the screen. Also, when writting back to the MCONF.DAT
' file, you must add a num terminator to the end of the string. More on this
' in the Non-Pointer example.
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "MCONF.EXE"   ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL					' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
			                ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **
'
'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' MCONF.DAT API which are located in the MCONF.INC file.
'
'---------------------------------------------------------------------------
' ** DIMENTION ALL VARIBLES, ARRAYS, TYPE STRUCTURES, & POINTERS **
'
'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for MCONF.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example

DIM MCN  AS STRING             ' Local Varible to hold the Message
                               ' Conference Name for this example

  MCONF_DAT_OpenRead 1         ' Will Open and Read in MCONF.DAT
                               ' record #1

    PRINT "Total Records:" MCONF_DAT_Length ' Returns and Prints Total
                                            ' Records in MCONF.DAT

    MCN = MCONF_DAT_GetMCN     ' Returns a 32-bit pointer to the Message
                               ' Conference's Name string

    PRINT MCN                  ' Prints the Message Conference Name

    MCONF_DAT_PutMCN "New Message Conference Name" ' Let's put a new Message
                                                   ' Conference Name in for
                                                   ' this Message Conference

    PRINT MCONF_DAT_GetMCN     ' Returns a 32-bit pointer to the Message
                               ' Conference's Name string with the new
                               ' Message Conference Name.

  MCONF_DAT_Close              ' Closes Mconf.dat file

 ' In the example below, we can open, read, close the Mconf.dat file, also
 ' get and print the Message Conference Name from record #1 all in a single
 ' line of code. :)

   PRINT    ' Print a blank line
   MCONF_DAT_OpenReadClose 1 : PRINT MCONF_DAT_GetMCN

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for MCONF.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example

 MCONF_DAT_OpenReadClose 1     ' Will Open and Read in MCONF.DAT
                               ' record #1 and Close the file

  ' Grab File Area's data from memory using the a 32-bit pointer

    PRINT MCONF_DAT_GetMCN     ' Message Conference Name
    PRINT MCONF_DAT_GetNWCN    ' Gets all of the Network Names which are
                               ' assigned to the Message Conference Record
                               ' that is currently being read in
    PRINT MCONF_DAT_GetRSL     ' Read Security Level
    PRINT MCONF_DAT_GetPSL     ' Post Security Level
    PRINT MCONF_DAT_GetTPNODTS ' TriPack Number Of Days To Save
    PRINT MCONF_DAT_GetHMN     ' Highest Message Number

  ' ** These are Bit Fields converted to integers below **

    PRINT                        ' Prints a blank line
    PRINT MCONF_DAT_GetNWF(1)    ' Gets Network Flag for Record #(nw)
                                   ' (nw) = 1 to 16
    PRINT MCONF_DAT_PutNWF(1, 1) ' Changes Network Flag for Record #(nw, n)
                                   ' nw = 1 to 16
                                   ' n  = either 0 or 1
                                   ' 0  = The conference does not belong to
                                   '      the network.
                                   ' 1  = The conference belongs to the
                                   '      network.
    PRINT MCONF_DAT_GetNWF(1)    ' Gets Network Flag for Record #(nw) after
                                 ' bit change - (nw) = 1 to 16
    PRINT                        ' Prints a blank line

    PRINT MCONF_DAT_GetNWCF     ' Networked Conference Flag
                                  ' 0 = The Conference isn't a networked
                                  '     conference
                                  ' 1 = The Conference is a networked
                                  '     conference
    PRINT MCONF_DAT_GetPCF      ' Private Conference Flag
                                  ' 0 = The conference isn't a private
                                  '     conference.
                                  ' 1 = The conference is a private
                                  '     conference.
    PRINT MCONF_DAT_GetFSNM     ' Fido Style Net Mail Flag
                                  ' 0 = The conference isn't a Fido-style
                                  '     netmail conference.
                                  ' 1 = The conference is a Fido-style
                                  '     netmail conference.
    PRINT MCONF_DAT_GetACF      ' Alais Conference Flag
                                  ' 0 = The conference isn't an alias
                                  '     conference.
                                  ' 1 = The conference is an alias conference.
    PRINT MCONF_DAT_GetUDF      ' User Delete Flag
                                  ' 0 = Users are not allowed to delete
                                  '     messages.
                                  ' 1 = Users can deleted messages.
    PRINT MCONF_DAT_GetTPBF     ' TriPack Backup Flag
                                  ' 0 = Do not save backup files while
                                  '     packing the message base.
                                  ' 1 = Save backup files while packing the
                                  '     message base.

  ' ** SPECIAL NOTE: When working with these two bit flags below, Do Not
  ' Set both to '1' which will set both to "NO". At least one of these
  ' has to be set to '0' which will set it to "YES". However, both can
  ' be set to '0' or "YES".

    PRINT MCONF_DAT_GetDPriM    ' Disable Private Messages Flag
                                  ' 0 = Do not disable private messages.
                                  ' 1 = Disable private messages.
    PRINT MCONF_DAT_GetDPubM    ' Disable Public Messages Flag
                                  ' 0 = Do not disable public messages.
                                  ' 1 = Disable public messages.
$ENDIF

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE for MCONF.DAT Non-Pointer Calls **
'----------------------------------------------------------------------------
'
' This sample section will show how to use the MCONF.PBU Unit in it's basic
' form. This will require more string operations than the pointer section
' since you will be grabing just basic data straight from the MCONF.DAT
' file. Trimming, and removing and adding null terminators will have to be
' performed in this manner. If is very important when writting any data
' back to the MCONF.DAT file in this manner, you add the null terminator
' CHR$(0) to the end of all normal predefined strings based on the MCONF.DAT
' type structure located in the MCONF.INC file. Follow the example below.
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$IF 0  ' Change the '0' to '1' to run this example

 MCONF_DAT_OpenRead 1        ' Open MCONF.DAT File, and Read in record #1


  PRINT MCONF.ConfName       ' Prints Message Conference Name as it is from
                             ' Mconf.dat
  PRINT LEN(MCONF.ConfName)  ' Prints Len of Message Conference Name
                             ' This shows a string length of 41 characters,
                             ' which is 40 charcaters that you may use for
                             ' data, and the last 41 contains the null
                             ' terminator, CHR$(0)
 MCONF_DAT_Close             ' Close MCONF.DAT File.


  ' Now, lets trim off the excess spaces and the null terminator.
  ' First I will create a new variable to hold the new data.

  DIM Temp AS STRING         ' Dimention a new variable

 MCONF_DAT_Open              ' Open MCONF.DAT File
 MCONF_DAT_Read 1            ' Read in Record #1

  Temp = RTRIM$(MCONF.ConfName, ANY " " + CHR$(0)) ' This preforms the trim
           										    ' operation
  PRINT Temp                 ' Prints the new string without the extra spaces
                             ' and CHR$(0)
  PRINT LEN(Temp)            ' Prints the True Length of the Message
                             ' Conference Name

 MCONF_DAT_Close             ' Closes MCONF.DAT File

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END                          ' Ends the Program