' 
' Program Title: Demo for Menu Control Screen
'     Copyright: 1997-98 By Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 

$CPU 80386                 ' program works 386 or higher CPU

$OPTIMIZE SPEED

'$COMPILE EXE  "DEMOMENU.EXE"  ' compile to an EXE

$DEBUG MAP OFF             ' turn off map file generation
$DEBUG PBDEBUG OFF         ' don't include pbdebug support in our executable

$LIB COM        OFF        ' turn off PowerBASIC's communications library.
$LIB LPT        OFF        ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF        ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF        ' turn off PowerBASIC's floating point support.

$ERROR ALL OFF

$FLOAT PROCEDURE           ' use procedural floating point to optimize for
               			   ' machines without a co-processor

$STRING 16                 ' set largest string size at 8k
$STACK 2048                ' let's use a 2k stack

$DIM none 'ALL                   ' force arrays to be pre-dimensioned before they can
			               ' be used

$DYNAMIC                   ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF      ' don't allow Ctrl-Break to exit program

DEFINT A-Z                 ' default all variables to integers for maximum
						   ' speed and minimum

'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE LOCAL SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
'---------------------------------------------------------------------------
'* DECLARE ALL LOCAL AND SHARED VARIABLES USED IN MAIN PROGRAM BETWEEN SUBS *
'
DIM HorzMenu(1:5)   AS STRING

DIM VertMenu1(1:9)  AS STRING
DIM VertInfo1(1:9)  AS STRING

DIM VertMenu2(1:9)  AS STRING
DIM VertInfo2(1:9)  AS STRING

DIM VertMenu3(1:9)  AS STRING
DIM VertInfo3(1:9)  AS STRING

DIM VertMenu4(1:9)  AS STRING
DIM VertInfo4(1:9)  AS STRING

DIM Mouse           AS INTEGER
DIM HelpTextColor   AS INTEGER
DIM HelpAttr        AS INTEGER
DIM TopRow          AS INTEGER
DIM Marker          AS INTEGER
DIM BarSave         AS STRING
DIM HiLight			AS INTEGER
DIM HPointer	    AS INTEGER
DIM VRtrn           AS STRING
DIM x				AS INTEGER

'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

'NOTE: This is only needed when you want to access TriBBS Database Files.
TBNode1sMainDirectory = "E:\TRIBBS"

'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

' NOTE:
'  To calculate a color number for the "Attr", select a color from 1 to 15,
'  then mulptiply x 16. If you want to do forground, then add the number of
'  color to the sum of the multiplied answer like so: 1 x 16 = 16 for Blue
'  Background, add 15 for a total of 31 to give you Blue background with
'  White forground. You can also call the Sub MakeByte(Attr%,lowbyte%,hibyte%)
'  which will perform the same operation. Example below:
'  MakeByte Attr%, 15, 1.   Attr% = 31
'
'----------------------------------------------------------------------------

HorzMenu$(1) = "@File"
HorzMenu$(2) = "@Edit"
HorzMenu$(3) = "@Screen"
HorzMenu$(4) = "@Help"
'----------------------------------------------------------------------------

VertMenu1$(1) = "@Quit"
'VertMenu1$(2) = " "
'VertMenu1$(3) = "_"
'VertMenu1$(4) = " "
'VertMenu1$(5) = "_"
'VertMenu1$(6) = " "
'VertMenu1$(7) = " "
'VertMenu1$(8) = " "

VertInfo1$(1) = "Quit and Return to System!"
'VertInfo1$(2) = ""
'VertInfo1$(4) = ""
'VertInfo1$(6) = ""
'VertInfo1$(7) = ""
'VertInfo1$(8) = ""

'----------------------------------------------------------------------------
VertMenu2$(1) = "@Open Files"
'VertMenu2$(2) = "_"
'VertMenu2$(3) = " "
'VertMenu2$(4) = "_"
'VertMenu2$(5) = " "
'VertMenu2$(6) = "_"
'VertMenu2$(7) = " "
'VertMenu2$(8) = " "

VertInfo2$(1) = "Open and Edit Files!"
'VertInfo2$(3) = " "
'VertInfo2$(5) = " "
'VertInfo2$(7) = " "
'VertInfo2$(8) = " "
'----------------------------------------------------------------------------
VertMenu3$(1) = "@Screen Control"
'VertMenu3$(2) = " "
'VertMenu3$(3) = "_"
'VertMenu3$(4) = " "
'VertMenu3$(5) = " "
'VertMenu3$(6) = " "
'VertMenu3$(7) = " "

VertInfo3$(1) = "Screen Controls"
'VertInfo3$(2) = " "
'VertInfo3$(4) = " "
'VertInfo3$(5) = " "
'VertInfo3$(6) = " "
'VertInfo3$(7) = " "
'----------------------------------------------------------------------------
VertMenu4$(1) = "Help @Commands"
'VertMenu4$(2) = "_"
'VertMenu4$(3) = " "
'VertMenu4$(4) = " "
'VertMenu4$(5) = "_"
'VertMenu4$(6) = " "
'VertMenu4$(7) = " "
'VertMenu4$(8) = " "

VertInfo4$(1) = "Help Commands for this program"
'VertInfo4$(3) = " "
'VertInfo4$(4) = " "
'VertInfo4$(6) = " "
'VertInfo4$(7) = " "
'VertInfo4$(8) = " "
'----------------------------------------------------------------------------

IF CheckForMouse% THEN Mouse% = 1

SCREEN 0

CenterPrint "Demo Menu",1,80,32,31
LOCATE 2,1,0: COLOR 7,9: PRINT STRING$(80, 205);

'Screen color = for background, ( 7 x 16 = 112), now add 15 for foregroud,
' ( 112 + 15 = 127)
MGInset 3,1,24,80,127

LOCATE 25,1,0: COLOR 0,9: PRINT SPACE$(80);

HelpTextColor% = 15
HelpAttr% = 63

TopRow% = 2
Marker% = 99

DO

HORIZONTALMENU HorzMenu$(),BarSave$,HiLight%,Mouse%,HPointer%,15,23,112,TopRow%,5,Marker%

SELECT CASE HPointer%
  CASE 1  'File
    VERTICALMENU VertMenu1$(),VertInfo1$(),VRtrn$,BarSave$,Mouse%,15,HelpTextColor%,HelpAttr%,112,TopRow%,Marker%,HPointer%,23,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
        CASE "Quit"
          GOSUB SHOWSELECTIONMADE
	      VRtrn$ = "Quit"
      END SELECT
    END IF
  CASE 2  'Edit
    VERTICALMENU VertMenu2$(),VertInfo2$(),VRtrn$,BarSave$,Mouse%,15,HelpTextColor%,HelpAttr%,112,TopRow%,Marker%,HPointer%,23,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
	    CASE "Open Files"
          GOSUB SHOWSELECTIONMADE
      END SELECT
    END IF
  CASE 3  'Screen
    VERTICALMENU VertMenu3$(),VertInfo3$(),VRtrn$,BarSave$,Mouse%,15,HelpTextColor%,HelpAttr%,112,TopRow%,Marker%,HPointer%,23,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
	    CASE "Screen Control"
	      GOSUB SHOWSELECTIONMADE
      END SELECT
    END IF
  CASE 4  'Help
    VERTICALMENU VertMenu4$(),VertInfo4$(),VRtrn$,BarSave$,Mouse%,15,HelpTextColor%,HelpAttr%,112,TopRow%,Marker%,HPointer%,23,1,1
    IF LEN(VRtrn$) THEN
      SELECT CASE VRtrn$
	    CASE "Help Commands"
	      GOSUB SHOWSELECTIONMADE
      END SELECT
    END IF
END SELECT

HiLight% = 1

LOOP UNTIL VRtrn$ = "Quit"

DELAY .5
COLOR 7,0
CLS

FOR x = 1 TO 25
 PRINT ""
NEXT x

END

'============================================================================
SHOWSELECTIONMADE:

DIM ScreenID    AS STRING
DIM Title       AS STRING
DIM Trow        AS INTEGER
DIM Leftcolumn  AS INTEGER
DIM Bottomrow   AS INTEGER
DIM Rightcolumn AS INTEGER
DIM Attr        AS INTEGER
DIM Shadow      AS INTEGER
DIM Border      AS INTEGER

Title$       = "Selection Made Window"
Trow%        = 10
Leftcolumn%  = 25
Bottomrow%   = 14
Rightcolumn% = 57
Attr         = 31 ' (1 x 16) + 15 = 31 for color
Shadow%      = 1
Border%      = 1

SaveScreen ScreenID$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Shadow%
PopWind Title$,Trow%,Leftcolumn%,Bottomrow%,Rightcolumn%,Attr%,Shadow%,Border%
COLOR 14, 9:LOCATE 12,27,0 : PRINT "You Selected " + CHR$(34) + VRtrn$ + CHR$(34)
DELAY 3
RestoreScreen ScreenID$

RETURN

'============================================================================
