' 
' Program Title: Sample Program for TriBBS's USERS.IDX API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample.bas file, you will see servals different examples on how
' to use the Pointer "ui" to make calls to the TriBBS API USERSIDX.PBU Unit.
' Also there are some examples showing how to use the USERSIDX.PBU Unit
' without using pointers.  To use any of the current examples, go to the
' section and you will see a "$IF 0" statment at the head of the example, all
' you need to do to make that section of code run is change the '0' to any
' non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerfull! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' All String Pointer calls will grab the data from memory, and strip any
' spaces and null terminator characters from the end of the string which
' will allow you to print with better screen output control.
'
' When writting back to memory with a pointer string, this USERSIDX API will
' set the length back to proper size and add the null terminator, CHR$(0)
' to the end of the string. This again, will save time in writting back
' to the original record USERS.IDX.
'
' For non-pointer calls, you will have to adjust the string yourself for
' proper printing to the screen. Also, when writting back to the USERS.IDX
' file, you must add a num terminator to the end of the string. More on this
' in the Non-Pointer example.
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "USERIDX.EXE" ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL                    ' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
                            ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' USERS.IDX API which are located in the USERSIDX.INC file.

'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for USERS.IDX Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

  USERS_IDX_Open           ' Will Open USERS.IDX

    'PRINT "Total Records:" USERS_IDX_Length  ' Returns and Prints Number of
                                              ' Records in USERS.IDX

   ' Search the USERS.IDX for a user's name. If found, will read record into
   ' memory, then you can read the user's name and record number. If user
   ' name isn't found, then it will return a '0'.

    IF USERS_IDX_Search("Gary Price") <> 0 THEN ' Checks to see if user is
                                                ' in the users.idx file.
                                                  ' 0 = User was not found
                                                  ' 1 = User was found

      PRINT USERS_IDX_GetUN  ' Returns a 32-bit pointer to the User's Name
                             ' string after the search.
      PRINT USERS_IDX_GetRN  ' Returns a 32-bit pointer to the User's Record
                             ' Number after the search
    END IF                   ' Ends IF/END statment

  USERS_IDX_Close          ' Closes USERS.IDX file

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for USERS.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

DIM RecNum AS WORD

   ' Search the USERS.IDX for a user's name. If found, will read record into
   ' memory, then you can get the record number and pass it to 'RecNum' so it
   ' can search and obtain user's information from the Users.dat file. If
   ' user's name isn't found, then USERS_IDX_Search() will return a '0'.

 USERS_IDX_Open             ' Opens USERS.IDX

 IF USERS_IDX_Search("Gary Price") <> 0 THEN ' Checks to see if user is
                                             ' in the users.idx file.
                                               ' 0 = User was not found
                                               ' 1 = User was found

     RecNum = USERS_IDX_GetRN ' Returns a 32-bit pointer to the User's
                              ' Record Number after the search

 USERS_DAT_OpenReadClose RecNum  ' Will Open, Read and Close USERS.DAT
                                 ' for RecNum, which was returned by the
                                 ' USERS_IDX_Search function

  ' Grab File Area's data from memory using the a 32-bit pointer
  ' and print partial record

    PRINT USERS_DAT_GetUN     ' Name
    PRINT USERS_DAT_GetAN     ' Alias Name
    PRINT USERS_DAT_GetUP     ' Password
    PRINT USERS_DAT_GetSA1    ' Street Address 1
    PRINT USERS_DAT_GetSA2    ' Street Address 2
    PRINT USERS_DAT_GetCity   ' City
    PRINT USERS_DAT_GetUS     ' State
    PRINT USERS_DAT_GetUC     ' Country
    PRINT USERS_DAT_GetUZ     ' Zipcode
    PRINT USERS_DAT_GetUPN    ' Phone Number
    PRINT USERS_DAT_GetUBD    ' Birth Date

 END IF       ' Ends the END/IF condition for Users.idx search

 USERS_IDX_Close              ' Closes USERS.IDX file


$ENDIF

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
END                          ' Ends the Program
