' 
' Program Title: Sample Program for TriBBS's USERS.DAT API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample.bas file, you will see servals different examples on how
' to use the Pointer "ud" to make calls to the TriBBS API USERSDAT.PBU Unit.
' Also there are some examples showing how to use the USERSDAT.PBU Unit
' without using pointers.  To use any of the current examples, go to the
' section and you will see a "$IF 0" statment at the head of the example, all
' you need to do to make that section of code run is change the '0' to any
' non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerful! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' All String Pointer calls will grab the data from memory, and strip any
' spaces and null terminator characters from the end of the string which
' will allow you to print with better screen output control.
'
' When writting back to memory with a pointer string, this USERSDAT API will
' set the length back to proper size and add the null terminator, CHR$(0)
' to the end of the string. This again, will save time in writting back
' to the original record USERS.DAT.
'
' For non-pointer calls, you will have to adjust the string yourself for
' proper printing to the screen. Also, when writting back to the USERS.DAT
' file, you must add a num terminator to the end of the string. More on this
' in the Non-Pointer example.
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "USERDAT.EXE"   ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL                    ' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
                            ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' USERS.DAT API which are located in the USERSDAT.INC file.

'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for USERS.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

DIM UN AS STRING          ' Dimention a Local Varible to hold User's Name for
                          ' this example

  USERS_DAT_OpenRead 1    ' Will Open and Read in USERS.DAT
                          ' record #1

    PRINT "Total Records:" USERS_DAT_Length ' Returns and Prints Total
                                           ' Records in USERS.DAT

    UN = USERS_DAT_GetUN  ' Returns a 32-bit pointer to the User's Name
                          ' string

    PRINT UN              ' Prints the User's Name

    USERS_DAT_PutUN "New User Name"  ' Let's put a new User Name in for
                                     ' this User's Record

    PRINT USERS_DAT_GetUN ' Returns a 32-bit pointer to the User's Name
                          ' string with the new User's Name.

  USERS_DAT_Close         ' Closes USERS.DAT file

 ' In the example below, we can open, read, close the USERS.DAT file, also
 ' get and print the User's Alais Name from record #1 all in a single
 ' line of code. :)

   PRINT    ' Print a blank line
   USERS_DAT_OpenReadClose 1 : PRINT USERS_DAT_GetAN

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for USERS.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0 ' Change the '0' to '1' to run this example

 USERS_DAT_OpenReadClose 1    ' Will Open and Read in USERS.DAT
                             ' record #1 and Close the file

  ' Grab File Area's data from memory using the a 32-bit pointer

    PRINT USERS_DAT_GetUN     ' Name
    PRINT USERS_DAT_GetAN     ' Alias Name
    PRINT USERS_DAT_GetUP     ' Password
    PRINT USERS_DAT_GetSA1    ' Street Address 1
    PRINT USERS_DAT_GetSA2    ' Street Address 2
    PRINT USERS_DAT_GetCity   ' City
    PRINT USERS_DAT_GetUS     ' State
    PRINT USERS_DAT_GetUC     ' Country
    PRINT USERS_DAT_GetUZ     ' Zipcode
    PRINT USERS_DAT_GetUPN    ' Phone Number
    PRINT USERS_DAT_GetUBD    ' Birth Date
    PRINT USERS_DAT_GetDOFC   ' Date Of First Call
    PRINT USERS_DAT_GetDOLFC  ' Date Of Last File Check
    PRINT USERS_DAT_GetSED    ' Subscription Expiration Date
    PRINT USERS_DAT_GetDATOLC ' Date And Time Of Last Call
    PRINT USERS_DAT_GetEM     ' Expert Mode
                               ' 0 = Novice mode.
                               ' 1 = Expert mode.
                               ' 2 = Super expert mode.
    PRINT USERS_DAT_GetSL     ' Security Level
    PRINT USERS_DAT_GetNOC    ' Number Of Calls
    PRINT USERS_DAT_GetTLFT   ' Time Left For Today (Minutes)
    PRINT "LMC: ";USERS_DAT_GetLMC    ' Last Message Conference
    PRINT "LFA: ";USERS_DAT_GetLFA    ' Last File Area
    PRINT USERS_DAT_GetDP     ' Default Protocol
                               ' 0        = No default.
                               ' 1 to 255 = ASCII code for the protocol's
                               ' first character.

       PRINT
       PRINT "Hit Any Key To Continue"
       DO: LOOP WHILE INKEY$ = ""
       CLS

    PRINT USERS_DAT_GetNOCT   ' Number Of Calls Today
    PRINT USERS_DAT_GetDE     ' Default Editor
                               ' 0 = No default editor.
                               ' 1 = Line editor.
                               ' 2 = Full screen editor.
    PRINT USERS_DAT_GetICS    ' Initial Chat Status
							   ' 0 = Available for chat.
							   ' 1 = Not available for chat.
    PRINT USERS_DAT_GetNOFDT  ' Number Of Files Downloaded Today
    PRINT USERS_DAT_GetAUIQ   ' Archive Used In QWK
							   ' 0 = ZIP
							   ' 1 = LZH
							   ' 2 = ARJ
							   ' 3 = ARC
							   ' 4 = PAK
    PRINT USERS_DAT_GetNOFU   ' Number Of Files Uploaded
    PRINT USERS_DAT_GetNOFD   ' Number Of Files Downloaded
    PRINT USERS_DAT_GetNOKBU  ' Number Of KBytes Uploaded
    PRINT USERS_DAT_GetNOKBD  ' Number Of KBytes Downloaded
    PRINT USERS_DAT_GetNOMP   ' Number Of Messages Posted
    PRINT USERS_DAT_GetNOBDT  ' Number Of Bytes Downloaded Today
    PRINT USERS_DAT_GetNWN    ' Gets all of the Network Names for this
                              ' User if he/she has QWK Network Node Status

 ' ** These are Bit Fields converted to integers below **

    PRINT USERS_DAT_GetNWF(1) ' Gets Network Flag for Record #(nw)
                             ' (nw) = 1 to 16
   ' USERS_DAT_PutNWF(nw, n)  ' Changes Network Flag for Record #(nw, n)
                               ' nw = 1 to 16
                               ' n  = either 0 or 1
							   ' 0 = User does not have netstatus for the
                               '     network 'nw'.
    						   ' 1 = The user has netstatus for the
                               '     network 'nw'.
    PRINT USERS_DAT_GetLOF    ' Locked Out Flag
							   ' 0 = The user is not locked out.
							   ' 1 = The user is locked out.
    PRINT USERS_DAT_GetMFDF   ' Marked For Deletion Flag
							   ' 0 = The user is not marked for deletion.
							   ' 1 = The user is marked for deletion.
    PRINT USERS_DAT_GetILIQF  ' Include Logon1 In QWK Flag
							   ' 0 = Do not include LOGON1 in a QWK packet.
							   ' 1 = Include LOGON1 in a QWK packet.
    PRINT USERS_DAT_GetIGIQF  ' Include Goodbye In QWK Flag
							   ' 0 = Do not include GOODBYE in a QWK packet.
							   ' 1 = Include GOODBYE in a QWK packet.
    PRINT USERS_DAT_GetIBIQF  ' Include Bulletins in QWK Flag
						       ' 0 = Do not include Bulletins in a QWK packet.
  							   ' 1 = Include bulletins in a QWK packet.
    PRINT USERS_DAT_GetINFIQF ' Include New Files In QWK Flag
							   ' 0 = Do not include a new files list in a QWK
                               '     packet.
							   ' 1 = Include a new files list in a QWK packet.
    PRINT USERS_DAT_GetINLIQF ' Include News Letter In QWK Flag
							   ' 0 = Do not include a newsletter in a QWK
                               '     packet.
							   ' 1 = Include a newsletter in a QWK packet.
    PRINT USERS_DAT_GetCWMF   ' Check Waiting Messages Flag
							   ' 0 = Check for waiting messages at logon.
							   ' 1 = Do not check for waiting messages at
                               '     logon.
    PRINT USERS_DAT_GetGAUF   ' Goodbye After Upload Flag
							   ' 0 = Do not log off after a REP packet
                               '     upload.
							   ' 1 = Log the user off after a REP packet
                               '     upload.
    PRINT USERS_DAT_GetAFIQF  ' Attach Files In QWK Flag
							   ' 0 = Do not include attached files in a QWK
                               '     packet.
							   ' 1 = Include attached files in a QWK packet.

$ENDIF

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE for USERS.DAT Non-Pointer Calls **
'----------------------------------------------------------------------------
'
' This sample section will show how to use the USERDAT.PBU Unit in it's basic
' form. This will require more string operations than the pointer section
' since you will be grabing just basic data straight from the USERS.DAT
' file. Trimming, and removing and adding null terminators will have to be
' performed in this manner. If is very important when writting any data
' back to the USERS.DAT file in this manner, you add the null terminator
' CHR$(0) to the end of all normal predefined strings based on the USERS.DAT
' type structure located in the USERDAT.INC file. Follow the example below.
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$IF 0  ' Change the '0' to '1' to run this example

 USERS_DAT_OpenRead 1        ' Open USERS.DAT File, and Read in record #1


  PRINT USERSDAT.UserName   ' Prints User's Name with padded spaces from
                            ' USERS.DAT file
  PRINT LEN(USERSDAT.UserName) ' Prints Len of User's Name
                               ' This shows a string length of 61 characters,
                               ' which is 60 charcaters that you may use for
                               ' data, and the last character, 61, contains the
                               ' null terminator, CHR$(0)
 USERS_DAT_Close               ' Close USERS.DAT File.


  ' Now, lets trim off the excess spaces and the null terminator.
  ' First I will create a new variable to hold the new data.

  DIM Temp AS STRING         ' Dimention a new variable

 USERS_DAT_Open              ' Open USERS.DAT File
 USERS_DAT_Read 1            ' Read in Record #1

   ' This line below preforms the trim operation
  Temp = RTRIM$(USERSDAT.UserName, ANY " " + CHR$(0))

  PRINT Temp                 ' Prints the new string without the extra spaces
                             ' and CHR$(0)
  PRINT LEN(Temp)            ' Prints the True Length of the User's Name

 USERS_DAT_Close             ' Closes USERS.DAT File

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END                          ' Ends the Program
