' 
' Program Title: Sample Program for TriBBS's NETWORK.DAT API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample.bas file, you will see servals different examples on how
' to use the Pointer "netwk" to make calls to the TriBBS API NETWORK.PBU Unit.
' Also there are some examples showing how to use the NETWORK.PBU Unit
' without using pointers.  To use any of the current examples, go to the
' section and you will see a "$IF 0" statment at the head of the example, all
' you need to do to make that section of code run is change the '0' to any
' non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerfull! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' All String Pointer calls will grab the data from memory, and strip any
' spaces and null terminator characters from the end of the string which
' will allow you to print with better screen output control.
'
' When writting back to memory with a pointer string, this NETWORK API will
' set the length back to proper size and add the null terminator, CHR$(0)
' to the end of the string. This again, will save time in writting back
' to the original record NETWORK.DAT.
'
' For non-pointer calls, you will have to adjust the string yourself for
' proper printing to the screen. Also, when writting back to the NETWORK.DAT
' file, you must add a num terminator to the end of the string. More on this
' in the Non-Pointer example.
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "NETWORK.EXE"   ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL					' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
			                ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' NETWORK.DAT API which are located in the NETWORK.INC file.

'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for NETWORK.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example

DIM NWN AS STRING   ' Dimention Local Varible to hold the Network Name for
                    ' this example

 NETWORK_DAT_Open                 ' Opens NETWORK.DAT

  IF NETWORK_DAT_Length <> 0 THEN ' Check and make sure record doesn't have
                                  ' 0 bytes

    NETWORK_DAT_Read 1            ' Reads in a record

    PRINT "Total Records:" NETWORK_DAT_Length ' Returns and Prints Total
                                              ' Records in NETWORK.DAT

    NWN = NETWORK_DAT_GetNWN     ' Returns a 32-bit pointer to the Network
                                 ' Name string

    PRINT NWN                    ' Prints the File Area Name

    NETWORK_DAT_PutNWN "New Network Name" ' Let's put a new Network Name in
                                          ' for this this Network

    PRINT NETWORK_DAT_GetNWN     ' Returns a 32-bit pointer to the Network
                                 ' Name string with the new Network Name.

  END IF                         ' End the check network file for records
                                 ' condition

 NETWORK_DAT_Close               ' Closes Network.dat file

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for NETWORK.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example

'Dimention some local variables for this example
DIM NWN                   AS STRING      ' Local Varible to hold the Network
                                         ' Name
DIM NetLength             AS INTEGER     ' Local Varible to hold Record
                                         ' length for Network.dat
DIM x                     AS INTEGER     ' Local Varible for FOR/NEXT Counter


 NETWORK_DAT_Open                 ' Opens NETWORK.DAT

  IF NETWORK_DAT_Length <> 0 THEN ' Check and make sure record doesn't have
                                  ' 0 bytes

   NetLength = NETWORK_DAT_Length ' Local varible to hold record for
                                  ' Network.dat

   FOR x = 1 TO NetLength         ' Set x for a FOR/NEXT Counter

    NETWORK_DAT_Read x            ' Reads in a record

    PRINT NETWORK_DAT_GetNWN      ' Returns a 32-bit pointer to the Network
                                  ' Name string with the new Network Name.

   NEXT x                         ' Add 1 to x

  END IF                          ' End the check network file for records
                                  ' condition

 NETWORK_DAT_Close                ' Closes Network.dat file

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 END                              ' Ends the Program