' 
' Program Title: Sample Program for TriBBS's MNNNN.HDR API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample.bas file, you will see servals different examples on how
' to use the Pointer "mch" to make calls to the TriBBS API MNNNNH.PBU Unit.
' Also there are some examples showing how to use the MNNNNH.PBU Unit
' without using pointers.  To use any of the current examples, go to the
' section and you will see a "$IF 0" statment at the head of the example, all
' you need to do to make that section of code run is change the '0' to any
' non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerfull! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' All String Pointer calls will grab the data from memory, and strip any
' spaces and null terminator characters from the end of the string which
' will allow you to print with better screen output control.
'
' When writting back to memory with a pointer string, this MNNNNH API will
' set the length back to proper size and add the null terminator, CHR$(0)
' to the end of the string. This again, will save time in writting back
' to the original record MNNNN.HDR.
'
' For non-pointer calls, you will have to adjust the string yourself for
' proper printing to the screen. Also, when writting back to the MNNNN.HDR
' file, you must add a num terminator to the end of the string. More on this
' in the Non-Pointer example.
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "MNNNN.EXE"   ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL					' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
			                ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' MNNNN.HDR API which are located in the MNNNNHDR.INC file.
'
'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for MNNNN.HDR Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example

' Dimentions some local variables below to hold values for this example
'
DIM c   AS INTEGER  ' For Message Conference Number
DIM mn  AS LONG     ' For Message Number in 'c'
DIM FU  AS STRING   ' For From User Name

c = 1   ' Message Conference Number
mn = 1  ' Message Record Number in 'c'

IF MNNNN_HDR_OpenRead(c, mn) <> 0 THEN ' Will Open and Read in MNNNN.HDR
                                       ' record if it returns a file exist
                                       ' value of 1. 'NNNN' can be 1 to 9999
                                       '  0 = MNNNN.HDR does not exist did
                                       '      not open
                                       '  1 = MNNNN.HDR does exist and was
                                       '      opened
 MNNNN_HDR_Open 1

    PRINT "Total Records:" MNNNN_HDR_Length ' Returns and Prints Total
                                            ' Records in MNNNN.HDR for 'c'

    FU = MNNNN_HDR_GetFU     ' Returns a 32-bit pointer to the From User
                             ' Name string

    PRINT FU                 ' Prints the From User name

    MNNNN_HDR_PutFU "Gary Price"  ' Let's put a new From User Name for this
                                  ' this Message

    PRINT MNNNN_HDR_GetFU     ' Returns a 32-bit pointer to the From User
                              ' Name string with the new User Name.

  MNNNN_HDR_Close              ' Closes MNNNN.HDR file

END IF

 ' In the example below, we can Open, Read, & Close the MNNNN.HDR file, also
 ' get and print the To User Name from Conference 1, Message 1 all in a
 ' single line of code. :)

   PRINT    ' Print a blank line
   IF MNNNN_HDR_OpenReadClose(c, mn) <> 0 THEN PRINT MNNNN_HDR_GetTU

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for MNNNN.HDR Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example

' Dimentions some local variables below to hold values for this example
'
DIM c   AS INTEGER  ' For Message Conference Number
DIM mn  AS LONG     ' For Message Number in 'c'

c = 1   ' Message Conference Number
mn = 1  ' Message Record Number in 'c'

 IF MNNNN_HDR_OpenRead(c,mn) <> 0 THEN ' Will Open and Read in MNNNN.HDR
                                       ' record if it returns a file exist
                                       ' value of 1. 'NNNN' can be 1 to 9999
                                       '  0 = MNNNN.HDR does not exist did
                                       '      not open
                                       '  1 = MNNNN.HDR does exist and was
                                       '      opened

  ' Grab File Area's data from memory using the a 32-bit pointer

    PRINT MNNNN_HDR_GetFU       ' From User
    PRINT MNNNN_HDR_GetTU       ' To User
    PRINT MNNNN_HDR_GetMS       ' Message's Subject
    PRINT MNNNN_HDR_GetNOAF     ' Name Of Attached File
    PRINT MNNNN_HDR_GetDAT      ' Date And Time
    PRINT MNNNN_HDR_GetNMFZ     ' Net Mail From Zone
    PRINT MNNNN_HDR_GetNMFNet   ' Net Mail From Net
    PRINT MNNNN_HDR_GetNMFNode  ' Net Mail From Node
    PRINT MNNNN_HDR_GetNMFP     ' Net Mail From Point
    PRINT MNNNN_HDR_GetNMTZ     ' Net Mail To Zone
    PRINT MNNNN_HDR_GetNMTNet   ' Net Mail To Net
    PRINT MNNNN_HDR_GetNMTNode  ' Net Mail To Node
    PRINT MNNNN_HDR_GetNMTP     ' Net Mail To Point
    PRINT MNNNN_HDR_GetOITF     ' Offset Into Text File
    PRINT MNNNN_HDR_GetML       ' Message Length
    PRINT MNNNN_HDR_GetMN       ' Message Number
    PRINT MNNNN_HDR_GetNOMTRT   ' Number of Messages This Replies To
    PRINT MNNNN_HDR_GetFH       ' From Hash
    PRINT MNNNN_HDR_GetTH       ' To Hash

    PRINT
    Print "Press Any Key to Continue"
    DO WHILE INKEY$ = "" :LOOP
    CLS

  ' ** These are Bit Fields converted to integers below **

    PRINT "Bit Fields"
    PRINT

    PRINT MNNNN_HDR_GetEMF       ' Echo Message Flag
                                   ' 0 = Do not echo the message
                                   ' 1 = Echo the message
    PRINT MNNNN_HDR_GetTMF       ' Threaded Message Flag
                                   ' 0 = The message is not the start of a
                                   '     message thread.
                                   ' 1 = The message is the start of a
                                   '      message thread.
    PRINT MNNNN_HDR_GetPriMF     ' Private Message Flag
                                   ' 0 = The message is a public message
                                   ' 1 = The message is a private message
    PRINT MNNNN_HDR_GetDMF       ' Deleted Message Flag
                                   ' 0 = The message is not marked for
                                   '     deletion
                                   ' 1 = The message is marked for deletion
    PRINT MNNNN_HDR_GetRMF       ' Received Message Flag
                                   ' 0 = The message hasn't been received
                                   ' 1 = The message has been received
    PRINT MNNNN_HDR_GetPerMF     ' Permanent Message Flag
                                   ' 0 = The message is not a permanent
                                   '     message
                                   ' 1 = The message is a permanent message
    PRINT MNNNN_HDR_GetTTEMF     ' TriToss Echo Message Flag
                                   ' 0 = The message has not been echoed by
                                   '     TriToss
                                   ' 1 = The message has been echoed by
                                   '     TriToss
    PRINT MNNNN_HDR_GetCMF       ' Crash Mail Flag
                                   ' 0 = The message is not a crashmail
                                   '     message
                                   ' 1 = The message is a crashmail message
END IF

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END                          ' Ends the Program
