' 
' Program Title: Sample Program for TriBBS's FAREA.DAT API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample.bas file, you will see servals different examples on how
' to use the Pointer "fa" to make calls to the TriBBS API FAREA.PBU Unit.
' Also there are some examples showing how to use the FAREA.PBU Unit
' without using pointers.  To use any of the current examples, go to the
' section and you will see a "$IF 0" statment at the head of the example, all
' you need to do to make that section of code run is change the '0' to any
' non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerfull! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' All String Pointer calls will grab the data from memory, and strip any
' spaces and null terminator characters from the end of the string which
' will allow you to print with better screen output control.
'
' When writting back to memory with a pointer string, this FAREA API will
' set the length back to proper size and add the null terminator, CHR$(0)
' to the end of the string. This again, will save time in writting back
' to the original record FAREA.DAT.
'
' For non-pointer calls, you will have to adjust the string yourself for
' proper printing to the screen. Also, when writting back to the FAREA.DAT
' file, you must add a num terminator to the end of the string. More on this
' in the Non-Pointer example.
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "FAREA.EXE"   ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL					' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
			                ' speed and minimum size
'============================================================================


'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"     ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC"  ' ** SET THIS LINE TO YOUR PATH **
'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' FAREA.DAT API which are located in the FAREA.INC file.

'---------------------------------------------------------------------------
'* DECLARE ALL LOCAL AND SHARED VARIABLES USED IN MAIN PROGRAM BETWEEN SUBS *

DIM FAN  AS STRING     ' Local Varible to hold the File Area Name

'---------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for FAREA.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example

  FAREA_DAT_OpenRead 1         ' Will Open and Read in FAREA.DAT
                               ' record #1

    PRINT "Total Records:" FAREA_DAT_Length  ' Returns and Prints Total
                                             ' Records in FAREA.DAT

    FAN = FAREA_DAT_GetFAN     ' Returns a 32-bit pointer to the File Area's
                               ' Name string

    PRINT FAN                  ' Prints the File Area Name

    FAREA_DAT_PutFAN "New File Area Name"  ' Let's put a new File Area Name
                                           ' in for this file area

    PRINT FAREA_DAT_GetFAN     ' Returns a 32-bit pointer to the File Area's
                               ' Name string with the new File Area Name.

  FAREA_DAT_Close              ' Closes Farea.dat file

 ' In the example below, we can open, read, close the Farea.dat file, also
 ' get and print the File Area Name from record #(1) all in a single line of
 ' code. :)

   PRINT    ' Print a blank line
   FAREA_DAT_OpenReadClose 1 : PRINT FAREA_DAT_GetFAN

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for FAREA.DAT Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example


 FAREA_DAT_OpenReadClose 1     ' Will Open and Read in FAREA.DAT
                               ' record #1 and close the file

  ' Grab File Area's data from memory using the a 32-bit pointer

    PRINT FAREA_DAT_GetFAN     ' File Area Name
    PRINT FAREA_DAT_GetFAP     ' File Area Path
    PRINT FAREA_DAT_GetFAUP    ' File Area Upload Path
    PRINT FAREA_DAT_GetFAFL    ' File Area Files List
    PRINT FAREA_DAT_GetFAUL    ' File Area Upload Files Llist
    PRINT FAREA_DAT_GetFAIF    ' File Area Index file
    PRINT FAREA_DAT_GetSL      ' File Area Security Level (0 to 9999)
    PRINT FAREA_DAT_GetVSL     ' File Area View Security Level (0 to 9999)
    PRINT FAREA_DAT_GetODN     ' File Offline CDROM Disk Number (0 to 9999)
    PRINT FAREA_DAT_GetFST     ' File Area Sort Type (0=By Date, 1=By Name)

     PRINT FAREA_DAT_GetAFAP(1) ' Additional File Area Paths
                                ' (1) represents the first add. file area
                                ' path, selection is (1 to 10)

     FAREA_DAT_PutAFAP 1, "C:\Newfiles" ' Change the Additional Farea Area
                                        ' Path Name number (1) to something
     PRINT FAREA_DAT_GetAFAP(1)         ' Grab the Additional Farea Area Path
                                        ' and print it for number (1)

   ' ** These are Bit Fields converted to integers below **

    PRINT						' Prints a blank line
    PRINT FAREA_DAT_GetPFAF     ' Private File Area Flag (0=No,1=Yes)
    PRINT FAREA_DAT_GetCDFAF    ' CDROM File Area Flag (0=No,1=Yes)
    PRINT FAREA_DAT_GetAFAF     ' Alias File Area Flag (0=No,1=Yes)
    PRINT FAREA_DAT_GetOFAF     ' Offline File Area Flag (0=No,1=Yes)
    PRINT FAREA_DAT_GetMIFAF    ' Master Index File Area Flag (0=No,1=Yes)

$ENDIF

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE for FAREA.DAT Non-Pointer Calls **
'----------------------------------------------------------------------------
'
' This sample section will show how to use the FAREA.PBU Unit in it's basic
' form. This will require more string operations than the pointer section
' since you will be grabing just basic data straight from the FAREA.DAT
' file. Trimming, and removing and adding null terminators will have to be
' performed in this manner. If is very important when writting any data
' back to the FAREA.DAT file in this manner, you add the null terminator
' CHR$(0) to the end of all normal predefined strings based on the FAREA.DAT
' type structure located in the FAREA.INC file. Follow the example below.
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

$IF 0  ' Change the '0' to '1' to run this example

 FAREA_DAT_OpenRead 1        ' Open FAREA.DAT File, and Read in record #1


  PRINT FAREA.FareaName      ' Prints File Area Name as is from Farea.dat
  PRINT LEN(FAREA.FareaName) ' Prints Len of File Area Name
                             ' This shows a string length of 41 characters,
                             ' which is 40 charcaters that you may use for
                             ' data, and the last 41 contains the null
                             ' terminator, CHR$(0)
 FAREA_DAT_Close             ' Close FAREA.DAT File.


  ' Now, lets trim off the excess spaces and the null terminator.
  ' First I will create a new variable to hold the new data.

  DIM Temp AS STRING         ' Dimention a new variable

 FAREA_DAT_Open              ' Open FAREA.DAT File
 FAREA_DAT_Read 1            ' Read in Record #1

  Temp = RTRIM$(FAREA.FareaName, ANY " " + CHR$(0)) ' This preforms the trim
           										    ' operation
  PRINT Temp                 ' Prints the new string without the extra spaces
                             ' and CHR$(0)
  PRINT LEN(Temp)            ' Prints the True Length of the File Area Name

 FAREA_DAT_Close             ' Closes FAREA.DAT File

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END                          ' Ends the Program