' 
' Program Title: Sample Program for TriBBS's DOORS.TMP API UNIT
'     Copyright: 1997-98 by Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'         Notes:
' 
'       History:
' 
'
' In this sample file, you will see servals different examples on how
' to use the Pointer "dt" to make calls to the TriBBS API DOORTMP.PBU Unit.
' However, will not need to concern yourself with actually using of "dt" as
' this is all handled in the DOORTMP.PBU Unit.
'
' To use any of the current examples, go to the section and you will see a
' "$IF 0" statment at the head of the example, all you need to do to make
' that section of code run is change the '0' to any non-zero number.
'
' A pointer is a varible that holds 32-bit (4 byte) address of data located
' elsewhere in memory. It is called a pointer because it literally points
' to data. The data at which it points is known as the target.
'
' Pointers are Powerfull! The address is defined at run-time, so any target
' in memory can be referenced by your program just as if it were a standard
' PowerBASIC varible. This type of indirection is much faster and more
' efficient than PEEKing and POKEing at the target data.
'
' 

$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "DOORTMP.EXE"  ' compile to an EXE

$DEBUG MAP OFF              ' turn off map file generation
$DEBUG PBDEBUG OFF          ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR BOUNDS   ON          ' turn on bounds checking for pointer debugging
$ERROR NUMERIC  OFF         ' turn off numeric checking
$ERROR OVERFLOW OFF         ' turn off overflow checking
$ERROR STACK    OFF         ' turn off stack checking

$COM    0                   ' set communications buffer to nothing
$STRING 16                  ' set largest string size at 16k
$STACK  2048                ' let's use a 2k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL					' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
			                ' speed and minimum size
'============================================================================
'NOTE!: You will have to create a DOORS.TMP file by logging into TriBBS and
'       going into a door, then shell out and copy the DOORS.TMP file to a
'       Dummy TriBBS directory like "C:\TRI\NWORK and then set your TriBBS
'       Main Node below to show "C:\TRI" directory.
'
============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"     ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC"  ' ** SET THIS LINE TO YOUR PATH **
'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **
'
' Use this section for any declarations needed to be made other than the
' DOORS.TMP API which are located in the DOORTMP.INC file.

'---------------------------------------------------------------------------
' ** DIMENTION ALL VARIBLES, ARRAYS, TYPE STRUCTURES, & POINTERS **

DIM n AS INTEGER     ' Local Variable

'---------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **
' * Special Note: If you setup a program to work with multinodes, then you
' * will have to create a config file to read in for your program and have
' * the sysop enter the node from which they are calling and running the
' * program from.
' *
' * Example: TBNode1sMainDirectory = "C:\TRIBBS2" for Node 2.

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================

CLS 	' Clears screen prepares it for printing

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 1 for DOORS.TMP Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example

 IF DOORS_TMP_OpenRead <> 0 THEN ' Will Open and Read in DOORS.TMP record if
                                 ' it returns a file exist value of 1.
                                 '  0 = Doors.tmp does not exist did not open
                                 '  1 = Doors.tmp does exist and was opened

   n = DOORS_TMP_GetTLAL        ' Gets Time Left At Logon
   PRINT n                      ' Prints the Time Left At Logon

   DOORS_TMP_PutTLAL 10         ' Put the value of '10' in the Time Left At
                                ' Logon

   PRINT DOORS_TMP_GetTLAL      ' Gets and Prints Time Left At Logon in one
                                ' line of code

   DOORS_TMP_Close              ' Closes Doors.tmp file

 END IF                         ' Ends IF/END IF Statement

 ' In the example below, we can open, read, close the doors.tmp file, also
 ' get and print the Time Left At Logon all in a single line of code. :)

   PRINT    ' Print a blank line
   IF DOORS_TMP_OpenReadClose <> 0 THEN PRINT DOORS_TMP_GetTLAL

$ENDIF
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'                ** EXAMPLE 2 for DOORS.TMP Pointer Calls **
'----------------------------------------------------------------------------
$IF 0  ' Change the '0' to '1' to run this example


 IF DOORS_TMP_OpenReadClose <> 0 THEN ' Will Open and Read in DOORS.TMP
                                      ' record if it returns a file exist
                                      ' value of 1 and then Closes the file.
                                        '  0 = Doors.tmp does not exist did not open
                                        '  1 = Doors.tmp does exist and was opened


 'Grab Doors.tmp data from memory using the a 32-bit pointer


    PRINT DOORS_TMP_GetTLAL   ' Time Left After Logon
    PRINT DOORS_TMP_GetCFA    ' Current File Area
    PRINT DOORS_TMP_GetCMC    ' Current Message Conference
    PRINT DOORS_TMP_GetFET    ' Front End Time
    PRINT DOORS_TMP_GetWTDWCF ' Where The Door Was Called From
 								' 0 = Called from Doors Menu
                                ' 1 = Newusers.bat
                                ' 2 = SECnnnn.bat
                                ' 3 = Logon.bat
                                ' 4 = Called from Main Menu
                                ' 5 = Called from Files Menu
                                ' 6 = Called from Message Menu
                                ' 7 = Called from Sysop Menu
    PRINT DOORS_TMP_GetLN     ' Language Number
    PRINT DOORS_TMP_GetNOFF   ' Number of Files Flagged
    PRINT DOORS_TMP_GetTIDSys ' Time In Door.Sys
    PRINT DOORS_TMP_GetURN    ' User Record Number
    PRINT DOORS_TMP_GetBR     ' Baud Rate
    PRINT DOORS_TMP_GetFEBR   ' Front End Baud Rate
    PRINT DOORS_TMP_GetTWULO  ' Time When User Logged On

  ' ** These are Bit Fields converted to integers below **

    PRINT DOORS_TMP_GetAF     ' ANSI Flag (0=No,1=Yes)
    PRINT DOORS_TMP_GetFEF    ' Front End Flag
                                ' 0 = TriBBS was not called from Front End
                                ' 1 = TriBBS was called from Front End
    PRINT DOORS_TMP_GetFEHU   ' Front End Hang Up Flag
                                ' 0 = TriBBS will not hang up on
                                '     the caller before returning to
                                '     front end
                                ' 1 = TriBBS will hang up on the
                                '     caller before returning to front end
    PRINT DOORS_TMP_GetUWF    ' User Window Flag
                                ' 0 = The User status window is
                                '     not being displayed
                                ' 1 = The User status window is
                                '     being displayed
    PRINT DOORS_TMP_GetCRF    ' Caller Requested Flag
                                ' 0 = The Caller hasn't requested a chat
                                ' 1 = The Caller has requested a chat
    PRINT DOORS_TMP_GetEPF    ' Event Pending Flag
                                ' 0 = An Event is not pending
                                ' 1 = An Even is pending
    PRINT DOORS_TMP_GetGFD    ' Goodbye From Door Flag
                                ' 0 = The caller hasn't selected
                                '     "goodbye" from a door
                                ' 1 = The caller has selected
                                '     "goodbye" from a door
    PRINT DOORS_TMP_GetFBDAC  ' Force Board Down After Call Flag
                                ' 0 = Do not exit TriBBS when
                                '     caller is done
                                ' 1 = Exit TriBBS when caller is
                                '     done
    PRINT DOORS_TMP_GetRIP    ' RIPscrip Flag
                                ' 0 = The caller isn't using
                                '     RIPscrip emualtion
                                ' 1 = The caller is using
                                '     RIPscrip emulation
    PRINT DOORS_TMP_GetDSF    ' DOOR.SYS Flag
                                ' 0 = Do not read DOOR.SYS back
                                '     in after returning from Door
                                ' 1 = Read DOOR.SYS back in after
                                '     returning from Door
    PRINT DOORS_TMP_GetECC    ' Error Correction Connection Flag
								' 0 = There is a non-error
                                '     correction connection
                                ' 1 = There is a error correction
                                '     connection

 END IF                         ' Ends IF/END IF Statement

$ENDIF

'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

END                             ' Ends the Program