' 
' Program Title: Demo Program to Show How to add User Records to TriBBS
'     Copyright: 1997-98 By Freejack's Software
'        Author: Gary Price
' Last Modified: 02/21/98
' 
'   Description: Program template for PowerBASIC programmers to control
'                exactly how PowerBASIC generates your executables.
' 
'         Notes:
' 
'       History:
' 
$CPU 80386				    ' Requires a 386 system or faster

$OPTIMIZE SPEED             ' make fastest possible executable

'$COMPILE EXE "DEMO2.EXE"   ' compile to an EXE

$DEBUG MAP      OFF         ' turn off map file generation
$DEBUG PBDEBUG  OFF         ' don't include pbdebug support in our executable

$LIB COM        OFF         ' turn off PowerBASIC's communications library.
$LIB CGA        OFF         ' turn off PowerBASIC's CGA graphics library.
$LIB EGA        OFF         ' turn off PowerBASIC's EGA graphics library.
$LIB VGA        OFF         ' turn off PowerBASIC's VGA graphics library.
$LIB LPT        OFF         ' turn off PowerBASIC's printer support library.
$LIB IPRINT     OFF         ' turn off PowerBASIC's interpreted print library.
$LIB FULLFLOAT  OFF         ' turn off PowerBASIC's floating point support.

$ERROR ALL                  ' Set for All Error checks

$COM    0                   ' set communications buffer to nothing
$STRING 32                  ' set largest string size at 32k
$STACK  8192                ' let's use a 8k stack
$SOUND  1                   ' smallest music buffer possible

$DIM ALL					' forces all Varibles and Arrays to be
                            ' pre-dementioned before use.

$DYNAMIC                    ' all arrays will be dynamic by default

$OPTION CNTLBREAK OFF       ' don't allow Ctrl-Break to exit program

DEFINT A-Z                  ' default all variables to integers for maximum
			                ' speed and minimum size
'============================================================================

'============================================================================
'                          DECLARATIONS SECTION
'============================================================================
' ** THIS SECTION IS FOR LINKS AND INCLUDES STATMENTS **

$LINK "G:\PB35\TBAPI10\PBAPI10.PBL"    ' ** SET THIS LINE TO YOUR PATH **
$INCLUDE "G:\PB35\TBAPI10\PBAPI10.INC" ' ** SET THIS LINE TO YOUR PATH **

'---------------------------------------------------------------------------
' ** DECLARE SUB's BELOW THAT WILL BE USED IN THIS PROGRAM **

'---------------------------------------------------------------------------
'* DECLARE ALL LOCAL AND SHARED VARIABLES USED IN MAIN PROGRAM BETWEEN SUBS *
'
'----------------------------------------------------------------------------
' ** SET THIS LINE BELOW TO YOUR TRIBBS MAIN NODE's DIRECTORY **

TBNode1sMainDirectory = "E:\TRIBBS"
'============================================================================

CLS ' Clears the Screen

'============================================================================
'                         ** MAIN PROGRAM BODY **
'============================================================================
ON ERROR GOTO DONE            ' Set Error Trap to Exit on any Errors

DIM CharAllow       AS STRING
DIM PromptLine      AS STRING
DIM RecordNum       AS WORD
DIM NEWUSER         AS STRING
DIM ENTERNAME       AS STRING
DIM NameCounter     AS INTEGER
DIM PASSWORD        AS STRING
DIM TempPass1       AS STRING
DIM TempPass2       AS STRING
DIM PasswordCounter AS INTEGER
DIM ALIASNAME       AS STRING
DIM STREETADDR1     AS STRING
DIM STREETADDR2     AS STRING
DIM CITY            AS STRING
DIM STATE           AS STRING
DIM ZIPCODE         AS STRING
DIM COUNTRY         AS STRING
DIM PHONENUMBER     AS STRING
DIM BIRTHDAY        AS STRING
DIM PROTOCOL        AS INTEGER
DIM EDITOR          AS INTEGER

'----------------------------------------------------------------------------

CharAllow = "abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" + _
            "~`'!@#$%^&*()_=+\|{}[],<>./?;:"

NameCounter = 1
PasswordCounter = 1

CLS

REDONAME:
   ENTERNAME = ""
   COLOR 15, 0
   PromptLine = "Enter your FIRST and LAST name: "
   ENTERNAME = LineInput("", CharAllow, PromptLine, 25, 47)
   ENTERNAME = InitialCaps(TrimString(ENTERNAME))

     IF ENTERNAME = "" THEN
       IF NameCounter => 5 THEN GOTO DONE
       INCR NameCounter
       GOTO REDONAME
     END IF

  COLOR 11, 0: PRINT "Searching user records for " + ENTERNAME, _
  : COLOR 15, 0: PRINT

      USERS_IDX_Open
    IF USERS_IDX_Search(ENTERNAME) = 0 THEN
      USERS_IDX_Close
         ALIAS_IDX_Open
       IF ALIAS_IDX_Search(ENTERNAME) = 0 THEN
         ALIAS_IDX_Close
       ELSE
         RecordNum = ALIAS_IDX_GetRN
         ALIAS_IDX_Close
         GOTO READUSERSRECORDS
       END IF
    ELSE
       RecordNum = USERS_IDX_GetRN
       USERS_IDX_Close
       GOTO READUSERSRECORDS
    END IF

        COLOR 15, 0: PRINT "<G>oodye, <R>eenter, or <N>ew User? "; _
        : LOCATE,,1

           NEWUSER = ""

           DO WHILE NEWUSER = ""
             NEWUSER = INKEY$
              SELECT CASE ASCII(UCASE$(NEWUSER))
                 CASE 71  ' For "G"
                   GOTO DONE
                 CASE 82  ' For "R"
                   PRINT:PRINT
                   GOTO REDONAME
                 CASE 78  ' For "N"
                   PRINT:PRINT
                   GOTO REDOPASSWORD
                 CASE ELSE
                   NEWUSER = ""
              END SELECT
           LOOP

'----------------------------------------------------------------------------
REDOPASSWORD:
   TempPass1 = ""
   TempPass2 = ""
   PASSWORD = ""
   COLOR 15, 0
   PromptLine = "Please select a password (1 to 15 chars.): "
   TempPass1 = LineInput("*", CharAllow, PromptLine, 25, 15)
   TempPass1 = InitialCaps(TrimString(TempPass1))

     IF TempPass1 = "" THEN
       IF PasswordCounter => 5 THEN GOTO DONE
       INCR PasswordCounter
       GOTO REDOPASSWORD
     END IF

   PromptLine = "Please reenter password for verification: "
   TempPass2 = LineInput("*", CharAllow, PromptLine, 25, 15)
   TempPass2 = InitialCaps(TrimString(TempPass2))

     IF TempPass1 = TempPass2 THEN
       PASSWORD = TempPass2
       PRINT
     ELSE
       COLOR 12, 0: PRINT "Sorry the passwords do not match!"
       PasswordCounter = 1
       COLOR 15, 0: PRINT
       GOTO REDOPASSWORD
     END IF

'----------------------------------------------------------------------------
REDOALIASNAME:
   COLOR 15, 0
   ALIASNAME = ""
   PromptLine = "Please enter an Alias Name: "
   ALIASNAME = LineInput("", CharAllow, PromptLine, 25, 50)
   ALIASNAME = InitialCaps(TrimString(ALIASNAME))

  IF ALIASNAME = "" THEN ALIASNAME = ENTERNAME

  COLOR 11, 0: PRINT "Searching for " + ALIASNAME, _
  : COLOR 15, 0: PRINT

      ALIAS_IDX_Open
    IF ALIAS_IDX_Search(ALIASNAME) <> 0 THEN
      ALIAS_IDX_Close
       COLOR 12, 0: PRINT ALIASNAME + " is already being used!"
        PRINT
        GOTO REDOALIASNAME
    ELSE
      ALIAS_IDX_Close
         COLOR 15, 0
         IF YesNo("Is " + ALIASNAME + " correct (Y/n)?", 25, 1) = 1 THEN
           PRINT:PRINT
         ELSE
           PRINT:PRINT
           GOTO REDOALIASNAME
         END IF
    END IF

'----------------------------------------------------------------------------
REDOSADDR1:
   COLOR 15, 0
   STREETADDR1 = ""
   PromptLine = "Enter your street address (line 1): "
   STREETADDR1 = LineInput("", CharAllow, PromptLine, 25, 40)
   STREETADDR1 = InitialCaps(TrimString(STREETADDR1))

      IF STREETADDR1 = "" THEN GOTO REDOSADDR1

         COLOR 15, 0
         IF YesNo("Is " + STREETADDR1 + " correct (Y/n)?", 25, 1) = 1 THEN
           PRINT:PRINT
         ELSE
           PRINT:PRINT
           GOTO REDOSADDR1
         END IF

'----------------------------------------------------------------------------
REDOSADDR2:
   COLOR 15, 0
   STREETADDR2 = ""
   PromptLine = "Enter your street address (line 2): "
   STREETADDR2 = LineInput("", CharAllow, PromptLine, 25, 40)
   STREETADDR2 = InitialCaps(TrimString(STREETADDR2))

        IF STREETADDR2 = "" THEN
           PRINT:PRINT
           EXIT IF
        ELSE
          COLOR 15, 0
          IF YesNo("Is " + STREETADDR2 + " correct (Y/n)?", 25, 1) = 1 THEN
            PRINT:PRINT
          ELSE
            PRINT:PRINT
            GOTO REDOSADDR2
          END IF
        END IF

'----------------------------------------------------------------------------
REDOCITY:
   COLOR 15, 0
   CITY = ""
   PromptLine = "Enter your City: "
   CITY = LineInput("", CharAllow, PromptLine, 25, 30)
   CITY = InitialCaps(TrimString(CITY))

      IF CITY = "" THEN GOTO REDOCITY

         COLOR 15, 0
         IF YesNo("Is " + CITY + " correct (Y/n)?", 25, 1) = 1 THEN
           PRINT:PRINT
         ELSE
           PRINT:PRINT
           GOTO REDOCITY
         END IF

'----------------------------------------------------------------------------
REDOSTATE:
   COLOR 15, 0
   STATE = ""
   PromptLine = "Enter your State: "
   STATE = LineInput("", CharAllow, PromptLine, 25, 30)
   STATE = InitialCaps(TrimString(STATE))

        IF STATE = "" THEN
          PRINT:PRINT
          EXIT IF
        ELSE
          COLOR 15, 0
          IF YesNo("Is " + STATE + " correct (Y/n)?", 25, 1) = 1 THEN
            PRINT:PRINT
          ELSE
            PRINT:PRINT
            GOTO REDOSTATE
          END IF
        END IF

'----------------------------------------------------------------------------
REDOZIPCODE:
   COLOR 15, 0
   ZIPCODE = ""
   PromptLine = "Enter your Zip Code: "
   ZIPCODE = LineInput("", CharAllow, PromptLine, 25, 10)
   ZIPCODE = InitialCaps(TrimString(ZIPCODE))

        IF ZIPCODE = "" THEN
           PRINT:PRINT
           EXIT IF
        ELSE
          COLOR 15, 0
          IF YesNo("Is " + ZIPCODE + " correct (Y/n)?", 25, 1) = 1 THEN
            PRINT:PRINT
          ELSE
            PRINT:PRINT
            GOTO REDOZIPCODE
          END IF
        END IF

'----------------------------------------------------------------------------
REDOCOUNTRY:
   COLOR 15, 0
   COUNTRY = ""
   PromptLine = "Enter your Country (ENTER for USA): "
   COUNTRY = LineInput("", CharAllow, PromptLine, 25, 30)
   COUNTRY = InitialCaps(TrimString(COUNTRY))

        IF COUNTRY = "" THEN COUNTRY = "Usa"

         COLOR 15, 0
         IF YesNo("Is " + COUNTRY + " correct (Y/n)?", 25, 1) = 1 THEN
           PRINT:PRINT
         ELSE
           PRINT:PRINT
           GOTO REDOCOUNTRY
         END IF

'----------------------------------------------------------------------------
REDOPHONENUMBER:
   COLOR 15, 0
   PHONENUMBER = ""
   PromptLine = "Enter your Phone Number ###-###-####: "
   PHONENUMBER = PhoneNumberInput(PromptLine, 25)
   PHONENUMBER = InitialCaps(TrimString(PHONENUMBER))

      IF PHONENUMBER = "" THEN GOTO REDOPHONENUMBER

         COLOR 15, 0
         IF YesNo("Is " + PHONENUMBER + " correct (Y/n)?", 25, 1) = 1 THEN
           PRINT:PRINT
         ELSE
           PRINT:PRINT
           GOTO REDOPHONENUMBER
         END IF

'----------------------------------------------------------------------------
REDOBIRTHDAY:
   COLOR 15, 0
   BIRTHDAY = ""
   PromptLine = "Enter your Date of Birth MM/DD/YY: "
   BIRTHDAY = DateInput(PromptLine, 25)
   BIRTHDAY = InitialCaps(TrimString(BIRTHDAY))

      IF BIRTHDAY = "" THEN GOTO REDOBIRTHDAY

         COLOR 15, 0
         IF YesNo("Is " + BIRTHDAY + " correct (Y/n)?", 25, 1) = 1 THEN
           PRINT:PRINT
         ELSE
           PRINT:PRINT
           GOTO REDOBIRTHDAY
         END IF

'----------------------------------------------------------------------------
REDOPROTOCOL:
   PROTOCOL = 0
   COLOR 11, 0
    PRINT "<A> Ascii"
    PRINT "<X> Xmodem"
    PRINT "<K> Xmodem-1K"
    PRINT "<Y> Ymodem"
    PRINT "<G> Ymodem-G"
    PRINT "<Z> Zmodem"
    PRINT "<N> No Default Protocol"
    COLOR 15, 0: PRINT

    PRINT "Please select a Default Protocol: "; : LOCATE,,1

           NEWUSER = ""

           DO WHILE NEWUSER = ""
             NEWUSER = INKEY$
              SELECT CASE ASCII(UCASE$(NEWUSER))
                 CASE 78
                   PROTOCOL = 0         ' For "N"
                   EXIT DO
                 CASE 65,88,75,89,71,78,90 ' For "A,X,K,Y,G,Z"
                   PROTOCOL = ASCII(UCASE$(NEWUSER))
                   EXIT DO
                 CASE ELSE
                  NEWUSER = ""
              END SELECT
           LOOP

PRINT:PRINT

'----------------------------------------------------------------------------
REDOEDITOR:
   EDITOR = 0
   COLOR 11, 0
    PRINT "<L> Line Editor"
    PRINT "<F> Full Screen Editor"
    PRINT "<N> No Default Editor"
    COLOR 15, 0 : PRINT

    PRINT "Please select a Default Editor: "; : LOCATE,,1

           NEWUSER = ""

           DO WHILE NEWUSER = ""
             NEWUSER = INKEY$
              SELECT CASE ASCII(UCASE$(NEWUSER))
                 CASE 78
                   EDITOR = 0  ' For "N"
                   EXIT DO
                 CASE 76       ' For "L"
                   EDITOR = 1
                   EXIT DO
                 CASE 70       ' For "F"
                   EDITOR = 2
                   EXIT DO
                 CASE ELSE
                  NEWUSER = ""
              END SELECT
           LOOP

PRINT:PRINT

'----------------------------------------------------------------------------
'** Add User to Users.dat file **

COLOR 12, 0: PRINT "Adding you to the system data files.....Please wait....."

DIM NewRecord   AS LONG
DIM Month       AS INTEGER
DIM Day         AS INTEGER
DIM Year        AS INTEGER
DIM CurrentDate AS STRING
DIM Hour        AS INTEGER
DIM Minute      AS INTEGER
DIM Second      AS INTEGER
DIM CurrentTime AS STRING
DIM DateTime    AS STRING
DIM nw          AS INTEGER

 USERS_DAT_Open
  NewRecord = USERS_DAT_LENGTH + 1          ' Gets last record and adds 1
  USERS_DAT_ClearIt(NewRecord)              ' Creates empty new record
    USERS_DAT_PutUN(ENTERNAME)              ' Name
    USERS_DAT_PutAN(ALIASNAME)              ' Alias Name
    USERS_DAT_PutUP(PASSWORD)               ' Password
    USERS_DAT_PutSA1(STREETADDR1)           ' Street Address 1
    USERS_DAT_PutSA2(STREETADDR2)           ' Street Address 2
    USERS_DAT_PutCity(CITY)                 ' City
    USERS_DAT_PutUS(STATE)                  ' State
    USERS_DAT_PutUC(COUNTRY)                ' Country
    USERS_DAT_PutUZ(ZIPCODE)                ' Zipcode
    USERS_DAT_PutUPN(PHONENUMBER)           ' Phone Number
    USERS_DAT_PutUBD(BIRTHDAY)              ' Birth Date
     SplitDate DATE$, Month, Day, Year      ' Get system date and split up
                                            ' it's components
     CurrentDate = MakeDate(Month, Day, Year) ' Create new USA date format
                                              ' MM/DD/YY
    USERS_DAT_PutDOFC(CurrentDate)          ' Date Of First Call
    USERS_DAT_PutDOLFC(CurrentDate)         ' Date Of Last File Check
    USERS_DAT_PutSED("")                    ' Subscription Expiration Date
     SplitTime TIME$, Hour, Minute, Second  ' Get system time and split up
                                            ' it's components
     CurrentTime = MakeTime12(Hour, Minute) ' Create new time format HH:MM
     DateTime = CurrentDate + " " + CurrentTime ' Create Date & Time String
    USERS_DAT_PutDATOLC(DateTime)           ' Date And Time Of Last Call
    USERS_DAT_PutEM(0)                      ' Set Expert Mode to Novice Mode
    USERS_DAT_PutSL(10)                     ' Set Security Level to 10
    USERS_DAT_PutNOC(1)                     ' Set Number Of Calls to 1
    USERS_DAT_PutTLFT(30)                   ' Set Time Left For Today,
                                            ' (Minutes), to 30
    USERS_DAT_PutLMC(0)                     ' Set Last Message Conference
                                            ' to 0
    USERS_DAT_PutLFA(0)                     ' Set Last File Area to 0
    USERS_DAT_PutDP(PROTOCOL)               ' Default Protocol
    USERS_DAT_PutNOCT(1)                    ' Set Number Of Calls Today to 1
    USERS_DAT_PutDE(EDITOR)                 ' Default Editor
    USERS_DAT_PutICS(0)                     ' Set Initial Chat Status to
                                            ' default, "available for chat"
    USERS_DAT_PutNOFDT(0)                   ' Set Number Of Files Downloaded
                                            ' Today to default 0
    USERS_DAT_PutAUIQ(0)                    ' Set Archive Used In QWK to
                                            ' default "ZIP"
    USERS_DAT_PutNOFU(0)                    ' Set Number Of Files Uploaded
                                            ' to default 0
    USERS_DAT_PutNOFD(0)                    ' Set Number Of Files Downloaded
                                            ' to default 0
    USERS_DAT_PutNOKBU(0)                   ' Set Number Of KBytes Uploaded
                                            ' to default 0
    USERS_DAT_PutNOKBD(0)                   ' Set Number Of KBytes Downloaded
                                            ' to default 0
    USERS_DAT_PutNOMP(0)                    ' Set Number Of Messages Posted
                                            ' to default 0
    USERS_DAT_PutNOBDT(0)                   ' Set Number Of Bytes Downloaded
                                            ' Today to default 0
     FOR nw = 1 to 16                       ' Set FOR/NEXT for 16 records
       USERS_DAT_PutNWF nw, 0               ' Set Network Flag for Record
     NEXT nw                                ' 'nw' to default 0,
                                            ' "no netstatus"
    USERS_DAT_PutLOF(0)                     ' Set Locked Out Flag to default
                                            ' 0, "Not locked out"
    USERS_DAT_PutMFDF(0)                    ' Set Marked For Deletion Flag to
                                            ' default 0, "not marked for deletion"
    USERS_DAT_PutILIQF(0)                   ' Set Include Logon1 In QWK Flag
                                            ' to default 0
    USERS_DAT_PutIGIQF(0)                   ' Set Include Goodbye In QWK Flag
                                            ' to default 0
    USERS_DAT_PutIBIQF(0)                   ' Set Include Bulletins in QWK
                                            ' Flag to default 0
    USERS_DAT_PutINFIQF(0)                  ' Set Include New Files In QWK
                                            ' Flag to default 0
    USERS_DAT_PutINLIQF(0)                  ' Set Include News Letter In QWK
                                            ' Flag to default 0
    USERS_DAT_PutCWMF(0)                    ' Set Check Waiting Messages Flag
                                            ' to default 0, "Yes"
    USERS_DAT_PutGAUF(0)                    ' Set Goodbye After Upload Flag
                                            ' to default 0
    USERS_DAT_PutAFIQF(0)                   ' Set Attach Files In QWK Flag
                                            ' to default 0
 USERS_DAT_WriteClose(NewRecord)            ' Write new user info and close
                                            ' Users.dat file

'----------------------------------------------------------------------------
'** Add User to Users.idx & Alias.idx files **

 USERS_IDX_Open
  USERS_IDX_Insert ENTERNAME, NewRecord
 USERS_IDX_Close

 ALIAS_IDX_Open
  ALIAS_IDX_Insert ALIASNAME, NewRecord
 ALIAS_IDX_Close

'----------------------------------------------------------------------------
'** Add User to Users.spm & Users.spf files **

 USERS_SPM_Open
  USERS_SPM_ClearIt(NewRecord)
 USERS_SPM_Close

 USERS_SPF_Open
  USERS_SPF_ClearIt(NewRecord)
 USERS_SPF_Close

COLOR 15, 0: PRINT
PRINT "Done!"
PRINT
PRINT "Hit Any Key To End Program"
WHILE NOT INSTAT: WEND

GOTO DONE

'----------------------------------------------------------------------------
READUSERSRECORDS:

DIM RecNum AS STRING
RecNum = LTRIM$(STR$(RecordNum))

 USERS_DAT_OpenReadClose RecordNum ' Will Open and Read in USERS.DAT
                                   ' for RecordNum and Close the file
    CLS
    PRINT "Record #";RecNum    ' Prints current Record Number
    PRINT USERS_DAT_GetUN      ' Name
    PRINT USERS_DAT_GetAN      ' Alias Name
    PRINT USERS_DAT_GetUP      ' Password
    PRINT USERS_DAT_GetSA1     ' Street Address 1
    PRINT USERS_DAT_GetSA2     ' Street Address 2
    PRINT USERS_DAT_GetCity    ' City
    PRINT USERS_DAT_GetUS      ' State
    PRINT USERS_DAT_GetUC      ' Country
    PRINT USERS_DAT_GetUZ      ' Zipcode
    PRINT USERS_DAT_GetUPN     ' Phone Number
    PRINT USERS_DAT_GetUBD     ' Birth Date

PRINT
PRINT "Hit Any Key To End Program"
WHILE NOT INSTAT: WEND

'---------------------------------------------------------------------------
DONE:
 CLS
 LOCATE 25, 1
END

'============================================================================
