/* $Id: subdir.c,v 1.1.1.1 1996/10/09 11:25:33 davidn Exp $
 * Make a subdirectory (including parent directory(s) if necessary)
 *
 */


#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "osdep.h"

int
makesubdir(char const * s)
{
    char *p, tmp[_MAX_PATH];
    int rc = 0;
    resolve_path(tmp, s, NULL);
    p = tmp;
    do {
	char ch = 0;
	struct stat st;
	char *q = strchr(p, DIRCH);
	if (q && (q == tmp || *(q - 1) == ':'))
	    q = strchr(q + 1, DIRCH);
	if ((p = q) != NULL) {
	    ch = *q;
	    *q = '\0';
	    ++p;
	}
	if (stat(tmp, &st) == 0)/* It exists */
	    rc = (S_ISDIR(st.st_mode)) ? 0 : -1;
	else
	    rc = makedir(tmp);
	if (q)
	    *q = ch;
    } while (rc == 0 && p != NULL);
    return rc;
}
