/* $Id: resolve.c,v 1.2 1996/10/30 19:18:54 davidn Exp $
 * Resolve a name into an absolute path/file
 *
 * $Log: resolve.c,v $
 * Revision 1.2  1996/10/30 19:18:54  davidn
 * Implemented ~{user}/path expansion.
 * Fixed WFILE to handle embedded ^Z at line start (consider EOF).
 *
 * Revision 1.1.1.1  1996/10/09 11:25:30  davidn
 * First import
 *
 *
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include  "osdep.h"

/* Local path buffer used as workarea to return values
 * Used when "dest" in many of the functions is NULL
 */

static char __local_path_buf[_MAX_PATH];
#ifdef DOSISH

#if defined(__OS2__) || defined(__EMX__)
#include "os2.h"
#elif defined(WIN32) || defined(_WIN32)
#include "windows.h"
#else
#include <dos.h>
#endif


/* getdisk() - Return current disk drive
 */

static int
getdisk(void)
{
#if defined(__OS2__)
#if defined(__FLAT__) || defined(__EMX__)
    ULONG drive, asdf;
    DosQueryCurrentDisk(&drive, &asdf);
#else
    unsigned short drive;
    unsigned long dont_care;
    DosQCurDisk(&drive, &dont_care);
#endif
    return (int) drive + 'A' - 1;
#elif defined(__MSDOS__)
    union REGS regs;
    regs.h.ah = 0x19;
    intdos(&regs, &regs);
    return (int) regs.h.al + 'A';
#elif defined(_WIN32) || defined(WIN32)
    char szPath[PATHLEN];
    GetCurrentDirectory(PATHLEN, szPath);
    return toupper(*szPath);
#endif
}


/* mydrive() - Returns drive relative to drv
 */

static int
mydrive(int drv)
{
    return (drv) ? toupper(drv) : getdisk();
}


/* getcurddir() - Get current drive and direcrtory on drive
 */

static int
getcurddir(int drive, char *directory, int chrs)
{
#if defined(__OS2__)
#if defined(__FLAT__) || defined(__EMX__)
    ULONG buflen = chrs - 3;
    drive = mydrive(drive);
    *directory++ = (char) drive;
    *directory++ = ':';
    *directory++ = DIRCH;
    return (DosQueryCurrentDir((ULONG) (drive - 'A' + 1), (PBYTE) directory, &buflen) == 0 ? 0 : -1);
#else
    USHORT buflen = chrs - 3;
    drive = mydrive(drive);
    *directory++ = (char) drive;
    *directory++ = ':';
    *directory++ = DIRCH;
    return (DosQCurDir((drive - 'A' + 1), directory, &buflen) == 0 ? 0 : -1);
#endif
#elif defined(__MSDOS__)
    union REGS r;
    chrs = chrs;
    drive = mydrive(drive);
    *directory++ = (char) drive;
    *directory++ = ':';
    *directory++ = DIRCH;

    r.h.ah = 0x47;
    r.h.dl = (unsigned char) (drive - 'A' + 1);
#if defined(__FLAT__)
    r.x.esi = FP_OFF(directory);
    int386(0x21, &r, &r);
#else
    {
	struct SREGS sr;
	sr.ds = FP_SEG(directory);
	r.x.si = FP_OFF(directory);
	int86x(0x21, &r, &r, &sr);
    }
#endif
    return (r.x.cflag == 0 ? 0 : -1);
#elif defined(_WIN32) || defined(WIN32)
    ULONG buflen = chrs;
    int old_disk, rc;
    drive = mydrive(drive);
    old_disk = getdisk();
    if (old_disk != drive)
	setdisk(drive);
    rc = GetCurrentDirectory(buflen, directory);
    if (old_disk != drive)
	setdisk(old_disk);
    return (rc > 0 ? 0 : -1);
#endif
}


/* getcurdir() - Returns current directory
 */

int
getcurdir(char *buf, int buflen)
{
    return getcurddir(0, buf, buflen);
}


/* resolve_path() - Resolve a src path into absolute path
 */

char *
resolve_path(char *dest, char const * src, char const * rel)
{
    int drv = 0,		/* Get current drive */
        abspath = 0,		/* Absolute path (ignore relative) */
        r = 0;
    char *p;
    char workp[_MAX_PATH * 2];

    char *dst = (dest == NULL) ? (dest = __local_path_buf) : dest;
    if (src && *src)
	strncpy(workp, src, _MAX_PATH);
    else
	*workp = '\0';

    fixpath(workp);

    if ((p = strchr(workp, ':')) != NULL) {	/* Looks like a drive
						 * specifier? */
	if (p > (workp + 1))	/* Maybe it's a volume */
	    abspath = 1;
	else {			/* Standard drive in path */
	    drv = toupper(*workp);
	    strcpy(workp, workp + 2);
	}
    }
    if (workp[0] == DIRCH)
	++abspath;		/* It's an absolute path */
    if (!abspath) {		/* It's not an absolute path */
	char relto[_MAX_PATH];
	if (rel) {
	    /* Resolve relative path first */
	    if (!*rel || resolve_path(relto, rel, NULL) == NULL)
		rel = 0;
	    else if (!drv)
		drv = mydrive(relto[0]);
	    else if (relto[0] != drv)
		rel = 0;	/* Not relative if wrong drive */
	}
	if (!rel)		/* Relative to current directory */
	    r = (getcurddir(mydrive(drv), relto, sizeof relto) == 0) ? 0 : -1;

	if (r == 0) {
	    int b, a = strlen(relto);
	    if (a && relto[a - 1] != DIRCH) {
		relto[a++] = DIRCH;
		relto[a] = 0;
	    }
	    for (b = strlen(workp); b >= 0; --b)
		workp[b + a] = workp[b];

	    while (--a >= 0)
		workp[a] = relto[a];
	}
    }
    if (r == 0) {		/* We should now have a full path to resolve */
	int l;
	for (p = workp; *p;) {
	    if (*p == DIRCH) {
		char *m = p++;
		if (*p == '.') {/* One dot */
		    if (!*++p || *p == DIRCH) {	/* Collapse */
			strcpy(m, p);
			p = m;
			continue;
		    }
		    if (*p == '.') {	/* Two dots */
			if (!*++p || *p == DIRCH) {	/* Fold back */
			    char *b = m;
			    while (b > workp && (*--b != DIRCH));
			    if (*b != DIRCH || b == m)
				return NULL;
			    strcpy(b, p);
			    p = b;
			    continue;
			}
		    }
		}
		continue;
	    }
	    ++p;
	}

	if ((l = strlen(workp)) > 0 && workp[l - 1] == DIRCH)
	    workp[--l] = 0;

	if (l == 0 || workp[l - 1] == ':') {	/* Drive spec alone */
	    workp[l++] = DIRCH;
	    workp[l] = 0;
	}
	if (workp[1] != ':' && !(workp[0] == DIRCH && workp[1] == DIRCH)) {
	    *dst++ = (char) mydrive(drv);
	    *dst++ = ':';
	}
	memcpy(dst, workp, l);
	dst[l] = 0;
    }
    return r == 0 ? dest : NULL;
}
#else

#include <unistd.h>
#include <pwd.h>

/* getcurdir() - Returns current directory
 */

int
getcurdir(char *buf, int buflen)
{
    char *ptr = getcwd(buf, buflen);
    return ptr == NULL ? (*buf = '\0', 0) : strlen(buf);
}


/* resolve_path() - Resolve src name into an absolute path
 */

char *
resolve_path(char *dest, char const * src, char const * rel)
{
    int r = 0;
    char *p;
    char workp[_MAX_PATH * 2];

    char *dst = (dest == NULL) ? (dest = __local_path_buf) : dest;
    if (src && *src)
	strncpy(workp, src, _MAX_PATH);
    else
	*workp = '\0';

    /*
     * We need to support ~/ and ~user/ style paths
     */
    if (workp[0] == '~') {	/* Got the tilde */
	struct passwd *pwd;
	p = strchr(workp, '/');
	if (p != NULL)
	    *p++ = '\0';
	pwd = (workp[1]) ? getpwnam(workp + 1) : getpwuid(getuid());
	if (pwd == NULL) {
	    /*
	     * Strictly we should return an error at this point, but it makes
	     * for non-obvious failures. Instead, we drop through and resolve
	     * it like an absolute path
	     */
	    if (p != NULL)
		*--p = '/';
	} else {
	    char workx[_MAX_PATH];
	    strcpy(workx, p ? p : "");
	    strcpy(workp, pwd->pw_dir);
	    if (p && workx[0] != '/')
		strcat(workp, "/");
	    strcat(workp, workx);
	}
    }
    if (workp[0] != '~' && workp[0] != DIRCH) {	/* It's not an absolute path */
	char relto[_MAX_PATH];
	if (rel && (!*rel || resolve_path(relto, rel, NULL) == NULL)) {	/* Resolve relative path
									 * first */
	    rel = NULL;
	}
	if (rel == NULL)
	    getcurdir(relto, _MAX_PATH);

	if (r == 0) {
	    int b, a = strlen(relto);
	    if (a && relto[a - 1] != DIRCH) {
		relto[a++] = DIRCH;
		relto[a] = 0;
	    }
	    for (b = strlen(workp); b >= 0; --b)
		workp[b + a] = workp[b];

	    while (--a >= 0)
		workp[a] = relto[a];
	}
    }
    if (r == 0) {		/* We should now have a full path to resolve */
	int l;
	for (p = workp; *p;) {
	    if (*p == DIRCH) {
		char *m = p++;
		if (*p == '.') {/* One dot */
		    if (!*++p || *p == DIRCH) {	/* Collapse */
			strcpy(m, p);
			p = m;
			continue;
		    }
		    if (*p == '.') {	/* Two dots */
			if (!*++p || *p == DIRCH) {	/* Fold back */
			    char *b = m;
			    while (b > workp && (*--b != DIRCH));
			    if (*b != DIRCH || b == m)
				return NULL;
			    strcpy(b, p);
			    p = b;
			    continue;
			}
		    }
		}
		continue;
	    }
	    ++p;
	}

	if ((l = strlen(workp)) > 0 && workp[l - 1] == DIRCH)
	    workp[--l] = 0;

	memcpy(dst, workp, l);
	dst[l] = 0;
    }
    return r == 0 ? dest : NULL;
}
#endif
