/* $Id: fileexec.c,v 1.1.1.1 1996/10/09 11:25:20 davidn Exp $
 * Execute a program
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "osdep.h"
#include "parse.h"
#include "mem.h"

#define MAXARGS 64

#ifdef DOSISH
#include <process.h>

int
file_execute(char *cmd)
{
    int rc = -1;
    if ((cmd && *cmd) || (cmd = getenv("COMSPEC")) != NULL) {
	static char const fn[] = "file_execute";
	char *cmdline = zstrdup(fn, cmd);
	if (!cmdline)
	    errno = ENOMEM;
	else {
	    int argno = 0;
	    char *args[MAXARGS + 1];
	    args[argno++] = parseword(cmdline, 1);
	    while ((args[argno] = (argno < MAXARGS) ? parseword(NULL, 1) : NULL) != NULL)
		argno++;
	    rc = spawnvp(P_WAIT, args[0], args);
	    zfree(fn, cmdline);
	}
    }
    return rc;
}
#else

#include <unistd.h>
#include <sys/wait.h>

int
file_execute(char *cmd)
{
    int rc = -1;
    if ((cmd && *cmd) || (cmd = getenv("SHELL")) != NULL) {
	static char const fn[] = "file_execute";
	char *cmdline = zstrdup(fn, cmd);
	if (!cmdline)
	    errno = ENOMEM;
	else {
	    pid_t pid;
	    int argno = 0;
	    char *args[MAXARGS + 1];
	    args[argno++] = parseword(cmdline, 1);
	    while ((args[argno] = (argno < MAXARGS) ? parseword(NULL, 1) : NULL) != NULL)
		argno++;
	    fflush(NULL);	/* Flush everything before fork () */
	    if ((pid = fork()) == 0) {	/* Child process */
		for (argno = getdtablesize(); argno-- > 2;)
		    close(argno);
		execvp(args[0], args);
		exit(-1);
	    }
	    if (pid == -1)
		rc = -1;
	    else {		/* Wait for child to finish */
		waitpid(pid, &rc, 0);
		rc = WEXITSTATUS(rc);
	    }
	    zfree(fn, cmdline);
	}
    }
    return rc;
}
#endif
