/* $Id: locks.h,v 1.1.1.1 1996/10/09 11:15:30 davidn Exp $
 * "Portable" file locking support
 *
 */

#ifndef _locks_h
#define _locks_h

#include "posix.h"

#if defined(DOSISH) && !defined(__EMX__)
#define LOCK(fd)    locking((fd), LK_NBRLCK, 1L)
#define UNLOCK(fd)  locking((fd), LK_UNLCK, 1L)
#elif !defined(F_TLOCK)		/* generic flock() */
 /*
  * This is the least compatible method since it locks the entire file
  * Fortunately, we can attempt a shared lock and not block, but it does in
  * fact lock the *entire* file rather than one byte only
  */
#define LOCK(fd)    flock((fd), LOCK_SH|LOCK_NB)
#define UNLOCK(fd)  flock((fd), LOCK_UN)
#else				/* lockf() or fcntl() style interface */
#define LOCK(fd)    lockf((fd), F_TLOCK, 1L)
#define UNLOCK(fd)  lockf((fd), F_ULOCK, 1L)
#endif


#endif
