/* $Id: compress.h,v 1.1.1.1 1996/10/09 11:14:36 davidn Exp $
 * Generic file compression interface
 *
 */

#ifndef _compress_h
#define _compress_h

#include <stdio.h>
#include "strbuf.h"
#include "array.h"

/* Control structure for definitions */

typedef struct _arcinfo {
    strbuf strs;
    Array defs;
}   ArcInfo;

enum _arcstrs {
    AV_NAME,			/* Name of method */
    AV_EXT,			/* Extension */
    AV_ADD,			/* Command to add */
    AV_EXTRACT,			/* Command to extract */
    AV_VIEW,			/* Command to view */
    AV_STRINGS,
    AV_IDENT = AV_STRINGS,	/* Identifier */
    AV_END,			/* End of definition */
    AV_PGPSIGN,			/* PGP signed msg */
    AV_PGPCRYPT,		/* PGP encrypted msg */
    AV_MYOS			/* OS identifier */
};

typedef struct _arcdef {
    sofs_t os[AV_STRINGS];	/* Archiver strings */
    sofs_t siglen;		/* Length of signature */
    long sigofs;		/* offset of signature in file */
    char *sig;			/* Signature itself */
#define   PGPSIGN   0x0001
#define   PGPCRYPT  0x0002
    unsigned flags;		/* Flags */
}   ArcDef;

ArcInfo *arcinfo_new(char const * file);
ArcInfo *arcinfo_init(ArcInfo * AI, char const * file);
void arcinfo_delete(ArcInfo * AI);
void arcinfo_destroy(ArcInfo * AI);

ArcDef *arcdef_new(ArcInfo * AI);
ArcDef *arcdef_filetype(ArcInfo * AI, char const * file);
ArcDef *arcdef_find(ArcInfo * AI, char const * str);
int arcdef_execute(int whichcmd, ArcInfo * AI, ArcDef * def, char const * arcname, char const * args);

sofs_t arcdef_newstring(ArcInfo * AI, char const * str);
char const *arcdef_string(ArcInfo * AI, sofs_t ofs);
int arcdef_fdtype(ArcDef * def, int fd);
#define ispgp(def)    ((def)?((def)->flags&(PGPSIGN|PGPCRYPT)):0)

#endif
