/* $Id: aplydiff.h,v 1.1.1.1 1996/10/09 11:13:38 davidn Exp $
 * module for applying
 *
 */

#ifndef _aplydiff_h
#define _aplydiff_h

#include <time.h>
#include "strbuf.h"
#include "array.h"

#define MAXLINEBUF  2048

enum {
    DA_Init,			/* Initial state, ready for command */
    DA_EOL,			/* Last state, end of list */
    DA_Add,			/* Currently adding lines */
    DA_Del,			/* Currently deleting lines */
    DA_Copy,			/* Currently copying lines */
    DA_Get
};

typedef struct _nlfile {
    sofs_t file;		/* Filename */
    short julian;		/* Julian day */
    short week;			/* Weeks prior current */
    unsigned short crc16;	/* File CRC */
    unsigned lineno;		/* Current line number */
    FILE *fp;
}   NLFILE;

typedef struct _difffile {
    sofs_t file;		/* Name of difference file */
    short julian;		/* Julian day */
    short week;			/* Relates to week prior current */
    unsigned short crc16;	/* CRC accumulator */
    unsigned lineno;		/* Current line number */
    short state;		/* Current state */
    unsigned short counter;	/* State counter */
    FILE *fp;			/* File descriptor */
}   DFFILE;

typedef struct _diffapp {
    strbuf sbuf;		/* Strings buffer */
    Array diffs;		/* List of diff files to apply */
    NLFILE orig;		/* Original nodelist file */
    NLFILE targ;		/* Target nodelist file */
    char *linebuf;		/* Nodelist linebuffer */
    time_t publish;		/* Current week's publishing date */
}   DIFFAPP;

enum {
    F_UNKNOWN = 0,
    F_LIST = 1,
    F_DIFF = 2,
    F_PWDERR = 0x8000
};

DIFFAPP *diffapp_new(time_t publish);
void diffapp_delete(DIFFAPP * da);

DIFFAPP *diffapp_init(DIFFAPP * da, time_t publish);
void diffapp_destroy(DIFFAPP * da);

int diffapp_nlfile(DIFFAPP * da, char const * nlfile);
int diffapp_nldiff(DIFFAPP * da, char const * nldiff);

int diffapp_settarget(DIFFAPP * da);
int diffapp_apply(DIFFAPP * da);
void diffapp_close(DIFFAPP * da);
/* Various utility functions */

extern int nlfiletype(char const * path, short *applies_to, unsigned short *crc16, char const * pwd);
extern short nldaynumber(time_t date);
extern short weeksold(time_t epoch, short daynum);
#endif
