/* $Id: parse.c,v 1.1.1.1 1996/10/09 11:25:29 davidn Exp $
 * Parsing support functions
 *
 */

#include <stdlib.h>
#include <string.h>
#include "osdep.h"
#include "parse.h"


/* verbno() - find a matching verb within the verb list
 * and return its index, or -1 on no match.
 * The idea here is to match AT LEAST the minimum number of chrs
 * required for each verb, but all letters remain significant.
 */

int
verbno(struct _verbstr verbs[], char const * kwd)
{
    if (kwd) {
	int i = 0;
	int l = strlen(kwd);
	/*
	 * Continue to the end of the list
	 */
	while (verbs[i].verb) {
	    int k;
	    /*
	     * Only bother if we have enough characters to match
	     */
	    if (l >= (k = verbs[i].minmatch)) {

		/*
		 * If we've been given more, match those too
		 */
		if (l > k)
		    k = l;

		/*
		 * Compare the strings
		 */
		if (strnicmp(kwd, verbs[i].verb, k) == 0)
		    return i;	/* Got the index! */
	    }
	    ++i;
	}
    }
    return -1;
}


/* parseword() - Like strtok(), but a little more geared to what
 * we need. Provides "quoted string" capability and smart about
 * comments
 */

static char *bufptr = NULL;

char *
parseword(char *buf, int withquote)
{
    if (buf == NULL)
	buf = bufptr;
    else
	bufptr = buf;
    if (buf == NULL)
	bufptr = buf;
    else {
	static char const toks[] = ", \t\r\n";
	/*
	 * Skip any leading whitespace or separators
	 */
	while (*buf && strchr(toks, *buf) != NULL)
	    ++buf;

	/*
	 * Check for a comment delimiter
	 */
	if (*buf == '\0' || *buf == ';' || *buf == '#')
	    buf = bufptr = NULL;/* End of string */
	else {

	    /*
	     * Next, check for quoted text
	     */
	    int quoted = 0;
	    if (*buf == '"' || *buf == '\'') {
		quoted = *buf;
		if (!withquote)
		    ++buf;
	    }
	    /*
	     * Now, skip over the word or quoted text
	     */
	    bufptr = buf;
	    while (*bufptr && quoted ? (*bufptr != quoted) : (strchr(toks, *bufptr) == NULL))
		++bufptr;

	    /*
	     * Terminate the string and save ptr for next time
	     */
	    if (*bufptr) {
		if (quoted && *bufptr == quoted && withquote)
		    bufptr++;	/* Include quote? */
		*bufptr++ = '\0';
	    } else
		bufptr = NULL;
	}
    }
    return buf;
}


/* parseline() - Parse a line of text
 */

char *
parseline(char *buf)
{
    if (buf == NULL)
	buf = bufptr;
    else
	bufptr = buf;
    if (buf == NULL)
	bufptr = buf;
    else {
	static char const toks[] = " \t\r\n";
	int inquote = 0;
	char *lastnonwhite = NULL;
	/*
	 * Skip any leading whitespace or separators
	 */
	while (*buf && strchr(toks, *buf) != NULL)
	    ++buf;
	bufptr = buf;

	/*
	 * Now, skip over the rest of the line
	 */
	while (*bufptr && (inquote || *bufptr != ';') && (strchr(toks + 2, *bufptr) == NULL)) {
	    if (strchr(toks, *bufptr) == NULL) {
		lastnonwhite = bufptr;
		if (!inquote)
		    inquote = (*bufptr == '"' || *bufptr == '\'') ? *bufptr : 0;
		else if (inquote == *bufptr)
		    inquote = 0;
	    } else if (inquote)
		lastnonwhite = bufptr;
	    ++bufptr;
	}
	*bufptr = '\0';

	/*
	 * Terminate the string and save ptr for next time
	 */
	if (lastnonwhite)
	    *++lastnonwhite = '\0';
	bufptr = NULL;
    }
    return buf;
}
