/* $Id: strbuf.h,v 1.1.1.1 1996/10/09 11:17:31 davidn Exp $
 * Strings buffer
 * Sub-allocator for strings
 *
 */

#ifndef strbuf_h_defined
#define strbuf_h_defined

typedef unsigned short sofs_t;
#define STRBUFSZ  ((sofs_t)512)	/* Default size */
#define STRBUFMAX ((sofs_t)-1)	/* Max size, 2's compl dependancy */
#define STRNONE   ((sofs_t)-1)	/* Returned if "no string" */
#define STRDELMK  '\xff'	/* Deleted string marker */

typedef struct _strbuf {
    sofs_t soSize;		/* String buffer size */
    sofs_t soOffset;		/* String buffer offset */
    char *heap;			/* Strings heap */
}   strbuf;
/* Creates/deletes an strbuf on the heap */
strbuf *sb_new(unsigned sz);	/* Allocate a new buffer */
void sb_delete(strbuf * sb);	/* Deallocate a strings buffer */
/* Init/deinit an strbuf declared */
strbuf *sb_init(strbuf * sb, unsigned sz);	/* Init a strings buffer */
void sb_destroy(strbuf * sb);	/* free a strings buffer */
/* Utility functions */
sofs_t sb_alloc(strbuf * sb, char const * s);	/* Allocate a string */
sofs_t sb_salloc(strbuf * sb, char const * s, int len);	/* Allocate a string */
void sb_free(strbuf * sb, sofs_t o);	/* 'free' a string */
void sb_reset(strbuf * sb);	/* Reset entire buffer */
int sb_realloc(strbuf * sb, int sz);	/* Reallocate */
void sb_pack(strbuf * sb, int (*reloc) (sofs_t mold, sofs_t mnew));
sofs_t sb_offset(strbuf * sb, char *s, int icase);	/* ofs of string in
							 * buffer */
char const *sb_string(strbuf * sb, sofs_t o);
#define sbsetofs(sb, ofs)    ((sb)->soOffset = (ofs))
#define sbat(sb)             ((sb)->soOffset)
#define sbsize(sb)           ((sb)->soSize)

#endif
