/* $Id: osdep.h,v 1.1.1.1 1996/10/09 11:16:46 davidn Exp $
 * Operationg system function prototypes
 *
 */

#ifndef _osdep_h
#define _osdep_h

#define DOSISH

#if defined(__WATCOMC__) && defined(__386__)
#ifndef __FLAT__
#define __FLAT__
#endif
#endif

#if defined(__OS2__) || defined(OS2) || defined(os2)
#ifndef __OS2__
#define __OS2__
#define __FLAT__
#endif
#if defined(__FLAT__) || defined(__EMX__)
#define HOSTOS	"OS2-32"
#else
#define HOSTOS	"OS2-16"
#endif

#elif defined(__MSDOS__)
#define HOSTOS	"MSDOS"
#elif defined(_WIN32) || defined(WIN32)
#define HOSTOS	"Win32"
#elif defined(__linux__) || defined(linux)
#undef DOSISH
#define HOSTOS	"Linux"
#define POSIXDIR
#elif defined(__freebsd__) || defined(__FreeBSD__)
#undef DOSISH
#define HOSTOS "FreeBSD"
#define POSIXDIR
#else
#undef DOSISH
#error Unable to determine target operating system!
#endif

#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "os_str.h"

#if !defined(DOSISH)
#include <sys/param.h>
#ifndef _MAX_PATH
#define _MAX_PATH PATH_MAX
#endif
#endif

#ifdef DOSISH
#define DIRCH	'\\'
#else
#define DIRCH	'/'
#endif

/* filesystem dependant */

extern char *build_path(char *dest, char const * path,...);
extern char *last_component(char const * path);
extern char *get_path(char *dest, char const * path);
extern char *path_ext(char *path);
extern char *add_ext(char *path, char const * ext);
extern char *add_extn(char *path, unsigned numbr);
extern char *resolve_path(char *dst, char const * src, char const * rel);
extern int setfiletimes(char const * dest, struct stat * st);
extern int fmove(char const * dest, char const * src);
extern int fcopy(char const * dest, char const * src, int moveit);
extern int changedir(char const * dir);
extern int makesubdir(char const * dir);
extern int getcurdir(char *buf, int buflen);
extern int makedir(char const * s);
extern int cleandir(char const * dir);
extern int removedir(char const * dir);
/* file search */

typedef struct ffind FFIND;

FFIND *file_findfirst(char const * dir, char const * patt);
int file_findnext(FFIND * ff);
void file_findclose(FFIND * ff);

char const *file_dir(FFIND * ff);	/* Return directory being searched */
char const *file_name(FFIND * ff);	/* Return name of current file */
char const *file_path(FFIND * ff, char *buf);	/* Return path/file of current */
unsigned file_attr(FFIND * ff); /* Return attributes/permissions of current
				 * file */
long file_size(FFIND * ff);	/* Return size of current file */
time_t file_date(FFIND * ff);	/* Last write date */
/* Some booleans for handling file attributes/types in a portable way */

int file_isdir(FFIND * ff);	/* Is file a directory? */
int file_isexe(FFIND * ff);	/* Is file an executable? */
int file_isreg(FFIND * ff);	/* Is file a regular file? */
int file_isdev(FFIND * ff);	/* Is flie a device? 1=chr 2=block */
/* wildcard matching */

int escape(int c);
int wildmatch(char const * s, char const * p, int icase);

char *file_tempname(char const * dir, char *buf);
int file_execute(char *cmdline);
int file_truncate(int fd, unsigned long atofs);
#ifdef DOSISH
extern char *fixpath(char *path);
#else
#define fixpath(p)	(p)
#endif

#endif
