/* $Id: mem.h,v 1.1.1.1 1996/10/09 11:15:55 davidn Exp $
 * Private allocators with (possible) error/debug handling
 *
 */

#ifndef _mem_h
#define _mem_h

#include <stdlib.h>

#if (defined(__MSDOS__)||defined(__OS2__)) && !(defined(__FLAT__)||defined(__386__)) && (defined(__SMALL__)||defined(__MEDIUM__)||defined(__COMPACT__)||defined(__LARGE__))
#define __16BITSEGMENTED__
typedef long lsize_t;
#else
#undef  __16BITSGEMENTED__
typedef size_t lsize_t;
#endif

void *zmalloc(char const * fn, size_t sz);
void *zrealloc(char const * fn, void *p, size_t sz);
void zfree(char const * fn, void *p);
char *zstrdup(char const * fn, char const * str);
/* Huge memory block allocation */

#ifdef __16BITSEGMENTED__
void huge *zhmalloc(char const * fn, lsize_t sz);
void huge *zhrealloc(char const * fn, void huge * p, lsize_t sz);
void zhfree(char const * fn, void huge * p);
/* Memory copying functions */
void hugememmove(void huge * dest, void const huge * src, lsize_t sz);
#else
/* Duds */
#define zhmalloc(fn,sz)     zmalloc(fn,sz)
#define zhrealloc(fn,p,sz)  zrealloc(fn,p,sz)
#define zhfree(fn,p)        zfree(fn,p)
#endif

typedef void (*fatalfunc) (int rc, char const * msg,...);
extern int memfatalcode;
extern fatalfunc memfatal;
#if defined(__FLAT__) || defined(__386__)
#define MEM_MAGIC_BLOCK   0x79c19cf3
#else
#define MEM_MAGIC_BLOCK   0x9cf3
#endif

#endif
