/* $Id: cfile.h,v 1.1.1.1 1996/10/09 11:14:01 davidn Exp $
 * Output file with CRC-16 handling
 *
 */

#ifndef _cfile_h
#define _cfile_h

#include <stdio.h>
#include "crc16.h"

typedef struct _cfile {
    FILE *fp;
    unsigned short crc16;
}   CFILE;

extern CFILE *cfopen(char const * filename, char const * modes);
extern int cfclose(CFILE * cfp);
extern size_t cfwrite(const void *ptr, size_t size, size_t n, CFILE * cfp);
extern int cfseek(CFILE * cfp, long int offset, int whence);
extern char *cfgets(char *s, int n, CFILE * cfp);
extern int cfprintf(CFILE * cfp, const char *fmt,...);
extern int cfputs(const char *s, CFILE * cfp);
extern int cferror(CFILE * cfp);
#define cfreset(cfp)  ((cfp)->crc16 = 0)
#define cfcrc16(cfp)  ((cfp)->crc16)

#endif
