/* $Id: updrsp.c,v 1.1.1.1 1996/10/09 11:25:35 davidn Exp $
 * Updates a linker or librarian response file
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static FILE *rsp = NULL;
static char const *pfx = "-+";
static char const *sfx = "";
static char const *rspfile = NULL;
static char dirchr = '\\';
static int debug = 0;

static void
usage(void)
{
    fprintf(stderr, "usage: updrsp <rspfile> [-sSUFFIX] [-pPREFIX] [-L|-I] <filename> [<filename> ...]\n");
    exit(1);
}

static void
update(char const * file)
{
    char updline[128];
    char tmpline[128];
    sprintf(updline, "%s%s%s\n", pfx, file, sfx);
    if (rsp == NULL && (rsp = fopen(rspfile, "a+")) == NULL) {
	fprintf(stderr, "Can't open %s for update\n", file);
	exit(2);
    }
    fseek(rsp, 0L, SEEK_SET);
    while (fgets(tmpline, sizeof tmpline - 1, rsp) != NULL)
	if (strcmp(tmpline, updline) == 0)
	    return;		/* Line is already there */
    fputs(updline, rsp);
    if (debug)
	printf("added \"%.*s\"\n", (int) (strlen(updline) - 1), updline);
}

int
main(int argc, char *argv[])
{
    int carg = 0;
    while (++carg < argc) {
	char *argp = argv[carg];
	if (carg == 1)		/* Response filename */
	    printf("Updating response file: %s\n", rspfile = argp);
	else {
	    if (*argp == '-') {
		++argp;
		switch (*argp) {
		case 's':	/* Suffix */
		    sfx = ++argp;
		    break;
		case 'p':	/* Prefix */
		    pfx = ++argp;
		    break;
		case 'd':
		    dirchr = *++argp;
		    break;
		case 'g':	/* GNU/UNIX type compiler */
		    dirchr = '/';
		    pfx = sfx = "";
		    break;
		case 'w':	/* WLIB compiler */
		    pfx = "-+";
		    sfx = "";
		    break;
		case 'l':	/* WLINK */
		    pfx = "file ";
		    sfx = "";
		    break;
		case 'x':	/* Debugging toggle */
		    debug = !debug;
		    break;
		default:
		    usage();

		case 'L':	/* Library, environment defaults */
#if defined(__linux__) || defined(__EMX__) || defined(__unix__)
		    pfx = sfx = "";
		    break;
#elif defined(__OS2__) && defined(__WATCOMC__)
		    pfx = "-+";
		    sfx = "";
#endif
		    break;
		case 'I':	/* Link, environment defaults */
#if defined(__linux__) || defined(__EMX__) || defined(__unix__)
		    pfx = sfx = "";
#elif defined(__OS2__) && defined(__WATCOMC__)
		    pfx = "file ";
		    sfx = "";
#endif
		    break;
		}
	    } else {
#if defined(__OS2__) || defined(__MSDOS__) || defined(WIN32) || defined(_WIN32)
		char *p = argp;	/* Make filenames DOSish */
		while ((p = strchr(p, '/')) != NULL)
		    *p++ = dirchr;
#endif
		update(argp);
	    }
	}
    }

    if (rspfile == NULL)
	usage();

    if (rsp)
	fclose(rsp);

    return 0;
}
