/* $Id: log.c,v 1.1.1.1 1996/10/09 11:24:48 davidn Exp $
 * Log message/file support
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>

#include "osdep.h"
#include "log.h"

extern char const progname[];
extern char const progabbr[];
extern char const version[];

static FILE *logfp = NULL;
static int daynumber = 0;
static int logformat = 0;
static int loglevel = 0;

static char const days[] = "SunMonTueWedThuFriSatSun";
static char const mons[] = "JanFebMarAprMayJunJulAugSepOctNovDec";
static char const lvls[] = " :+%$*?!";


/* logent() - write an entry to the line (no stdarg)
 */

void
logent(int llevel, char const * str)
{
    int level = (llevel & 0xf);
    char ch = lvls[level];
    time_t now = time(NULL);
    struct tm *t = localtime(&now);
    char buf[1024];
    if (logformat && logfp && t->tm_yday != daynumber)
	fprintf(logfp, "----------  %s v%s/" HOSTOS " %3.3s %2d %3.3s %02d\n", progname, version,
		days + (t->tm_wday * 3), t->tm_mday, mons + (t->tm_mon * 3), t->tm_year % 100);
    daynumber = t->tm_yday;
    if (logformat) {

	/*
	 * FD-style log output
	 */
	static char const logstr[] = "%c %02u:%02u:%02u  %s\n";
	sprintf(buf, logstr, ch, t->tm_hour, t->tm_min, t->tm_sec, str);
    } else {

	/*
	 * Binkley-style log output
	 */
	static char const logstr[] = "%c %02u %3.3s %02u:%02u:%02u %s %s\n";
	sprintf(buf, logstr, ch, t->tm_mday, mons + (t->tm_mon * 3), t->tm_hour, t->tm_min, t->tm_sec, progabbr, str);
    }
    if (logfp && level >= loglevel)
	fputs(buf, logfp);
    if (!(llevel & LOG_NOECHO))
	fprintf(stdout, "%c %02u:%02u %s\n", ch, t->tm_hour, t->tm_min, str);
    if (logfp && loglevel >= LOG_ERROR)	/* Flush log for anything serious */
	fflush(logfp);
}


/* setlogformat() - Set format of log entries
 */

void
setlogformat(int fmt)
{
    if (fmt != logformat) {
	logformat = fmt;
	daynumber = 0;
    }
}


/* openlog() - opens (or closes) the log file
 */

void
openlog(char const * logfile, int fmt, int minlevel)
{
    char tmp[20];
    if (logfp) {

	/*
	 * Close it if it is open
	 */
	if (!logformat) {
	    sprintf(tmp, "End, v%s", version);
	    logent(LOG_MARK | LOG_NOECHO, tmp);
	}
	fputc('\n', logfp);
	fclose(logfp);
	logfp = NULL;
    }
    logformat = fmt;
    loglevel = minlevel;
    daynumber = 0;
    if (logfile && *logfile && (logfp = fopen(logfile, "a+")) != NULL && !logformat) {
	sprintf(tmp, "Begin, v%s", version);
	logent(LOG_MARK | LOG_NOECHO, tmp);
    }
}
/* logit() - logs information to the currently open log file
 */

void
logit(int level, char const * msg,...)
{
    if (msg) {
	char tmp[1024];

	va_list argp;
	va_start(argp, msg);
	vsprintf(tmp, msg, argp);
	va_end(argp);
	logent(level, tmp);
    }
}


/* fatal() - fatal error handler with log message
 */

void
fatal(int errlvl, char const * msg,...)
{
    if (msg) {
	char tmp[1024];

	va_list argp;
	va_start(argp, msg);
	vsprintf(tmp, msg, argp);
	va_end(argp);
	logent(LOG_FATAL, tmp);
    }
    openlog(NULL, -1, 0);
    exit(errlvl);
}
