/* $Id: filetemp.c,v 1.1.1.1 1996/10/09 11:25:21 davidn Exp $
 * Temporary file support
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "osdep.h"

#ifdef DOSISH
#include <process.h>
#include <io.h>
#if defined(__EMX__)
#include <unistd.h>
#endif

#define MAXTRIES  16

char *
file_tempname(char const * dir, char *buf)
{
    char *res = NULL;
    int tries = 0;
    if (dir == NULL && (dir = getenv("TMP")) == NULL)
	dir = getenv("TEMP");
    while (res == NULL && (tries++ < MAXTRIES)) {
	char fn[10];

	static unsigned counter = 0;
	if (counter++ == 0) {
	    srand((unsigned) time(NULL));
	    counter = (unsigned) rand();
	}
#ifdef __MSDOS__
#define getpid()  42
#endif
	sprintf(fn, "%04x%04x", (unsigned) getpid(), counter);
	res = resolve_path(buf, fn, dir);
	if (access(res, F_OK) == 0 || errno != ENOENT)
	    res = NULL;
    }
    return res;
}


#else

/* Usually present */
extern char *tempnam(char const * dir, char const * pfx);

char *
file_tempname(char const * dir, char *buf)
{
    char *res = NULL;
    if (dir == NULL && (dir = getenv("TMP")) == NULL && (dir = getenv("TMPDIR")) == NULL)
	dir = "/tmp";
    if ((res = tempnam(dir, "TfNx")) != NULL) {
	strcpy(buf, res);
	free(res);
    }
    return res;
}
#endif
