/* $Id: fidoaddr.c,v 1.1.1.1 1996/10/09 11:25:19 davidn Exp $
 * Functions to parse and format a FidoNet style address
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "fidoaddr.h"
#include "mem.h"

#define NID_OFS 0		/* policy: change to 1 to allow '.' in domains */
static char const not_in_domain[] = ". \t:\r\n@#!*&^%$=+-~`'\":;";

static char domain_buf[32];
#define longtoascii(n,b)	sprintf(b,"%ld",(long)n);

/* wasdomain() - return domain for previously parsed address
 */

char const *
wasdomain(void)
{
    return *domain_buf ? domain_buf : NULL;
}
/* fidoaddr() - Parse a fidonet address
 */

int
fidoaddr(char const * str, ZNNP * addr, ZNNP * dflt)
{
    char const *p;
    ZNNP netaddr;
    /*
     * Zone
     */
    netaddr.zone = 0;
    if ((p = strchr(str, ':')) != NULL) {
	netaddr.zone = (node_t) atol(str);
	str = ++p;
    } else if (dflt)
	netaddr.zone = dflt->zone;

    /*
     * Net
     */
    netaddr.net = 0;
    if ((p = strchr(str, '/')) != NULL) {
	netaddr.net = (node_t) atol(str);
	str = ++p;
    } else if (dflt)
	netaddr.net = dflt->net;

    /*
     * Node
     */
    if (*str == '.')
	netaddr.node = dflt ? dflt->node : 0;
    else
	netaddr.node = (node_t) atol(str);

    /*
     * Point
     */
    netaddr.point = 0;
    if ((p = strchr(str, '.')) != NULL)
	netaddr.point = (node_t) atol(++p);

    /*
     * Domain
     */
    domain_buf[0] = 0;
    if ((p = strchr(str, '@')) != NULL) {
	strncpy(domain_buf, ++p, sizeof domain_buf);
	domain_buf[sizeof domain_buf - 1] = '\0';
	strcpy(domain_buf, strtok(domain_buf, not_in_domain + NID_OFS));
    }
    if (netaddr.net == 0)
	return 0;
    *addr = netaddr;
    return 1;
}
/* fidodaddr() - parse a fidonet address in domain format
 */

int
fidodaddr(char const * str, ZNNPD * netaddr, ZNNPD * dflt)
{
    int rc = fidoaddr(str, &netaddr->znnp, dflt ? &dflt->znnp : NULL);
    if (rc) {
	netaddr->domain = NULL;
	if (domain_buf[0])
	    netaddr->domain = zstrdup("fidoaddr", domain_buf);
	else if (dflt)
	    netaddr->domain = dflt->domain;
    }
    return rc;
}
/* fidofmt() - Format a FidoNet address
 */

char const *
fidofmt(char *dest, ZNNP * netaddr, char const * domain)
{
    char *p;
    static char tmp_addr[64];
    if (dest == NULL)
	dest = tmp_addr;

    if (!netaddr->zone && !netaddr->net && !netaddr->node && !netaddr->point)
	*domain_buf = *dest = '\0';
    else {
	p = dest;
	if (netaddr->zone) {
	    p += longtoascii(netaddr->zone, p);
	    *p++ = ':';
	}
	if (netaddr->zone || netaddr->net) {
	    p += longtoascii(netaddr->net, p);
	    *p++ = '/';
	}
	p += longtoascii(netaddr->node, p);
	if (netaddr->point) {
	    *p++ = '.';
	    p += longtoascii(netaddr->point, p);
	}
	if (domain && *domain) {
	    *p++ = '@';
	    for (strcpy(p, domain); *p && strchr(not_in_domain, *p) == NULL; p++)	/* Styalize */
		if (isupper(*p))
		    *p = (char) tolower(*p);
	    if (*(p - 1) == '@')
		--p;
	    *p = '\0';
	}
    }
    return dest;
}


/* fidodfmt() - Format a FidoNet address (with domain
 */

char const *
fidodfmt(char *dest, ZNNPD * netaddr)
{
    return fidofmt(dest, &netaddr->znnp, netaddr->domain);
}
