/* $Id: stamp.h,v 1.1.1.1 1996/10/09 11:17:21 davidn Exp $
 * Defines a "DOS" directory date/time stamp structure
 *
 */

#ifndef _stamp_h
#define _stamp_h

typedef struct _stamp {
    unsigned short date;
    unsigned short time;
}   DATESTAMP;
/* Helper macros for unpacking the above
 */

#define DU_DAY(d)       ((d) & 0x1f)
#define DU_MON(d)       (((d) >> 5) & 0x0f)
#define DU_YEAR(d)      ((((d) >> 9) & 0x7f)+1980)

#define TU_SEC(t)       (((t) & 0x1f) * 2)
#define TU_MIN(t)       (((t) >> 5) & 0x3f)
#define TU_HOUR(t)      (((t) >> 11) & 0x1f)

/* Helper macros for packing the above
 */

#define DP_DAY(d)       ((d) & 0x1f)
#define DP_MON(m)       ((m) << 5)
#define DP_YEAR(y)      (((y) - 1980) << 9)
#define DP_DATE(d,m,y)  (DP_DAY(d)|DP_MON(m)|DP_YEAR(y))

#define TP_SEC(s)       ((s) / 2)
#define TP_MIN(m)       ((m) << 5)
#define TP_HOUR(h)      ((h) << 11)
#define TP_TIME(h,m,s)  (TP_SEC(s)|TP_MIN(m)|TP_HOUR(h))

#endif
