/* $Id: log.h,v 1.1.1.1 1996/10/09 11:15:47 davidn Exp $
 * Log file support routines
 *
 */

#ifndef _log_h
#define _log_h

enum _loglevels {
    LOG_PROGRESS,		/* Just progress information */
    LOG_MARK,			/* More interesting progress */
    LOG_EVENT,			/* Logs a significant event */
    LOG_RESULT,			/* Reporting a result */
    LOG_TRANX,			/* Transaction (mail?) event */
    LOG_WARN,			/* Warning */
    LOG_ERROR,			/* Error */
    LOG_FATAL,			/* Fatal error */
    LOG_NOECHO = 0x8000
};

extern void openlog(char const * logfile, int fmt, int minlevel);
extern void logit(int loglevel, char const * msg,...);
extern void logent(int loglevel, char const * str);
extern void fatal(int errlvl, char const * msg,...);
extern void setlogformat(int fmt);
#endif
