; This is a sample control for a the coordinator of a Zone.
; Edit fields within angle brackets as necessary (removing the brackets)

name	   FidoNet
make       Zone 3 ; nltool.dat  ; No "master data file"  input data is below.

outfile    z3list         	; use generic name for output file if very large
outdiff	   z3diff		;
comments   comments.txt
prolog     prolog.txt
epilog	   epilog.txt

process    Thursday		; Set this day to meet deadline ITC gives you or
				; Friday after cut-over to zone based nodelist

arc 5			  	; force ARC 6 or 7 to generate level 5 archives
				; DO NOT use ARC5 with ARC versions earlier than 6

master     C:\Zone3\      	; where master files reside (default - current)
update     C:\Zone3\Upd\  	; where to save received files 'till processing
mailfiles  C:\Mail\Secure\	; where mail server places received files
mailfiles  C:\Mail\In\		; where BBS places uploaded files (if needed)
badfiles   C:\Zone3\Bad\	; optional "waste can" for files with fatal errors

notify     Errors CRASH XFLAGS 	; notify of errors (CRASH optional). Errors should
				; not occur at this level, but. . .

submit     1:1/0 CRASH XFLAGS  	; where you send updates, CRASH and/or HOLD optional
netaddress 3:3/0	      	; your network address here
messages   C:\Msg\Mail\		; path name to mail server's FidoNet mail area

pgppass	   "my pgp password: that's it"
logfile	   FD nltool.log

cleanup

data

; Your zone source data goes here.  Note that first non-comment statement
; must begin with the keyword "Zone" not "Region"

files

Region 	50   REGION50	3:633/371
Region 	51   REGION51
Region 	54   REGION54
Region 	55   REGION55
Region 	57   REGION57

;      etc.

