*:*****************************************************************************
*:
*: Procedure file: D:\IPADMGR\SOURCE\STATS.PRG
*:
*:         System: STATS
*:         Author: Jeff Johnson
*:      Copyright (c) 1996, BBS Consultants, Inc.
*:  Last modified: 10/01/96     12:08
*:
*:  Procs & Fncts: DELTATIME()
*:
*:          Calls: HELP.PRG
*:               : RDDSETDEFAULT()    (function  in ?)
*:               : FREADSTR()         (function  in ?)
*:               : DELTATIME()        (function  in STATS.PRG)
*:               : FWRITE()           (function  in ?)
*:
*:           Uses: IPADCFG.DBF        
*:               : IPADMGR.DBF        
*:               : STATS.DBF          
*:               : TRASHCAN.DBF
*:
*:        Indexes: IPADMGR.NX1        
*:               : IPADMGR.NX2        
*:               : IPADMGR.NX3        
*:               : IPADMGR.NX4        
*:               : IPADMGR.NX5        
*:               : IPADMGR.NX6        
*:               : STATS.NX1          
*:               : TRASHCAN.NX1       
*:               : TRASHCAN.NX2       
*:
*:    Other Files: &SYSTEM
*:               : &TEMP
*:               : DBF
*:               : &NEW
*:
*:      Documented 10/01/96 at 12:11                SNAP!  version 5.02
*:*****************************************************************************
*** CLIPPER /R
*** BLINKER FI stats LI clipper, dbfndx
***

*** Workareas
***   1  =  ipadmgr
***   2  =  ipadcfg
***   5  =  stats

REQUEST DBFNDX
RddSetDefault("DBFNDX")

SET SCOREBOARD OFF
SET TALK OFF
SET EXCLUSIVE ON
PUBLIC dostat, demo
CLEAR
SET COLOR TO W+/B
i  := 0
DO WHILE i < 25
   @ i, 0 SAY Replicate(Chr(176),80)
   i++
   LOOP
ENDDO
SET COLOR TO W+/N
@ 12,11 CLEAR TO 14,69
SET COLOR TO W+/B,N/W
@ 11,10 CLEAR TO 13,68
@ 11,10 TO 13,68 double

SELECT 2
USE ipadcfg
STORE Ltrim(Rtrim(dns)) TO domain
STORE Rtrim(sys_log)    TO system
STORE Rtrim(mail_log)   TO cMail
STORE Rtrim(bill_log)   TO billing
SET COLOR TO N/BG
@ 0, 0
*@ 0,0 SAY "                                                                               "
SET COLOR TO W+/R
@ 0,0 SAY " IpadMgr  v 1.0.8 "
@ 0,78-Len(domain) SAY " " + domain + " "
SET COLOR TO W+/B

SELECT 1
USE ipadmgr
INDEX ON Upper(name) TO ipadmgr.nx1
@ 12,13 SAY "Reindexing Ipadmgr.nx1   "
INDEX ON Upper(s_login) TO ipadmgr.nx2
@ 12,13 SAY "Reindexing Ipadmgr.nx2   "
INDEX ON Upper(f_login) TO ipadmgr.nx3
@ 12,13 SAY "Reindexing Ipadmgr.nx3   "
INDEX ON Upper(p_login) TO ipadmgr.nx4
@ 12,13 SAY "Reindexing Ipadmgr.nx4   "
INDEX ON Upper(pop_dir) TO ipadmgr.nx5
@ 12,13 SAY "Reindexing Ipadmgr.nx5   "
INDEX ON Upper(login_name) TO ipadmgr.nx6
@ 12,13 SAY "Reindexing Ipadmgr.nx6   "

SELECT 5
USE stats
INDEX ON Day TO stats.nx1
@ 12,13 SAY "Reindexing Stats.nx1     "

USE trashcan
INDEX ON Upper(phrase) TO trashcan.nx1
@ 12,13 SAY "Reindexing Trashcan.nx1  "
INDEX ON card TO trashcan.nx2
@ 12,13 SAY "Reindexing Trashcan.nx2  "
USE

SELECT 1
USE ipadmgr INDEX ipadmgr.nx1, ipadmgr.nx2, ipadmgr.nx3, ipadmgr.nx4, ipadmgr.nx5
STORE .F. TO dostat

SELECT 5
USE stats INDEX stats.nx1
SET ORDER TO 0
GOTO BOTTOM
DO CASE
CASE Month(Date()) = 1 .AND. Left(Day,2) = "12"
   APPEND BLANK
   REPLACE Day WITH Dtoc(Date())
CASE Month(Date()) > Val(Left(Day,2))
   APPEND BLANK
   REPLACE Day WITH Dtoc(Date())
ENDCASE
SET ORDER TO 1
SET COLOR TO W+/B
SET EXACT OFF
STORE 0 TO bytes, i_ppp, o_ppp, i_tel, o_tel, i_ftp, a_ftp, i_mail, o_mail
STORE Rat("\",system) TO m
STORE Left(system,m) TO line
STORE line + "Temp.tmp" TO TEMP
STORE Right(system,(Len(system)-m)) TO l
STORE Ltrim(Str(Month(Date()),2)) TO m
IF Len(m) = 1
   STORE Left(l,4) + "0" + m TO m
ELSE
   STORE Left(l,4) + m TO m
ENDIF
STORE Ltrim(Str(Day(Date()),2)) TO d
IF Len(d) = 1
   STORE Left(m,6) + "0" + d + "." TO m
ELSE
   STORE Left(m,6) + d + "." TO m
ENDIF
STORE Right(Str(Year(Date()),4),2) TO y
IF Len(y) = 1
   STORE Left(m,9) + "0" + y TO m
ELSE
   STORE Left(m,9) + y TO m
ENDIF
STORE line + m TO new
IF .NOT. FILE("&New")
   *****************************************************************
   IF FILE("&Temp")
      in = FOPEN('&System',0)
      tmp = FOPEN('&Temp',0)
      STORE "" TO line
      STORE Right(Str(Year(Date()),4),2) TO y
      DO WHILE .T.
         STORE freadstr(tmp,1) TO mvar
         STORE bytes + 1 TO bytes
         DO CASE
         CASE Len(mvar) = 0
            EXIT
         CASE Asc(mvar) = 10
            @ 20,0 SAY Space(80)
            @ 20,0 SAY Left(line,79)
            STORE Ltrim(line) TO line, templine
            STORE Upper(Ltrim(Rtrim(Substr(line,9,8)))) TO m
            STORE Dtoc(Ctod(m)) TO m
            DO CASE
            CASE "-ANS]" $ line .AND. "Connected" $ line
               @ 12,13 SAY "Processing :" + m + " Answered SLIP   "
               SEEK m
               IF Found()
                  REPLACE Day WITH m,;
                     in_ppp WITH in_ppp + 1
               ELSE
                  APPEND BLANK
                  REPLACE Day WITH m,;
                     in_ppp WITH in_ppp + 1
               ENDIF
               STORE 0 TO lapsed, sttime, endtime, start
               STORE Substr(line,18,8) TO sttime
               STORE Substr(line,27,6) TO port
               STORE At("-",port) TO N
               IF N > 0
                  STORE Left(port,N-1) TO port
               ENDIF
               STORE At("ANS] [",line) TO N
               STORE Right(line,(Len(line)-(N+5))) TO line
               STORE At("]",line) TO N
               STORE Left(line,N-1) TO mname
               STORE bytes TO start
               STORE "" TO line
               DO WHILE .T.
                  STORE freadstr(in,1) TO mvar
                  DO CASE
                  CASE Len(mvar) = 0
                     FSEEK(tmp,start)
                     EXIT
                  CASE Asc(mvar) = 10
                     @ 20,0 SAY Space(80)
                     @ 20,0 SAY Left(line,79)
                     DO CASE
                     CASE port $ line .AND. "Disconnected" $ line
                        lapsed := DeltaTime()
                        FSEEK(tmp,start)
                        SELECT ipadmgr
                        SET ORDER TO 2
                        *                                Set Order To 4
                        SEEK Upper(mname)
                        IF Found()
                           REPLACE c_slogins WITH c_slogins + 1,;
                              c_stime WITH c_stime + lapsed
                        ENDIF
                        SELECT stats
                        EXIT
                     CASE port $ line .AND. "Loss of Carrier" $ line
                        lapsed := DeltaTime()
                        FSEEK(tmp,start)
                        SELECT ipadmgr
                        SET ORDER TO 2
                        *                                Set Order To 4
                        SEEK Upper(mname)
                        IF Found()
                           REPLACE c_slogins WITH c_slogins + 1,;
                              c_stime WITH c_stime + lapsed
                        ENDIF
                        SELECT stats
                        EXIT
                     OTHERWISE
                        STORE "" TO line
                     ENDCASE
                  OTHERWISE
                     STORE line + mvar TO line
                  ENDCASE
               ENDDO
            CASE "FTP Server:[anonymous]" $ line
               @ 12,13 SAY "Processing :" + m + " Anonymous FTP   "
               SEEK m
               IF Found()
                  REPLACE Day WITH m,;
                     any_ftp WITH any_ftp + 1
               ELSE
                  APPEND BLANK
                  REPLACE Day WITH m,;
                     any_ftp WITH any_ftp + 1
               ENDIF
               STORE 0 TO lapsed, sttime, endtime, start
               STORE Substr(line,18,8) TO sttime
               STORE Right(line,(Len(line)-27)) TO port
               STORE At("]",port) TO N
               IF N > 0
                  STORE Left(port,N) TO port
               ENDIF
               STORE At("FTP Server:[",line) TO N
               STORE Right(line,(Len(line)-(N+11))) TO line
               STORE At("]",line) TO N
               STORE Left(line,N-1) TO mname
               STORE bytes TO start
               STORE "" TO line
               DO WHILE .T.
                  STORE freadstr(in,1) TO mvar
                  DO CASE
                  CASE Len(mvar) = 0
                     FSEEK(tmp,start)
                     EXIT
                  CASE Asc(mvar) = 10
                     @ 20,0 SAY Space(80)
                     @ 20,0 SAY Left(line,79)
                     IF port $ line
                        lapsed := DeltaTime()
                        SELECT ipadmgr
                        SET ORDER TO 3
                        SEEK Upper(mname)
                        IF Found()
                           REPLACE c_flogins WITH c_flogins + 1,;
                              c_ftime WITH c_ftime + lapsed
                        ENDIF
                        SELECT stats
                        FSEEK(tmp,start)
                        EXIT
                     ELSE
                        STORE "" TO line
                     ENDIF
                  OTHERWISE
                     STORE line + mvar TO line
                  ENDCASE
               ENDDO
            CASE "FTP Server:" $ line .AND. "logged in" $ line
               @ 12,13 SAY "Processing :" + m + " Customer FTP IN "
               SEEK m
               IF Found()
                  REPLACE Day WITH m,;
                     in_ftp WITH in_ftp + 1
               ELSE
                  APPEND BLANK
                  REPLACE Day WITH m,;
                     in_ftp WITH in_ftp + 1
               ENDIF
               STORE 0 TO lapsed, sttime, endtime, start
               STORE Substr(line,18,8) TO sttime
               STORE Right(line,(Len(line)-27)) TO port
               STORE At("]",port) TO N
               IF N > 0
                  STORE Left(port,N) TO port
               ENDIF
               STORE At("FTP Server:[",line) TO N
               STORE Right(line,(Len(line)-(N+11))) TO line
               STORE At("]",line) TO N
               STORE Left(line,N-1) TO mname
               STORE bytes TO start
               STORE "" TO line
               DO WHILE .T.
                  STORE freadstr(in,1) TO mvar
                  DO CASE
                  CASE Len(mvar) = 0
                     FSEEK(tmp,start)
                     EXIT
                  CASE Asc(mvar) = 10
                     @ 20,0 SAY Space(80)
                     @ 20,0 SAY Left(line,79)
                     IF port $ line
                        lapsed := DeltaTime()
                        SELECT ipadmgr
                        SET ORDER TO 3
                        SEEK Upper(mname)
                        IF Found()
                           REPLACE c_flogins WITH c_flogins + 1,;
                              c_ftime WITH c_ftime + lapsed
                        ENDIF
                        SELECT stats
                        FSEEK(tmp,start)
                        EXIT
                     ELSE
                        STORE "" TO line
                     ENDIF
                  OTHERWISE
                     STORE line + mvar TO line
                  ENDCASE
               ENDDO
            ENDCASE
            STORE "" TO line
         OTHERWISE
            STORE line + mvar TO line
         ENDCASE
         SKIP
         LOOP
      ENDDO
      FCLOSE(in)
      FCLOSE(tmp)
      ERASE &temp
   ENDIF
   *******************************************************************
   IF .NOT. FILE("&Temp")
      FCREATE('&Temp')
   ENDIF
   RENAME &system TO &new
   *   Fcreate('&System')
   in = FOPEN('&New',0)
   tmp = FOPEN('&Temp',2)
   STORE "" TO line
   STORE Right(Str(Year(Date()),4),2) TO y
   DO WHILE .T.
      IF Readkey() = 12
         WAIT
         QUIT
      ENDIF
      STORE freadstr(in,1) TO mvar
      STORE bytes + 1 TO bytes
      DO CASE
      CASE Len(mvar) = 0
         EXIT
      CASE Asc(mvar) = 10
         @ 20,0 SAY Space(80)
         @ 20,0 SAY Left(line,79)
         STORE Ltrim(line) TO line, templine
         STORE Upper(Ltrim(Rtrim(Substr(line,9,8)))) TO m
         STORE Dtoc(Ctod(m)) TO m
         DO CASE
         CASE "-ANS]" $ line .AND. "Connected" $ line
            @ 12,13 SAY "Processing :" + m + " Answered SLIP   "
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  in_ppp WITH in_ppp + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  in_ppp WITH in_ppp + 1
            ENDIF
            STORE 0 TO lapsed, sttime, endtime, start
            STORE Substr(line,18,8) TO sttime
            STORE Substr(line,27,6) TO port
            STORE At("-",port) TO N
            IF N > 0
               STORE Left(port,N-1) TO port
            ENDIF
            STORE At("ANS] [",line) TO N
            STORE Right(line,(Len(line)-(N+5))) TO line
            STORE At("]",line) TO N
            STORE Left(line,N-1) TO mname
            STORE bytes TO start
            STORE "" TO line
            DO WHILE .T.
               STORE freadstr(in,1) TO mvar
               DO CASE
               CASE Len(mvar) = 0
                  fwrite(tmp,templine,Len(templine))
                  STORE Chr(10) TO templine
                  fwrite(tmp,templine,Len(templine))
                  FSEEK(in,start)
                  EXIT
               CASE Asc(mvar) = 10
                  @ 20,0 SAY Space(80)
                  @ 20,0 SAY Left(line,79)
                  DO CASE
                  CASE port $ line .AND. "Disconnected" $ line
                     lapsed := DeltaTime()
                     FSEEK(in,start)
                     SELECT ipadmgr
                     SET ORDER TO 2
                     *                             Set Order To 4
                     SEEK Upper(mname)
                     IF Found()
                        REPLACE c_slogins WITH c_slogins + 1,;
                           c_stime WITH c_stime + lapsed
                     ENDIF
                     SELECT stats
                     EXIT
                  CASE port $ line .AND. "Loss of Carrier" $ line
                     ?? Chr(7)
                     lapsed := DeltaTime()
                     FSEEK(in,start)
                     SELECT ipadmgr
                     SET ORDER TO 2
                     *                             Set Order To 4
                     SEEK Upper(mname)
                     IF Found()
                        REPLACE c_slogins WITH c_slogins + 1,;
                           c_stime WITH c_stime + lapsed
                     ENDIF
                     SELECT stats
                     EXIT
                  OTHERWISE
                     STORE "" TO line
                  ENDCASE
               OTHERWISE
                  STORE line + mvar TO line
               ENDCASE
            ENDDO
         CASE "FTP Server:[anonymous]" $ line
            @ 12,13 SAY "Processing :" + m + " Anonymous FTP   "
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  any_ftp WITH any_ftp + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  any_ftp WITH any_ftp + 1
            ENDIF
            STORE 0 TO lapsed, sttime, endtime, start
            STORE Substr(line,18,8) TO sttime
            STORE Right(line,(Len(line)-27)) TO port
            STORE At("]",port) TO N
            IF N > 0
               STORE Left(port,N) TO port
            ENDIF
            STORE At("FTP Server:[",line) TO N
            STORE Right(line,(Len(line)-(N+11))) TO line
            STORE At("]",line) TO N
            STORE Left(line,N-1) TO mname
            STORE bytes TO start
            STORE "" TO line
            DO WHILE .T.
               STORE freadstr(in,1) TO mvar
               DO CASE
               CASE Len(mvar) = 0
                  fwrite(tmp,templine,Len(templine))
                  STORE Chr(10) TO templine
                  fwrite(tmp,templine,Len(templine))
                  FSEEK(in,start)
                  EXIT
               CASE Asc(mvar) = 10
                  @ 20,0 SAY Space(80)
                  @ 20,0 SAY Left(line,79)
                  IF port $ line .AND. "Close FTP" $ line
                     lapsed := DeltaTime()
                     SELECT ipadmgr
                     SET ORDER TO 3
                     SEEK Upper(mname)
                     IF Found()
                        REPLACE c_flogins WITH c_flogins + 1,;
                           c_ftime WITH c_ftime + lapsed
                     ENDIF
                     SELECT stats
                     FSEEK(in,start)
                     EXIT
                  ELSE
                     STORE "" TO line
                  ENDIF
               OTHERWISE
                  STORE line + mvar TO line
               ENDCASE
            ENDDO
         CASE "FTP Server:" $ line .AND. "logged in" $ line
            @ 12,13 SAY "Processing :" + m + " Customer FTP IN "
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  in_ftp WITH in_ftp + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  in_ftp WITH in_ftp + 1
            ENDIF
            STORE 0 TO lapsed, sttime, endtime, start
            STORE Substr(line,18,8) TO sttime
            STORE Right(line,(Len(line)-27)) TO port
            STORE At("]",port) TO N
            IF N > 0
               STORE Left(port,N) TO port
            ENDIF
            STORE At("FTP Server:[",line) TO N
            STORE Right(line,(Len(line)-(N+11))) TO line
            STORE At("]",line) TO N
            STORE Left(line,N-1) TO mname
            STORE bytes TO start
            STORE "" TO line
            DO WHILE .T.
               STORE freadstr(in,1) TO mvar
               DO CASE
               CASE Len(mvar) = 0
                  fwrite(tmp,templine,Len(templine))
                  STORE Chr(10) TO templine
                  fwrite(tmp,templine,Len(templine))
                  FSEEK(in,start)
                  EXIT
               CASE Asc(mvar) = 10
                  @ 20,0 SAY Space(80)
                  @ 20,0 SAY Left(line,79)
                  IF port $ line .AND. "Close FTP" $ line
                     lapsed := DeltaTime()
                     SELECT ipadmgr
                     SET ORDER TO 3
                     SEEK Upper(mname)
                     IF Found()
                        REPLACE c_flogins WITH c_flogins + 1,;
                           c_ftime WITH c_ftime + lapsed
                     ENDIF
                     SELECT stats
                     FSEEK(in,start)
                     EXIT
                  ELSE
                     STORE "" TO line
                  ENDIF
               OTHERWISE
                  STORE line + mvar TO line
               ENDCASE
            ENDDO
         CASE "]WWW Server: GET" $ line
            @ 12,13 SAY "Processing :" + m + " WWW Server "
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  in_www WITH in_www + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  in_www WITH in_www + 1
            ENDIF
         CASE "Incoming Telnet Request" $ line
            @ 12,13 SAY "Processing :" + m + " Incoming Telnet "
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  inc_telnet WITH inc_telnet + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  inc_telnet WITH inc_telnet + 1
            ENDIF
         CASE "Telnet connect" $ line
            @ 12,13 SAY "Processing :" + m + " Outbound Telnet "
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  out_telnet WITH out_telnet + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  out_telnet WITH out_telnet + 1
            ENDIF
         CASE "-TERM] Cmd> PPP"  $ line
            @ 12,13 SAY "Processing :" + m + " Outbound PPP    "
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  out_ppp WITH out_ppp + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  out_ppp WITH out_ppp + 1
            ENDIF
         CASE "-TERM] Cmd> SLIP"  $ line
            @ 12,13 SAY "Processing :" + m + " Outbound SLIP   "
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  out_slip WITH out_slip + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  out_slip WITH out_slip + 1
            ENDIF
         ENDCASE
         STORE "" TO line
      OTHERWISE
         STORE line + mvar TO line
      ENDCASE
      SKIP
      LOOP
   ENDDO
   FCLOSE(in)
   FCLOSE(tmp)
   STORE .T. TO dostat
ELSE
   @ 12,13 SAY "Backup file exists - skipping        "
ENDIF
STORE Rat("\",cMail) TO m
STORE Left(cMail,m) TO line
STORE Right(cMail,(Len(cMail)-m)) TO l
STORE Ltrim(Str(Month(Date()),2)) TO m
IF Len(m) = 1
   STORE Left(l,4) + "0" + m TO m
ELSE
   STORE Left(l,4) + m TO m
ENDIF
STORE Ltrim(Str(Day(Date()),2)) TO d
IF Len(d) = 1
   STORE Left(m,6) + "0" + d + "." TO m
ELSE
   STORE Left(m,6) + d + "." TO m
ENDIF
STORE Right(Str(Year(Date()),4),2) TO y
IF Len(y) = 1
   STORE Left(m,9) + "0" + y TO m
ELSE
   STORE Left(m,9) + y TO m
ENDIF
STORE line + m TO new
IF .NOT. FILE("&New")
   RENAME &cMail TO &new
   ***   Fcreate('&cMail')
   in = FOPEN('&New',0)
   STORE "" TO line
   STORE Right(Str(Year(Date()),9),2) TO y
   DO WHILE .T.
      STORE freadstr(in,1) TO mvar
      DO CASE
      CASE Len(mvar) = 0
         EXIT
      CASE Asc(mvar) = 10
         STORE Ltrim(line) TO line
         STORE Upper(Ltrim(Rtrim(Substr(line,9,8)))) TO m
         STORE Dtoc(Ctod(m)) TO m
         DO CASE
         CASE "SMTP Server: New mail posted" $ line
            @ 12,13 SAY "Processing :" + m + " New mail posted"
            SELECT stats
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  in_mail WITH in_mail + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  in_mail WITH in_mail + 1
            ENDIF
            STORE At("To: ",line) TO N
            STORE Right(line,(Len(line)-(N+3))) TO line
            STORE At("@",line) TO N
            STORE Left(line,N-1) TO line
            STORE At(".",line) TO N
            IF N > 0
               line = Stuff(line,N,1," ")
            ENDIF
            SELECT ipadmgr
            SET ORDER TO 4
            SEEK Upper(line)
            IF Found()
               REPLACE c_rmsg WITH c_rmsg + 1
            ENDIF
            SELECT stats
         CASE "SMTP Client:" $ line .AND. "Sent To:" $ line
            @ 12,13 SAY "Processing :" + m + " New mail sent  "
            SELECT stats
            SEEK m
            IF Found()
               REPLACE Day WITH m,;
                  out_mail WITH out_mail + 1
            ELSE
               APPEND BLANK
               REPLACE Day WITH m,;
                  out_mail WITH out_mail + 1
            ENDIF
            STORE At("From: ",line) TO N
            STORE Right(line,(Len(line)-(N+5))) TO line
            STORE At("@",line) TO N
            STORE Left(line,N-1) TO line
            STORE At(".",line) TO N
            IF N > 0
               line = Stuff(line,N,1," ")
            ENDIF
            SELECT ipadmgr
            SET ORDER TO 4
            SEEK Upper(line)
            IF Found()
               REPLACE c_smsg WITH c_smsg + 1
            ENDIF
            SELECT stats
         ENDCASE
         STORE "" TO line
      OTHERWISE
         STORE line + mvar TO line
      ENDCASE
      SKIP
      LOOP
   ENDDO
   FCLOSE(in)
   STORE .T. TO dostat
ELSE
   @ 12,13 SAY "Backup file exists - skipping        "
ENDIF

SELECT ipadmgr
SET ORDER TO 0
GOTO TOP
DO WHILE .NOT. Eof()
   IF daily
      STORE c_stime - base_min TO mvar
      IF mvar > 0
         REPLACE ovr_t_mins WITH ovr_t_mins + mvar
      ENDIF
      REPLACE c_stime WITH 0
   ENDIF
   SKIP
   LOOP
ENDDO
SET COLOR TO W+/N
@ 23,0 SAY ""


*!*****************************************************************************
*!
*!       Function: DELTATIME()
*!
*!      Called by: STATS.PRG                         
*!
*!*****************************************************************************
FUNCTION DeltaTime()
endtime  := Substr(line,18,8)
stmin    := Val(Left(sttime,2)) * 60
stmin    := stmin + Val(Substr(sttime,4,2))
endmin   := Val(Left(endtime,2)) * 60
endmin   := endmin + Val(Substr(endtime,4,2))
nLapsed  := Max( Abs(endmin - stmin), 1 )

RETURN nLapsed

*: EOF: STATS.PRG
