*:*****************************************************************************
*:
*:        Program: D:\IPADMGR\ROLLOFF.PRG
*:
*:         System: IPAD Manager
*:         Author: Jeff Johnson
*:      Copyright (c) 1996, BBS Consultants, Inc.
*:  Last modified: 01/25/96     12:17
*:
*:      Called by: IPADMGR.PRG                       
*:
*:           Uses: IPADBACK.DBF       
*:               : IPADMGR.DBF        
*:               : IPADCFG.DBF        
*:               : TRASHCAN.DBF       
*:               : IPADFEES.DBF       
*:               : STATS.DBF          
*:               : PAYMENTS.DBF       
*:
*:        Indexes: IPADMGR.NX1        
*:               : IPADMGR.NX2        
*:               : IPADMGR.NX3        
*:               : IPADMGR.NX4        
*:               : IPADMGR.NX5        
*:               : IPADMGR.NX6        
*:               : TRASHCAN.NX1       
*:               : TRASHCAN.NX2       
*:               : STATS.NX1          
*:               : PAYMENTS.NX1       
*:               : PAYMENTS.NX2       
*:               : PAYMENTS.NX3       
*:               : PAYMENTS.NX4       
*:
*:      Documented 08/19/96 at 14:35                SNAP!  version 5.02
*:*****************************************************************************
SET ESCAPE OFF
SET EXCLUSIVE OFF
SET BELL OFF
SET COLOR TO W+/N
CLEAR
SET COLOR TO W+/B
@ 10,20 CLEAR TO 15,60
@ 10,20 TO 15,60
@ 11,22 SAY "Making Backup file : Ipadback.dbf"
SELECT 2
STORE exp_days TO max_day
SELECT 1
SET EXCLUSIVE ON
ERASE ipadback.dbf
SET EXCLUSIVE OFF
COPY FILE ipadmgr.dbf TO ipadback.dbf
CLOSE ALL
SELECT 1
USE ipadmgr
ZAP
USE ipadback
@ 12,22 SAY "Removing accounts older than "  + Dtoc(Date() - max_day)
SET ORDER TO 0
GOTO TOP
DO WHILE .NOT. Eof()
   IF keep .OR. hold
      SKIP
      LOOP
   ENDIF
   IF .NOT. Empty(exp_date)
      IF exp_date + max_day < Date() +1
         DELETE
      ENDIF
   ENDIF
   SKIP
   LOOP
ENDDO
COPY TO ipadmgr FOR .NOT. Deleted()
GOTO TOP
IF .NOT. FILE("Delete.log")
   FCREATE fo delete.log 13
   FOPEN fo delete.log 13
   STORE "                                                                  DELETE LOG                                                                 " + Chr(13) + Chr(10) TO line
   FLWRITE fo size line
   STORE "  DATE     SUBSCRIPTION NAME             SLIP LOGIN NAME             EXP DATE  CREDIT CARD NAME                  CREDIT CARD NUMBER     DATE " + Chr(13) + Chr(10) TO line
   FLWRITE fo size line
ELSE
   FOPEN fo delete.log 13
ENDIF
DO WHILE .NOT. Eof()
   IF Deleted()
      STORE Dtoc(Date()) + "   " TO line
      FLWRITE fo size line
      STORE name + s_login + "   " TO line
      FLWRITE fo size line
      STORE Dtoc(exp_date) + "   " TO line
      FLWRITE fo size line
      DO CASE
      CASE Asc(Left(card_num,1)) < 124 .OR. Empty(card_num)
         STORE card_num TO cardno
      OTHERWISE
         STORE Chr(Asc(Substr(card_num,1,1)) - 105) TO cardno
         STORE cardno + Chr(Asc(Substr(card_num,3,1)) - 105) TO cardno
         STORE cardno + Chr(Asc(Substr(card_num,5,1)) - 105) TO cardno
         STORE cardno + Chr(Asc(Substr(card_num,7,1)) - 105) TO cardno
         STORE cardno + Chr(Asc(Substr(card_num,9,1)) - 105) TO cardno
         STORE cardno + Chr(Asc(Substr(card_num,11,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,13,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,15,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,17,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,19,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,20,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,18,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,16,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,14,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,12,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,10,1)) - 105) TO cardn
         STORE cardno + Chr(Asc(Substr(card_num,8,1)) - 105) TO cardno
         STORE cardno + Chr(Asc(Substr(card_num,6,1)) - 105) TO cardno
         STORE cardno + Chr(Asc(Substr(card_num,4,1)) - 105) TO cardno
         STORE cardno + Chr(Asc(Substr(card_num,2,1)) - 105) TO cardno
      ENDCASE
      STORE card_name + "   " + cardno + "   " + card_date + "   " TO line
      FLWRITE fo size line
      STORE Chr(13) + Chr(10) TO line
      FLWRITE fo size line
   ENDIF
   SKIP
   LOOP
ENDDO
FCLOSE fo
SET INDEX TO
SET EXCLUSIVE ON
USE ipadmgr
@ 13,22 SAY "Reindexing database         "
@ 14,22 SAY "     Please wait            "
SET EXCLUSIVE ON
USE ipadmgr
@ 14,22 SAY "Reindexing IPADMGR.NX1     "
INDEX ON Upper(name) TO ipadmgr.nx1
@ 14,22 SAY "Reindexing IPADMGR.NX2     "
INDEX ON Upper(s_login) TO ipadmgr.nx2
@ 14,22 SAY "Reindexing IPADMGR.NX3     "
INDEX ON Upper(f_login) TO ipadmgr.nx3
@ 14,22 SAY "Reindexing IPADMGR.NX4     "
INDEX ON Upper(p_login) TO ipadmgr.nx4
@ 14,22 SAY "Reindexing IPADMGR.NX5     "
INDEX ON Upper(pop_dir) TO ipadmgr.nx5
@ 14,22 SAY "Reindexing IPADMGR.NX6     "
INDEX ON Upper(login_name) TO ipadmgr.nx6
SET COLOR TO W+/B
SET EXCLUSIVE OFF
SELECT 1
USE ipadmgr INDEX ipadmgr.nx1, ipadmgr.nx2, ipadmgr.nx3, ipadmgr.nx4, ipadmgr.nx5, ipadmgr.nx6
SELECT 2
USE ipadcfg
STORE Ltrim(Rtrim(slipusers)) TO slip_path
STORE Ltrim(Rtrim(ftpusers)) TO ftp_path
STORE Ltrim(Rtrim(popusers)) TO pop_path
STORE Ltrim(Rtrim(popheader)) TO header
STORE Ltrim(Rtrim(popmails)) TO mpop_dir
STORE Ltrim(Rtrim(logfile)) TO clog
IF Right(mpop_dir,1) = "\"
ELSE
   STORE Ltrim(Rtrim(popmails)) + "\" TO mpop_dir
ENDIF
STORE Ltrim(Rtrim(dns)) TO domain
STORE exp_days TO expire
STORE force_bill TO mforce
STORE .F. TO NOTE
SELECT 4
USE trashcan INDEX trashcan.nx1, trashcan.nx2
SELECT 3
USE ipadfees
SELECT 5
USE stats INDEX stats.nx1
SELECT 6
USE payments INDEX payments.nx1, payments.nx2, payments.nx3, payments.nx4
SELECT 1
RETURN
*: EOF: ROLLOFF.PRG
