*:*****************************************************************************
*:
*:        Program: D:\IPADMGR\BILLCHK.PRG
*:
*:         System: IPAD Manager
*:         Author: Jeff Johnson
*:      Copyright (c) 1996, BBS Consultants, Inc.
*:  Last modified: 07/29/96     12:02
*:
*:      Called by: IPADMGR.PRG
*:
*:    Other Files: IPADMGR.LOG
*:
*:      Documented 08/19/96 at 14:35                SNAP!  version 5.02
*:*****************************************************************************
SELECT 1
SET ORDER TO 2
GOTO TOP
SET CONSOLE OFF
SET ALTERNATE TO ipadmgr.log APPEND
SET ALTERNATE ON
DO WHILE .NOT. Eof()
   SELECT 1
   IF hold .OR. Deleted()
      SKIP
      LOOP
   ENDIF
   IF renew_lev > 16
      ? "Invalid Renewal Level Record Number " + Str(Recno(),7)
      SKIP
      LOOP
   ENDIF
   *   If Left(Card_num,4) = "Cash" .Or. Left(Card_num,4) = "Mail" .Or. Left(Card_num,4) = "Free"
   *      Skip
   *      Loop
   *   Endif
   IF Empty(host_name)
      IF auto_renew .AND. Date() >= (exp_date-2) .AND. .NOT. Empty(card_num)
         DO CASE
         CASE hourly
            IF renew_lev = 0
               STORE days TO mdays
               STORE base_rate TO mbase, tot
               STORE s_rate TO ms_rate
               STORE base_min TO mbase_min
            ELSE
               STORE renew_lev TO lev
               SELECT 3
               GOTO lev
               STORE days TO mdays
               STORE amount TO mbase
               STORE s_rate TO ms_rate
               STORE minutes TO mbase_min
            ENDIF
            SELECT 1
            IF (ms_rate * ((c_stime-mbase_min)/60)) > 0
               STORE mbase + (ms_rate * ((c_stime-mbase_min)/60)) TO tot
            ELSE
               STORE mbase TO tot
            ENDIF
         CASE daily
            IF renew_lev = 0
               STORE days TO mdays
               STORE base_rate TO mbase, tot
               STORE s_rate TO ms_rate
               STORE base_min TO mbase_min
            ELSE
               STORE renew_lev TO lev
               SELECT 3
               GOTO lev
               STORE days TO mdays
               STORE amount TO mbase
               STORE s_rate TO ms_rate
               STORE minutes TO mbase_min
            ENDIF
            SELECT 1
            IF (ms_rate * (ovr_t_mins/60)) > 0
               STORE mbase + (ms_rate * (ovr_t_mins/60)) TO tot
            ELSE
               STORE mbase TO tot
            ENDIF
         OTHERWISE
            IF renew_lev = 0
               STORE days TO mdays
               STORE renew_amt TO tot
               STORE s_rate TO ms_rate
               STORE base_min TO mbase_min
            ELSE
               STORE renew_lev TO lev
               SELECT 3
               GOTO lev
               STORE days TO mdays
               STORE 0 TO total
               STORE amount TO tot
            ENDIF
         ENDCASE
         SELECT 1
         REPLACE exp_date WITH exp_date + mdays,;
            renewal WITH Date()
         REPLACE renew_amt WITH tot,;
            total_fees WITH total_fees + tot
         REPLACE lt_bill_dt WITH bill_date,;
            lt_bill_am WITH bill_amt,;
            bill_date WITH Date(),;
            bill_amt WITH tot
         REPLACE p_slogins WITH c_slogins,;
            p_stime WITH c_stime,;
            p_flogins WITH c_flogins
         REPLACE p_ftime WITH c_ftime,;
            p_smsg WITH c_smsg,;
            p_rmsg WITH c_rmsg
         REPLACE c_slogins WITH 0,;
            c_stime WITH 0,;
            c_flogins WITH 0
         REPLACE c_ftime WITH 0,;
            c_smsg WITH 0,;
            c_rmsg WITH 0,;
            ovr_t_mins WITH 0
         IF Left(card_num,4) = "Cash" .OR. Left(card_num,4) = "Mail" .OR. Left(card_num,4) = "Free"
            STORE card_num TO cardno
         ELSE
            IF Asc(Left(card_num,1)) < 124 .OR. Empty(card_num)
               STORE card_num TO cardno
            ELSE
               STORE Chr(Asc(Substr(card_num,1,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,3,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,5,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,7,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,9,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,11,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,13,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,15,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,17,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,19,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,20,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,18,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,16,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,14,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,12,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,10,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,8,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,6,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,4,1)) - 105) TO cardno
               STORE cardno + Chr(Asc(Substr(card_num,2,1)) - 105) TO cardno
            ENDIF
         ENDIF
         SET CONSOLE OFF
         SET ALTERNATE TO ipadmgr.log APPEND
         SET ALTERNATE ON
         version = Right( Space(8) + version,8 )

         SELECT 1
         STORE name TO pvar1
         STORE s_login TO pvar2
         STORE p_login TO pvar3
         STORE f_login TO pvar4
         STORE renew_amt TO pvar5
         STORE auto_renew TO pvar6
         STORE card_name TO pvar7
         STORE card_date TO pvar8
         STORE card_num TO pvar9
         SELECT 6
         APPEND BLANK
         REPLACE Date WITH Date(),;
            name WITH pvar1,;
            slogin WITH pvar2,;
            plogin WITH pvar3
         REPLACE flogin WITH pvar4,;
            amount WITH pvar5,;
            auto_renew WITH pvar6
         REPLACE card_name WITH pvar7,;
            card_date WITH pvar8,;
            card_num WITH pvar9
         REPLACE card WITH .y.,;
            cash WITH .n.
         SELECT 1
         ? "ͻ"
         ? "                         Ipad Manager   " + Version + "                "  + Dtoc(Date()) + "     "
         ? "                            AUTO RENEWAL                                     "
         ? "ͼ"
         ? "Name      : " + name
         ? "Address   : " + address1
         ? "            " + address2
         ? "City, St. : " + Rtrim(city) + ", " + Rtrim(State) + "  " + zip
         ? "Phone     : " + phone
         ? "Renewal Date " + Dtoc(renewal)
         ?? "      New Expiration Date " + Dtoc(exp_date)
         ? "Renewal Amount   $ " + Transform(bill_amt,"9999.99")
         IF auto_renew
            ?? "           Auto Renewal : Yes   "
         ELSE
            ?? "           Auto Renewal : No   "
         ENDIF
         IF Left(card_num,4) = "Cash" .OR. Left(card_num,4) = "Mail" .OR. Left(card_num,4) = "Free"
            ? card_num
         ELSE
            ? "Using card issued to: " + Rtrim(card_name)
            ? "Number " + cardno + "  Expiring on  " + card_date
         ENDIF
         IF popmail
            IF Empty(pop_domain)
               ? "Enabled Popmail Account : " + Rtrim(p_login)
            ELSE
               ? "Enabled Popmail Account : " + Rtrim(p_login) + "@" + Rtrim(domain)
            ENDIF
            ? "Popmail Dir : " + mpop_dir + pop_dir
         ENDIF
         IF ppp_slip
            ? "Enabled Slip Account    : " + s_login
         ENDIF
         IF ftp
            ? "Enabled Ftp Account     : " + f_login
         ENDIF
         SELECT 1
      ELSE
         REPLACE logical1 WITH .n.
      ENDIF
   ENDIF
   SELECT 1
   *   If Email_N .And. .Not. Logical1
   *      Do Email
   *   Endif
   SKIP
   LOOP
ENDDO
SET CONSOLE ON
SET ALTERNATE OFF
CLOSE ALTERNATE
RETURN
*: EOF: BILLCHK.PRG
