#define TITLE   "EXTR_NET"      /* Program Name */
#define DATES   "1988-2003"     /* Copyright Date */
#define VERSION "2.30"          /* Version Number */

/****************************************************************************

   This program is designed to read an input nodelist file and extract
   selected Networks, Regions and/or Zones.  The extracted portions of
   the nodelist are stored in a file specified on the command line.

   The format for using this program is as follows:

     EXTR_NET [-q] [-i] -s "srcfile" -d "destfile" <net1> [<net2>...<net20>]

   where "srcfile"    is the name of the nodelist file to be read
         "destfile"   is the name of the output file created
         -q           operate in "quiet" mode (suppress screen output)
         -i           optionally include all Zone entries
         <net..>      are the numbers of the Net/Region/Zones to be extracted
                      and may include zone specifiers for Nets and Regions
                      (the program is presently set to handle 20 numbers).
                      These numbers may be preceded by a N, R or Z in order
                      to extract the entire Net, Region or Zone.  Examples
                      are: 123 N342 n2:201 r17 Z1

   The source and destination files may be specified with a full drive and
   path.  If there are spaces in the name or path, the entry must be enclosed
   in quotes ("").

   The inclusion of Zone lines is controlled in two ways and they operate
   differently.  The first way is to use the optional '-i' parameter, which
   will include all Zone lines in the nodelist.  The other way is to use a
   zone-specifier with the search criteria.  This will only include those
   Zone lines which are specified in the search criteria.  For example, if
   your command line looks like this:

        extr_net -s nodelist.123 -d net-342.123 -i n342

   the output would include all Zone listings as well as all of the entries
   in Net 342 in every zone where Net 342 appears.  If the command line is
   modified as:

        extr_net -s nodelist.123 -d net-342.123 n342

   the output would not include any Zone listings but would include all of
   the entries in Net 342 in every zone where Net 342 appears.  If the
   command line is further modified as:

        extr_net -s nodelist.123 -d net-342.123 n1:342

   the output would not include any Zone listings except Zone 1, and would
   include all of the entries for Net 342 in Zone 1.  Note that use of the
   '-i' parameter will always result in the inclusion of all Zone lines.

   The program will display a VERY brief set of instructions if it is called
   without any arguments or if it encounters an error.  The following is a
   list of the error codes returned by the program:

                  0 - No errors.  Normal termination.
                  1 - Bad or missing command line argument.
                  2 - Unable to open the input file.
                  3 - Unable to open the output file.
                  4 - Problem writing to output file.
                  5 - Problem closing input file.
                  6 - Problem closing output file.
                  7 - No extraction criteria specified.
                 -1 - Help screen (called with -?)

   When an error is encountered, the program will exit immediately and will
   attempt to properly close all files.

   Although I have chosen to retain all rights to this program, you are free
   to use it under the following conditions:

            - You realize that there is NO Warrantee of any sort.
              It was tested pretty thoroughly here before release
              but who knows what bugs may be lurking within.

            - You will not modify the code and release a new version
              of the program.  I welcome suggestions for improvement
              (especially when accompanied by code) but I make no
              guarantee of future releases.

            - If you find the program useful, I ask that you do
              something to brighten somebody else's day.  Just
              exactly what, I will leave up to you.

   You may freely distribute this program provided that you distribute only
   the complete archive.

                                                   Bob Swift
                                                   FidoNet: 1:342/5
                                                   Internet: bswift@shaw.ca

****************************************************************************/

#ifdef OS2
#define OPSYSTEM "OS/2"
#endif
#ifdef DOS
#define OPSYSTEM "DOS"
#endif
#ifdef WIN
#define OPSYSTEM "Windows"
#endif
#ifdef LINUX
#define OPSYSTEM "Linux"
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#ifdef LINUX
#include <unistd.h>
#else
#include <mem.h>
#endif

/****************************************************************************
The CRC polynomial. This is used by XMODEM (almost CCITT). If you
change P, you must change crctab[]'s initial value to what is
printed by initcrctab()
****************************************************************************/
#define   P    0x1021

/* number of bits in CRC: don't change it. */
#define W 16

/* this the number of bits per char: don't change it. */
#define B 8

/* calculated by initcrctab() */
static unsigned short crctab[1 << B] = {
  0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
  0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
  0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294, 0x72f7, 0x62d6,
  0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de,
  0x2462, 0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485,
  0xa56a, 0xb54b, 0x8528, 0x9509, 0xe5ee, 0xf5cf, 0xc5ac, 0xd58d,
  0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695, 0x46b4,
  0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc,
  0x48c4, 0x58e5, 0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823,
  0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948, 0x9969, 0xa90a, 0xb92b,
  0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
  0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a,
  0x6ca6, 0x7c87, 0x4ce4, 0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41,
  0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b, 0x8d68, 0x9d49,
  0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70,
  0xff9f, 0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78,
  0x9188, 0x81a9, 0xb1ca, 0xa1eb, 0xd10c, 0xc12d, 0xf14e, 0xe16f,
  0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046, 0x6067,
  0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e,
  0x02b1, 0x1290, 0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256,
  0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e, 0xe54f, 0xd52c, 0xc50d,
  0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
  0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c,
  0x26d3, 0x36f2, 0x0691, 0x16b0, 0x6657, 0x7676, 0x4615, 0x5634,
  0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9, 0xb98a, 0xa9ab,
  0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3,
  0xcb7d, 0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a,
  0x4a75, 0x5a54, 0x6a37, 0x7a16, 0x0af1, 0x1ad0, 0x2ab3, 0x3a92,
  0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8, 0x8dc9,
  0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1,
  0xef1f, 0xff3e, 0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8,
  0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93, 0x3eb2, 0x0ed1, 0x1ef0
};

int cfputs(char *s, FILE * stream);
unsigned short updcrc(unsigned short icrc, char *icp, unsigned int icnt);
void helpscrn(int ernum);
void lf_to_crlf(char s[]);
int min(int, int);
int myfputs(char *s, FILE * stream);
int linetest(char *linetst1, char *inputline);
char version[] = { VERSION };
char title[] = { TITLE };
char dates[] = { DATES };
char opsystem[] = { OPSYSTEM };
unsigned short crc;

#define CR 13
#define LF 10

/*******************************************************************/

int main(int argc, char *argv[])
{

  FILE *infile, *outfile;
  char sfilename[255];
  char dfilename[255];
  char inputline[358];
  char lintest[21][20];
  char zontest[21][10];
  char linshow[21][40];
  int lineflag[21];
  char semi[20];
  char temp[1024];
  char spaces[80];
  char curzone[10];
  time_t t;

#ifdef LINUX
  long filepos;
#else
  fpos_t filepos;
#endif
  int i, j, k;
  int sub1;
  int count;
  int flag;
  int zoneflag;
  int quiet;

  memset(spaces, ' ', 79);
  spaces[79] = '\0';
  strcpy(curzone, "0");
  zoneflag = 0;
  t = time(NULL);

  strcpy(sfilename, "");        /* Input File */
  strcpy(dfilename, "");        /* Output File */

  quiet = 0;
  sub1 = 0;

  if (argc < 2)
    helpscrn(-1);
  for (k = 1; k < argc; k++) {
    if (argv[k][0] == '-' && tolower(argv[k][1]) == 's') {
      k++;
      k = min(k, argc - 1);
      strcpy(sfilename, argv[k]);
    }
    else if (argv[k][0] == '-' && tolower(argv[k][1]) == 'd') {
      k++;
      k = min(k, argc - 1);
      strcpy(dfilename, argv[k]);
    }
    else if (argv[k][0] == '-' && tolower(argv[k][1]) == 'i') {
      sub1++;
      strcpy(lintest[sub1], "I,");
      strcpy(zontest[sub1], "0");
      strcpy(linshow[sub1], "Include all ZONE entries.");
      lineflag[sub1] = 'I';
      zoneflag = 1;
    }
    else if (argv[k][0] == '-' && tolower(argv[k][1]) == 'q') {
      quiet = 1;
    }
    else if (argv[k][0] == '-' && argv[k][1] == '-'
             && tolower(argv[k][2]) == 'h') {
      helpscrn(-1);
    }
    else if (argv[k][0] == '-' && tolower(argv[k][1]) == '?') {
      helpscrn(-1);
    }
    else {
      strcpy(semi, argv[k]);
      switch (semi[0]) {
        case 'n':;
        case 'N':
          sub1++;
          strcpy(lintest[sub1], "Host,");
          strcpy(zontest[sub1], "0");
          strcpy(linshow[sub1], "Net ");
          lineflag[sub1] = 'N';
          i = 0;
          j = 1;
          strcpy(temp, "0");
          while (semi[j] != '\0') {
            temp[i] = semi[j];
            i++;
            j++;
            temp[i] = '\0';
            if (semi[j] == ':') {
              j++;
              strcpy(zontest[sub1], temp);
              i = 0;
              strcpy(temp, "0");
            }
          }
          strcat(lintest[sub1], temp);
          strcat(lintest[sub1], ",");
          strcat(linshow[sub1], temp);
          if (zontest[sub1][0] != '0') {
            strcat(linshow[sub1], "  (Zone ");
            strcat(linshow[sub1], zontest[sub1]);
            strcat(linshow[sub1], ")");
          }
          break;
        case 'r':;
        case 'R':
          sub1++;
          strcpy(lintest[sub1], "Region,");
          strcpy(zontest[sub1], "0");
          strcpy(linshow[sub1], "Region ");
          lineflag[sub1] = 'R';
          i = 0;
          j = 1;
          strcpy(temp, "0");
          while (semi[j] != '\0') {
            temp[i] = semi[j];
            i++;
            j++;
            temp[i] = '\0';
            if (semi[j] == ':') {
              j++;
              strcpy(zontest[sub1], temp);
              i = 0;
              strcpy(temp, "0");
            }
          }
          strcat(lintest[sub1], temp);
          strcat(lintest[sub1], ",");
          strcat(linshow[sub1], temp);
          if (zontest[sub1][0] != '0') {
            strcat(linshow[sub1], "  (Zone ");
            strcat(linshow[sub1], zontest[sub1]);
            strcat(linshow[sub1], ")");
          }
          break;
        case 'z':;
        case 'Z':
          sub1++;
          strcpy(lintest[sub1], "Zone,");
          strcpy(zontest[sub1], "0");
          strcpy(linshow[sub1], "Zone ");
          lineflag[sub1] = 'Z';
          i = 5;
          j = 1;
          strcpy(temp, "0");
          while (semi[j] != '\0') {
            lintest[sub1][i] = semi[j];
            linshow[sub1][i] = semi[j];
            i++;
            j++;
          }
          lintest[sub1][i] = '\0';
          linshow[sub1][i] = '\0';
          strcat(lintest[sub1], ",");
          break;
        default:
        {
          sub1++;
          lineflag[sub1] = 'A';
          strcpy(lintest[sub1], "Zone,");
          strcpy(zontest[sub1], "0");
          strcpy(linshow[sub1], "Zone ");
          i = 0;
          j = 0;
          strcpy(temp, "0");
          while (semi[j] != '\0') {
            temp[i] = semi[j];
            i++;
            j++;
            temp[i] = '\0';
            if (semi[j] == ':') {
              j++;
              strcpy(zontest[sub1], temp);
              i = 0;
              strcpy(temp, "0");
            }
          }
          strcat(lintest[sub1], temp);
          strcat(lintest[sub1], ",");
          strcat(linshow[sub1], temp);
          sub1++;
          lineflag[sub1] = 'A';
          strcpy(lintest[sub1], "Region,");
          strcpy(zontest[sub1], zontest[sub1 - 1]);
          strcpy(zontest[sub1 - 1], "0");
          strcpy(linshow[sub1], "Region ");
          strcat(lintest[sub1], temp);
          strcat(lintest[sub1], ",");
          strcat(linshow[sub1], temp);
          if (zontest[sub1][0] != '0') {
            strcat(linshow[sub1], "  (Zone ");
            strcat(linshow[sub1], zontest[sub1]);
            strcat(linshow[sub1], ")");
          }
          sub1++;
          lineflag[sub1] = 'A';
          strcpy(lintest[sub1], "Host,");
          strcpy(zontest[sub1], zontest[sub1 - 1]);
          strcpy(linshow[sub1], "Net ");
          strcat(lintest[sub1], temp);
          strcat(lintest[sub1], ",");
          strcat(linshow[sub1], temp);
          if (zontest[sub1][0] != '0') {
            strcat(linshow[sub1], "  (Zone ");
            strcat(linshow[sub1], zontest[sub1]);
            strcat(linshow[sub1], ")");
          }
        }
      }
    }
  }

  if (sub1 < 1)
    helpscrn(7);

  infile = fopen(sfilename, "rt");
  if (infile == NULL)
    helpscrn(2);

  if ((outfile = fopen(dfilename, "w+t")) == NULL)
    helpscrn(3);

  if (quiet == 0)
    printf("\n%s Version %s for %s\n", title, version, opsystem);
  if (quiet == 0)
    printf("Copyright (c) Bob Swift, %s.  All Rights Reserved.\n", dates);

  if (quiet == 0)
    printf("Extracting:   ");   /* Echo Input To User */
  for (count = 1; count <= sub1; count++) {
    if (quiet == 0)
      printf("%s\n              ", linshow[count]);
  }
  if (quiet == 0)
    printf("\n");

  if (fgets(inputline, 256, infile) == NULL) {
    strcpy(temp, ";A Extracted Nodelist Segment : 00000\n");
  }
  else {
    strcpy(temp, ";A Extracted ");
    strcat(temp, inputline + 3);
  }
  lf_to_crlf(temp);
  if (myfputs(temp, outfile) == EOF)
    helpscrn(4);
  crc = 0;
#ifdef LINUX
  filepos = ftell(outfile) - 7L;
#else
  if (fgetpos(outfile, &filepos) != 0)
    helpscrn(4);
  filepos = filepos - 7L;
#endif

  if (cfputs(";A \n;A Extracted with ", outfile) == EOF)
    helpscrn(4);
  if (cfputs(title, outfile) == EOF)
    helpscrn(4);
  if (cfputs(" Version ", outfile) == EOF)
    helpscrn(4);
  if (cfputs(version, outfile) == EOF)
    helpscrn(4);
  if (cfputs(" for ", outfile) == EOF)
    helpscrn(4);
  if (cfputs(opsystem, outfile) == EOF)
    helpscrn(4);
  if (cfputs("\n;A ", outfile) == EOF)
    helpscrn(4);
  if (cfputs("Copyright (c) Bob Swift, ", outfile) == EOF)
    helpscrn(4);
  if (cfputs(dates, outfile) == EOF)
    helpscrn(4);
  if (cfputs(".  All Rights Reserved.", outfile) == EOF)
    helpscrn(4);
  if (cfputs("\n;A \n;A Extracted from ", outfile) == EOF)
    helpscrn(4);
  i = 0;
  j = 0;
  while (sfilename[i] != '\0') {
    if (sfilename[i] == '/') {
      j = 0;
    }
    else {
      temp[j] = toupper(sfilename[i]);
      j++;
    }
    temp[j] = '\0';
    i++;
  }

/****************************************************************************
if (cfputs(sfilename,outfile) == EOF) helpscrn(4);
if (cfputs(" on ",outfile) == EOF) helpscrn(4); 
if (cfputs(ctime(&t),outfile) == EOF) helpscrn(4);
****************************************************************************/
  if (cfputs(temp, outfile) == EOF)
    helpscrn(4);
  if (cfputs("\n;A \n;A Extracting:     ", outfile) == EOF)
    helpscrn(4);
  if (cfputs(linshow[1], outfile) == EOF)
    helpscrn(4);
  for (count = 2; count <= sub1; count++) {
    if (cfputs("\n;A                 ", outfile) == EOF)
      helpscrn(4);
    if (cfputs(linshow[count], outfile) == EOF)
      helpscrn(4);
  }
  if (cfputs("\n;A \n;\n", outfile) == EOF)
    helpscrn(4);

  count = sub1;
  flag = 1;
  j = 0;

  while (fgets(inputline, 256, infile) != NULL) {
    if (inputline[0] == 'Z') {
      i = 0;
      for (sub1 = 5;
           (inputline[sub1] != ',') && (sub1 < strlen(inputline)); sub1++) {
        curzone[i] = inputline[sub1];
        i++;
        curzone[i] = '\0';
      }
    }
    strcpy(semi, ";");
    i = linetest(semi, inputline);
    strcpy(semi, ";\n");
    if ((linetest(semi, inputline) == 1 && flag == 0) || i == 0) {

      if (flag == 0) {
        strcpy(semi, "Host");
        i = linetest(semi, inputline);
        if (i == 1 && (j == 'N' || j == 'A'))
          flag = 1;
        if (flag == 1)
          if (cfputs(";\n", outfile) == EOF)
            helpscrn(4);
      }

      if (flag == 0) {
        strcpy(semi, "Region");
        i = linetest(semi, inputline);
        if (i == 1 && (j == 'N' || j == 'R' || j == 'A'))
          flag = 1;
        if (flag == 1)
          if (cfputs(";\n", outfile) == EOF)
            helpscrn(4);
      }

      if (flag == 0) {
        strcpy(semi, "Zone");
        flag = linetest(semi, inputline);
        if (flag == 1)
          if (cfputs(";\n", outfile) == EOF)
            helpscrn(4);
      }

      if (flag == 0) {
        if (cfputs(inputline, outfile) == EOF)
          helpscrn(4);
      }

      if (flag == 1) {

/* Cycle through the search patterns */
        for (sub1 = 1;
             sub1 <= count
             && linetest(lintest[sub1], inputline) == 0; sub1++) {
        }

        if (sub1 <= count)
          i = linetest(curzone, zontest[sub1]);
        if ((sub1 <= count)
            && ((zontest[sub1][0] == '0') || (i == 1))) {
          if (cfputs(inputline, outfile) == EOF)
            helpscrn(4);
          flag = 0;
          j = lineflag[sub1];
        }
      }

      if (flag == 1) {

        strcpy(semi, "Zone");
        if (linetest(semi, inputline) == 1) {
          i = 0;
          for (sub1 = 1; sub1 <= count; sub1++) {
            if (linetest(zontest[sub1], curzone) == 1)
              i = 1;
          }
          if ((i == 1) || (zoneflag == 1)) {
            if (cfputs(inputline, outfile) == EOF)
              helpscrn(4);
            if (cfputs(";\n", outfile) == EOF)
              helpscrn(4);
          }
        }

      }
    }
    if (inputline[0] == 'Z' || inputline[0] == 'R'
        || (inputline[0] == 'H' && inputline[2] == 's')) {
      inputline[strlen(inputline) - 1] = '\0';
      i = 0;
      for (sub1 = 0; sub1 <= strlen(inputline) && i < 3; sub1++) {
        if (inputline[sub1] == ',') {
          i++;
          if (i >= 3)
            inputline[sub1] = '\0';
          if (i == 1)
            inputline[sub1] = ' ';
        }
        if (inputline[sub1] == '_')
          inputline[sub1] = ' ';
      }
      strcat(inputline, spaces);
      inputline[79] = '\0';
      if (quiet == 0)
        printf("%s", inputline);
      if (inputline[0] == 'Z') {
        if (quiet == 0)
          printf("\n");
      }
      else {
        if (quiet == 0)
          printf("\r");
      }
    }
  }
  if (cfputs(";S End of extracted file.\n;S \n", outfile) == EOF)
    helpscrn(4);

  if (fclose(infile) != 0)
    helpscrn(5);

#ifdef LINUX
  if (fseek(outfile, filepos, SEEK_SET) != 0)
    helpscrn(4);
#else
  if (fsetpos(outfile, &filepos) != 0)
    helpscrn(4);
#endif
  fprintf(outfile, "%05u", crc);
  if (quiet == 0)
    printf("%s", spaces);
  if (quiet == 0)
    printf("\nCRC: %u\n", crc);

  if (fclose(outfile) != 0)
    helpscrn(6);

  if (quiet == 0)
    printf("%s", spaces);
  if (quiet == 0)
    printf("\nExtraction complete.  Thank-you for using %s.\n\n", title);
  exit(0);
}

/*******************************************************************/

int cfputs(char *s, FILE * stream)
{
  char string[1024];
  int i;

  strcpy(string, s);
  lf_to_crlf(string);
  i = 0;
  while (string[i] != '\0') {
    i++;
  }
  crc = updcrc(crc, string, i);
  return (myfputs(string, stream));
}

/*******************************************************************/

int myfputs(char *s, FILE * stream)
{
  char string[1024];
  int i, j, k;

  strcpy(string, s);
  i = 0;
  j = 0;
  k = 0;
  while (string[j] != '\0') {
    i = fputc(string[j], stream);
    j++;
    if (k != EOF) {
      k = i;
    }
  }
  return k;
}

/*******************************************************************/

int min(one, two)
int one, two;
{
  int three;

  three = one;
  if (two < one)
    three = two;
  return (three);
}

/*******************************************************************/

unsigned short updcrc(unsigned short icrc, char *icp, unsigned int icnt)
{
  register unsigned short crc1 = icrc;
  register char *cp = icp;
  register unsigned int cnt = icnt;

  while (cnt--)
    crc1 = (crc1 << B) ^ crctab[(crc1 >> (W - B)) ^ *cp++];

  return (crc1);
}

/*******************************************************************/

void lf_to_crlf(char s[])
{
  char string[1024];
  int i, j;

  i = 0;
  j = 0;
  string[0] = '\0';
  while (s[j] != '\0') {
    if (s[j] == CR || s[j] == LF) {
      string[i] = CR;
      i++;
      string[i] = LF;
      i++;
      string[i] = '\0';
      j++;
      while (s[j] == CR || s[j] == LF) {
        j++;
      }
    }
    else {
      string[i] = s[j];
      i++;
      string[i] = '\0';
      j++;
    }
  }
  strcpy(s, string);
}

/*******************************************************************/

int linetest(char *linetst1, char *inputline)
{
  int j;

  for (j = 0; linetst1[j] == inputline[j]; j++)
    if (linetst1[j + 1] == '\0')
      return (1);
  return (0);
}

/*******************************************************************/

void helpscrn(int ernum)
{
  printf("\n");
  switch (ernum) {

    case 1:
      printf("     **  Bad or missing command line argument  **\n\n");
      break;

    case 2:
      printf("     **  Unable to open input file  **\n\n");
      break;

    case 3:
      printf("     **  Unable to open output file  **\n\n");
      break;

    case 4:
      printf("     **  Problem writing to output file  **\n\n");
      break;

    case 5:
      printf("     **  Problem closing input file  **\n\n");
      break;

    case 6:
      printf("     **  Problem closing output file  **\n\n");
      break;

    case 7:
      printf("     **  No extraction criteria specified  **\n\n");
      break;

    default:
      printf("%s Version %s for %s\nCopyright ", title, version, opsystem);
      printf("(c) Bob Swift, %s.  All Rights Reserved.\n\n", dates);
      printf("This program is designed to read an input nodelist ");
      printf("file and extract\nselected Networks, Regions and/or ");
      printf("Zones.  The extracted portions of\nthe nodelist are ");
      printf("stored in a file specified on the command line.\n\n");
      printf("Usage: EXTR_NET [-q] [-i] -s \"srcfile\" -d \"destfi");
      printf("le\" <net1> [<net2>...<net20>]\n\n   where \"srcfile");
      printf("\"    is the name of the nodelist file to be read\n");
      printf("         \"destfile\"   is the name of the output ");
      printf("file created\n         -q           operate in \"quiet");
      printf("\" mode (suppress screen output)\n         -i       ");
      printf("    optionally include all Zone entries\n         <n");
      printf("et..>      are the numbers of the Net/Region/Zones to ");
      printf("be extracted\n                      and may include ");
      printf("zone specifiers for Nets and Regions\n              ");
      printf("        (the program is presently set to handle 20 n");
      printf("umbers).\n                      These numbers may be ");
      printf("preceded by a N, R or Z in order\n                  ");
      printf("    to extract the entire Net, Region or Zone.  Exam");
      printf("ples\n                      are: 123 N342 n2:201 r17 Z1\n");
  }
  exit(ernum);
}
