package com.oopsconsultancy.classfind;

import java.io.*;
import java.util.*;

/**
 * The main classfind mechanism
 *
 * @author <a href="mailto:brian@oopsconsultancy.com">Brian Agnew</a>
 * @version $Id: Main.java,v 1.2 2004/03/13 15:52:55 bagnew Exp $
 */
public class Main {

  public static void main(String[] args) {

    boolean generateImports = false;
    boolean rebuild = false;
    String classToFind = null;

    // gets the environment info...
    String classpath = System.getProperty("java.class.path");
    String javahome = System.getProperty("java.home");
    String homedir = System.getProperty("user.home");

    String packageName = null;
    String cacheName = homedir + File.separator + ".classfind";
    boolean duplicates = true;

    for (int a = 0; a < args.length; a++) {
      if (args[a].equals("-v")) {
        generateImports = true;
        classToFind = args[a+1];
      }
      else if (args[a].equals("-r")) {
        rebuild = true;
      }
      else if (args[a].equals("-c")) {
        classToFind = args[a+1];
      }
      else if (args[a].equals("-f")) {
        cacheName = args[a+1];
      }
      else if (args[a].equals("-p")) {
        packageName = args[a+1];
      }
      else if (args[a].equals("-d")) {
        duplicates = false;
      }
      else if (args[a].equals("-h")) {
        System.err.println("classfind - www.oopsconsultancy.com");
        System.err.println("  -h         : this message");
        System.err.println("  -r         : rebuilds the cache");
        System.err.println("  -d         : don't display classes duplicated in multiple packages");
        System.err.println("  -c [class] : finds the given class");
        System.err.println("  -v [class] : displays the complete package for the given class");
        System.err.println("  -f [file]  : the classfind cache file to use");
        System.err.println("  -p [pkg]   : the package to expand from");
        System.exit(0);
      }
    }

    // add in the appropriate rt.jar...
    if (!javahome.endsWith(File.separator)) {
      javahome = javahome + File.separator;
    }
    String runtime = javahome + "lib" + File.separator + "rt.jar";
    classpath = classpath + File.pathSeparator + runtime;

    // now check if the cache needs rebuilding or
    // simply constructing from an existing .classfind file
    ClassCache cache = null;
    try {
      cache = new ClassCache(cacheName, classpath);
      if (rebuild || cache.isExpired()) {
        cache.build(classpath);
        cache.save(cacheName);
      }
    }
    catch (IOException e) {
      e.printStackTrace();
    }

    if (classToFind != null) {
      List results = cache.findClass(classToFind);
      Iterator iresults = results.iterator();
      Map output = new HashMap();
      while (iresults.hasNext()) {
        ClassCache.Pair result = (ClassCache.Pair)iresults.next();
        if (!duplicates && output.get(result.fullname) != null) {
          // don't display...
        }
        else {
          if (generateImports) {
            System.out.println(result.fullname);
          }
          else {
            System.out.println(result);
          }
        }
        output.put(result.fullname, result);
      }
    }
    else if (packageName != null) {
      // we take a package name, and find the subpackages from it
      // eg. com.s -> com.sun
      // eg. com.sun. -> com.sun.x com.sun.y etc...
      List results = cache.findPackages(packageName);
      Iterator iresults = results.iterator();
      while (iresults.hasNext()) {
        String pkg = (String)iresults.next();
        System.out.print(pkg + " ");
      }
      System.out.println("");
    }
  }
}
