/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.classfind;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ClassCache {
    private static final String CLASS_SUFFIX = ".class";
    private Map components;
    private String classpath;
    private boolean expired;

    public List findClass(String classname) {
        ArrayList<Pair> matches = new ArrayList<Pair>();
        Set elements = this.components.keySet();
        Iterator ielements = elements.iterator();
        while (ielements.hasNext()) {
            String pkg = (String)ielements.next();
            List classes = (List)this.components.get(pkg);
            Iterator iclasses = classes.iterator();
            while (iclasses.hasNext()) {
                String fullname = (String)iclasses.next();
                if (!fullname.equals(classname) && !fullname.endsWith("." + classname)) continue;
                matches.add(new Pair(pkg, fullname));
            }
        }
        return matches;
    }

    public List findPackages(String packageName) {
        ArrayList<String> matches = new ArrayList<String>();
        Set elements = this.components.keySet();
        Iterator ielements = elements.iterator();
        while (ielements.hasNext()) {
            String pkg = (String)ielements.next();
            List classes = (List)this.components.get(pkg);
            Iterator iclasses = classes.iterator();
            while (iclasses.hasNext()) {
                String fullname = (String)iclasses.next();
                if (!fullname.startsWith(packageName)) continue;
                String remainder = fullname.substring(packageName.length());
                int index = remainder.indexOf(".");
                String res = null;
                if (index == 0) {
                    index = remainder.indexOf(".", 0);
                }
                if ((res = index == -1 ? fullname : fullname.substring(0, packageName.length() + index)) == null || matches.contains(res)) continue;
                matches.add(res);
            }
        }
        return matches;
    }

    public void build(String classpath) {
        this.components.clear();
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            File felement;
            String element = st.nextToken();
            if (this.components.get(element) != null || element.length() <= 0 || !(felement = new File(element)).exists()) continue;
            List classes = this.getClasses(felement);
            Iterator iclasses = classes.iterator();
            this.components.put(element, classes);
        }
    }

    private final List getClasses(File felement) {
        if (felement.isDirectory()) {
            return this.getClassesFromDir(felement);
        }
        return this.getClassesFromJar(felement);
    }

    private final List getClassesFromJar(File jarfile) {
        ArrayList<String> classes = new ArrayList<String>();
        try {
            JarFile jar = new JarFile(jarfile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = ((Object)entries.nextElement()).toString();
                if (!name.endsWith(CLASS_SUFFIX)) continue;
                classes.add(this.normalise(name));
            }
        }
        catch (IOException iOException) {}
        return classes;
    }

    private final List getClassesFromDir(File directory) {
        return this.getClassesFromDir(directory, directory);
    }

    private final List getClassesFromDir(File directory, File base) {
        ArrayList<String> classes = new ArrayList<String>();
        File[] contents = directory.listFiles();
        int c = 0;
        while (c < contents.length) {
            if (contents[c].isDirectory()) {
                classes.addAll(this.getClassesFromDir(contents[c], base));
            } else if (contents[c].getName().endsWith(CLASS_SUFFIX)) {
                String name = contents[c].getAbsolutePath();
                name = name.substring(base.getAbsolutePath().length());
                classes.add(this.normalise(name));
            }
            ++c;
        }
        return classes;
    }

    private final String normalise(String name) {
        if (name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        name = name.substring(0, name.length() - CLASS_SUFFIX.length());
        StringTokenizer st = new StringTokenizer(name, File.separator);
        StringBuffer pkg = new StringBuffer();
        while (st.hasMoreTokens()) {
            pkg.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            pkg.append(".");
        }
        return pkg.toString();
    }

    public void save(String name) throws IOException {
        FileWriter fw = new FileWriter(name);
        fw.write(this.classpath + '\n');
        Set elements = this.components.keySet();
        Iterator ielements = elements.iterator();
        while (ielements.hasNext()) {
            String pkg = (String)ielements.next();
            List classes = (List)this.components.get(pkg);
            Iterator iclasses = classes.iterator();
            while (iclasses.hasNext()) {
                String fullname = (String)iclasses.next();
                fw.write(pkg + '\t' + fullname + '\n');
            }
        }
        fw.close();
    }

    public boolean load(String name) throws IOException {
        if (!new File(name).exists()) {
            this.expired = true;
            return false;
        }
        FileReader fr = new FileReader(name);
        BufferedReader bfr = new BufferedReader(fr);
        int num = 0;
        while (bfr.ready()) {
            int tabindex;
            String line = bfr.readLine();
            if (num == 0) {
                this.classpath = line;
            } else if (!line.startsWith("#") && !line.trim().equals("") && (tabindex = line.indexOf("\t")) != -1) {
                String element = line.substring(0, tabindex);
                String classname = line.substring(tabindex + 1);
                if (this.components.get(element) == null) {
                    this.components.put(element, new ArrayList());
                }
                List list = (List)this.components.get(element);
                list.add(classname);
            }
            ++num;
        }
        bfr.close();
        return true;
    }

    public boolean isExpired() {
        return this.expired;
    }

    private final /* synthetic */ void this() {
        this.components = new HashMap();
        this.classpath = null;
        this.expired = false;
    }

    public ClassCache(String cacheName, String classpath) throws IOException {
        this.this();
        this.load(cacheName);
        if (this.classpath == null || !this.classpath.equals(classpath)) {
            this.expired = true;
            this.classpath = classpath;
        }
    }

    public class Pair {
        public String element;
        public String fullname;

        public String toString() {
            return this.element + " -> " + this.fullname;
        }

        public Pair(String p, String name) {
            this.element = p;
            this.fullname = name;
        }
    }
}

